/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class RuleTextField
extends JTextField {
    private static final long serialVersionUID = 3976731454594365493L;
    public static final int N = 1;
    public static final int H = 2;
    public static final int A = 3;
    public static final int O = 4;
    public static final int AN = 5;
    private int columns;
    private int editLength;
    private boolean unlimitedEdit;
    private Toolkit toolkit;

    public RuleTextField(int digits, int editLength, int type, boolean unlimitedEdit, Toolkit toolkit) {
        super(digits + 1);
        this.setColumns(digits);
        this.toolkit = toolkit;
        this.editLength = editLength;
        this.unlimitedEdit = unlimitedEdit;
        Rule rule = new Rule();
        rule.setRuleType(type, editLength, unlimitedEdit);
        this.setDocument(rule);
    }

    protected Document createDefaultModel() {
        Rule rule = new Rule();
        return rule;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getEditLength() {
        return this.editLength;
    }

    public boolean unlimitedEdit() {
        return this.unlimitedEdit;
    }

    public void setColumns(int columns) {
        super.setColumns(columns + 1);
        this.columns = columns;
    }

    class Rule
    extends PlainDocument {
        private static final long serialVersionUID = 3258134643651063862L;
        private int editLength;
        private int type;
        private boolean unlimitedEdit;

        Rule() {
        }

        public void setRuleType(int type, int editLength, boolean unlimitedEdit) {
            this.type = type;
            this.editLength = editLength;
            this.unlimitedEdit = unlimitedEdit;
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            int totalSize = this.getLength() + str.length();
            if (totalSize <= this.editLength || this.unlimitedEdit) {
                boolean error = false;
                if (this.type == 1) {
                    for (int i = 0; i < str.length(); ++i) {
                        if (Character.isDigit(str.charAt(i))) continue;
                        error = true;
                    }
                } else if (this.type == 2) {
                    for (int i = 0; i < str.length(); ++i) {
                        char focusChar = Character.toUpperCase(str.charAt(i));
                        if (Character.isDigit(focusChar) || focusChar == 'A' || focusChar == 'B' || focusChar == 'C' || focusChar == 'D' || focusChar == 'E' || focusChar == 'F') continue;
                        error = true;
                    }
                } else if (this.type == 3) {
                    for (int i = 0; i < str.length(); ++i) {
                        if (Character.isLetter(str.charAt(i))) continue;
                        error = true;
                    }
                } else if (this.type == 5) {
                    for (int i = 0; i < str.length(); ++i) {
                        if (Character.isLetterOrDigit(str.charAt(i))) continue;
                        error = true;
                    }
                } else if (this.type != 4) {
                    System.out.println("type = " + this.type);
                }
                if (!error) {
                    super.insertString(offs, str, a);
                } else {
                    RuleTextField.this.toolkit.beep();
                }
            } else {
                RuleTextField.this.toolkit.beep();
            }
        }
    }
}

