{$IFDEF WINDOWS}
{$N-,V-,W-,G+,C MOVEABLE DISCARDABLE}
{$ELSE}
{$N-,E-,V-,O+,F+}
{$ENDIF}

Unit bibsave;

Interface

uses
{$IFDEF WINDOWS}
  Wobjects, WinDos, wbibdisp, strings, winprocs,
{$ELSE}
  objects, Dos, bibdisp,
{$ENDIF}
  bibstrg, bibstrm, bibvars, bibfile, bibutil, bibsrtpt, rc_Strng,
  bib8bit, bibtmplt, rc_param, bibcache, lfnunit;


procedure SaveConfigOptions(SPrefs,SRegs,SSort,SFormats,SFields: boolean);


Implementation


procedure SaveConfigOptions(Sprefs,Sregs,Ssort,Sformats,SFields: boolean);
const
  MaxEnvList = 11;
  TibEnvIndex    = 1; ReferEnvIndex   = 2; CommaEnvIndex  = 3;
  RegsEnvIndex   = 4; SortEnvIndex    = 5; ParamsEnvIndex = 6;
  BibTeXEnvIndex = 7; WindowsEnvIndex = 8; MemoryEnvIndex = 9;
  FieldsEnvIndex = 10;
type
  ParamRecPtr = ^ParamRecType;
  ParamRecType = record
    Pname,OrigPname,argument: Pstring;
    Next,back: ParamRecPtr;
    Updated: boolean;
  end;
  EnvListType  = array[1..MaxEnvList] of string[20];
  EnvIndexType = array[1..MaxEnvList] of byte;
var
  cfg: text;
  fout: PSafeBufStream;
  TempFile,BackFile: string;
  FoundIt,ok,UnixConfig: boolean;
  line,tmp: string;
  i,InList,NEnvList,NEnvFound: integer;
  ParamRec,P: ParamRecPtr;
  EnvList: EnvListType;
  EnvIndex: EnvIndexType;

procedure PrepareTheFiles(var ok: boolean);
var
  Dir,Name,Ext,NewFile: Pstring;
  FAttr: word;

procedure TidyUp;
begin
  AllocStrings(false,@Dir,@Name,@Ext,@NewFile);
end;

begin          { PrepareTheFiles }
  ok:=false;
  LFNAssign(cfg,ConfigFile^);
  if LFNGetFAttr(cfg,FAttr)<>0 then
  begin
    ErrorMessageRC(Str_CantFindCfg,ConfigFile^); Exit;
  end;
  if (FAttr AND ReadOnly)>0 then
  begin
    ErrorMessageRC(Str_CfgFileRO,ConfigFile^);
    Exit;
  end;
  UnixConfig:=IsUnixFile(cfg,ConfigFile^);
  if LFNReset(cfg,0)<>0 then
  begin
    ErrorMessageRC(Str_CantReadFile,ConfigFile^); Exit;
  end;

  AllocStrings(true,@Dir,@Name,@Ext,@NewFile);
  LFNFsplit(ConfigFile^,Dir,Name,Ext);
  BackFile:=Dir^+Name^+ConfigBackExtension^; CanonicalFname(BackFile);
  Unique(Dir^,TempFile);
  if TempFile='' then
  begin
    ErrorMessageRC(Str_CantWriteCfg,'');
    TidyUp; Exit;
  end;

  fout:=Nil;
  New(fout,Init(TempFile,stCreate,AuxBufSize));
  if (fout=nil) or (fout^.status<>stOK) then
  begin
    ErrorMessageRC(Str_CantCreateTemp,'');
    if fout<>Nil then Dispose(fout,done); fout:=Nil;
    TidyUp; Exit;
  end;
  ok:=true;
  TidyUp;
end;                                   { PrepareTheFiles }

procedure GetRidOfComment(var line: string);
var
  tmp: string;
begin
  tmp:=line; UnTabify(tmp); ChrDelL(tmp,' ');
  if (tmp<>'') and (tmp[1] in CommentSet) then line:='';
end;                                { GetRidOfComment }

procedure AddParam(var P: ParamRecPtr; name,arg: string);
begin
  if name='' then Exit;
  if P=Nil then
  begin
    New(P); P^.back:=Nil;
  end else
  begin
    New(P^.Next); P^.Next^.Back:=P; P:=P^.Next;
  end;
  with P^ do
  begin
    OrigPname:=NewStr(name); argument:=NewStr(arg); Updated:=false; Next:=Nil;
    StrLwr(name); Pname:=NewStr(name);
  end;
end;                                { AddParam }

procedure AddParamRC(var P: ParamRecPtr; id: integer; arg: string);
begin
  AddParam(P,StringRC(id,''),arg);
end;

procedure KillParamList(var Root: ParamRecPtr);
var
  P,P2: ParamRecPtr;
begin
  if Root=Nil then Exit;
  P:=Root;
  while P^.Next<>Nil do P:=P^.Next;
  repeat
    P2:=P^.Back;
    DisposeStr(P^.Pname); DisposeStr(P^.OrigPname); DisposeStr(P^.argument);
    Dispose(P);
    if P2<>Nil then
    begin
      P:=P2; P^.Next:=Nil;
    end;
  until P2=Nil;
  Root:=Nil;
end;                                { KillParamList }

procedure UpdateParams(Root: ParamRecPtr);
const
  TokenStr = '='+lbrace+rbrace;
var
  line,Memline,param,description: string;
  RightPre: string[4];
  PreArr: array[boolean] of string[4];
  EndOfEnv,FoundIt,Written,Pre: boolean;
  P: ParamRecPtr;
  i,nbr: integer;
begin
  if Root=Nil then Exit;
{$IFDEF WINDOWS}
  RightPre:= 'win:';
{$ELSE}
  RightPre:= 'dos:';
{$ENDIF}
  PreArr[false]:='';
  PreArr[true]:=RightPre; StrUpr(PreArr[true]);
  EndOfEnv:=false;
  repeat
    line:=''; Pre:=false; description:='';
    ReadLine(cfg,line,UnixConfig); Memline:=line; GetRidOfComment(line);
    Untabify(line); ChrDelL(line,' '); ChrDelR(line,' ');
    Written:=false;
    if eof(cfg) or (line=rbrace) then EndOfEnv:=true
    else if (length(line)>0) and IsAlpha(line[1]) then
    begin
      param:='';
      i:=1; while (i<=length(line)) and (Pos(line[i],TokenStr)=0) do inc(i);
      param:=Copy(line,1,i-1); ChrDelR(param,' '); StrLwr(param);
      if Pos(RightPre,param)=1 then
      begin
        Pre:=true; Delete(Param,1,length(RightPre));
      end;
      { Look for descriptive text }
      if (i<length(line)) and (line[i]=lbrace) then
      begin
        description:=Copy(line,i+1,255);
        i:=1; nbr:=1;
        while (nbr>0) and (i<=length(description)) do
        begin
          if (i=1) or ((i>1) and (description[i-1]<>'\')) then
          begin
            if description[i]=lbrace then inc(nbr)
            else if description[i]=rbrace then dec(nbr);
          end;
          inc(i);
        end;
        if i>length(description) then Description:=''
        else delete(Description,1,i-1);
      end;
      P:=Root; FoundIt:=false;
      while (P<>Nil) and (not FoundIt) do
      begin
        FoundIt:=(param=P^.Pname^);
        if not FoundIt then P:=P^.Next;
      end;
      if FoundIt then
      begin
        StreamWriteln(fout,
            '  '+PreArr[Pre]+P^.OrigPname^+lbrace+P^.argument^+rbrace
            +Description,UnixConfig);
        P^.Updated:=true; Written:=true;
      end;
    end;
    if EndOfEnv then
    begin
      P:=Root;
      while P<>Nil do
      begin
        if not P^.Updated then
        begin
          StreamWriteln(fout,'  '+P^.OrigPname^+lbrace+P^.argument^+rbrace,UnixConfig);
          P^.Updated:=true;
        end;
        P:=P^.Next;
      end;
      StreamWriteln(fout,rbrace,UnixConfig);
    end else if not Written then StreamWriteln(fout,Memline,UnixConfig);
  until EndOfEnv;
end;                                { UpdateParams }

{$IFDEF WINDOWS}
procedure SaveFields;
var
  line: string;
  i: integer;
begin
  for i:=1 to OrigFieldLast do
  begin
    line:='';
    with FieldParams^[i] do
    begin
      if AuthorLike  then line:='AuthorLike';
      if Numeric     then line:=line+',Numeric';
      if Capitalize  then line:=line+',Capitalize';
      if ProtectCase then line:=line+',ProtectCase';
      if ProtectCap  then line:=line+',ProtectCap';
      if (AltName<>Nil) and (AltName^<>'') then
        line:=line+',Alt="'+AltName^+'"';
    end;
    if line[1]=',' then delete(line,1,1);
    if line='' then StreamWriteln(fout,'  '+typefield^[i],UnixConfig)
    else StreamWriteln(fout,'  '+TypeField^[i]+lbrace+line+rbrace,UnixConfig);
  end;
                              { Skip the remainder of the environment }
  if not eof(cfg) then
  repeat
    ReadLine(cfg,line,UnixConfig); ChrDelR(line,' '); ChrDelL(line,' ');
  until eof(cfg) or (line=rbrace);
  StreamWriteln(fout,rbrace,UnixConfig);
end;                 { SaveFields }
{$ENDIF}

procedure SaveRegisters;
const
  MaxLineLen=79;
var
  line,tmp,OutLine: string;
  First,FoundIt,ok: boolean;
  i,j: integer;
  Ind: word;
  MemChar: char;
begin
  for i:=0 to 35 do
  begin
    RecallBufferStack(line[0],MemoryPos+i);
    if line<>'' then
    begin
      if i<=25 then MemChar:=Chr(Ord('A')+i)
      else MemChar:=Chr(Ord('0')+i);
      OutLine:='  '+MemChar+' = ';
      if (line[1]='=') or (line[1]='"') or
             (length(line)+length(OutLine)>MaxLineLen) then
      begin
        OutLine:=OutLine+'"';
        Ind:=1; First:=true;
        repeat
          TeXWordGet(tmp,line[1],length(line),Ind);
          if tmp<>'' then
          begin
            j:=length(tmp);
            while j>0 do
            begin
              if tmp[j]='"' then Insert('"',tmp,j);
              dec(j);
            end;
            if first then tmp:=' '+tmp;
            if length(OutLine)+length(tmp)>MaxLineLen then
            begin
              StreamWriteln(fout,outline,UnixConfig);
              OutLine:='     '+tmp;
            end else OutLine:=OutLine+tmp;
            first:=false;
          end;
        until (Ind=0) or (Ind>length(line));
        StreamWriteln(fout,OutLine+'"',UnixConfig);
      end else StreamWriteln(fout,OutLine+line,UnixConfig);
    end;
  end;
  StreamWriteln(fout,rbrace,UnixConfig);
                              { Skip the remainder of the environment }
  if not eof(cfg) then
  repeat
    ReadLine(cfg,line,UnixConfig); ChrDelR(line,' '); ChrDelL(line,' ');
  until eof(cfg) or (line=rbrace);
end;                               { SaveRegisters }

function IsOn(istrue: boolean): string;
begin
  if IsTrue then IsOn:='on'
  else IsOn:='off';
end;

procedure ParametersOptions(var ParamRecRoot: ParamRecPtr);
var
  P: ParamRecPtr;
  tmp: string;
begin
  P:=Nil; ParamRecRoot:=Nil;

  AddParamRC(P,Par_UseIndexFile,    IsOn(UseIndexFile)); ParamRecRoot:=P;    
  AddParamRC(P,Par_AutoBuildIndex,  IsOn(AutoBuildIndex));
  AddParamRC(P,Par_AutoCapitalize,  IsOn(UseAutoCap));
  AddParamRC(P,Par_StickyList,      IsOn(StickyList));
  AddParamRC(P,Par_WrapEOF2BOF,     IsOn(WrapEOF2BOF));
  AddParamRC(P,Par_AlwaysReadFields,IsOn(AlwaysRead));  
  AddParamRC(P,Par_RetainNullFields,IsOn(RetainNullFields)); 
  AddParamRC(P,Par_SortedByDefault, IsOn(SortedByDefault));
  AddParamRC(P,Par_SortNewFiles,    IsOn(SortNewFiles));
  AddParamRC(P,Par_SaveOptsOnExit,  IsOn(SaveOptsOnExit));
  AddParamRC(P,Par_HideExtraBraces, IsOn(StripExtraBraces));
  AddParamRC(P,Par_TagNewEntries,   IsOn(TagNewEntries));

  if Prog8bit then tmp:='8 bit'
  else if Prog7bit then tmp:='7 bit TeX codes'
  else tmp:='none';
  AddParamRC(P,Par_DisplayEncoding,tmp+', '+
                        PEncoding(EncodingsList.at(DispEncoding))^.Name^);
  if File8bit then tmp:='8 bit'
  else if File7bit then tmp:='7 bit TeX codes'
  else tmp:='none';
  AddParamRC(P,Par_FileEncoding,tmp+', '+
                        PEncoding(EncodingsList.at(FReadEncoding))^.Name^);

  tmp:='';
  if CheckDuplicate=AllowDuplicate then         tmp:='off'
  else if CheckDuplicate=DuplicateCaseOn then   tmp:='RespectCase'
  else if CheckDuplicate=DuplicateCaseOff then  tmp:='IgnoreCase'
  else if CheckDuplicate=DuplicateCaseWarn then tmp:='WarnCase';
  AddParamRC(P,Par_CheckDuplicate,tmp);
  
  tmp:='';
  case AddSort2New of
    AddToNoNew:     tmp:='none';
    AddToAllNew:    tmp:='all';
    AddToSortedNew: tmp:='sorted';
  end;
  AddParamRC(P,Par_AddSortEnv,tmp);

  tmp:='';
  case LabelMode of
    OffLabelMode:    tmp:='off';
    VerifyLabelMode: tmp:='verify';
    AutoLabelMode:   tmp:='auto ';
  end;
  AddParamRC(P,Par_LabelMode,tmp);

  DecompTemplate(tmp,LabelTemplate^);
  AddParamRC(P,Par_LabelTemplate,tmp);

  tmp:='off'; if UsePreamble then tmp:='on';
  if Pos(' ',PreambleName^)=0 then tmp:=tmp+','+PreambleName^
  else tmp:=tmp+',"'+PreambleName^+'"';
  AddParamRC(P,Par_Preamble,tmp);
end;                               { ParametersOptions }

procedure MemoryOptions(var ParamRecRoot: ParamRecPtr);
var
  P: ParamRecPtr;
  tmp: string;
begin
  P:=Nil; ParamRecRoot:=Nil;
  if AutoLoadCache and AutoSaveCache then tmp:='load,save'
  else if AutoLoadCache then tmp:='load'
  else if AutoSaveCache then tmp:='save'
  else tmp:='off';
  AddParamRC(P,Mem_AutoLoadCache,tmp); ParamRecRoot:=P;
end;   

procedure BibTeXOptions(var ParamRecRoot: ParamRecPtr);
var
  P: ParamRecPtr;
  tmp: string[10];
begin
  P:=Nil; ParamRecRoot:=Nil;

  tmp:='';
  case Verify[BibTeXFormat] of
    VerifyOff:   tmp:='off';
    VerifyLabel: tmp:='labels';
    VerifyEntry: tmp:='on';
  end;
  AddParamRC(P,Form_ImportVerify,tmp); ParamRecRoot:=P;
  
  AddParamRC(P,Form_Width,num2str(LineWidth[BibTeXFormat]));
end;                                { BibTeXOptions }

procedure TibOptions(var ParamRecRoot: ParamRecPtr);
var
  i: integer;
  P: ParamRecPtr;
  tmp: string;
begin
  P:=Nil; ParamRecRoot:=Nil;

  tmp:='';
  if Verify[TibFormat]=VerifyOff then        tmp:='off'
  else if Verify[TibFormat]=VerifyLabel then tmp:='labels'
  else if Verify[TibFormat]=VerifyEntry then tmp:='on';
  AddParamRC(P,Form_ImportVerify,tmp); ParamRecRoot:=P;

  tmp:='';
  for i:=1 to length(TibLabels) do
  begin
    if tmp<>'' then tmp:=tmp+',';
    tmp:=tmp+'%'+TibLabels[i];
  end;
  AddParamRC(P,Form_Labels,tmp);

  tmp:='';
  if TibMacros=NotImpOrExp then    tmp:='off'
  else if TibMacros=ImpOnly then   tmp:='import'
  else if TibMacros=ExpOnly then   tmp:='export'
  else if TibMacros=ImpAndExp then tmp:='import,export';  
  AddParamRC(P,Form_Macros,tmp);
  
  AddParamRC(P,Form_Width,num2str(LineWidth[TibFormat]));
end;                                { TibOptions }

procedure ReferOptions(var ParamRecRoot: ParamRecPtr);
var
  i: integer;
  P: ParamRecPtr;
  tmp: string;
begin
  P:=Nil; ParamRecRoot:=Nil;
  
  tmp:='';
  if Verify[ReferFormat]=VerifyOff then        tmp:='off'
  else if Verify[ReferFormat]=VerifyLabel then tmp:='labels'
  else if Verify[ReferFormat]=VerifyEntry then tmp:='on';
  AddParamRC(P,Form_ImportVerify,tmp); ParamRecRoot:=P;

  tmp:='';
  for i:=1 to length(ReferLabels) do
  begin
    if tmp<>'' then tmp:=tmp+',';
    tmp:=tmp+'%'+ReferLabels[i];
  end;
  AddParamRC(P,Form_Labels,tmp);
  
  AddParamRC(P,Form_Width,num2str(LineWidth[ReferFormat]));
end;                                { ReferOptions }

procedure CommaOptions(var ParamRecRoot: ParamRecPtr);
var
  i: integer;
  tmp: string;
begin
  ParamRecRoot:=Nil;
  
  if Verify[CommaDelimited]=VerifyOff then        tmp:='off'
  else if Verify[CommaDelimited]=VerifyLabel then tmp:='labels'
  else if Verify[CommaDelimited]=VerifyEntry then tmp:='on';
  AddParamRC(ParamRecRoot,Form_ImportVerify,tmp);
end;                                { CommaOptions }

procedure DefSortOptions;
var
  SortPattern: PatRecPtr;
  line: string;
begin
  New(SortPattern); MaxMemAvail;
  RecallBufferStack(SortPattern^,SortPattPosDef);
  WriteSortMode(fout,ConfigSortMode^,SortPattern,true,UnixConfig);
  Dispose(SortPattern); SortPattern:=Nil;
                      
  if not eof(cfg) then        { Skip the remainder of the environment }
  repeat
    ReadLine(cfg,line,UnixConfig); ChrDelR(line,' '); ChrDelL(line,' ');
  until eof(cfg) or (line=rbrace);
end;                                { DefSortOptions }

procedure TidyUp;
var
  bak: text;
  FAttr: word;
begin
  LFNClose(cfg);
  if fout^.status=stOK then
  begin
    Dispose(fout,Done); fout:=Nil;
    if not ConfigFileBacked then
    begin
      LFNNew(bak,true); LFNAssign(bak,BackFile);
      if LFNGetFAttr(bak,FAttr)=0 then
      begin
        if (LFNErase(bak)<>0) and not YesNoRC(Str_QCantBackTo,BackFile) then
        begin
          LFNDispose(bak); Exit;
        end;
      end;
      LFNDispose(bak);
      LFNAssign(cfg,ConfigFile^);
      if LFNRename(cfg,BackFile)<>0 then
      begin
        ErrorMessageRC(Str_CantBackTo,BackFile); Exit;
      end;
      ConfigFileBacked:=true;
    end else
    begin
      if LFNErase(cfg)<>0 then
      begin
        ErrorMessageRC(Str_CantWriteCfg,'');  Exit;
      end;
    end;
    LFNAssign(cfg,TempFile);
    LFNRename(cfg,ConfigFile^);
    if SPrefs   then OptionsModified.Preferences:=false;
    if SSort    then OptionsModified.Sort:=false;
    if SRegs    then OptionsModified.Registers:=false;
    if SFormats then OptionsModified.Formats:=false;
  end else
  begin
    ErrorMessageRC(Str_CfgWriteError,num2str(fout^.status));
    Dispose(fout,Done); fout:=Nil;
  end;
  LFNDispose(cfg);
end;                                  { TidyUp }


begin                               { SaveConfigOptions }
  if not (SPrefs or SRegs or SSort or SFormats or SFields) then Exit;
  fout:=Nil; ParamRec:=Nil;
  LFNNew(cfg,true);
  PrepareTheFiles(ok); if not ok then
  begin
    LFNDispose(cfg); Exit;
  end;

  for i:=1 to MaxEnvList do
  begin
    EnvList[i]:=''; EnvIndex[i]:=0;
  end;
  NEnvList:=0;
  if SFormats then
  begin
    inc(NEnvList);
    EnvList[NEnvList]:='bibtex';         EnvIndex[NEnvList]:=BibTeXEnvIndex;
    inc(NEnvList);
    EnvList[NEnvList]:='tib';            EnvIndex[NEnvList]:=TibEnvIndex;
    inc(NEnvList);
    EnvList[NEnvList]:='refer';          EnvIndex[NEnvList]:=ReferEnvIndex;
    inc(NEnvList);
    EnvList[NEnvList]:='commadelimited'; EnvIndex[NEnvList]:=CommaEnvIndex;
  end;
  if SRegs then
  begin
    inc(NEnvList);
    EnvList[NEnvList]:='registers';      EnvIndex[NEnvList]:=RegsEnvIndex;
  end;
  if SSort then
  begin
    inc(NEnvList);
    EnvList[NEnvList]:='sort';           EnvIndex[NEnvList]:=SortEnvIndex;
  end;
  if SPrefs then
  begin
    inc(NEnvList);
    EnvList[NEnvList]:='parameters';     EnvIndex[NEnvList]:=ParamsEnvIndex;
    inc(NEnvList);
    EnvList[NEnvList]:='memory';         EnvIndex[NEnvList]:=MemoryEnvIndex;
    inc(NEnvList);
    EnvList[NEnvList]:='bibtex';         EnvIndex[NEnvList]:=BibTeXEnvIndex;
  end;
{$IFDEF WINDOWS}
  if SFields then
  begin
    inc(NEnvList);
    EnvList[NEnvList]:='fields';         EnvIndex[NEnvList]:=FieldsEnvIndex;
  end;
{$ENDIF}
  NEnvFound:=0;

  repeat
    InList:=0;
    repeat
      ReadLine(cfg,line,UnixConfig);
      tmp:=line; UnTabify(tmp); ChrDel(tmp,' ');
      if (tmp[1]='\') and (Pos(lbrace,tmp)>0) then
      begin
        tmp:=Copy(tmp,2,Pos(lbrace,tmp)-2);
        ChrDel(tmp,' '); StrLwr(tmp);
        for i:=1 to NEnvList do
          if (EnvIndex[i]>0) and (tmp=EnvList[i]) then InList:=i;
      end;
      if (InList=0) or (EnvIndex[InList]<>SortEnvIndex) then   { not for \sort }
        StreamWriteln(fout,line,UnixConfig);
    until (InList>0) or eof(cfg);

    if InList>0 then
    begin
      ParamRec:=Nil;
      case EnvIndex[InList] of
        TibEnvIndex:     TibOptions(ParamRec);
        ReferEnvIndex:   ReferOptions(ParamRec);
        CommaEnvIndex:   CommaOptions(ParamRec);
        ParamsEnvIndex:  ParametersOptions(ParamRec);
        MemoryEnvIndex:  MemoryOptions(ParamRec);
        BibTeXEnvIndex:  BibTeXOptions(ParamRec);
        RegsEnvIndex:    SaveRegisters;
        SortEnvIndex:    DefSortOptions;
{$IFDEF WINDOWS}
        FieldsEnvIndex:  SaveFields;
{$ENDIF}
      end;
      MaxMemAvail;
      UpdateParams(ParamRec);
      KillParamList(ParamRec);
      EnvIndex[InList]:=0; inc(NEnvFound);
    end;
  until eof(cfg) or (NEnvFound>=NEnvList);

  while not eof(cfg) do        { Copy the rest of the file }
  begin
    ReadLine(cfg,line,UnixConfig); StreamWriteln(fout,line,UnixConfig);
  end;

  for i:=1 to NEnvList do          { write remaining envs }
  if EnvIndex[i]<>0 then
  begin
    ParamRec:=Nil;
    StreamWriteln(fout,'',UnixConfig);
    if EnvIndex[i]<>SortEnvIndex then   { not for \sort }
      StreamWriteln(fout,'\'+UpCase(EnvList[i][1])+Copy(EnvList[i],2,255)+lbrace,
                    UnixConfig);
    case EnvIndex[i] of
      TibEnvIndex:    TibOptions(ParamRec);
      ReferEnvIndex:  ReferOptions(ParamRec);
      CommaEnvIndex:  CommaOptions(ParamRec);
      ParamsEnvIndex: ParametersOptions(ParamRec);
      MemoryEnvIndex: MemoryOptions(ParamRec);
      BibTeXEnvIndex: BibTeXOptions(ParamRec);
      RegsEnvIndex:   SaveRegisters;
      SortEnvIndex:   DefSortOptions;
    end;
    MaxMemAvail;
    P:=ParamRec;
    while P<>Nil do
    begin
      StreamWriteln(fout,'  '+P^.OrigPname^+lbrace+P^.argument^+rbrace,UnixConfig);
      P:=P^.Next;
    end;
    if ParamRec<>Nil then StreamWriteln(fout,rbrace,UnixConfig);
    KillParamList(ParamRec);
  end;

  TidyUp;
end;                                     { SaveConfigOptions }

end.
