#ifndef ROOT_H_INCLUDED
#define ROOT_H_INCLUDED
#include <Windows.h>
#include <stdio.h> // FILE
#include "dd.h"

#define WM_USER_INITIATE (WM_USER + 1)     // [U[bZ[W
#define WM_USER_ALREADY_EXIST (WM_USER +2) // AvĂыN悤
										   // Ƃɑ
#define WM_USER_FILE_OPEN (WM_USER+3)      // ̧قJƂɑ
#define WM_USER_NEW_PAGE (WM_USER+4)       // y[WړBwParam == new page.
#define WM_USER_HSCROLL (WM_USER+5)
#define WM_USER_VSCROLL (WM_USER+6)
#define WM_USER_FINDNEXT (WM_USER+7)
#define WM_USER_EXECMACRO (WM_USER+8)
#define WM_USER_EXECHYPER (WM_USER+9)
#define WM_USER_CLEARMACRO (WM_USER+10)
#define WM_USER_DO_HREF (WM_USER+11)

#define MAX_FIND_LEN    80

#define NORMAL 0
#define PLUS   1
#define MINUS  2
#define BOTTOM 3

#define	MINI_INFO 80

#define USE_INTELLI_MOUSE
#ifdef UNICODE
#define MSH_MOUSEWHEEL L"MSWHEEL_ROLLMSG"
#define MOUSEZ_CLASSNAME  L"MouseZ"           // wheel window class  
#define MOUSEZ_TITLE      L"Magellan MSWHEEL" // wheel window title
#define MSH_SCROLL_LINES L"MSH_SCROLL_LINES_MSG"
#else
#define MSH_MOUSEWHEEL "MSWHEEL_ROLLMSG"
#define MOUSEZ_CLASSNAME  "MouseZ"            // wheel window class  
#define MOUSEZ_TITLE      "Magellan MSWHEEL"  // wheel window title
#define MSH_SCROLL_LINES "MSH_SCROLL_LINES_MSG"
#endif
#ifndef WM_MOUSEWHEEL
#define WM_MOUSEWHEEL WM_MOUSELAST+1
#endif
#define MSH_WHEELMODULE_CLASS (MOUSEZ_CLASSNAME)
#define MSH_WHEELMODULE_TITLE (MOUSEZ_TITLE)

#define	DOUBLE_PAGE

typedef struct tagTOOLBAR_COMPONENT{
	HWND hWndToolBar;			// toolbar
	BOOL	bShown;
	HWND hWndFindCombo;			// handle to combo box for searching
	HWND hWndEditInCombo;		// handle to edit box in finding combo box
	HWND hWndPageEdit;			// handle to edit box for selecting page
	HWND hWndNombreStatic;		// handle to static text which shows page nombre.
	HWND hWndPageSpin;			// handle to spin for selecting page
	int cy;
} TOOLBAR_COMPONENT;

typedef struct tagSTATUSBAR_PROPERTY{
	HWND	hWnd;
	BOOL	bShown;
	int		cy;
} STATUSBAR_PROPERTY;

typedef struct tagINFO_WINDOW_PROPERTY{
	HWND	hWnd;
	BOOL	bShown;
	int		cy;
} INFO_WINDOW_PROPERTY;

typedef struct tagPAGE_SLIDER_PROPERTY{
	HWND	hWnd;
	BOOL	bShown;
	int		cx;
} PAGE_SLIDER_PROPERTY;

typedef enum{ /* HORIZONTAL, VERTICAL were both used in dd.h, so we use long names */
	NO_MOVE = 0,
	VERTICAL_MOVE = 1,
	HORIZONTAL_MOVE = 2
} MOVE_DIRECTION;

typedef enum {
	F_LCIRCLE	= 0x1,
	F_LWHITE	= 0x2,
	F_LBLACK	= 0x4,
	F_LCOLOR	= 0x6,
	F_LMEASURE	= 0x8,
	F_LEDGE		= 0x10,
	F_LHAND		= 0x100,
	F_LTOOLBAR	= 0x200,
	F_LUPDOWN	= 0x400,
	LOUPE_KILL_CURSOR	= 0x800 /* This is used only to store the value in a registory. */
} LOUPE_SHAPE;

typedef struct tagLOUPE
{
	HWND			hWnd;
	BOOL			bShown;		/* TRUE if shown. */
	BOOL			bDrawing;	/* drawing the loupe; no more draw! */
	BOOL			bKillCursor;	/* erace cursor when loupe is shown. */
	LOUPE_SHAPE		fShape;
	unsigned int	diam;		/* diameter if fShape is CIRCLE. */
	unsigned int	CTRL_size_scale;	/* high word: size, low word (16bit) scale when CTRL is pressed. */
	int div;
	unsigned int	ctrl_diam;	/* diameter if CTRL is pressed. */
	LOUPE_SHAPE		ctrl_fShape;/* shape if CTRL is pressed. */
	unsigned int	ctrl_div;	/* div if CTRL is pressed. */
	int skip;
} LOUPE;

typedef enum tagCS_PLACE{
	CS_BOTTOM	= 1,
	CS_RIGHT	= 2,
	CS_LEFT		= 4
} CS_PLACE;

typedef enum tagCS_ONOFF{
	CS_OFF	= 0,
	CS_ON	= 1,
	CS_SUSPEND	= 2 /* suspended if CS_ON & CS_SUSPEND. TODO: 3 is better? (ON | SUSPEND) */
} CS_ONOFF;

typedef enum tagCS_BUTTON{
	CS_NOBUTTON	= 0,
	CS_LBUTTON	= 1,
	CS_RBUTTON	= 2
} CS_BUTTON;

typedef struct tagCOVER_SHEET{
	CS_ONOFF	fOn;			/* CS_ON / CS_OFF / CS_SUSPEND */
	BOOL	bArrangeForPause;	/* if TRUE, Coversheet should bereplaced if "On for Pause" and there is a "Pause". */
	BOOL	bOnForPause;		/* "On For Pause" is selected. */
	BOOL	bScrollToPause;		/* "Scroll To Pause" is selected. */
	CS_PLACE	fPlace;			/* CS_BOTTOM / CS_RIGHT / CS_LEFT */
	CS_BUTTON	fButton;		/* CS_NOBUTTON / CS_LBUTTON / CS_RBUTTON */
} COVER_SHEET;

typedef enum tag_CUSROR_SHAPE{
	CS_HIDE			= 0,
	CS_NORMAL		= 1,
	CS_HAND			= 2,
	CS_MOVING_HAND	= 3,
	CS_WAIT			= 4,
	CS_POINT		= 5,
	CS_POINT_PUSH	= 6,
	CS_NS_ARROW		= 7,
	CS_WE_ARROW		= 8,
	CS_ALL_ARROW	= 9,
	CS_POINTER		= 10,
	CS_LASER_HAND	= 11,
	CS_NUMBER,			/* Automatic count. */
	CS_PREV				/* To restore the previous pointer in ChangeMousePointer */
} CURSOR_SHAPE;

typedef struct tagDVI_WINDOW_PROPERTY{
	HWND	hWnd;
	short	cxClient;
	short	cyClient;
	short	nVscrollPos;
	short	nHscrollPos;
	short	nVscrollMax;
	short	nHscrollMax;
	BYTE*	pDib;
	WORD	cxDib;
	WORD	cyDib;
	short	cxIndent;
	short	cyIndent;
	BOOL	bStopRedrawByUser;
	int		gamma;
	LOUPE	loupe;
	COVER_SHEET	cover_sheet;
	/* mouse cursor */
	BOOL	bHand;				/* mouse cursor is in "hand" shape */
	BOOL	bDragging;			/* being dragged to scroll, or drawing by pen,  */
	BOOL	bCapture;			/* Mouse cursor captured. */
	BOOL	bCursorShown;				/* TRUE if a mouse cursor is shown */
	CURSOR_SHAPE	fCursorShape;		/* Mouse cursor shape. */
	/* Properties */
	BOOL	bScrollBarShown;
	MOVE_DIRECTION	fCoverMoveDir;	/* Direction to move for the covering sheet, NOMOVE, HORIZONTAL, VERTICAL */
} DVI_WINDOW_PROPERTY;

typedef enum{
	NOT_ON_FRAME = 0,
	ON_FRAME = 1,
	IN_CLIENT = 2
} CURSOR_POSITION;

typedef struct tagFRAME_COMPONENT{
	HINSTANCE hInstance;
	HWND hMainWnd;	// WINDOW handle for the frame window.
	/* Child windows */
	DVI_WINDOW_PROPERTY		dviwin;
	TOOLBAR_COMPONENT		toolbar;	
	STATUSBAR_PROPERTY		statusbar;
	PAGE_SLIDER_PROPERTY	slider;
	INFO_WINDOW_PROPERTY	info;
	HWND hWndPresenMenu;		// handle to the menu in the presentation mode
	HWND hWndPick;
	HWND hWndFind;
	HWND hWndFindAbort;
	/* Resources */	
	HANDLE hHeap;
	HMENU hMenu;
	BOOL	bMenuShown;
	HCURSOR* pCursor;
	char* szWindowTitle;	// captions of the frame window
	char* szClassName;
	char* szAppName;

	/* properties */
	/* presentation mode */
	int draw_style;
	int draw_color;

} FRAME_COMPONENT;	// global variable, g_winData.

typedef enum tagMACRO_MODE{
	KEY = 0,
	DVIOUT_SPECIAL = 1,
	HYPERTEX_SPECIAL = 2,
	DDE = 3
} MACRO_MODE;


typedef struct tagDDEDATAS{
	char* szService;   // T[rX
	HANDLE hInst;                   // CX^Xnh
	DWORD  idInst;                  // CX^Xhc
	HSZ    hszService1;              // T[rX̕nh
	HSZ    hszService2;
	HSZ    hszTopic1;                // gsbN̕nh
	HSZ    hszTopic2;
} DDESTRUCT;

typedef enum tagTIMERID{
	MOUSE_NO_MOVE = 8
} TIMERID;

#define	MAX_MACROSIZE 0x800


extern HBITMAP	hBitmap;
extern HDC		hMemDC;

void NotifyDviInfo( DVI_WINDOW_PROPERTY * );
POINT GetDVICoordFromClient(const DVI_WINDOW_PROPERTY *w, int x, int y);

/* Application Global variables */
extern FRAME_COMPONENT g_winData;	/* wmain.c, all information about windows */
extern UINT g_nErrorCode;			/* err.c, application wide error code */
extern char *g_szLogFileName;		/* wmain.c, name of the log file */
extern BOOL g_bLog;					/* wmain.c, boolean log-output */
extern BOOL g_bPropertySheetChange;	/* tabctrl.c, TRUE if [OK] or [Apply] was pressed at "Setup parameters" */
extern BOOL g_bCheckColorSpecial;	/* inter.c, boolean check color special */
extern SCALED_PT OX;						/* prtinit.c horizontal absolute shift amount of output */
extern SCALED_PT OY;						/* prtinit.c vertical absolute shift amount of output */

extern int stop_level;
extern int stop_max;
extern BOOL f_killstop;
extern UINT f_s_color;
extern UINT f_h_color;
extern BOOL f_button;
extern int	f_renew;
extern int  f_osversion;
extern int  f_quit;
extern BOOL f_English;
extern BOOL f_dstop;
extern int f_background;
extern int start_background;
#ifdef	RAWOUT
extern BOOL f_rawfile;
#endif
#ifdef	DOUBLE_PAGE
extern BYTE *pDib2;
extern BYTE *p2Page;
extern int f_2page;
extern int last_bmp;
#endif
extern BOOL f_macro;

#define	G_CYTOOLBAR		26
#define	G_CYSTATUSBAR	18

#define	G_ROOM			2
#define	MAX_FSIZE		512


enum {
	START_EXPL, END_EXPL, CREATE_GROUP, CREATE_ICON, DELETE_GROUP, DELETE_ICON
};

/*********************************************************************************
*** Prototype declarations
*********************************************************************************/
LRESULT  CALLBACK WndProc( HWND, UINT, WPARAM, LPARAM );
LRESULT  CALLBACK MainWndProc( HWND, UINT, WPARAM, LPARAM );
BOOL     CALLBACK AboutDlgProc( HWND, UINT, UINT, LONG );
HDDEDATA CALLBACK DdeCallback(UINT,UINT,HCONV,HSZ,HSZ,HDDEDATA,DWORD,DWORD );
LRESULT  CALLBACK ComboWndProc( HWND, UINT, WPARAM, LPARAM );
LRESULT  CALLBACK PageEditProc( HWND, UINT, WPARAM, LPARAM );
LRESULT  CALLBACK PageSpinProc( HWND, UINT, WPARAM, LPARAM );
LRESULT  CALLBACK ComboEditProc( HWND, UINT, WPARAM, LPARAM );
LRESULT  CALLBACK LoupeWndProc( HWND, UINT, WPARAM, LPARAM );
BOOL	 CALLBACK KeyDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL	 CALLBACK PageSizeDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL	 CALLBACK PSearchDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL	 CALLBACK PHyperDlgProc( HWND, UINT, WPARAM, LPARAM );

void InitMainWindow( HANDLE, int );
void InitViewWindow( void );
void InitLoupeWindow( void );
void InitDDE( void );

/* wmain.c */
void	DisplayMessage(char *);
void	ChangeLinkToReal(char *);
void	SystemInfo(int count);
void	PrintEnv(char *env);
void	EnvironInfo(void);
void	DisplayInfo(BYTE *pDib);
void	DisplayURL(void);
void	DisplayAnchor(unsigned char *pDib);
void	DisplaySRC(unsigned char *pDib);
void	MessageNoFile(void);
void	CheckError(void);

/* getfont.c */
void SetPropw(int);

/* epsbox.c */
BOOL bmp2bmc(char *, unsigned char *, int);

/* plug_in.c */
int open_xplugin(char *type, int depth);
int SavePicture(char *path, unsigned char *info, unsigned char *data, 
	int width, int height, int depth, char *msg);

/* misc.c */
void *marea(unsigned int);
char *Language(int);
char *FindFirstW32(char *);
char *FindNextW32(void);


/* ttfont.c */
BOOL MakeETF(void);
BOOL DeleteETF(int);
BOOL DisplayETF(void);

/* printbmp.c */
int VERdvipdfmx(void);

/* option.c */
void set_config(char *);

/* pret.c */
void do_special(char *);

/* inter.c */
void CoverChange(int);
void KeepCover(void);
void KeepCoverPos(void);
void RenewCover(void);
BOOL CoverSuspend(void);
int CoverReturn(void);
void KeepParaSpecial(char *);
void RestoreParaSpecial(void);
int GetS_Count(int);
int GetH_NamePos(POINT *, char *);
void MarkPoint(unsigned char*, int, int, int, int, unsigned char);
void JoinBoundigBox(RECT *, RECT *);
int CompBMP(unsigned char *, unsigned char *, RECT *);

/* loadpk.c */
FILE *fopenf(char *, char *);

/* pret.c */
char *IsExec(char *);
int GetPause(int *, int *, int);
int CountDvioutInitialize(void);
int GetShiftInt(unsigned char *);
int GetPickString(int);


/* prtinit.c */
int GetAddTotal(void);
int GetAddMemory(char *, char *, int);

/* wmain.c */
HFONT SetFont( float pt, HWND hwnd, const char* fontname, BOOL twobytes );
void ShowHyperLink( const char* href );
void SetMargin(HWND);
void DisplayMessage(char *);
DWORD GetFontSize( int size, const char* fontname, BOOL twobytes );
int GetVersionLevel( void );
HFONT SetFontJE(HWND hwnd);

void Clear2Page(void);

/* tabctrl.c */
void AdjustPropPage( HWND hwnd );
BOOL CALLBACK DlgChgFontProc(HWND hwnd, UINT message, UINT wParam, LONG lParam);
char *print10mm(int);
extern char *para_paper[];

/* printbmp.c */
void CutEdge(int);

/* vfont.c */
void fttInfo(void);

int ChangeMouseCursor( CURSOR_SHAPE s ); /* mwndproc.c Call it to change the cursor shape. */


BOOL     QueryFileName( char * );
char*    QuerySaveName( void );
char*    QueryParaName( void );
char*    QueryCfgName( void );
char*    QueryPrnName( void );
char*    QueryGeneralName( char *, char *, char * );
void     ViewBmpFile( BYTE*, WORD, WORD );
BYTE*    ReadDIB( char* );
BYTE*    GetDibBitsAddress( BYTE* );
WORD     GetDibWidth( BYTE* );
WORD     GetDibHeight( BYTE* );
void     HorizontalScroll( DWORD );
void     VerticalScroll( DWORD );
void     PrintBmp( BYTE* );
void     ReserveInt( char*, char*, int );
void     ReserveString( char*, char*, char* );
int      RestoreInt( char*, char*, int );
int      RestoreString( char*, int, char*, char*, char* );
void	 SetStatusBar( int, char* );
void     SetSpinRange( short, short, short );
void	 SetMarkRange( short start, short end );
void	 SetPageView( int );
void     ReserveComboList( void );
void     AddStringToCombo( char* );
void     SetUpSearchFromCombo( LPFINDREPLACE );
void     SetStringToCombo( char* );
void     SetLoupeRect( void );
void     SetLoupeCircle( void );
void     ReserveGlobal( void );
void     RestoreGlobal( void );
BOOL     ResizeAllWindows( void );
int 	 CreateTabCtrl( HWND );
BOOL 	 FontCust( void );
void	 EnableButton( BOOL );
void	 ReserveBinary( char*, char*, BYTE*, int );
int		 RestoreBinary( unsigned char*, int, char*, char*, BYTE );
int 	 ShowMessage( char *, char *, int );
void	 ApplyOn(HWND, UINT *);
void	 ApplyOff(HWND);
UINT	 QueryApply(HWND, UINT);
void	 RestoreRegistry(void);
int	 DeleteRegistry(char *, char *);
int	 SetParaSection(int);
int	 RestoreIntPara(char *, int);
void	 ShowWinHelp(int);
int	 ChangeToolBar(int);
void	 ReserveKeyTable(void);
void	 DisplayWinMessage(HWND, char *);
void	 NotifyDviinfo(DVI_WINDOW_PROPERTY *);
void	 ShowCHelp(DWORD, DWORD *);
void	 ChangeWaitCursor(int);
void	 MessageSaved(HWND);
BOOL 	 InstallPara(void);
int 	 GetLPTName(char *, int);
unsigned int KeyId(char *);
int 	 RestoreClassString(char*, int, char*, char*, char*);
BOOL	 CallExplorer(int, char *, char *, char *);
unsigned int GetUserKey(int);
char	 *GetUserInfo(int);
void	 SetButton(void);
HINSTANCE ExecHref(HWND, char *);
BOOL	 Install2Reg(char *);
void	 Clear2Page(void);
void	 InitTTOut(HDC, int, int, int, int);
void	 DisplayMetaFile(HDC, BYTE*, int, int, int, int, int);
int		 PrintKeepBMP(HDC, HDC, BYTE*, int, int, int, int, int, int, int, int, int, int, int);
void	 CheckMenu(UINT, BOOL);
void	 CheckMenuSet(UINT, UINT, UINT);
int      GetVersionLevel( void );
HFONT	 SetFont(float, HWND, const char*, BOOL);
HFONT	 SetFontJE(HWND);
HFONT	 ReSetFont(HWND);
int		 SetStatusWindow(void);
BOOL	 ToSource(char **, int);
int		 SetPoint(int, int, int);
void	 GetLastPoint(int *, int *);
void	 ArrangeMenuString(void);
UINT	 MessageCBox(HWND, char *, char *, unsigned int);
char*	 DefineDVIFileName( const char* );
void	 RelateDVI(void);
BOOL	 SetStartMenu(void);
void	 Copy2Clipboad(HWND, char *);
void	 Add2Clipboad(HWND, char *);
void	 Copy2Editor(HWND, char *, int);
void	CALLBACK Timer9Proc(HWND hWnd, UINT uMsg, UINT idEvent, DWORD dwTime);
void	CALLBACK Timer7Proc(HWND hWnd, UINT uMsg, UINT idEvent, DWORD dwTime);
void	CALLBACK Timer10Proc(HWND hWnd, UINT uMsg, UINT idEvent, DWORD dwTime);
int		DoMacro(char *para, MACRO_MODE mode);

int DownPage( void );
int UpPage( void );
int TurnPage( int nBase );
int ShowNewPage( int n );
int Show4Pages( void );
int Show16Pages( void );
int ShowDVI( RECT *pRect, const POINT* p_cursor_pt );
int RenewDVI( BYTE **ppDibNew, const POINT* p_cursor_pt  );
int ShowDVI0( RECT *pRect );
int SetDraggingCursorShape( void );
int SelectPage( int x, int y );
int ReOpen( BOOL );
int NewOpen( void );
#endif // ROOT_H_INCLUDED

#if	defined(MSVC) && !defined(_WARNING_)
#define	_WARNING_
#pragma warning( disable : 4244 4245 4018 4102 4761 )
#endif
