-- |
-- Module      :  HsIndex.CharLists.SubsIEC
-- Copyright   :  Jean-Luc JOULIN 2018-2019
-- License     :  General Public Licence (GPLv3)
-- Maintainer  :  Jean-Luc JOULIN  <jean-luc-joulin@orange.fr>
-- Stability   :  alpha
-- Portability :  portable
-- The list of imakeidx IEC substitution hard-coded for all languages.


module HsIndex.CharLists.SubsIEC where


-- | List of characters substitutions for parsing the 'imakeindex' output file.
lstLaTeXSubs =
  [ ("'e"      , 'é')
  , ("`e"      , 'è')
  , ("^e"      , 'ê')
  , ("\"e"     , 'ë')
  , ("`a"      , 'à')
  , ("^a"      , 'â')
  , ("\"a"     , 'ä')
  , ("\"\\i"   , 'ï')
  , ("^\\i "   , 'î')
  , ("^u"      , 'û')
  , ("\"u"     , 'ü')
  , ("^o"      , 'ô')
  , ("\"o"     , 'ö')
  , ("'E"      , 'É')
  , ("`E"      , 'È')
  , ("^E"      , 'Ê')
  , ("\"E"     , 'Ë')
  , ("`A"      , 'À')
  , ("^A"      , 'Â')
  , ("\"A"     , 'Ä')
  , ("\"\\I"   , 'Ï')
  , ("^\\I "   , 'Î')
  , ("^U"      , 'Û')
  , ("\"U"     , 'Ü')
  , ("^O"      , 'Ô')
  , ("\"O"     , 'Ö')
  , ("r a"     , 'å')
  , ("ae"      , 'æ')
  , ("oe"      , 'œ')
  , ("c c"     , 'ç')
  , ("ss"      , 'ß')
  , ("r A"     , 'Å')
  , ("AE"      , 'Æ')
  , ("OE"      , 'Œ')
  , ("cyra"    , 'а')
  , ("cyrb"    , 'б')
  , ("cyrv"    , 'в')
  , ("cyrg"    , 'г')
  , ("cyrd"    , 'д')
  , ("cyre"    , 'е')
  , ("cyryo"   , 'ё')
  , ("cyrzh"   , 'ж')
  , ("cyrz"    , 'з')
  , ("cyri"    , 'и')
  , ("cyrishrt", 'й')
  , ("cyrk"    , 'к')
  , ("cyrl"    , 'л')
  , ("cyrm"    , 'м')
  , ("cyrn"    , 'н')
  , ("cyro"    , 'о')
  , ("cyrp"    , 'п')
  , ("cyrr"    , 'р')
  , ("cyrs"    , 'с')
  , ("cyrt"    , 'т')
  , ("cyru"    , 'у')
  , ("cyrf"    , 'ф')
  , ("cyrh"    , 'х')
  , ("cyrc"    , 'ц')
  , ("cyrch"   , 'ч')
  , ("cyrsh"   , 'ш')
  , ("cyrshch" , 'щ')
  , ("cyrhrdsn", 'ъ')
  , ("cyrery"  , 'ы')
  , ("cyrsftsn", 'ь')
  , ("cyrerev" , 'э')
  , ("cyryu"   , 'ю')
  , ("cyrya"   , 'я')
  , ("CYRA"    , 'А')
  , ("CYRB"    , 'Б')
  , ("CYRV"    , 'В')
  , ("CYRG"    , 'Г')
  , ("CYRD"    , 'Д')
  , ("CYRE"    , 'Е')
  , ("CYRYO"   , 'Ё')
  , ("CYRZH"   , 'Ж')
  , ("CYRZ"    , 'З')
  , ("CYRI"    , 'И')
  , ("CYRISHRT", 'Й')
  , ("CYRK"    , 'К')
  , ("CYRL"    , 'Л')
  , ("CYRM"    , 'М')
  , ("CYRN"    , 'Н')
  , ("CYRO"    , 'О')
  , ("CYRP"    , 'П')
  , ("CYRR"    , 'Р')
  , ("CYRS"    , 'С')
  , ("CYRT"    , 'Т')
  , ("CYRU"    , 'У')
  , ("CYRF"    , 'Ф')
  , ("CYRH"    , 'Х')
  , ("CYRC"    , 'Ц')
  , ("CYRCH"   , 'Ч')
  , ("CYRSH"   , 'Ш')
  , ("CYRSHCH" , 'Щ')
  , ("CYRHRDSN", 'Ъ')
  , ("CYRERY"  , 'Ы')
  , ("CYRSFTSN", 'Ь')
  , ("CYREREV" , 'Э')
  , ("CYRYU"   , 'Ю')
  , ("CYRYA"   , 'Я')
  

  , ("textquoteleft"   , '‘')
  , ("textquoteright"   , '’')
  , ("nobreakspace"   , ' ')
  
  
  ]





