#include "align.h"
/* VAX/VMS verion
#include <unixio>
*/
#include <stdio.h>
#include <ctype.h>

char *input_pointer;

FILE *outstream;

static FILE *input_stream;
 char  input_buffer[512];
static int   input_eof = TRUE;
static int   input_eoln = TRUE;
static int   line_count;


int open_source(file)
char *file;
{
  input_pointer = input_buffer;
  line_count = 0;
  if (strcmp(file,"stdin") == 0) {
    input_eof = FALSE;
    input_stream = stdin;
    return(TRUE);
  }
  else
  if ((input_stream = fopen(file,"r")) != NULL) {
    input_eof = FALSE;
    return(TRUE);
  }
  else {
  input_eof = TRUE;
  return(FALSE);
  }
}


int fetchline()
{
  if (fgets(input_buffer,511,input_stream) == NULL) {
    input_eof=TRUE;
    return(FALSE);
  }
  else {
    input_pointer = input_buffer;
    line_count++;
    input_eoln = FALSE;
    return(TRUE);
  }
}


/* returns the next character, interpreting EOLN as ' ', calling
   for new line at EOLN, and maintaining input_eoln flag. */
char nextchar()
{
  char c;

  if (input_eoln) {
    if (fetchline())
      input_eoln = FALSE;
    else  return(' ');
    }

  c = *input_pointer++;
  if (c == '\n') {
    input_eoln = TRUE;
    return(' ');
  }
  else return(c);

}

/* returns nextchar without advancing char pointer */
char peekchar()
{
  char c;
  c = nextchar();
  input_pointer--;
  return(c);
}

/* returns current position (old)
int currentpos()
{
  return(input_pointer-input_buffer);
}
*/

int currentpos()
{
  int pos;
  char *point;

  pos = 0;
  for (point = input_buffer; point <= input_pointer; point++)
    if (*point == '\t') {
      pos = pos - (pos%8)+8;
    }
    else pos++;
  return(pos);
}


/* returns TRUE if remainder of line matches string */
int matchstr(s)
char s[];
{
  if (!strncmp(input_pointer,s,strlen(s)))
    return(TRUE);
  else
   return(FALSE);
}

/* returns whether end-of-line has been reached */
int eoln()
{
  return(input_eoln);
}

/* returns whether end-of-file has been reached */
int eof()
{return(input_eof);}

/* advances to next printing char */
void advance()
{
  while (nextchar() == ' ' && !eof()) {};
  input_pointer--;
}

/* advances to next printing char or eoln, returning TRUE if not eoln */
int advanceeoln()
{
  char c;

  if (eoln()) return(FALSE);
  while ((c = nextchar()) == ' ' || c == '\t')
    if (eoln()) return(FALSE);
  input_pointer--;
  return (TRUE);
}

/* returns actual next char, no fiddles */
char squizchar()
{
	  return(*input_pointer);
}	  


int advanceeoln_pos(pos)
int *pos;
{
  int okay;

  okay = advanceeoln();
  *pos = currentpos();
  return(okay);
}

skip_to(to)
char to[];
{
  int l;
  l = strlen(to);
  while (!(strncmp(to,input_pointer,l) == 0 || eof())) {
    nextchar();
  }
}

gettoken(t)
char *t;
{
  if (advanceeoln()) {
    if (isalnum(*t++ = nextchar())) {
      while (isalnum(*t++ = nextchar())) {}
      input_pointer--;
      t--;
    }
    *t = '\0';
    return(TRUE);
  }
  else return(FALSE);
}


int linecount()
{return(line_count);}

void writeline()
{
  fputs(input_buffer,outstream);
}

/*
main()
{

  char s[30];

  open_source("stdin");
  printf(": ");

  fetchline();
  while (gettoken(s))
    printf("%s\n",s);
}
*/
