/* pkfont.cpp							-*- C++ -*-
   Time-stamp: "97/08/10 02:23:53 mik"

   Copyright (C) 1991, 92, 93, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.
   
   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef USE_MFC
#include <strstrea.h>
#endif
#include <stdio.h>
#include <string.h>
#include <io.h>
#include <process.h>

//#ifdef USE_MFC
typedef int boolean;		// FIXME: used in miktex.h
//#endif

#include "miktex.h"
#include "common.h"
#include "pkfont.h"
#include "pkchar.h"

_pkfont::_pkfont (const char *_fontname,
		  dvi_integer _mag,
		  dvi_integer _designsize,
		  dvi_integer _scaledsize,
		  const char *_mode,
		  int _bdpi)

  : char_count (256),		// FIXME
    checkdpi (dvi_false),
    fontname (strdup (_fontname)),
    mag (_mag),
    designsize (_designsize),
    scaledsize (_scaledsize),
    mode (strdup (_mode)),
    bdpi (_bdpi)
  
{
  dprintf4 ("_pkfont::_pkfont(%p, \"%s\", %ld, %ld)\n",
	    this, fontname, designsize, scaledsize);
  for (int i = 0; i < 30; i++)
    existSizes[i] = 0;
  existSizes[1] = 99999999;
  chars = 0;
}

_pkfont::~_pkfont ()

{
  dprintf1 ("_pkfont::~pkfont (%p)\n", this);
  if (chars)
    {
      for (int i = 0; i < char_count; i++)
	{
	  if (chars[i])
	    {
	      delete chars[i];
	      chars[i] = 0;
	    }
	}
      delete [] chars;
      chars = 0;
    }
  if (fontname)
    {
      free ((void *) fontname);
      fontname = 0;
    }
  if (mode)
    {
      free ((void *) mode);
      mode = 0;
    }
}

void
_pkfont::addsiz (dvi_integer rhsize)

{
  dvi_integer hsize = rhsize;
  for (dvi_integer *p = existSizes; *p < hsize; p++)
    ;
  if (*p == hsize)
    return;
  do
    {
      dvi_integer t = *p;
      *p++ = hsize;
      hsize = t;
    }
  while (hsize);
}

void
_pkfont::adddpi (dvi_integer hsize)

{
  addsiz (hsize) ;
  addsiz ((hsize * (long) 116161 + (long) 53020) / (long) 106040);
  dvi_integer a = hsize;
  dvi_integer b = 0 ;
  dvi_integer c = 1 ;
  for (int i = 0; i < 9; i++)
    {
      b = 6 * b + (a % 5) * c;
      a = a + a / 5;
      c = c * 5;
      if (b > c)
	{
	  b -= c;
	  a++;
	}
      if (b + b >= c)
	addsiz (a + 1);
      else
	addsiz (a);
    }
}

dvi_integer
_pkfont::dpicheck (dvi_integer dpi,
		   int bdpi)

{
  if (! checkdpi)
    {
      adddpi (bdpi);
      checkdpi = dvi_true;
    }
  for (int i = 0; existSizes[i] < dpi; i++)
    ;
  dvi_integer margin = 1 + dpi / 500;
  if (existSizes[i] - dpi <= margin)
    return (existSizes[i]);
  else
    if (dpi - existSizes[i - 1] <= margin)
      return (existSizes[i - 1]) ;
    else
      return (dpi);
}

const int pk_xxx1 = 240;
const int pk_xxx2 = 241;
const int pk_xxx3 = 242;
const int pk_xxx4 = 243;
const int pk_yyy = 244;
const int pk_post = 245;
const int pk_no_op = 246;
const int pk_pre = 247;

enum dvi_bool
_pkfont::read ()

{
  if (chars)
    return (dvi_true);

  chars = new _pkchar * [char_count];
  memset (chars, 0, sizeof (_pkchar *) * char_count);
  if (chars == 0)
    return (dvi_false);
  
  dvi_integer dpi = ((dvi_integer)
		     (((dvi_real) mag * (dvi_real) scaledsize * (dvi_real) bdpi)
		      / ((dvi_real) designsize * 1000.0) + 0.5));
  dpi = dpicheck (dpi, bdpi);

  char filename[300];
  if (! find_pk_file (fontname, mode, dpi, filename))
    {
      if (! makeit (fontname, dpi, bdpi, mode))
	return (dvi_false);
      if (! find_pk_file (fontname, mode, dpi, filename))
	return (dvi_false);
    }
  _ifwrdstream pkstream (filename);
  while (pkstream.good () && ! pkstream.eof ())
    {
      int b = pkstream.readbyte ();
      dprintf1 ("PK command: %d\n", b);

      // Process a PK command
      switch (b)
	{
	case pk_xxx1:
	case pk_xxx2:
	case pk_xxx3:
	case pk_xxx4:
	  // Do xxx
	  {
	    dvi_integer w;
	    dvi_integer k;
	    int n = b - pk_xxx1;
	    switch (n)
	      {
	      case 0:
		k = pkstream.readbyte ();
		break;
	      case 1:
		k = pkstream.readpair ();
		break;
	      case 2:
		k = pkstream.readtrio ();
		break;
	      case 3:
		k = pkstream.readsignedquad ();
		break;
	      }
	    pkstream.skipg (k);
	  } // Do xxx
	  break;

	case pk_yyy:
	  pkstream.skipg (4); // ignore value
	  break;

	case pk_post:
	case pk_no_op:
	  break;

	case pk_pre:
	  // Do the preamble
	  {
	    pkstream.readbyte ();	// skip id byte
	    int len = pkstream.readbyte ();
	    pkstream.skipg (len);	// skip the comment
	    ds = pkstream.readsignedquad ();
	    cs = pkstream.readsignedquad ();
	    hppp = pkstream.readsignedquad ();
	    vppp = pkstream.readsignedquad ();
	    dprintf1 ("ds: %lu\n", ds);
	    dprintf1 ("cs: %lo\n", cs);
	    dprintf1 ("hppp: %lu\n", hppp);
	    dprintf1 ("vppp: %lu\n", vppp);
	  } // Do the preamble
	  break;

	default:
	  // Do a character definition
	  _pkchar *pkc = new _pkchar ();
	  pkc->read (pkstream, b, scaledsize);
	  chars[ pkc->code() ] = pkc;
	  break;
	} // Process a PK command
    }

  wrdspace = 0.2 * scaledsize;
  bakspace = 0.9 * scaledsize;
  linspace = 0.8 * scaledsize;
  return (dvi_true);
}

enum dvi_bool
_pkfont::makeit (const char *	name,
		 int		dpi,
		 int		bdpi,
		 const char *	mode)

{
  return (make_pk_font (name, dpi, bdpi, mode) == 0 ? dvi_true : dvi_false);
}

const _pkchar *
_pkfont::operator[] (size_t idx)

{
  _pkchar *ret;
  if (! read () || chars[idx] == 0)
    ret = &nilchar;
  else
    ret = chars[idx];
  ret->makebitmap ();
  return (ret);
}

dvi_integer
_pkfont::wordspace ()

{
  read ();
  return (wrdspace);
}

dvi_integer
_pkfont::backspace ()

{
  read ();
  return (bakspace);
}

dvi_integer
_pkfont::linespace ()

{
  read ();
  return (linspace);
}
