/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.AssignedMacro;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.CountRegister;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.IntegerContentCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXLongNumber;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.AtFirstOfOne;
import com.dickimawbooks.texparserlib.latex.AtFirstOfTwo;
import com.dickimawbooks.texparserlib.latex.AtNumberOfNumber;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXGenericCommand;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.DTLandname;
import com.dickimawbooks.texparserlib.latex.datatool.DTLcompare;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdatumtype;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdatumvalue;
import com.dickimawbooks.texparserlib.latex.datatool.DTLdefcurrency;
import com.dickimawbooks.texparserlib.latex.datatool.DTLfetchlistelement;
import com.dickimawbooks.texparserlib.latex.datatool.DTLformatlist;
import com.dickimawbooks.texparserlib.latex.datatool.DTLifinlist;
import com.dickimawbooks.texparserlib.latex.datatool.DTLifintclosedbetween;
import com.dickimawbooks.texparserlib.latex.datatool.DTLifintopenbetween;
import com.dickimawbooks.texparserlib.latex.datatool.DTLinsertinto;
import com.dickimawbooks.texparserlib.latex.datatool.DTLlistelement;
import com.dickimawbooks.texparserlib.latex.datatool.DTLnewcurrencysymbol;
import com.dickimawbooks.texparserlib.latex.datatool.DTLnumitemsinlist;
import com.dickimawbooks.texparserlib.latex.datatool.DTLpadleadingzeros;
import com.dickimawbooks.texparserlib.latex.datatool.DTLparse;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetdefaultcurrency;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetnumberchars;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsettemporaldatum;
import com.dickimawbooks.texparserlib.latex.datatool.DTLsetup;
import com.dickimawbooks.texparserlib.latex.datatool.DataCurrencyElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataDateElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataDateTimeElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataIntElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataNumericElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataRealElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataStringElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataTimeElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolDateFmt;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolDateTimeFmt;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolTimeFmt;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolTimeZoneFmt;
import com.dickimawbooks.texparserlib.latex.datatool.DateFormatter;
import com.dickimawbooks.texparserlib.latex.datatool.DatumElement;
import com.dickimawbooks.texparserlib.latex.datatool.DatumMarker;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import com.dickimawbooks.texparserlib.latex.datatool.Julian;
import com.dickimawbooks.texparserlib.latex.datatool.NumericFormatter;
import com.dickimawbooks.texparserlib.latex.ifthen.IfThenSty;
import com.dickimawbooks.texparserlib.latex.latex3.LaTeX3Boolean;
import com.dickimawbooks.texparserlib.latex.latex3.SequenceCommand;
import com.dickimawbooks.texparserlib.primitives.NewIf;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Pattern;

public class DataToolBaseSty
extends LaTeXSty {
    private IfThenSty ifThenSty;
    private Locale numericLocale;
    private Vector<TeXObject> currencySymbolList;
    private CountRegister sortCountReg;
    private TeXObjectList nullMarker;
    private GenericCommand noValueCs;
    private GenericCommand numberNullCs;
    private GenericCommand stringNullCs;
    private DataToolSty datatoolSty;
    public static final String INDEX_OUT_OF_RANGE = "datatool.index.outofrange";
    public static final String INVALID_DATE_TIME = "datatool.invalid.datetime";
    public static final String FMT_INTEGER_VALUE = "__texparser_fmt_integer_value:n";
    public static final String FMT_DECIMAL_VALUE = "__texparser_fmt_decimal_value:n";
    public static final String FMT_CURRENCY_VALUE = "__texparser_fmt_currency_value:n";
    public static final String FMT_DATETIME_VALUE = "__texparser_fmt_datetime_value:n";
    public static final String FMT_DATE_VALUE = "__texparser_fmt_date_value:n";
    public static final String FMT_TIME_VALUE = "__texparser_fmt_time_value:n";
    static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("y-MM-dd'T'HH:mm:ssX");
    static final SimpleDateFormat LOCAL_DATE_TIME_FORMAT = new SimpleDateFormat("y-MM-dd'T'HH:mm:ss");
    static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("y-MM-dd");
    static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    static final Pattern TIMESTAMP_PATTERN = Pattern.compile("([+\\-]?\\d+)-(\\d{2})-(\\d{2})[ T](\\d{2}):(\\d{2})(?:(\\d{2}))?(Z|[+\\-]\\d{2}:\\d{2})?");
    public static final String DATUM_NNNN = "__datatool_datum:nnnn";
    public static final String OLD_NULL_VALUE_CSNAME = "@dtlnovalue";
    public static final String NULL_VALUE_CSNAME = "c_datatool_nullvalue_tl";
    public static final String NUMBER_NULL_CSNAME = "@dtlnumbernull";
    public static final String STRING_NULL_CSNAME = "@dtlstringnull";
    public static final String DTL_CURRENCY_CSNAME = "@dtl@currency";
    public static final String PARSE_DATETIME_BOOL = "l__datatool_parse_datetime_bool";
    public static final String REFORMAT_DATETIME_BOOL = "l__datatool_reformat_datetime_bool";
    public static final String REFORMAT_NUMERIC_BOOL = "l__datatool_reformat_numeric_bool";
    public static final String AUTO_REFORMAT_TYPES_SEQ = "l__datatool_auto_reformat_types_seq";
    public static final String TMPA_VAR = "l__datatool_tmpa_tl";
    public static final String TMPB_VAR = "l__datatool_tmpb_tl";
    public static final Pattern SCIENTIFIC_PATTERN = Pattern.compile("[+\\-]?\\d+(\\.\\d+)?[Ee][+\\-]?\\d+");

    public DataToolBaseSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, "datatool-base", laTeXParserListener, bl);
    }

    @Override
    public void addDefinitions() {
        TeXParser teXParser = this.getListener().getParser();
        this.sortCountReg = teXParser.getSettings().newcount(false, "dtl@sortresult");
        NewIf.createConditional(true, teXParser, "ifDTLlistskipempty", true);
        this.registerControlSequence(new LaTeX3Boolean(PARSE_DATETIME_BOOL, false));
        this.registerControlSequence(new LaTeX3Boolean(REFORMAT_DATETIME_BOOL, false));
        this.registerControlSequence(new LaTeX3Boolean(REFORMAT_NUMERIC_BOOL, false));
        SequenceCommand sequenceCommand = new SequenceCommand(AUTO_REFORMAT_TYPES_SEQ);
        sequenceCommand.append(this.getListener().createString("integer"));
        sequenceCommand.append(this.getListener().createString("decimal"));
        sequenceCommand.append(this.getListener().createString("si"));
        sequenceCommand.append(this.getListener().createString("currency"));
        sequenceCommand.append(this.getListener().createString("datetime"));
        sequenceCommand.append(this.getListener().createString("date"));
        sequenceCommand.append(this.getListener().createString("time"));
        this.registerControlSequence(sequenceCommand);
        this.registerControlSequence(new DTLnewcurrencysymbol(this));
        this.registerControlSequence(new DTLsetdefaultcurrency(this));
        this.registerControlSequence(new DTLifintopenbetween());
        this.registerControlSequence(new DTLifintclosedbetween());
        this.registerControlSequence(new DTLifinlist());
        this.registerControlSequence(new DTLnumitemsinlist());
        this.registerControlSequence(new DTLlistelement());
        this.registerControlSequence(new DTLfetchlistelement());
        this.registerControlSequence(new DTLformatlist());
        this.registerControlSequence(new AtFirstOfOne("DTLlistformatitem"));
        this.registerControlSequence(new GenericCommand("DTLlistformatoxford"));
        this.registerControlSequence(new GenericCommand("DTLlistformatsep", null, this.getListener().createString(", ")));
        this.registerControlSequence(new GenericCommand(true, "DTLlistformatlastsep", null, new TeXObject[]{new TeXCsRef("space"), new TeXCsRef("DTLandname"), new TeXCsRef("space")}));
        this.registerControlSequence(new DTLandname());
        this.registerControlSequence(new DTLinsertinto(this));
        this.registerControlSequence(new DTLinsertinto("edtlinsertinto", true, this));
        this.registerControlSequence(new DTLcompare());
        this.registerControlSequence(new DTLcompare("dtlicompare", false));
        this.registerControlSequence(new DTLsetnumberchars(this));
        if (this.numericLocale == null) {
            this.setNumericLocale(this.getListener().getTeXApp().getDefaultLocale());
        }
        this.registerControlSequence(new AtFirstOfTwo("DTLtemporalvalue"));
        this.registerControlSequence(new DateFormatter(FMT_DATETIME_VALUE, DATE_TIME_FORMAT));
        this.registerControlSequence(new DateFormatter(FMT_DATE_VALUE, DATE_FORMAT));
        this.registerControlSequence(new DateFormatter(FMT_TIME_VALUE, TIME_FORMAT));
        this.registerControlSequence(new DTLpadleadingzeros());
        this.registerControlSequence(new TextualContentCommand("dtlpadleadingzerosminus", "-"));
        this.registerControlSequence(new TextualContentCommand("dtlpadleadingzerosplus", ""));
        this.registerControlSequence(new DataToolDateFmt());
        this.registerControlSequence(new DataToolTimeFmt());
        this.registerControlSequence(new DataToolTimeZoneFmt());
        this.registerControlSequence(new TextualContentCommand("DataToolTimeStampFmtSep", " "));
        this.registerControlSequence(new DataToolDateTimeFmt());
        this.addCurrencySymbol("$");
        this.addCurrencySymbol("pounds");
        this.addCurrencySymbol("textsterling");
        this.addCurrencySymbol("textdollar");
        this.addCurrencySymbol("textyen");
        this.addCurrencySymbol("texteuro");
        this.addCurrencySymbol("textwon");
        this.addCurrencySymbol("textcurrency");
        this.addCurrencySymbol("euro");
        this.addCurrencySymbol("yen");
        this.defineCurrency(null, "XXX", new TeXCsRef("textcurrency"), this.listener.getOther(164));
        this.defineCurrency(null, "XBT", new TeXCsRef("faBtc"), this.listener.getOther(8383));
        this.defineCurrency(null, "EUR", new TeXCsRef("euro"), this.listener.getOther(8364));
        this.registerControlSequence(new GenericCommand(true, DTL_CURRENCY_CSNAME, null, new TeXCsRef("$")));
        this.registerControlSequence(new LaTeXGenericCommand(true, "DTLcurrency", false, "m", TeXParserUtils.createStack(teXParser, new TeXCsRef("DTLfmtcurrency"), new TeXCsRef(DTL_CURRENCY_CSNAME), TeXParserUtils.createGroup(teXParser, this.listener.getParam(1)))));
        this.registerControlSequence(new LaTeXGenericCommand(true, "DTLfmtcurrency", "mm", TeXParserUtils.createStack(this.listener, new TeXCsRef("dtlcurrdefaultfmt"), TeXParserUtils.createGroup(this.listener, this.listener.getParam(1)), TeXParserUtils.createGroup(this.listener, this.listener.getParam(2)))));
        this.registerControlSequence(new LaTeXGenericCommand(true, "dtlcurrdefaultfmt", "mm", TeXParserUtils.createStack(this.listener, new TeXCsRef("dtlcurrprefixfmt"), TeXParserUtils.createGroup(this.listener, this.listener.getParam(1)), TeXParserUtils.createGroup(this.listener, this.listener.getParam(2)))));
        this.registerControlSequence(new LaTeXGenericCommand(true, "dtlcurrprefixfmt", false, "mm", TeXParserUtils.createStack(teXParser, this.listener.getParam(1), new TeXCsRef("dtlcurrfmtsep"), this.listener.getParam(2))));
        this.registerControlSequence(new LaTeXGenericCommand(true, "dtlcurrsuffixfmt", false, "mm", TeXParserUtils.createStack(teXParser, this.listener.getParam(2), new TeXCsRef("dtlcurrfmtsep"), this.listener.getParam(1))));
        this.registerControlSequence(new GenericCommand(true, "dtlcurrfmtsep", null, TeXParserUtils.createStack(this.listener, new TeXCsRef("DTLcurrCodeOrSymOrChar"), TeXParserUtils.createGroup(this.listener, this.listener.getActiveChar(126)), this.listener.createGroup(), this.listener.createGroup())));
        this.registerControlSequence(new TextualContentCommand("DTLCurrencyCode", "XXX"));
        this.registerControlSequence(new AtNumberOfNumber("DTLcurrCodeOrSymOrChar", 2, 3));
        this.registerControlSequence(new GenericCommand(true, "DTLdefaultEURcurrencyfmt", null, new TeXCsRef("dtlcurrdefaultfmt")));
        this.registerControlSequence(new DTLdefcurrency(this));
        this.nullMarker = TeXParserUtils.createStack(this.listener, this.listener.getOther(32), this.listener.getLetter(85), this.listener.getLetter(110), this.listener.getLetter(100), this.listener.getLetter(101), this.listener.getLetter(102), this.listener.getLetter(105), this.listener.getLetter(110), this.listener.getLetter(101), this.listener.getLetter(100), this.listener.getOther(32), this.listener.getLetter(86), this.listener.getLetter(97), this.listener.getLetter(108), this.listener.getLetter(117), this.listener.getLetter(101), this.listener.getLetter(32));
        this.registerControlSequence(new GenericCommand(true, NULL_VALUE_CSNAME, null, this.nullMarker));
        this.noValueCs = new GenericCommand(true, "dtlnovalue", null, new TeXCsRef(NULL_VALUE_CSNAME));
        this.registerControlSequence(this.noValueCs);
        this.registerControlSequence(new IntegerContentCommand(NUMBER_NULL_CSNAME, 0, true));
        this.numberNullCs = new GenericCommand(true, "DTLnumbernull", null, new TeXCsRef(NUMBER_NULL_CSNAME));
        this.registerControlSequence(this.numberNullCs);
        this.registerControlSequence(new TextualContentCommand(STRING_NULL_CSNAME, "NULL", true));
        this.stringNullCs = new GenericCommand(true, "DTLstringnull", null, new TeXCsRef(STRING_NULL_CSNAME));
        this.registerControlSequence(this.stringNullCs);
        this.registerControlSequence(new DTLsetup(this));
        this.registerControlSequence(new DatumMarker());
        this.registerControlSequence(new AtNumberOfNumber("datatool_datum_value:Nnnnn", 3, 5));
        this.registerControlSequence(new AtNumberOfNumber("datatool_datum_type:Nnnnn", 5, 5));
        this.registerControlSequence(new DTLdatumtype(this));
        this.registerControlSequence(new DTLdatumvalue(this));
        this.registerControlSequence(new DTLsettemporaldatum(this));
        this.registerControlSequence(new DTLparse(this));
        this.registerControlSequence(new DTLparse("xDTLparse", true, this));
        for (DatumType datumType : DatumType.values()) {
            this.registerControlSequence(new IntegerContentCommand(datumType.getCsName(), datumType.getValue(), true));
        }
        this.registerControlSequence(new TextualContentCommand("datatoolpersoncomma", ", "));
        this.registerControlSequence(new TextualContentCommand("datatoolplacecomma", ", "));
        this.registerControlSequence(new TextualContentCommand("datatoolsubjectcomma", ", "));
        this.registerControlSequence(new TextualContentCommand("datatoolparenstart", " "));
        this.registerControlSequence(new LaTeXGenericCommand(true, "datatoolparen", "m", TeXParserUtils.createStack(this.listener, this.listener.getSpace(), this.listener.getOther(40), this.listener.getParam(1), this.listener.getOther(41))));
        this.registerControlSequence(new GenericCommand(true, "datatoolasciistart"));
        this.registerControlSequence(new GenericCommand(true, "datatoolasciiend"));
        this.registerControlSequence(new GenericCommand(true, "datatoolctrlboundary"));
        this.registerControlSequence(new AtFirstOfTwo("dtltexorsort"));
        this.addSymbolVars("cent", 162);
        this.addSymbolVars("pound", 163);
        this.addSymbolVars("currency", 164);
        this.addSymbolVars("yen", 165);
        this.addSymbolVars("middot", 183);
        this.addSymbolVars("florin", 402);
        this.addSymbolVars("baht", 3647);
        this.addSymbolVars("ecu", 8352);
        this.addSymbolVars("colonsign", 8353);
        this.addSymbolVars("cruzerio", 8354);
        this.addSymbolVars("frenchfranc", 8355);
        this.addSymbolVars("lira", 8356);
        this.addSymbolVars("mill", 8357);
        this.addSymbolVars("naira", 8358);
        this.addSymbolVars("peseta", 8359);
        this.addSymbolVars("rupee", 8360);
        this.addSymbolVars("won", 8361);
        this.addSymbolVars("shekel", 8362);
        this.addSymbolVars("dong", 8363);
        this.addSymbolVars("euro", 8364);
        this.addSymbolVars("kip", 8365);
        this.addSymbolVars("tugrik", 8366);
        this.addSymbolVars("drachma", 8367);
        this.addSymbolVars("germanpenny", 8368);
        this.addSymbolVars("peso", 8369);
        this.addSymbolVars("guarani", 8370);
        this.addSymbolVars("austral", 8371);
        this.addSymbolVars("hryvnia", 8372);
        this.addSymbolVars("cedi", 8373);
        this.addSymbolVars("livretournois", 8374);
        this.addSymbolVars("spesmilo", 8375);
        this.addSymbolVars("tenge", 8376);
        this.addSymbolVars("indianrupee", 8377);
        this.addSymbolVars("turkishlira", 8378);
        this.addSymbolVars("nordicmark", 8379);
        this.addSymbolVars("manat", 8380);
        this.addSymbolVars("ruble", 8381);
        this.addSymbolVars("lari", 8382);
        this.addSymbolVars("bitcoin", 8383);
        this.addSymbolVars("som", 8384);
    }

    protected void addSymbolVars(String string, int n) {
        this.registerControlSequence(this.listener.createSymbol("l_datatool_" + string + "_str", 8384));
        this.registerControlSequence(this.listener.createSymbol("l_datatool_" + string + "_tl", 8384));
    }

    @Override
    protected void preOptions(TeXObjectList teXObjectList) throws IOException {
        this.getListener().requirepackage("etoolbox", teXObjectList);
        this.ifThenSty = (IfThenSty)this.getListener().requirepackage("ifthen", teXObjectList);
    }

    public void setDataBaseSty(DataToolSty dataToolSty) {
        this.datatoolSty = dataToolSty;
    }

    public void processSetupOption(String string, TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        if (!(string.equals("verbose") || string.equals("initial-purify") || string.equals("compare") || string.equals("lists"))) {
            if (string.equals("auto-reformat-types")) {
                SequenceCommand sequenceCommand = new SequenceCommand(AUTO_REFORMAT_TYPES_SEQ);
                if (teXObject != null) {
                    String[] stringArray;
                    for (String string2 : stringArray = teXObject.toString(this.getParser()).split(",")) {
                        if ((string2 = string2.trim()).isEmpty()) continue;
                        if (string2.equals("integer") || string2.equals("decimal") || string2.equals("si") || string2.equals("datetime") || string2.equals("date") || string2.equals("time")) {
                            sequenceCommand.append(this.getListener().createString(string2));
                            continue;
                        }
                        throw new LaTeXSyntaxException(this.getParser(), "latex.invalid.option.value", string, string2);
                    }
                }
                this.getParser().putControlSequence(true, sequenceCommand);
            } else if (string.equals("numeric")) {
                if (teXObject == null) {
                    throw new LaTeXSyntaxException(this.getParser(), "latex.error.missing_key_value", string);
                }
                this.setupNumeric(TeXParserUtils.toKeyValList(teXObject, this.getParser()), teXObjectList);
            } else if (string.equals("datetime")) {
                if (teXObject == null) {
                    throw new LaTeXSyntaxException(this.getParser(), "latex.error.missing_key_value", string);
                }
                this.setupDateTime(TeXParserUtils.toKeyValList(teXObject, this.getParser()), teXObjectList);
            } else if (!(string.equals("utf8") || string.equals("math") || string.equals("locales") || string.equals("nolocale"))) {
                if (this.datatoolSty != null) {
                    this.datatoolSty.processSetupOption(string, teXObject, teXObjectList);
                } else {
                    throw new LaTeXSyntaxException(this.getParser(), "latex.unknown.option", string, "datatool-base");
                }
            }
        }
    }

    public void setupNumeric(KeyValList keyValList, TeXObjectList teXObjectList) throws IOException {
        for (String string : keyValList.keySet()) {
            TeXObject teXObject = (TeXObject)keyValList.get(string);
            if (string.equals("auto-reformat")) {
                boolean bl = true;
                if (teXObject != null && !teXObject.isEmpty() && this.getParser().expandToString(teXObject, teXObjectList).trim().equals("false")) {
                    bl = false;
                }
                this.getParser().putControlSequence(true, new LaTeX3Boolean(REFORMAT_NUMERIC_BOOL, bl));
                continue;
            }
            if (string.equals("set-number-chars")) {
                TeXObjectList teXObjectList2 = TeXParserUtils.toList(teXObject, this.getParser());
                TeXObject teXObject2 = teXObjectList2.popArg(this.getParser());
                TeXObject teXObject3 = teXObjectList2.popArg(this.getParser());
                this.setNumberChars(teXObject2, teXObject3);
                continue;
            }
            if (string.equals("region-number-chars")) continue;
            if (string.equals("set-currency")) {
                if (teXObject == null) {
                    throw new LaTeXSyntaxException(this.getParser(), "latex.error.missing_key_value", string);
                }
                this.setDefaultCurrency(teXObject);
                continue;
            }
            if (string.equals("region-currency") || string.equals("region-currency-prefix") || string.equals("currency-symbol-style")) continue;
            throw new LaTeXSyntaxException(this.getParser(), "latex.unknown.option", string, "numeric");
        }
    }

    public void setupDateTime(KeyValList keyValList, TeXObjectList teXObjectList) throws IOException {
        for (String string : keyValList.keySet()) {
            String string2;
            TeXObject teXObject = (TeXObject)keyValList.get(string);
            if (string.equals("auto-reformat")) {
                string2 = "true";
                if (teXObject != null && !teXObject.isEmpty() && (string2 = this.getParser().expandToString(teXObject, teXObjectList).trim()).isEmpty()) {
                    string2 = "true";
                }
                this.getParser().putControlSequence(true, new LaTeX3Boolean(PARSE_DATETIME_BOOL, !string2.equals("false")));
                continue;
            }
            if (string.equals("parse")) {
                string2 = "true";
                if (teXObject != null && !teXObject.isEmpty() && (string2 = this.getParser().expandToString(teXObject, teXObjectList).trim()).isEmpty()) {
                    string2 = "true";
                }
                if (string2.equals("false")) {
                    this.getParser().putControlSequence(true, new LaTeX3Boolean(PARSE_DATETIME_BOOL, false));
                    continue;
                }
                if (string2.equals("true")) {
                    this.getParser().putControlSequence(true, new LaTeX3Boolean(PARSE_DATETIME_BOOL, true));
                    continue;
                }
                if (string2.equals("parse-only")) {
                    this.getParser().putControlSequence(true, new LaTeX3Boolean(PARSE_DATETIME_BOOL, true));
                    this.getParser().putControlSequence(true, new LaTeX3Boolean(REFORMAT_DATETIME_BOOL, false));
                    continue;
                }
                if (string2.equals("auto-reformat")) {
                    this.getParser().putControlSequence(true, new LaTeX3Boolean(PARSE_DATETIME_BOOL, true));
                    this.getParser().putControlSequence(true, new LaTeX3Boolean(REFORMAT_DATETIME_BOOL, true));
                    continue;
                }
                if (string2.equals("iso-only")) {
                    this.getParser().putControlSequence(true, new LaTeX3Boolean(PARSE_DATETIME_BOOL, true));
                    continue;
                }
                if (string2.equals("region-only")) {
                    this.getParser().putControlSequence(true, new LaTeX3Boolean(PARSE_DATETIME_BOOL, true));
                    continue;
                }
                if (string2.equals("iso+region")) {
                    this.getParser().putControlSequence(true, new LaTeX3Boolean(PARSE_DATETIME_BOOL, true));
                    continue;
                }
                throw new LaTeXSyntaxException(this.getParser(), "latex.invalid.option.value", string, string2);
            }
            throw new LaTeXSyntaxException(this.getParser(), "latex.unknown.option", string, "numeric");
        }
    }

    public void setNumberChars(TeXObject teXObject, TeXObject teXObject2) {
        this.setNumberChars(teXObject.toString(this.getParser()), teXObject2.toString(this.getParser()));
    }

    public void setNumberChars(String string, String string2) {
        TeXParser teXParser = this.getParser();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator(string2.charAt(0));
        decimalFormatSymbols.setGroupingSeparator(string.charAt(0));
        teXParser.putControlSequence(true, new TextualContentCommand("@dtl@numbergroupchar", string));
        teXParser.putControlSequence(true, new TextualContentCommand("@dtl@decimal", string2));
        DecimalFormat decimalFormat = new DecimalFormat("#,##0", decimalFormatSymbols);
        decimalFormat.setParseIntegerOnly(true);
        teXParser.putControlSequence(true, new NumericFormatter(FMT_INTEGER_VALUE, decimalFormat));
        teXParser.putControlSequence(true, new NumericFormatter(FMT_DECIMAL_VALUE, new DecimalFormat("#,##0.0######", decimalFormatSymbols)));
        teXParser.putControlSequence(new NumericFormatter(FMT_CURRENCY_VALUE, new DecimalFormat("#,##0.00", decimalFormatSymbols)));
    }

    public void addCurrencySymbol(TeXObject teXObject) {
        if (this.currencySymbolList == null) {
            this.currencySymbolList = new Vector();
        }
        if (teXObject == null) {
            throw new NullPointerException();
        }
        this.currencySymbolList.add(teXObject);
    }

    public void addCurrencySymbol(String string) {
        this.addCurrencySymbol(new TeXCsRef(string));
    }

    public boolean isCurrencySymbol(TeXObject teXObject) {
        if (teXObject == null) {
            return false;
        }
        for (TeXObject teXObject2 : this.currencySymbolList) {
            if (teXObject2 instanceof ControlSequence && teXObject instanceof ControlSequence && ((ControlSequence)teXObject2).getName().equals(((ControlSequence)teXObject).getName())) {
                return true;
            }
            if (!teXObject2.equals(teXObject)) continue;
            return true;
        }
        return false;
    }

    public void setDefaultCurrency(TeXObject teXObject) {
        String string = teXObject.toString(this.getParser());
        ControlSequence controlSequence = this.getParser().getControlSequence("dtl@curr@" + string + "@fmt");
        if (controlSequence == null) {
            this.getParser().putControlSequence(new TextualContentCommand("DTLCurrencyCode", "XXX"));
            this.getParser().putControlSequence(true, new GenericCommand(true, DTL_CURRENCY_CSNAME, null, teXObject));
        } else {
            this.getParser().putControlSequence(new TextualContentCommand("DTLCurrencyCode", string));
            this.getParser().putControlSequence(true, new GenericCommand(true, DTL_CURRENCY_CSNAME, null, new TeXCsRef("DTLcurr" + string)));
            this.getParser().putControlSequence(true, new GenericCommand(true, "DTLfmtcurrency", null, controlSequence));
        }
    }

    public void defineCurrency(TeXObject teXObject, String string, TeXObject teXObject2, TeXObject teXObject3) {
        if (teXObject == null) {
            teXObject = new TeXCsRef("dtlcurrdefaultfmt");
        }
        this.getParser().putControlSequence(true, new GenericCommand(true, "dtl@curr@" + string + "@str", null, teXObject3));
        this.getParser().putControlSequence(true, new GenericCommand(true, "dtl@curr@" + string + "@sym", null, teXObject2));
        this.getParser().putControlSequence(true, new GenericCommand(true, "DTLcurr" + string, null, TeXParserUtils.createStack(this.listener, new TeXCsRef("dtltexorsort"), TeXParserUtils.createGroup(this.listener, new TeXCsRef("DTLcurrCodeOrSymOrChar"), TeXParserUtils.createGroup(this.listener, this.listener.getParam(1)), new TeXCsRef("dtl@curr@" + string + "@sym"), new TeXCsRef("dtl@curr@" + string + "@str")), TeXParserUtils.createGroup(this.listener, new TeXCsRef("dtl@curr@" + string + "@str")))));
        this.addCurrencySymbol("DTLcurr" + string);
        this.addCurrencySymbol(teXObject2);
        this.addCurrencySymbol(teXObject3);
        this.getParser().putControlSequence(true, new GenericCommand(true, "dtl@curr@" + string + "@fmt", null, teXObject));
    }

    public IfThenSty getIfThenSty() {
        return this.ifThenSty;
    }

    public CountRegister getSortCountRegister() {
        return this.sortCountReg;
    }

    protected boolean isAutoReformatOn(String string) {
        ControlSequence controlSequence = this.getParser().getControlSequence(AUTO_REFORMAT_TYPES_SEQ);
        boolean bl = false;
        if (controlSequence instanceof SequenceCommand) {
            return ((SequenceCommand)controlSequence).contains(string);
        }
        return false;
    }

    public boolean isSIAutoReformatOn(boolean bl) {
        return bl && this.isAutoReformatOn("si");
    }

    public boolean isAutoReformatOn(DatumType datumType, boolean bl, boolean bl2) {
        switch (datumType) {
            case INTEGER: {
                return bl && this.isAutoReformatOn("integer");
            }
            case DECIMAL: {
                return bl && this.isAutoReformatOn("decimal");
            }
            case CURRENCY: {
                return bl && this.isAutoReformatOn("currency");
            }
            case DATETIME: {
                return bl2 && this.isAutoReformatOn("datetime");
            }
            case DATE: {
                return bl2 && this.isAutoReformatOn("date");
            }
            case TIME: {
                return bl2 && this.isAutoReformatOn("time");
            }
        }
        return false;
    }

    public static int parseInt(String string, TeXParser teXParser) throws TeXSyntaxException {
        ControlSequence controlSequence = teXParser.getControlSequence(FMT_INTEGER_VALUE);
        try {
            if (controlSequence instanceof NumericFormatter) {
                return ((NumericFormatter)controlSequence).parse(string).intValue();
            }
            return Integer.parseInt(string);
        }
        catch (NumberFormatException | ParseException exception) {
            throw new TeXSyntaxException((Throwable)exception, teXParser, "tex.error.number_expected", string);
        }
    }

    public static double parseDecimal(String string, TeXParser teXParser) throws TeXSyntaxException {
        ControlSequence controlSequence = teXParser.getControlSequence(FMT_DECIMAL_VALUE);
        try {
            if (controlSequence instanceof NumericFormatter) {
                return ((NumericFormatter)controlSequence).parse(string).doubleValue();
            }
            if (SCIENTIFIC_PATTERN.matcher(string).matches()) {
                try {
                    return new BigDecimal(string).doubleValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return Double.parseDouble(string);
        }
        catch (NumberFormatException | ParseException exception) {
            throw new TeXSyntaxException((Throwable)exception, teXParser, "tex.error.number_expected", string);
        }
    }

    public static double parseCurrencyDecimal(String string, TeXParser teXParser) throws TeXSyntaxException {
        ControlSequence controlSequence = teXParser.getControlSequence(FMT_CURRENCY_VALUE);
        try {
            if (controlSequence instanceof NumericFormatter) {
                return ((NumericFormatter)controlSequence).parse(string).doubleValue();
            }
            return Double.parseDouble(string);
        }
        catch (NumberFormatException | ParseException exception) {
            throw new TeXSyntaxException((Throwable)exception, teXParser, "tex.error.number_expected", string);
        }
    }

    public DataElement getPlainElement(DatumType datumType, TeXObject teXObject) throws IOException {
        boolean bl = TeXParserUtils.isTrue("l__datatool_db_store_datum_bool", this.getParser());
        return this.getPlainElement(datumType, teXObject, bl);
    }

    public DataElement getPlainElement(DatumType datumType, TeXObject teXObject, boolean bl) throws IOException {
        boolean bl2 = false;
        boolean bl3 = false;
        if (datumType.isTemporal()) {
            bl3 = TeXParserUtils.isTrue(REFORMAT_DATETIME_BOOL, this.getParser());
        } else if (datumType.isNumeric()) {
            bl2 = TeXParserUtils.isTrue(REFORMAT_NUMERIC_BOOL, this.getParser());
        }
        return this.getPlainElement(datumType, teXObject, bl, bl2, bl3);
    }

    public DataElement getPlainElement(DatumType datumType, TeXObject teXObject, boolean bl, boolean bl2, boolean bl3) throws IOException {
        DataElement dataElement;
        Object object;
        TeXObject teXObject2 = teXObject;
        Number number = null;
        AbstractTeXObject abstractTeXObject = null;
        Object object2 = null;
        Julian julian = null;
        if (datumType.isNumeric()) {
            try {
                object = teXObject.toString(this.getParser());
                try {
                    number = Integer.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    number = Double.valueOf((String)object);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.getListener().getTeXApp().error(numberFormatException);
                datumType = DatumType.STRING;
                number = null;
            }
        }
        if (datumType == DatumType.INTEGER || datumType == DatumType.DECIMAL) {
            if (this.isAutoReformatOn(datumType, bl2, bl3)) {
                teXObject2 = this.formatNumber(datumType, number);
            }
        } else if (datumType == DatumType.CURRENCY) {
            object = this.getListener().createStack();
            ((TeXObjectList)object).add(new TeXCsRef("DTLcurr"));
            ((TeXObjectList)object).add(TeXParserUtils.createGroup(this.getListener(), new TeXCsRef("DTLCurrencyCode")));
            object2 = object;
            if (this.isAutoReformatOn(datumType, bl2, bl3)) {
                TeXObjectList teXObjectList = this.getListener().createStack();
                teXObjectList.add(new TeXCsRef("DTLcurrency"));
                teXObjectList.add(TeXParserUtils.createGroup(this.getListener(), teXObject));
                teXObject2 = teXObjectList;
            }
        } else if (datumType.isTemporal()) {
            if (datumType == DatumType.TIME) {
                julian = Julian.createTime(number.doubleValue());
            } else if (datumType == DatumType.DATETIME) {
                julian = Julian.createDate(number.doubleValue());
            } else if (datumType == DatumType.DATE) {
                julian = Julian.createDay(number.intValue());
            }
            if (this.isAutoReformatOn(datumType, bl2, bl3)) {
                teXObject2 = julian.createTeXFormat(this.getListener());
            }
            if (bl) {
                object = this.getListener().createStack();
                ((TeXObjectList)object).add(new TeXCsRef("DTLtemporalvalue"));
                ((TeXObjectList)object).add(TeXParserUtils.createGroup(this.getListener(), abstractTeXObject));
                ((TeXObjectList)object).add(this.getListener().createGroup(julian.getTimeStamp()));
                return new DatumElement(teXObject2, (TeXNumber)((Object)abstractTeXObject), (TeXObject)object, null, julian, datumType);
            }
        }
        if (bl) {
            switch (datumType) {
                case INTEGER: {
                    abstractTeXObject = new UserNumber(number.intValue());
                    break;
                }
                case DECIMAL: 
                case CURRENCY: {
                    abstractTeXObject = new TeXFloatingPoint(number.doubleValue());
                }
            }
            dataElement = new DatumElement(teXObject2, (TeXNumber)((Object)abstractTeXObject), (TeXObject)object2, datumType);
        } else {
            switch (datumType) {
                case INTEGER: {
                    dataElement = new DataIntElement(number.intValue(), teXObject2);
                    break;
                }
                case DECIMAL: {
                    dataElement = new DataRealElement(number.doubleValue(), teXObject2);
                    break;
                }
                case CURRENCY: {
                    dataElement = new DataCurrencyElement((TeXObject)object2, number.doubleValue(), teXObject2);
                    break;
                }
                case DATE: {
                    dataElement = new DataDateElement(julian, teXObject2);
                    break;
                }
                case TIME: {
                    dataElement = new DataTimeElement(julian, teXObject2);
                    break;
                }
                case DATETIME: {
                    dataElement = new DataDateTimeElement(julian, teXObject2);
                    break;
                }
                default: {
                    dataElement = new DataStringElement(TeXParserUtils.toList(teXObject2, this.getParser()));
                }
            }
        }
        return dataElement;
    }

    public DataElement getElement(TeXObject teXObject) throws IOException {
        boolean bl = TeXParserUtils.isTrue("l__datatool_db_store_datum_bool", this.getParser());
        return this.getElement(teXObject, bl);
    }

    public DataElement getElement(TeXObject teXObject, boolean bl) throws IOException {
        boolean bl2 = TeXParserUtils.isTrue(REFORMAT_NUMERIC_BOOL, this.getParser());
        boolean bl3 = TeXParserUtils.isTrue(REFORMAT_DATETIME_BOOL, this.getParser());
        return this.getElement(teXObject, bl, bl2, bl3);
    }

    public DataElement getElement(TeXObject teXObject, boolean bl, boolean bl2, boolean bl3) throws IOException {
        TeXObject teXObject2;
        Object object;
        TeXParser teXParser = this.getListener().getParser();
        if (teXObject instanceof DatumElement) {
            return (DatumElement)teXObject;
        }
        if (teXObject instanceof DataElement) {
            if (bl) {
                DatumType datumType = ((DataElement)teXObject).getDatumType();
                switch (datumType) {
                    case INTEGER: {
                        return new DatumElement(teXObject, new UserNumber(((DataNumericElement)teXObject).intValue()), null, datumType);
                    }
                    case DECIMAL: {
                        return new DatumElement(teXObject, new TeXFloatingPoint(((DataNumericElement)teXObject).doubleValue()), null, datumType);
                    }
                    case CURRENCY: {
                        return new DatumElement(teXObject, new TeXFloatingPoint(((DataNumericElement)teXObject).doubleValue()), ((DataElement)teXObject).getCurrencySymbol(), datumType);
                    }
                    case DATETIME: 
                    case TIME: {
                        return new DatumElement(teXObject, new TeXFloatingPoint(((DataNumericElement)teXObject).doubleValue()), ((DataElement)teXObject).getTeXValue(teXParser), datumType);
                    }
                    case DATE: {
                        return new DatumElement(teXObject, new TeXLongNumber(((DataNumericElement)teXObject).longValue()), ((DataElement)teXObject).getTeXValue(teXParser), datumType);
                    }
                }
                return new DatumElement(teXObject);
            }
            return (DataElement)teXObject;
        }
        TeXObject teXObject3 = (TeXObject)teXObject.clone();
        if (teXObject instanceof TeXObjectList) {
            object = (TeXObjectList)teXObject;
            teXObject2 = ((TeXObjectList)object).peekStack();
            if (teXObject2 == null) {
                return null;
            }
            if (DatumMarker.isDatumMarker(teXObject2)) {
                DataElement dataElement = DatumMarker.popDataElement(bl, teXParser, (TeXObjectList)object);
                ((TeXObjectList)object).trim();
                if (!((Vector)object).isEmpty()) {
                    throw new LaTeXSyntaxException(teXParser, "latex.trailing_content", teXObject2, ((TeXObjectList)object).toString(teXParser));
                }
                return dataElement;
            }
            if (this.isCurrencySymbol(teXObject2)) {
                teXObject2 = ((TeXObjectList)object).popStack(teXParser);
                try {
                    ControlSequence controlSequence = teXParser.getControlSequence(FMT_CURRENCY_VALUE);
                    String string = ((TeXObjectList)object).toString(teXParser).trim();
                    double d = controlSequence instanceof NumericFormatter ? ((NumericFormatter)controlSequence).parse(string).doubleValue() : Double.parseDouble(string);
                    if (bl) {
                        return new DatumElement(teXObject3, new TeXFloatingPoint(d), teXObject2, DatumType.CURRENCY);
                    }
                    return new DataCurrencyElement(teXObject2, d, teXObject3);
                }
                catch (NumberFormatException | ParseException exception) {
                    ((TeXObjectList)object).add(0, teXObject2);
                    return new DataStringElement((TeXObjectList)object);
                }
            }
            TeXObject teXObject4 = (TeXObject)((Vector)object).lastElement();
            int n = ((Vector)object).size() - 1;
            while (teXObject4 instanceof Ignoreable && n > 1) {
                teXObject4 = (TeXObject)((Vector)object).get(--n);
            }
            if (this.isCurrencySymbol(teXObject4)) {
                for (int i = ((Vector)object).size() - 1; i >= n; --i) {
                    ((Vector)object).remove(i);
                }
                try {
                    ControlSequence controlSequence = teXParser.getControlSequence(FMT_CURRENCY_VALUE);
                    String string = ((TeXObjectList)object).toString(teXParser).trim();
                    double d = controlSequence instanceof NumericFormatter ? ((NumericFormatter)controlSequence).parse(string).doubleValue() : Double.parseDouble(string);
                    if (bl) {
                        return new DatumElement(teXObject3, new TeXFloatingPoint(d), teXObject4, DatumType.CURRENCY);
                    }
                    return new DataCurrencyElement(teXObject4, d, teXObject3);
                }
                catch (NumberFormatException | ParseException exception) {
                    ((TeXObjectList)object).add(teXObject4);
                    return new DataStringElement((TeXObjectList)object);
                }
            }
        }
        if (SCIENTIFIC_PATTERN.matcher((CharSequence)(object = teXObject.toString(teXParser).trim())).matches()) {
            try {
                double d = new BigDecimal((String)object).doubleValue();
                if (bl) {
                    return new DatumElement(teXObject3, new TeXFloatingPoint(d), null, DatumType.DECIMAL);
                }
                return new DataRealElement(d, teXObject3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.isParseTemporalOn() && (teXObject2 = this.parseTemporal((String)object, teXObject, bl)) != null) {
            return teXObject2;
        }
        try {
            teXObject2 = teXParser.getControlSequence(FMT_INTEGER_VALUE);
            int n = teXObject2 instanceof NumericFormatter ? ((NumericFormatter)teXObject2).parse((String)object).intValue() : Integer.parseInt((String)object);
            if (bl) {
                return new DatumElement(teXObject3, new UserNumber(n), null, DatumType.INTEGER);
            }
            return new DataIntElement(n, teXObject3);
        }
        catch (NumberFormatException | ParseException exception) {
            try {
                ControlSequence controlSequence = teXParser.getControlSequence(FMT_DECIMAL_VALUE);
                double d = controlSequence instanceof NumericFormatter ? ((NumericFormatter)controlSequence).parse((String)object).doubleValue() : Double.parseDouble((String)object);
                if (bl) {
                    return new DatumElement(teXObject3, new TeXFloatingPoint(d), null, DatumType.DECIMAL);
                }
                return new DataRealElement(d, teXObject3);
            }
            catch (NumberFormatException | ParseException exception2) {
                if (bl) {
                    if (teXObject.isEmpty()) {
                        return new DatumElement();
                    }
                    return new DatumElement(teXObject);
                }
                if (teXObject instanceof TeXObjectList) {
                    return new DataStringElement((TeXObjectList)teXObject);
                }
                DataStringElement dataStringElement = new DataStringElement();
                dataStringElement.add(teXObject);
                return dataStringElement;
            }
        }
    }

    protected DataElement parseTemporal(String string, TeXObject teXObject, boolean bl) throws IOException {
        return this.parseTemporal(string, teXObject, bl, this.isReformatTemporalOn());
    }

    protected DataElement parseTemporal(String string, TeXObject teXObject, boolean bl, boolean bl2) throws IOException {
        try {
            Julian julian = Julian.create(string);
            return julian.toDataElement(this.getListener(), teXObject, bl, bl2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public boolean isParseTemporalOn() {
        return TeXParserUtils.isTrue(PARSE_DATETIME_BOOL, this.getParser());
    }

    public boolean isReformatTemporalOn() {
        return TeXParserUtils.isTrue(REFORMAT_DATETIME_BOOL, this.getParser());
    }

    public static double toJulianDate(Date date) {
        return DataToolBaseSty.unixEpochMillisToJulianDate(date.getTime());
    }

    public static double unixEpochSecondsToJulianDate(long l) {
        return (double)l / 86400.0 + 2440587.5;
    }

    public static double unixEpochMillisToJulianDate(long l) {
        return DataToolBaseSty.unixEpochSecondsToJulianDate(l / 1000L);
    }

    public static long unixEpochSecondsFromJulianDate(long l) {
        return DataToolBaseSty.unixEpochSecondsFromJulianDate((double)l);
    }

    public static long unixEpochSecondsFromJulianDate(double d) {
        return Math.round((d - 2440587.5) * 86400.0);
    }

    public static long unixEpochMillisFromJulianDate(long l) {
        return DataToolBaseSty.unixEpochMillisFromJulianDate((double)l);
    }

    public static long unixEpochMillisFromJulianDate(double d) {
        return Math.round((d - 2440587.5) * 8.64E7);
    }

    public static String formatDateTime(Number number) {
        return DATE_TIME_FORMAT.format(new Date(DataToolBaseSty.unixEpochMillisFromJulianDate(number.doubleValue())));
    }

    public boolean isNull(TeXObject teXObject) {
        String string;
        if (teXObject instanceof AssignedMacro) {
            teXObject = ((AssignedMacro)teXObject).getBaseUnderlying();
        }
        if (teXObject.equals(this.noValueCs) || teXObject.equals(this.numberNullCs) || teXObject.equals(this.stringNullCs)) {
            return true;
        }
        return teXObject instanceof ControlSequence ? (string = ((ControlSequence)teXObject).getName()).equals(NULL_VALUE_CSNAME) || string.equals(NUMBER_NULL_CSNAME) || string.equals(STRING_NULL_CSNAME) || string.equals(OLD_NULL_VALUE_CSNAME) : this.getParser().isStack(teXObject) && (TeXParserUtils.onlyContainsControlSequence((TeXObjectList)teXObject, NULL_VALUE_CSNAME, NUMBER_NULL_CSNAME, STRING_NULL_CSNAME, OLD_NULL_VALUE_CSNAME) || ((TeXObjectList)teXObject).equalsMatchCatCode(this.nullMarker));
    }

    public Locale getNumericLocale() {
        return this.numericLocale;
    }

    public void setNumericLocale(Locale locale) {
        this.numericLocale = locale;
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
        this.registerControlSequence(new TextualContentCommand("@dtl@numbergroupchar", "" + decimalFormatSymbols.getGroupingSeparator()));
        this.registerControlSequence(new TextualContentCommand("@dtl@decimal", "" + decimalFormatSymbols.getDecimalSeparator()));
        this.registerControlSequence(new NumericFormatter(FMT_INTEGER_VALUE, NumberFormat.getIntegerInstance(locale), decimalFormatSymbols, true));
        this.registerControlSequence(new NumericFormatter(FMT_DECIMAL_VALUE, NumberFormat.getNumberInstance(locale), decimalFormatSymbols, false));
        this.registerControlSequence(new NumericFormatter(FMT_CURRENCY_VALUE, new DecimalFormat("#,##0.00", decimalFormatSymbols)));
    }

    public TeXObject formatNumber(DatumType datumType, Number number) {
        ControlSequence controlSequence = datumType == DatumType.INTEGER ? this.getParser().getControlSequence(FMT_INTEGER_VALUE) : this.getParser().getControlSequence(FMT_DECIMAL_VALUE);
        if (controlSequence instanceof NumericFormatter) {
            return ((NumericFormatter)controlSequence).format(number, this.getListener());
        }
        return this.getListener().createString(number.toString());
    }

    public TeXObject formatCurrency(DatumType datumType, Number number, String string) {
        ControlSequence controlSequence = this.getParser().getControlSequence(FMT_CURRENCY_VALUE);
        if (controlSequence instanceof NumericFormatter) {
            return ((NumericFormatter)controlSequence).format(number, this.getListener());
        }
        return this.getListener().createString(number.toString());
    }
}

