{$IFDEF WINDOWS}
{$N-,B-,V-,W-,G+}
{$ELSE}
{$N-,E-,B-,V-,F+,O+}
{$ENDIF}

Unit BibMisc;

Interface

Uses
{$IFDEF WINDOWS}
  WinDos, Wobjects, Wbibgui, wbibdisp, wbibslct, wbibinit, wbibabv2, rc_id,
  wbibeden, wbibdlg, WinTypes, WinProcs, wbiblist, wbibpatt, wbibesrt,
  Strings, commdlg, wc_help,
{$ELSE}
  bibwindo, Dos, bibCrt, Objects, spawno, BibMouse, bibdisp, bibsedit,
  bibedit, bibdialg, bibselct, bibedent, biblist, bibedsrt,
{$ENDIF}
  bibstrg, streams, bibstrm, bibvars, bibfile, bibutil, bib8bit, bibtext,
  bibreadB, bibwritO, bibreach, bibfilch, bibSrtPt, bibwild, bibsort,
  bibprint, bibPchec, bibsave, rc_strng, bibflch2, bibcache, bibmain, lfnunit;

{$IFDEF WINDOWS}
function  LookForDups(AParent: PWindowsObject;
                      Entry: EntryRecPtr; Pattern: PatRecPtr): longint;
{$ENDIF}
procedure DealWithMisc(Entry: EntryRecPtr; Pattern: PatRecPtr;
                       selected: SelectionType);


implementation


{$IFDEF WINDOWS}

const
  NDupTabs = 2;

type
  TDupRec=record
    name: string;
    fl: integer;
    rnum,enum: longint;
  end;
  PDupRec=^TDupRec;

  PDispDupsDlg = ^TDispDupsDlg;
  TDispDupsDlg = object(TResizableDialog)
    List: PAuxStream;
    ListFont: HFont;
    TabStops: array[1..MaxOverview] of integer;
    LineHeight: word;
    ToGo: PLongint;
    constructor init(AParent: PWindowsObject; AList: PAuxStream; AToGo: PLongint);
    procedure   wmMeasureItem(var Msg: TMessage); virtual wm_first+wm_MeasureItem;
    procedure   wmDrawItem(var Msg: TMessage);    virtual wm_first+wm_DrawItem;
    procedure   FixControlPos; virtual;
    procedure   SetupWindow;   virtual;
    procedure   Update;
    procedure   HandleLBox(var Msg: TMessage);    virtual id_first+dl_DupsLBox;
    procedure   SaveBtn(var Msg: TMessage);       virtual id_first+dl_DupsSave;
    procedure   ok(Var Msg: TMessage);            virtual id_first+id_ok;
    destructor  Done;          virtual;
  end;

procedure WriteDupRec(P: PAuxStream; Rec: pointer); far;
begin
  with PDupRec(Rec)^ do
  begin
    P^.Write(name,Ord(name[0])+1);
    P^.write(fl,sizeof(integer));
    P^.write(rnum,sizeof(longint));
    P^.write(enum,sizeof(longint));
  end;
end;                 { WriteDupRec }

procedure ReadDupRec(P: PAuxStream; Rec: pointer); far;
begin
  with PDupRec(Rec)^ do
  begin
    P^.read(name[0],1);
    P^.read(name[1],Ord(name[0]));
    P^.read(fl,sizeof(integer));
    P^.read(rnum,sizeof(longint));
    P^.read(enum,sizeof(longint));
  end;
end;                 { ReadDupRec }

constructor TDispDupsDlg.Init(AParent: PWindowsObject; AList: PAuxStream;
                              AToGo: PLongint);
begin
  TResizableDialog.Init(AParent,PChar(rc_DupEntries),@DispDupsSize);
  List:=AList; ToGo:=AToGo; ToGo^:=-1;
  ListFont:=CreateHelvFont(true,@LineHeight);
  FillChar(TabStops,sizeof(TabStops),0);
  HelpContext:=hc_DuplicatesItem;
end;

procedure TDispDupsDlg.wmMeasureItem(var Msg: TMessage);
begin
  with PMeasureItemStruct(Msg.lParam)^ do
  begin
    ItemWidth:=0;
    ItemHeight:=LineHeight;
  end;
end;                          { TDispDupsDlg.wmMeasureItem }
             
procedure TDispDupsDlg.wmDrawItem(var Msg: TMessage);
begin
  DrawTabbedLBoxItem(PDrawItemStruct(Msg.lParam),ListFont,false,
                     TabStops,NDupTabs,false);
end;                          { TDispDupsDlg.wmDrawItem }

procedure TDispDupsDlg.FixControlPos;
begin
  NewControl(dl_DupsLBox, RelTo_Left, RelTo_Right,RelTo_Top,   RelTo_Bottom);
  NewControl(id_ok,       RelTo_Left, RelTo_Size, RelTo_Bottom,RelTo_Size);
  NewControl(dl_DupsSave, RelTo_Right,RelTo_Size, RelTo_Bottom,RelTo_Size);
  NewControl(id_cancel,   RelTo_Right,RelTo_Size, RelTo_Bottom,RelTo_Size);
end;

procedure TDispDupsDlg.SetupWindow;
const
  PLen = 256;
  AddedLen = 4;
var
  P: PChar;
  l: longint;
  DupRec: PDupRec;
  DC: HDC;
  Metric: TTextMetric;
  OldFont: HFont;
  du,i,TotWidth: word;
  Widths: array[1..NDupTabs] of word;
  F: array[0..300] of char;
  F1,F2: PChar;
  n: longint;

procedure GetLine(F: PChar; var n: longint);
begin
  List^.read(N,sizeof(longint));
  List^.read(F^,1);
  repeat
    if (F^=#10) then F^:=#0
    else begin
      if F^<>#13 then inc(F);
      List^.read(F^,1);
    end;
  until (List^.status<>stOK) or (F^=#0);
end;

begin
  TResizableDialog.SetupWindow;
  DisableSysMinimize; InitPos;

  du:=LoWord(GetDialogBaseUnits) div 4;
  New(DupRec);
  DC:=GetDC(GetItemHandle(dl_DupsLBox));
  OldFont:=SelectObject(DC,ListFont);

  TabStops[1]:=LoWord(GetTextExtent(DC,'MMM',3));

  List^.seek(0);
  FillChar(Widths,sizeof(Widths),0); TotWidth:=0;
  GetLine(F,n);

  while List^.Status=stOK do
  begin
    if F[0]=#9 then
    begin
      F1:=@F; inc(F1);
      i:=0; while not (F1[i] in [#0,#9]) do inc(i);
      Widths[1]:=imax(Widths[1],LoWord(GetTextExtent(DC,F1,i)));
      if F1[i]=#9 then
      begin
        F1:=F1+i+1;
        Widths[2]:=imax(Widths[2],LoWord(GetTextExtent(DC,F1,StrLen(F1))));
      end;
    end else
      TotWidth:=imax(TotWidth,LoWord(GetTextExtent(DC,F,StrLen(F))));
    SendDlgItemMsg(dl_DupsLBox,lb_SetItemData,
         SendDlgItemMsg(dl_DupsLBox,lb_AddString,0,longint(@F)),
       n);
    GetLine(F,n);
  end;
  TabStops[2]:=TabStops[1]+Widths[1]+AddedLen*du;
  TotWidth:=imax(TotWidth,TabStops[2]+Widths[2])+2*AddedLen*du;
  SendDlgItemMsg(dl_DupsLBox,lb_SetHorizontalExtent,TotWidth,0);

  SelectObject(DC,OldFont);
  ReleaseDC(DC,GetItemHandle(dl_DupsLBox));
  Dispose(DupRec);
  List^.reset; List^.flush; List^.seek(0);
  SendDlgItemMsg(dl_DupsLBox,lb_SetCurSel,1,0);
  Update;
end;               { TDispDupsDlg.SetupWindow }

procedure TDispDupsDlg.Update;
var
  Ind: integer;
  on: boolean;
  n: longint;
begin
  on:=false;
  Ind:=SendDlgItemMsg(dl_DupsLBox,lb_GetCurSel,0,0);
  if Ind<>lb_Err then
  begin
    n:=SendDlgItemMsg(dl_DupsLBox,lb_GetItemData,Ind,0);
    on:=(n>0);
  end;
  EnableWindow(GetItemHandle(id_ok),on);
end;                  { TDispDupsDlg.Update }

procedure TDispDupsDlg.HandleLBox(var Msg: TMessage);
begin
  if Msg.lParamHi=lbn_DblClk then ok(Msg)
  else begin
    DefWndProc(Msg);
    if Msg.lParamHi=lbn_SelChange then Update;
  end;
end;

procedure TDispDupsDlg.SaveBtn(var Msg: TMessage);
var
  T:  TOpenFilename;
  F,line,l1:  PChar;
  fl: TDosStream;
  i: integer;
begin
  GetMem(F,256); StrPCopy(F,'*.dup');
  GetMem(line,512);
  Fillchar(T,sizeof(T),0);
  with T do
  begin
    lStructSize:=sizeof(TOpenFilename);
    hWndOwner:=HWindow;
    lpstrFile:=F;
    nMaxFile:=255;
    Flags:=OFN_HideReadOnly or OFN_PathMustExist or OFN_OverwritePrompt;
    if LFNAble then flags:=flags or ofn_LongNames;
  end;
  if GetSaveFileName(T) then
  begin
    if LFNFileExist(StrPas(F)) then fl.Init(F,stOpenWrite)
    else fl.Init(F,stCreate);
    fl.seek(0);
    for i:=0 to SendDlgItemMsg(dl_DupsLBox,lb_GetCount,0,0)-1 do
    begin
      SendDlgItemMsg(dl_DupsLBox,lb_GetText,i,longint(line));
      l1:=line; if line^<#3 then inc(l1);
      StrCat(line,#13#10);
      fl.write(l1^,StrLen(l1));
    end; 
    fl.Done;
  end;
  FreeMem(line,512); FreeMem(F,256);
end;                 { TDispDupsDlg.SaveBtn }

procedure TDispDupsDlg.ok(var Msg: TMessage);
var
  F,F1,F2: Pchar;
  Ind: integer;
  Data: longint;
begin
  Ind:=SendDlgItemMsg(dl_DupsLBox,lb_GetCurSel,0,0);
  if Ind=lb_Err then
  begin
    MessageBeep(0); Exit;
  end;
  Data:=SendDlgItemMsg(dl_DupsLBox,lb_GetItemData,Ind,0);
  if Data<1 then Messagebeep(0)
  else begin
    ToGo^:=Data;
    EndDlg(id_ok);
  end;
end;                  { TDispDupsDlg.ok }

destructor TDispDupsDlg.Done;
begin
  if ListFont<>0 then DeleteObject(ListFont);
  TResizableDialog.Done;
end;

function CompDupRecs(R1,R2: pointer): integer; far;
var
  c,Index1,Index2: integer;
  ch1,ch2: integer;
  S1,S2: PString;
begin
  S1:=@PDupRec(R1)^.name; S2:=@PDupRec(R2)^.name;
  if (S1^='') and (S2^='') then
  begin
    CompDupRecs:=0; Exit;
  end else if S1^='' then
  begin
    CompDupRecs:=-1; Exit;
  end else if S2^='' then
  begin
    CompDupRecs:=1; Exit;
  end;
  Index1:=0; Index2:=0;
  c:=0;
  while (index1<length(S1^)) and (Index2<length(S2^)) and (c=0) do
  begin
    inc(Index1); inc(Index2);
    ch1:=MixedSortOrder^[Ord(S1^[Index1])];
    ch2:=MixedSortOrder^[Ord(S2^[Index1])];
    if ch1<ch2 then c:=-1
    else if ch1>ch2 then c:=1;
  end;
  if c=0 then
  begin
    index1:=length(S1^)-index1; Index2:=Length(S2^)-Index2;
    if Index1<Index2 then c:=-1
    else if Index1>Index2 then c:=1;
  end;
  CompDupRecs:=c;
end;                   { CompDupRecs }

function LookForDups(AParent: PWindowsObject;
                     Entry: EntryRecPtr; Pattern: PatRecPtr): longint;
const
  CR: string[2] = #13#10;
var
  List,DupList: PAuxStream;
  OEntry,OReal,Oplace,fentry,LastNum,N,NumDups,i,ToGo: longint;
  ok,HasDups: boolean;
  DupRec1,DupRec2: PDupRec;
  tmp: string;

procedure TidyUp;
begin
  if DupList<>Nil then Dispose(DupList,Done);
  if DupRec2<>Nil then Dispose(DupRec2);
  if DupRec1<>Nil then Dispose(DupRec1);
  if List<>Nil    then Dispose(List,Done);
  if OEntry<>-2   then ReachEntry(Entry,Oreal,OEntry,oplace,false);
  WaitingOff;
end;

procedure OutputLine(Rec: PDupRec);
begin
  with Rec^ do
  begin
    DupList^.write(enum,sizeof(longint));
    if ActivePattern(Pattern) then
      tmp:=#9'['+num2str(enum-BibFiles^[BibRing[fl]].EntryStart)+
           +'/'+num2str(rnum-BibFiles^[BibRing[fl]].RealStart)+']'#9
    else
      tmp:=#9'['+num2str(enum-BibFiles^[BibRing[fl]].EntryStart)+']'#9;
    DupList^.write(tmp[1],length(tmp));
    DupList^.write(BibFiles^[BibRing[fl]].name[1],
                      length(BibFiles^[BibRing[fl]].name));
    DupList^.write(CR[1],length(CR));
  end;
end;

begin                { LookForDups }
  LookForDups:=-1;
  if bibname^='' then Exit;
  List:=Nil; DupList:=Nil; DupRec1:=Nil; DupRec2:=Nil; OEntry:=-2;
  HasDups:=false;
  New(List,init(WorkStreamOrder)); if List=Nil then Exit;
  List^.Seek(0); List^.Truncate;
  if List^.Status<>stOK then
  begin
    TidyUp; Exit;
  end;
  OEntry:=Entry^.EntryNum; OReal:=Entry^.RealNum; Oplace:=Entry^.Beginning;
  New(DupRec1); New(DupRec2);
  ResetBib(Entry);
  GetEntry(Entry,Nil,1,false,Pattern,ok);
  fentry:=Entry^.entrynum; LastNum:=fentry; N:=0;
  TrapAbort;
  SearchingMessage;
  if ok and not AbortFlag then
  repeat
    with DupRec1^ do
    begin
      name:=Entry^.name;
      fl:=BibInRing;
      rnum:=Entry^.Realnum; enum:=Entry^.EntryNum;
    end;
    WriteDupRec(List,DupRec1); inc(N);
    GetEntry(Entry,Nil,entry^.entrynum+1,false,Pattern,ok);
    if Entry^.entrynum>LastNum then LastNum:=Entry^.EntryNum;
    TrapAbort;
  until (entry^.realnum<=fentry) or (Entry^.entrynum<N) or AbortFlag
    or (List^.Status<>stOK);
  if AbortFlag or (List^.Status<>stOK) then
  begin
    TidyUp; Exit;
  end;
  if not ActivePattern(Pattern) then EntryCache^.SetLast(LastNum,Pattern);

  List^.Seek(0);
  ok:=SortAList(List,N,DupRec1,DupRec2,ReadDupRec,WriteDupRec,CompDupRecs);

  New(DupList,Init(WorkStreamOrder));
  if (DupList=Nil) or (DupList^.Status<>stOK) then
  begin
    TidyUp; Exit;
  end;

  DupRec1^.name:=''; DupRec2^.Name:=''; NumDups:=0;
  ReadDupRec(List,DupRec1);
  while List^.status=stOK do
  begin
    if DupRec1^.name=DupRec2^.name then
    begin
      if NumDups=0 then
      begin
        i:=0; DupList^.write(i,sizeof(longint));
        tmp:=TabbedLBox_DupEntriesColor+'DUPLICATE LABEL: '; DupList^.write(tmp[1],length(tmp));  { Red }
        DupList^.write(DupRec1^.name[1],length(DupRec1^.name));
        DupList^.write(CR[1],length(CR));
        {
        tmp:='-'; for i:=1 to 16+length(DupRec1^.name) do DupList^.write(tmp[1],1);
        DupList^.write(CR[1],length(CR));
        }
        OutputLine(DupRec2);
      end;
      OutputLine(DupRec1);
      HasDups:=true;
    end else
    begin
      DupRec2^:=DupRec1^; NumDups:=0;
    end;
    ReadDupRec(List,DupRec1);
  end;
  WaitingOff;

  if HasDups then
  begin
    if Application^.ExecDialog(New(PDispDupsDlg,
                                init(AParent,DupList,@ToGo)))=id_ok then
    begin
      LookForDups:=ToGo;
    end;
  end else MessageRC(Str_NoDupsFound,'');

  TidyUp;
end;                { LookForDups }


{$ENDIF}


procedure DealWithMisc(Entry: EntryRecPtr; Pattern: PatRecPtr;
                       selected: SelectionType);
Var
  il,MemoryFree,OTime,NTime: LongInt;
  tmp,line: string;
  choice: integer;
  orealnum,OEntry,fentry,NumberFound: Word;
  ok,oldpatton,Bjunk,movedbib,accept,found,Equiv: boolean;
  bibattr: Word;
  Index, Icode, i, xstart: Byte;
{  Dir,Name,Ext: PString;}
  drive: char;
  oplace: longint;
  TempSMode: ConfigSortPtr;
  TempPatt: PatRecPtr;
begin                                              { DealWithMisc }
  MemoryFree:=MaxAvail; AbortFlag:=false;
  if selected[1]=0 then exit;
  TimeOutOn:=false;
  if selected[1]=CMisc_About then                         { About }
    About
  else if selected[1]=CMisc_Count then                    { Count entries }
  begin
    NumberFound:=0; 
    if EntryCache^.UseCache(Pattern) and (EntryCache^.Last>-1) then
      NumberFound:=EntryCache^.Last
    else begin
      orealnum:=entry^.realnum;OEntry:=entry^.entrynum;
      oplace:=Entry^.beginning;
      ResetBib(Entry);
      WaitingMessage('Counting...');
      GetEntry(Entry,Nil,1,false,Pattern,ok);
      TrapAbort;
      fentry:=Entry^.realnum;
      if ok and not AbortFlag then
      repeat
        Inc(NumberFound);
        GetEntry(Entry,Nil,entry^.entrynum+1,false,Pattern,ok);
        TrapAbort;
      until (entry^.realnum<=fentry) or (Entry^.entrynum<NumberFound) or AbortFlag;
      ReachEntry(Entry,Orealnum,OEntry,oplace,false);
      WaitingOff;
    end;
    if not AbortFlag then
    begin
      if NumberFound=1 then
      begin
        tmp:='entry'; if EditOnlyStrings then tmp:='string';
      end else
      begin
        tmp:='entries'; if EditOnlyStrings then tmp:='strings';
      end;
      if (Pattern<>Nil) and Pattern^.on then tmp:='pattern-conforming '+tmp;
      if MacroCommand then OutputStr^:=num2str(NumberFound)
      else begin
        if NumberFound=0      then message(' No '+tmp+' found. ')
        else if NumberFound=1 then message(' One '+tmp+' found. ')
        else message(' '+num2str(NumberFound)+' '+tmp+' found. ');
      end;
      EntryCache^.SetLast(NumberFound,Pattern);
    end;
{$IFNDEF WINDOWS}
  end else if (selected[1]=CMisc_Vmode) and (selected[2]>0) then   { Change video mode }
  begin
    if not (IsEGA or IsVGA) then Exit;
    if selected[2]>=25 then      { Preset VGA modes }
    begin
      if IsColor then CurrentMode:=3
      else CurrentMode:=2;
      CurrentLen:=selected[2];
    end else CurrentMode:=VModeList[Selected[2]];
    set_bibdb_mode;
    MakeBox(2,1,ScrLen-1,ScrWidth,EntryNorm,EntryNorm,2,0,0,0);
    UseMouse:=OrigUseMouse and ((ScrWidth<=80) or WideScreenMouse);
    if UseMouse then
    begin
      if ScrLen>50 then InitMouse;
      MouseBox(0,0,ScrWidth*xpixels-1,ScrLen*ypixels-1);
    end;

    with MainMenu do                    { Adjusting the main menus }
    begin
      if ScrWidth<84 then
      begin
        item[8] := ' eXprt ';
        item[9] := ' Patt ';
      end else
      begin
        item[8] := ' eXport ';
        item[9] := ' Pattern ';
      end;
      ipos[1]:=2;
      for i:=2 to nitems-1 do ipos[i]:=ipos[i-1]+length(item[i-1])+1;
      ipos[nitems]:=ScrWidth-length(item[nitems]);
    end;
    with EntryEditMenu do
    begin
      ipos[nitems]:=ScrWidth-length(item[nitems]);
      ipos[nitems-1]:=ipos[nitems]-length(item[nitems-1])-1;
      ipos[nitems-2]:=ipos[nitems-1]-length(item[nitems-2])-1;
    end;
    with EntryModifyMenu do
    begin
      ipos[nitems]:=ScrWidth-length(item[nitems]);
      ipos[nitems-1]:=ipos[nitems]-length(item[nitems-1])-1;
    end;
    with StringEditMenu do
    begin
      ipos[nitems]:=ScrWidth-length(item[nitems]);
      ipos[nitems-1]:=ipos[nitems]-length(item[nitems-1])-1;
      ipos[nitems-2]:=ipos[nitems-1]-length(item[nitems-2])-1;
    end;
    with StringModifyMenu do
    begin
      ipos[nitems]:=ScrWidth-length(item[nitems]);
      ipos[nitems-1]:=ipos[nitems]-length(item[nitems-1])-1;
    end;
    with PattEditMenu do
    begin
      ipos[nitems]:=ScrWidth-length(item[nitems]);
      ipos[nitems-1]:=ipos[nitems]-length(item[nitems-1])-1;
    end;
{$ENDIF}
  end else if selected[1]=CMisc_View then             { Toggle view }
  begin
    FirstShowBuf:=not FirstShowBuf;
  end else if selected[1]=CMisc_TagNew then           { Toggle view }
  begin
    TagNewEntries:=not TagNewEntries;
    OptionsModified.Preferences:=true;
  end else if selected[1]=CMisc_Strings then         { Strings/Entries }
  begin
    EditOnlyStrings:=not EditOnlyStrings;
    ResetBib(Entry);
    if linked then
      for i:=1 to MaxBibFiles do
      begin
        BibFiles^[i].RealStart:=0; BibFiles^[i].EntryStart:=0;
      end;
{    EntryCache^.Clear;}
    GetEntry(Entry,Nil,1,true,Pattern,ok);
    if not ok then ResetBib(Entry);
    EraseTags(Tags);
  end else if selected[1]=CMisc_Suspend then             { Suspend }
  begin
    SuspendedPos:=-1;
    if (TextRec(bib).Mode=fminput) or
       (TextRec(bib).Mode=fminout) or
       (TextRec(bib).Mode=fmoutput) then
    begin
      SuspendedPos:=TextFilePos(bib);
      CloseFile(bib);
    end;
    suspended:=true;
  end else if selected[1]=CMisc_Preferences then         { Preferences }
  begin
    Bjunk:=EditOnlyStrings;
    Preferences;
    if EditOnlyStrings<>Bjunk then
    begin
      EntryCache^.Clear; ResetBib(Entry); EraseTags(Tags);
    end;
    CheckForIndexFile(bib,bibname);
{$IFNDEF WINDOWS}
  end else if selected[1]=CMisc_Encoding then
  begin
    EncodingsOptions;
    RefreshEntry(Entry);
 {$ENDIF}
  end else if selected[1]=CMisc_Soptions then              { Sort options }
  begin
    if Linked and (Selected[2]=CSortMode_Current) then
      ErrorMessageRC(Str_NoCurSortInLink,'')
    else if BibReadOnly and (Selected[2]=CSortMode_Current) then
      ErrorMessageRC(Str_NoCurSortInRO,'')
    else begin
      orealnum:=entry^.realnum; OEntry:=entry^.entrynum;
      if BibFileExists then GetFTime(bib,OTime) else OTime:=-1;
      SortOptions(selected[2],movedbib);
      BibFileExists:=LFNFileExist(BibName^);
      Equiv:=true;
      { Check for changes and incompatibilities }
      if BibFileExists and (not Linked) and
        ((EditOnlyStrings and (CurrentSortMode^.StringNameSort<>StrSortOff)) or
         (not EditOnlyStrings and CurrentSortMode^.SortingOn)) then
      begin
        New(TempPatt); New(TempSMode);
        CloseFile(Bib);
        ResetBibFile(bib,bibname^);
        i:=0; found:=false; Equiv:=true;
        while (not eof(bib)) and (not found) and (i<=MaxLookForSort) do
        begin
          tmp:='';
          ReadLine(bib,tmp,UnixBib); ChrDel(tmp,' '); StrLwr(tmp);
          inc(i);
          if tmp='\sort'+lbrace then
          begin
            LoadSortMode(bib,Nil,TempSMode^,TempPatt);
            found:=true;
          end;
        end;
        CloseFile(Bib);
        movedbib:=true;
        if EditOnlyStrings then
          Equiv:=CurrentSortMode^.StringNameSort=TempSMode^.StringNameSort
        else begin
          PushBufferStack(Pattern^,sizeof(PatRec),EnoughMem(sizeof(PatRec)),0);
          RecallBufferStack(Pattern^,SortPattPosCur);
          Equiv:=EquivSortModes(CurrentSortMode^,TempSMode^,Pattern,TempPatt);
          PopBufferStack(Pattern^);
        end;
        Dispose(TempSMode); Dispose(TempPatt);
      end;
      if (not Equiv) and YesNoRC(Str_SortModeChanged,'') then
      begin
        EntryCache^.Clear;
        Selected[0]:=CMainFile; Selected[1]:=CFile_Sort;
        DealWithFiles(Entry,Pattern,selected);
      end else if movedbib then
      begin
        if BibFileExists then
        begin
          GetFTime(Bib,NTime);
          if NTime<>OTime then
          begin
            EntryCache^.Clear;
            EntryCache^.LoadCache(Pattern);
          end;
          ResetBib(Entry);
          ReachEntry(Entry,Orealnum,OEntry,-2,false);
        end else ResetBib(Entry);
      end;
    end;
  end else if selected[1]=CMisc_Foptions then              { File format options }
  begin
    FileFormatOptions;
  end else if Selected[1]=CMisc_CacheMenu then
  begin
    if Selected[2]=CMisc_SaveCache then
    begin
      if not AutoSaveCache then EntryCache^.SaveCache(Pattern);
    end else if Selected[2]=CMisc_ClearCache then
    begin
      if (CacheDir^<>'') and IsDirName(CacheDir^) then
      begin
        if YesNoRC(Str_OkToClearCache,CacheDir^) then
        begin
          if ActivePattern(Pattern) then EntryCache^.Clear;
          EntryCache^.LookForCacheFile('',Nil,true,true,Nil,Nil,Nil);
          if ActivePattern(Pattern) then EntryCache^.LoadCache(Pattern);
        end;
      end else ErrorMessageRC(Str_NoCacheDir,'');
    end;
  end else if selected[1]=CMisc_CD then             { CD }
  begin
    tmp:=LFNFExpand('');
    repeat
      CanonicalFname(tmp);
      GetAString(' Change to: ',tmp,4,255,50,[#0..#255]-FileNameSet,accept,false);
      if accept and (tmp<>'') then
      begin
        {$I-}
        ChDir(LFNShortName(tmp)); icode:=IoResult;
        {$I+}
        if icode<>0 then
          ErrorMessage(Concat(' CD to "',tmp,'" failed! '));
      end;
    until (not accept) or (tmp='') or (icode=0);
  end else if selected[1]=CMisc_SaveOpts then       { Save settings }
  begin
    if selected[2]=CMiscSave_Prefs then             { Save preferences }
      SaveConfigOptions(true,false,false,false,false)
    else if selected[2]=CMiscSave_Regs then         { Save registers }
      SaveConfigOptions(false,true,false,false,false)
    else if selected[2]=CMiscSave_Sort then         { Save default sort mode }
      SaveConfigOptions(false,false,true,false,false)
    else if selected[2]=CMiscSave_Formats then      { Save file formats }
      SaveConfigOptions(false,false,false,true,false)
    else if selected[2]=CMiscSave_Windows then
    else if selected[2]=CMiscSave_All then          { Save all }
    begin
      SaveConfigOptions(true,true,true,true,true);
{$IFDEF WINDOWS}
      SaveWinOptions;
{$ENDIF}
    end else if selected[2]=CMiscSave_Exit then     { Toggle Save on Exit }
    begin
      SaveOptsOnExit:=not SaveOptsOnExit;
      if SaveOptsOnExit then OptionsModified.Preferences:=true;
    end;
  end;
end;                                           { DealWithMisc }


end.

