/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.xmlmerge.factory;

import com.izforge.izpack.util.xmlmerge.AbstractXmlMergeException;
import com.izforge.izpack.util.xmlmerge.Operation;
import com.izforge.izpack.util.xmlmerge.OperationFactory;
import com.izforge.izpack.util.xmlmerge.factory.OperationResolver;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AttributeOperationFactory
implements OperationFactory {
    private Operation m_defaultOperation;
    private Namespace m_namespace;
    private String m_keyword;
    private OperationResolver m_resolver;

    public AttributeOperationFactory(Operation defaultOperation, OperationResolver resolver, String keyword, String namespace) {
        this.m_defaultOperation = defaultOperation;
        this.m_keyword = keyword;
        this.m_resolver = resolver;
        this.m_namespace = Namespace.getNamespace((String)namespace);
    }

    @Override
    public Operation getOperation(Element originalElement, Element modifiedElement) throws AbstractXmlMergeException {
        if (modifiedElement == null) {
            return this.m_defaultOperation;
        }
        String operationString = modifiedElement.getAttributeValue(this.m_keyword, this.m_namespace);
        if (operationString != null) {
            return this.m_resolver.resolve(operationString);
        }
        return this.m_defaultOperation;
    }
}

