/*
 * Decompiled with CFR 0.152.
 */
package ch.bfh.lpdg;

import ch.bfh.lpdg.DependencyScanner;
import ch.bfh.lpdg.GraphHelper;
import ch.bfh.lpdg.InteractionHandler;
import ch.bfh.lpdg.LatexHelper;
import ch.bfh.lpdg.datastructure.Dependency;
import ch.bfh.lpdg.datastructure.DependencyType;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.ParseException;

public class Application {
    public static void main(String[] args) {
        InteractionHandler interactionHandler = InteractionHandler.getInstance();
        GraphHelper graphHelper = GraphHelper.getInstance();
        try {
            interactionHandler.handleOptions(args);
        }
        catch (ParseException pE) {
            System.err.println("Handling parameters went wrong: " + pE.getMessage());
        }
        List<File> files = interactionHandler.getFiles();
        for (File file : files) {
            try {
                Dependency res = DependencyScanner.getInstance().findDependencies(file.getAbsolutePath(), DependencyType.FILE, "", Collections.emptyList(), interactionHandler.getDepth());
                interactionHandler.printDebugMessage("Dependencies for file: " + file.getName());
                interactionHandler.printDebugMessage(res.toString());
                LatexHelper latexHelper = new LatexHelper(file, res);
                latexHelper.findUnnecessaryDependencies(interactionHandler.hasOverwriteFlag(), interactionHandler.hasMinimizeFlag());
                graphHelper.createFileForDependency(res, "./");
            }
            catch (Exception e) {
                System.out.println("Error on scanning the file: " + file.getAbsolutePath() + "\n" + e);
            }
        }
    }
}

