/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types.selectors;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.util.file.types.Parameter;
import com.izforge.izpack.util.file.types.Path;
import com.izforge.izpack.util.file.types.selectors.BaseSelector;
import com.izforge.izpack.util.file.types.selectors.ExtendFileSelector;
import com.izforge.izpack.util.file.types.selectors.FileSelector;
import java.io.File;
import java.util.Vector;

public class ExtendSelector
extends BaseSelector {
    private String classname = null;
    private FileSelector dynselector = null;
    private Vector<Parameter> paramVec = new Vector();
    private Path classpath = null;

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void selectorCreate() {
        if (this.classname != null && this.classname.length() > 0) {
            try {
                Class<?> c = Class.forName(this.classname);
                this.dynselector = (FileSelector)c.newInstance();
            }
            catch (ClassNotFoundException cnfexcept) {
                this.setError("Selector " + this.classname + " not initialized, no such class");
            }
            catch (InstantiationException iexcept) {
                this.setError("Selector " + this.classname + " not initialized, could not create class");
            }
            catch (IllegalAccessException iaexcept) {
                this.setError("Selector " + this.classname + " not initialized, class not accessible");
            }
        } else {
            this.setError("There is no classname specified");
        }
    }

    public void addParam(Parameter p) {
        this.paramVec.addElement(p);
    }

    public final void setClasspath(Path classpath) throws Exception {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public final Path createClasspath() throws Exception {
        if (this.classpath == null) {
            this.classpath = new Path();
        }
        return this.classpath.createPath();
    }

    public final Path getClasspath() {
        return this.classpath;
    }

    @Override
    public void verifySettings() {
        if (this.dynselector == null) {
            this.selectorCreate();
        }
        if (this.classname == null || this.classname.length() < 1) {
            this.setError("The classname attribute is required");
        } else if (this.dynselector == null) {
            this.setError("Internal Error: The custom selector was not created");
        } else if (!(this.dynselector instanceof ExtendFileSelector) && this.paramVec.size() > 0) {
            this.setError("Cannot set parameters on custom selector that does not implement ExtendFileSelector");
        }
    }

    @Override
    public boolean isSelected(InstallData idata, File basedir, String filename, File file) throws Exception {
        this.validate();
        if (this.paramVec.size() > 0 && this.dynselector instanceof ExtendFileSelector) {
            Object[] paramArray = new Parameter[this.paramVec.size()];
            this.paramVec.copyInto(paramArray);
            ((ExtendFileSelector)this.dynselector).setParameters((Parameter[])paramArray);
        }
        return this.dynselector.isSelected(idata, basedir, filename, file);
    }
}

