/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.descriptor;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.container.CIDType0Container;
import org.apache.pdfbox.preflight.font.descriptor.FontDescriptorHelper;
import org.apache.pdfbox.preflight.utils.COSUtils;

public class CIDType0DescriptorHelper
extends FontDescriptorHelper<CIDType0Container> {
    public CIDType0DescriptorHelper(PreflightContext context, PDFontLike font, CIDType0Container fontContainer) {
        super(context, font, fontContainer);
    }

    @Override
    public PDStream extractFontFile(PDFontDescriptor fontDescriptor) {
        PDStream ff3 = fontDescriptor.getFontFile3();
        if (ff3 != null) {
            COSStream stream = ff3.getStream();
            if (stream == null) {
                ((CIDType0Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", fontDescriptor.getFontName() + ": The FontFile is missing"));
                ((CIDType0Container)this.fContainer).notEmbedded();
            } else {
                String st = stream.getNameAsString(COSName.SUBTYPE);
                if (!"CIDFontType0C".equals(st) && !"Type1C".equals(st)) {
                    ((CIDType0Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", fontDescriptor.getFontName() + ": invalid /Subtype /" + st + " in /FontFile3 stream"));
                }
                this.checkCIDSet(fontDescriptor);
            }
        }
        return ff3;
    }

    protected void checkCIDSet(PDFontDescriptor pfDescriptor) {
        if (CIDType0DescriptorHelper.isSubSet(pfDescriptor.getFontName())) {
            COSDocument cosDocument = this.context.getDocument().getDocument();
            COSBase cidset = pfDescriptor.getCOSObject().getItem(COSName.getPDFName("CIDSet"));
            if (cidset == null || !COSUtils.isStream(cidset, cosDocument)) {
                ((CIDType0Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.11", pfDescriptor.getFontName() + ": The CIDSet entry is missing for the Composite Subset"));
            }
        }
    }

    @Override
    protected void processFontFile(PDFontDescriptor fontDescriptor, PDStream fontFile) {
        if (this.font.isDamaged()) {
            ((CIDType0Container)this.fContainer).push(new ValidationResult.ValidationError("3.2.3", this.font.getName() + ": The FontFile can't be read"));
        }
    }
}

