/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.image;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public final class CCITTFactory {
    private CCITTFactory() {
    }

    @Deprecated
    public static PDImageXObject createFromRandomAccess(PDDocument document, RandomAccess reader) throws IOException {
        return CCITTFactory.createFromRandomAccessImpl(document, reader, 0);
    }

    @Deprecated
    public static PDImageXObject createFromRandomAccess(PDDocument document, RandomAccess reader, int number) throws IOException {
        return CCITTFactory.createFromRandomAccessImpl(document, reader, number);
    }

    public static PDImageXObject createFromFile(PDDocument document, File file) throws IOException {
        return CCITTFactory.createFromRandomAccessImpl(document, new RandomAccessFile(file, "r"), 0);
    }

    public static PDImageXObject createFromFile(PDDocument document, File file, int number) throws IOException {
        return CCITTFactory.createFromRandomAccessImpl(document, new RandomAccessFile(file, "r"), number);
    }

    private static PDImageXObject createFromRandomAccessImpl(PDDocument document, RandomAccess reader, int number) throws IOException {
        COSDictionary decodeParms = new COSDictionary();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        CCITTFactory.extractFromTiff(reader, bos, decodeParms, number);
        if (bos.size() == 0) {
            return null;
        }
        ByteArrayInputStream encodedByteStream = new ByteArrayInputStream(bos.toByteArray());
        PDImageXObject pdImage = new PDImageXObject(document, encodedByteStream, COSName.CCITTFAX_DECODE, decodeParms.getInt(COSName.COLUMNS), decodeParms.getInt(COSName.ROWS), 1, PDDeviceGray.INSTANCE);
        COSStream dict = pdImage.getCOSStream();
        dict.setItem(COSName.DECODE_PARMS, (COSBase)decodeParms);
        return pdImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFromTiff(RandomAccess reader, OutputStream os, COSDictionary params, int number) throws IOException {
        try {
            int amountRead;
            reader.seek(0L);
            char endianess = (char)reader.read();
            if ((char)reader.read() != endianess) {
                throw new IOException("Not a valid tiff file");
            }
            if (endianess != 'M' && endianess != 'I') {
                throw new IOException("Not a valid tiff file");
            }
            int magicNumber = CCITTFactory.readshort(endianess, reader);
            if (magicNumber != 42) {
                throw new IOException("Not a valid tiff file");
            }
            int address = CCITTFactory.readlong(endianess, reader);
            reader.seek(address);
            for (int i = 0; i < number; ++i) {
                int numtags = CCITTFactory.readshort(endianess, reader);
                if (numtags > 50) {
                    throw new IOException("Not a valid tiff file");
                }
                reader.seek(address + 2 + numtags * 12);
                address = CCITTFactory.readlong(endianess, reader);
                if (address == 0) {
                    return;
                }
                reader.seek(address);
            }
            int numtags = CCITTFactory.readshort(endianess, reader);
            if (numtags > 50) {
                throw new IOException("Not a valid tiff file");
            }
            int k = -1000;
            int dataoffset = 0;
            int datalength = 0;
            block21: for (int i = 0; i < numtags; ++i) {
                int tag = CCITTFactory.readshort(endianess, reader);
                int type = CCITTFactory.readshort(endianess, reader);
                int count = CCITTFactory.readlong(endianess, reader);
                int val = CCITTFactory.readlong(endianess, reader);
                if (endianess == 'M') {
                    switch (type) {
                        case 1: {
                            val >>= 24;
                            break;
                        }
                        case 3: {
                            val >>= 16;
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                }
                switch (tag) {
                    case 256: {
                        params.setInt(COSName.COLUMNS, val);
                        continue block21;
                    }
                    case 257: {
                        params.setInt(COSName.ROWS, val);
                        continue block21;
                    }
                    case 259: {
                        if (val == 4) {
                            k = -1;
                        }
                        if (val != 3) continue block21;
                        k = 0;
                        continue block21;
                    }
                    case 262: {
                        if (val != 1) continue block21;
                        params.setBoolean(COSName.BLACK_IS_1, true);
                        continue block21;
                    }
                    case 273: {
                        if (count != 1) continue block21;
                        dataoffset = val;
                        continue block21;
                    }
                    case 279: {
                        if (count != 1) continue block21;
                        datalength = val;
                        continue block21;
                    }
                    case 292: {
                        if ((val & 1) != 0) {
                            k = 50;
                        }
                        if ((val & 4) != 0) {
                            throw new IOException("CCITT Group 3 'uncompressed mode' is not supported");
                        }
                        if ((val & 2) == 0) continue block21;
                        throw new IOException("CCITT Group 3 'fill bits before EOL' is not supported");
                    }
                    case 324: {
                        if (count != 1) continue block21;
                        dataoffset = val;
                        continue block21;
                    }
                    case 325: {
                        if (count != 1) continue block21;
                        datalength = val;
                        continue block21;
                    }
                }
            }
            if (k == -1000) {
                throw new IOException("First image in tiff is not CCITT T4 or T6 compressed");
            }
            if (dataoffset == 0) {
                throw new IOException("First image in tiff is not a single tile/strip");
            }
            params.setInt(COSName.K, k);
            reader.seek(dataoffset);
            byte[] buf = new byte[8192];
            while ((amountRead = reader.read(buf, 0, Math.min(8192, datalength))) > 0) {
                datalength -= amountRead;
                os.write(buf, 0, amountRead);
            }
        }
        finally {
            os.close();
        }
    }

    private static int readshort(char endianess, RandomAccess raf) throws IOException {
        if (endianess == 'I') {
            return raf.read() | raf.read() << 8;
        }
        return raf.read() << 8 | raf.read();
    }

    private static int readlong(char endianess, RandomAccess raf) throws IOException {
        if (endianess == 'I') {
            return raf.read() | raf.read() << 8 | raf.read() << 16 | raf.read() << 24;
        }
        return raf.read() << 24 | raf.read() << 16 | raf.read() << 8 | raf.read();
    }
}

