=begin rdoc
call_rake4latex.rb offers an easy and fast interface
to rake4latex.

Just call it from the shell:
  call_rake4latex.rb my_file

my_file.tex will be compiled to my_file.pdf.

For details, please use the help:
  call_rake4latex.rb -h

For complex documents you may want define your own rakefile
and use rake.

It is recommended to copy this file to a location in your 
search path for executable files.
=end

require 'rake4latex'
#~ Dir.chdir('lib'){ require 'rake4latex' }
require 'optparse'

#Anlegen des Parsers
opts = OptionParser.new()
opts.banner = "Usage: call_rake4latex.rb [options] filename"	#Usage-zeile
opts.separator "Call LaTeX as often as needed."
opts.separator ""
opts.separator "Examples:"
opts.separator "call_rake4latex testdocument.pdf"
opts.separator "  Create testdocument.pdf via pdflatex"
opts.separator "  Starts only if testdocument.tex is newer then testdocument.pdf."
opts.separator ""
opts.separator "call_rake4latex -e testdocument"
opts.separator "  Touch 'testdocument.tex' (set the modification date)"
opts.separator "  Create testdocument.pdf via pdflatex"
opts.separator ""
opts.separator "Specific options:"

#
#List of task to be done after the TeX-call.
#
TASK_BEFORE_TeX = []  #only task where we need the filenem
TASK_AFTER_TeX = []
PARSE_MESSAGES = true


#
#fixme: format
=begin
Shortcuts
=end
opts.on('-e', "--enforce", "Enforce an initial TeX-run") { |v|
  TASK_BEFORE_TeX << :enforce
}

opts.on('-f', "--format FORMAT", "Set the format for TeX-run (pdflatex, xelatex, lualatex)") { |v|
  Rake4LaTeX::DEFAULT_SETTINGS[:program] = v.to_sym
}

#
#fixme:
#Warum gibt es immer einen TeX-Lauf mit dieser Option?
#
opts.on('--dep', "--dependecies", "Build dependecies (rakefile recommended)") { |v|
  TASK_BEFORE_TeX << :dependecies
}
opts.on("-i", "--ignore", "--ignore-error", "Allow LaTeX errors") { |v|
  puts "Allow LaTeX errors"  if PARSE_MESSAGES
    Rake4LaTeX::DEFAULT_SETTINGS[:texerrors_allowed] = true
}
opts.on("-s", "--statistic", "Show the statistic after TeX-run") { |v|
  puts "Show the statistic after TeX-run"  if PARSE_MESSAGES
  TASK_BEFORE_TeX  << :statistic  #Set filename
  TASK_AFTER_TeX  << :statistic
}
opts.on("-o", "--overview", "Create a log-overview file") { |v|
  puts "Create a log-overview file after TeX-run"  if PARSE_MESSAGES
  TASK_BEFORE_TeX  << :statistic  #Set filename
  TASK_AFTER_TeX  << :log_overview_file
}
opts.on("-c", "--clean", "Clean after TeX-run (delete auxiliary files)") { |v|
  puts "Clean after TeX-run"  if PARSE_MESSAGES
  TASK_AFTER_TeX  << :clean
}

=begin
Main options
=end
# Soll der Parameter Optional sein, kann [] verwendet werden.
opts.on("--touch FILE", "Touch FILE") { |v|
  puts "Touch #{v.inspect}" if PARSE_MESSAGES
  task :touch => v
  task :default => :touch
}


#
opts.on("--task TASK", "Define a rake-task") { |v|
  puts "Set task #{v.inspect}" if PARSE_MESSAGES
  task :default => v
}

#
opts.on("--task_after TASK", "Define a rake-task after the TeX-run") { |v|
  puts "Set task #{v.inspect} after LaTeX" if PARSE_MESSAGES
  TASK_AFTER_TeX  << v
}

=begin
LaTeXRunner-options
=end
#
opts.on("--maxrun MAXRUN", "Maximum MAXRUN TeX calls") { |v|
  puts "Set maximum TeX-Runs #{v.inspect}"  if PARSE_MESSAGES
    Rake4LaTeX::DEFAULT_SETTINGS[:maxruns] = v.to_i
}

opts.on("-l", "--loglevel LEVEL", "Log Level for the logger (1=debug, 2=info(default), 3=warn 4=error)") { |v|
  puts "Set loglevel to #{v.inspect}"  if PARSE_MESSAGES
  Rake4LaTeX::DEFAULT_SETTINGS[:loglevel] = v.to_i
}

opts.on("-v", "--version", "Version") { |v|
  puts "Rake4LaTeX-Caller Version #{Rake4LaTeX::VERSION}" 
}

task :default #empty dummy task

#Parsen der Parameter mit Exception bei ungltigen Parametern
begin
	opts.parse!
  ARGV.each{|arg|
    target = arg.ext('pdf')
    puts "Define target #{target}"
    TASK_BEFORE_TeX.each{|task|
    case task
      when :enforce
        puts "Force an initial TeX-run (touch #{target.ext('tex')})" if PARSE_MESSAGES
        task (:touch => target.ext('tex'))
        task (:default => :touch)
      when :dependecies
        puts "Build dependecies for #{target.ext('tex')}" if PARSE_MESSAGES
        TeXfile.new(target.ext('tex')).includes(:recursive, :uniq).each{|dep|
          puts "     => #{dep.inspect}" if PARSE_MESSAGES
          task (target => dep)
        }
      when :statistic
        task (:statistic => target.ext('tex'))
      when :log_overview_file
        task (:log_overview_file => target.ext('tex'))
      else
        raise ArgumentError, "Undefined option #{task.inspect}"
      end
    }
    task( :default => target )
    puts "call_rake4latex tries to generate #{target}"
  }  
rescue OptionParser::MissingArgument, OptionParser::InvalidOption => err
	puts "Error:\t#{err}"
	#Ausgabe der Schnittstelle
	puts opts
end

#
#Set tasks after the LaTeX-call
TASK_AFTER_TeX.each{|task|
  task (:default => task)
}

app = Rake.application
app[:default].invoke

if $0 == __FILE__
  if STDIN.tty?
    puts "Finished, please enter any key"
    STDOUT.flush
    STDIN.getc 
  end
end