/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse;

import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sourceforge.texlipse.SelectedResourceManager;
import net.sourceforge.texlipse.bibeditor.BibCodeScanner;
import net.sourceforge.texlipse.bibeditor.BibColorProvider;
import net.sourceforge.texlipse.bibeditor.BibEntryScanner;
import net.sourceforge.texlipse.templates.BibTexContextType;
import net.sourceforge.texlipse.templates.TexContextType;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TexlipsePlugin
extends AbstractUIPlugin {
    private static final String PLUGIN_ID = "net.sourceforge.texlipse";
    private static final String ICONS_PATH = "icons/";
    private static final String CUSTOM_TEMPLATES_TEX_KEY = "TeXTemplates";
    private static final String CUSTOM_TEMPLATES_BIBTEX_KEY = "BiBTeXTemplates";
    private static TexlipsePlugin plugin;
    private ResourceBundle resourceBundle;
    private TemplateStore texTemplateStore;
    private TemplateStore bibtexTemplateStore;
    private ContributionContextTypeRegistry texTypeRegistry = null;
    private ContributionContextTypeRegistry bibtexTypeRegistry = null;
    private BibColorProvider bibColor;
    private BibCodeScanner bibCodeScanner;
    private BibEntryScanner bibEntryScanner;
    protected static IWorkbenchWindow currentWindow;

    public TexlipsePlugin() {
        plugin = this;
        SelectedResourceManager.getDefault();
        try {
            this.resourceBundle = ResourceBundle.getBundle(String.valueOf(((Object)((Object)this)).getClass().getPackage().getName()) + ".TexlipsePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static TexlipsePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = TexlipsePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getPreference(String key) {
        return TexlipsePlugin.getDefault().getPreferenceStore().getString(key);
    }

    public static String[] getPreferenceArray(String key) {
        String g = TexlipsePlugin.getDefault().getPreferenceStore().getString(key);
        if (g == null) {
            return new String[0];
        }
        return g.split(",");
    }

    public static Image getImage(String name) {
        return TexlipsePlugin.getDefault().getCachedImage(name);
    }

    protected Image getCachedImage(String key) {
        if (key == null) {
            return null;
        }
        Image g = this.getImageRegistry().get(key);
        if (g != null) {
            return g;
        }
        ImageDescriptor d = TexlipsePlugin.getImageDescriptor(key);
        if (d == null) {
            return null;
        }
        if (d.equals(ImageDescriptor.getMissingImageDescriptor())) {
            return null;
        }
        g = d.createImage();
        this.getImageRegistry().put(key, g);
        return g;
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        return TexlipsePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(ICONS_PATH + relativePath + ".gif"));
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static IProject getCurrentProject() {
        IWorkbenchPage page = TexlipsePlugin.getCurrentWorkbenchPage();
        IEditorPart actEditor = null;
        if (!page.isEditorAreaVisible() || page.getActiveEditor() == null) {
            return null;
        }
        actEditor = page.getActiveEditor();
        IEditorInput editorInput = actEditor.getEditorInput();
        IFile aFile = (IFile)editorInput.getAdapter(IFile.class);
        if (aFile != null) {
            return aFile.getProject();
        }
        IResource res = SelectedResourceManager.getDefault().getSelectedResource();
        return res == null ? null : res.getProject();
    }

    public static IWorkbenchPage getCurrentWorkbenchPage() {
        IWorkbench workbench = TexlipsePlugin.getDefault().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            Display display = workbench.getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    currentWindow = TexlipsePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                }
            });
            window = currentWindow;
        }
        return window.getActivePage();
    }

    public static String getPluginId() {
        return TexlipsePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static IStatus stat(String msg, Throwable t) {
        return new Status(4, TexlipsePlugin.getPluginId(), 4, msg, t);
    }

    public static IStatus stat(String msg) {
        return TexlipsePlugin.stat(msg, null);
    }

    public static void log(String msg, Throwable t) {
        TexlipsePlugin.log(msg, t, 4);
    }

    public static void log(String msg, Throwable t, int level) {
        Status stat = new Status(level, TexlipsePlugin.getPluginId(), level, msg, t);
        TexlipsePlugin.getDefault().getLog().log((IStatus)stat);
    }

    public TemplateStore getTexTemplateStore() {
        if (this.texTemplateStore == null) {
            this.texTemplateStore = new ContributionTemplateStore(this.getTexContextTypeRegistry(), this.getPreferenceStore(), CUSTOM_TEMPLATES_TEX_KEY);
            try {
                this.texTemplateStore.load();
            }
            catch (IOException e) {
                TexlipsePlugin.log("Loading TeX template store", e);
                throw new RuntimeException(e);
            }
        }
        return this.texTemplateStore;
    }

    public TemplateStore getBibTemplateStore() {
        if (this.bibtexTemplateStore == null) {
            this.bibtexTemplateStore = new ContributionTemplateStore(this.getBibContextTypeRegistry(), this.getPreferenceStore(), CUSTOM_TEMPLATES_BIBTEX_KEY);
            try {
                this.bibtexTemplateStore.load();
            }
            catch (IOException e) {
                TexlipsePlugin.log("Loading BibTeX template store", e);
                throw new RuntimeException(e);
            }
        }
        return this.bibtexTemplateStore;
    }

    public ContextTypeRegistry getTexContextTypeRegistry() {
        if (this.texTypeRegistry == null) {
            this.texTypeRegistry = new ContributionContextTypeRegistry();
            this.texTypeRegistry.addContextType(TexContextType.TEX_CONTEXT_TYPE);
            this.texTypeRegistry.addContextType(TexContextType.MATH_CONTEXT_TYPE);
        }
        return this.texTypeRegistry;
    }

    public ContextTypeRegistry getBibContextTypeRegistry() {
        if (this.bibtexTypeRegistry == null) {
            this.bibtexTypeRegistry = new ContributionContextTypeRegistry();
            this.bibtexTypeRegistry.addContextType(BibTexContextType.BIBTEX_CONTEXT_TYPE);
        }
        return this.bibtexTypeRegistry;
    }

    public BibColorProvider getBibColorProvider() {
        if (this.bibColor == null) {
            this.bibColor = new BibColorProvider();
        }
        return this.bibColor;
    }

    public BibCodeScanner getBibCodeScanner() {
        if (this.bibCodeScanner == null) {
            this.bibCodeScanner = new BibCodeScanner(this.getBibColorProvider());
        }
        return this.bibCodeScanner;
    }

    public BibEntryScanner getBibEntryScanner() {
        if (this.bibEntryScanner == null) {
            this.bibEntryScanner = new BibEntryScanner(this.getBibColorProvider());
        }
        return this.bibEntryScanner;
    }
}

