#include <sys/emx.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dostime.h>
#include <sys/doscalls.h>

#define ACC(x) (((x)>>6)*0111)

static long _sys_ino = 0x20000;

int __fstat (int handle, struct stat *statbuf)
{
    struct file_time ft;
    unsigned long gmt;
    int info;

    if ((info = dos_ioctl_getattr(handle)) == -1)
	return -1;

    if (!(info & 0x80)) {	/* file */
	long oldpos;
	statbuf->st_mode = S_IFREG;
	oldpos = dos_lseek(handle, 0L, 1);
	statbuf->st_size = dos_lseek(handle, 0L, 2);
	dos_lseek(handle, oldpos, 0);
	statbuf->st_dev = 0;
    } else {			/* device */
	statbuf->st_mode = S_IFCHR;
	statbuf->st_size = 0L;
	statbuf->st_dev = (long) (info & 0x3F);
    }
    dos_getftime(handle, &ft.ft_date, &ft.ft_time);
    gmt = filetime2gmt(&ft);
    statbuf->st_atime = gmt;
    statbuf->st_ctime = gmt;
    statbuf->st_mtime = gmt;
    statbuf->st_mode |= ACC(S_IREAD | S_IWRITE);
    statbuf->st_uid = 0L;
    statbuf->st_gid = 0L;
    statbuf->st_rdev = statbuf->st_dev;
    statbuf->st_nlink = 1L;
    statbuf->st_ino = _sys_ino++;
    statbuf->st_attr = 0L;
    statbuf->st_reserved = 0L;
    return 0;
}
