# MAKEINST     (C) Santiago Vila    sanvila@unex.es
#
# Version 0.3a, 29-Dec-1995"
#
# Usage: 
# gawk -f makeinst.awk options mt.txt DSKFile [DATFile] > batfile.bat
#   where "options" is [-vlang=es] [-vpk=1] -vBATFile=batfile
#   
#
#
# You can use and modify this program freely.
# If you change the program, you must add your name and e-mail address
# and add a comment making clear it is a modified version.

function ltrim(a,i) {
  for (i = 1; i <= length(a); i++)
    if (substr(a,i,1) != " ")
      break;
  return substr(a,i);
}
function left(a, b) {
  return substr(a,1,b)
}
function NewLabel() {
  Label++ 
  return LabelName ltrim(Label)
}
function PRINTI(string) {
  print string
}
function PREM(s) {
  PRINTI(s == "" ? "REM" : "REM " s)
}
function ECH(s) {
  PRINTI(s == "" ? "ECHO." : "ECHO " s)
}
BEGIN {
  Strings[1]="This .BAT file has been created automatically with makeinst.awk"
  Strings[2]="Usage: "
  Strings[3]=" source-drive: destination-drive:"
  Strings[4]="source-drive: can also be a directory if it is not the root directory"
  Strings[5]="Examples:"
  Strings[6]="Please, insert disk "
  Strings[7]=" and then"
  Strings[8]="Do you want to install the "
  Strings[9]=" package "
  Strings[10]=" -----  This .BAT file has finished execution. ----- "
  Strings[11]=" Please, continue reading the README file that came with it"
  Strings[12]=" to know what to do next."
  Strings[13]="Warning, "
  Strings[14]="does not exist in that diskette!"
  Strings[15]="Try again with another one "
  
  if (lang == "es") {

  Strings[1]="Este fichero .BAT ha sido creado automticamente con makeinst.awk"
  Strings[2]="Modo de empleo: "
  Strings[3]=" unidad-origen: unidad-destino:"
  Strings[4]="unidad-origen: puede ser tambin un directorio si no es el directorio raz."
  Strings[5]="Ejemplos:"
  Strings[6]="Por favor, inserte el disquete "
  Strings[7]=" y a continuacin"
  Strings[8]="Desea instalar el paquete "
  Strings[9]=" "
  Strings[10]=" ----- Este archivo .BAT ha terminado de ejecutarse. ----- "
  Strings[11]=" Por favor, siga leyendo el archivo LEEME que lo acompaaba" 
  Strings[12]=" para saber qu hay que hacer ahora."
  Strings[13]="Atencin, "
  Strings[14]="no existe en ese disquete!"
  Strings[15]="Lo intentamos con otro "

  }

  Yes = 1
  No = 0
  LabelName = "lab"
  CheckDisk = Yes

  # pk may be Yes or No, and is defined with "-vpk=1" for example.

  # BATFile is defined with "-vBATFile=Whatever"

  MasterTableFile = ARGV[1]
  DskFile = ARGV[2] ".dsk"

  if (ARGC > 3)
    DatFile = ARGV[3] ".dat"
  else
    DatFile = ARGV[2] ".dat"

  if (pk) {
    UNZIP = "PK" "UNZIP"
    PathSep = "\\"
  }
  else {
    UNZIP = "UNZIP386"  # Change this to whatever you use.
    # Warning: 16-bit UNZIP does not seem to work with -x @file ...
    PathSep = "/"
    # I think that "\" doesn't work with 32-bit UNZIP
  }

  ARGV[2] = DatFile
  ARGV[3] = DskFile
  ARGC = 4

  PRINTI("@ECHO OFF")
  PREM("")
  PREM(Strings[1])
  PREM("(C) Santiago Vila  sanvila@unex.es")
  PREM("")
  PRINTI("IF NOT %2.==. GOTO Go")
  ECH(Strings[2] BATFile Strings[3])
  ECH(Strings[4])
  ECH(Strings[5])
  ECH("")
  ECH(BATFile " A: C:")
  ECH(BATFile " C:\\EMTEX.ZIP C:")
  PRINTI("GOTO End")
  PRINTI(":Go")
} # end BEGIN
{
  if (ARGIND==1) {
    MT++
    Master1[MT] = $1
    Master2[MT] = $3
  }
  else if (ARGIND==2) {
  # OPEN DatFile FOR INPUT AS #C
    Count++
    M[Count] = $0
  }
  else {
    # D = FREEFILE
    # OPEN DskFile FOR INPUT AS #D

    # I = FREEFILE
    # OPEN BATFile + ".BAT" FOR OUTPUT AS #I

    Key = left($0, 1)
    if (Key == "[") {
      Bracket = index($0, "]")
      DiskName = substr($0, 2, Bracket - 2)
    }
    else {
      OnlyName = tolower(left($0, index($0, ".") - 1))
      for (f = 1; f <= Count; f++) {
        NumberOfExcludeFiles = split(substr(M[f], 3), Work)
        NameInM = tolower(Work[1])
        if (OnlyName == NameInM)
          break;
      }
      if (f == Count + 1) {
        print "Fatal error: " OnlyName " not found in " DatFile > "/dev/stderr"
        STOP()
      }
      ZipFile = toupper(OnlyName)
      if (NumberOfExcludeFiles == 1)
        Excl = ""
      else {
        if (pk) {
          Excl = ""
          for (g = 2; g <= NumberOfExcludeFiles; g++)
            Excl = Excl "-x" Work[g] " "
        }
        else {
          Excl = "-x "
          for (g = 2; g <= NumberOfExcludeFiles; g++)
            Excl = Excl Work[g] " "
        }
      }
      Key = left(M[f], 1)

      if (Key == "Y" || Key == "A") {
        # Look for ZipFile in MT.TXT to see which is the true name.
        if (index(ZipFile, "?")) {
          for (g = 1; g <= MT; g++) {
            if (toupper(Master1[g]) == toupper(ZipFile))
              break;
          } 
          if (g == MT + 1) {
            print "Fatal error: " ZipFile " not found in " MasterTableFile > "/dev/stderr"
            STOP();
          }
          TrueZipFile = toupper(Master2[g])
        }
        else
          TrueZipFile = ZipFile
      
        if (pk)
          UNZIPLine = UNZIP " -d " Excl "%1" PathSep TrueZipFile " " "%2" PathSep
        else
          UNZIPLine = UNZIP " " "%1" PathSep TrueZipFile " " Excl "-d%2" PathSep
      
        if (DiskName "" != PreviousDiskName) {
          # Message to change diskette.
          if (CheckDisk) {
            Lab1 = NewLabel()
            Lab2 = NewLabel()
            PRINTI(":" Lab1)
          }
          ECH("")
          ECH("")
          ECH(Strings[6] DiskName Strings[7])
          PRINTI("PAUSE")
          if (CheckDisk) {
            PRINTI("IF EXIST %1\\" TrueZipFile ".ZIP GOTO " Lab2)
            ECH(Strings[13] TrueZipFile ".ZIP " Strings[14])
            PRINTI("CHOICE " Strings[15])
            PRINTI("IF NOT ERRORLEVEL 2 GOTO " Lab1)
            PRINTI(":" Lab2)
          }
          PreviousDiskName = DiskName;
        }
      }
      if (Key == "Y")
        PRINTI(UNZIPLine)
      else if (Key == "A") {
        Lab = NewLabel()
        ECH("")
        PRINTI("CHOICE " Strings[8] TrueZipFile Strings[9])
        PRINTI("IF ERRORLEVEL 2 GOTO " Lab)
        PRINTI(UNZIPLine)
        PRINTI(":" Lab)
      }
      else if (Key == "N")
        ; # (Do nothing)
      else 
        print "Sorry, I didn't understand the meaning of " Key > "/dev/stderr"
    }  
  } (end ARGIND==3)
}  
END {
  PRINTI("")
  ECH("")
  ECH(Strings[10])
  ECH("")
  ECH(Strings[11])
  ECH(Strings[12])
  PRINTI("")
  PRINTI(":End")

  print BATFile ".BAT created." > "/dev/stderr"
}
