/* symlink.c -- make a symbolic link.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <errno.h>
#include <stdio.h>
#include "ansidecl.h"
#include "symlink.h"
#include "symlink/ea.h"


static int
DEFUN (link, (old, new, mode),
const char *old AND
const char *new AND
int mode)
{
  char full[_MAX_PATH];
  int handle, result;

  if (!old)
    {
      errno = EINVAL;
      return (-1);
    }

  if (_fullpath (full, old, _MAX_PATH) == -1)
    return (-1);

  handle = ea_open (new, mode);
  if (handle == -1)
    return (-1);

  result = ea_set (handle, SYMLINK_ATTR_LINK, full, strlen (full));

  ea_close (handle);

  if (result == -1)
    remove (new);

  return (result);
}


int
DEFUN (symlink, (old, new),
const char *old AND
const char *new)
{
  return (link (old, new, EA_OPEN_NEW));
}


int
DEFUN (_symlink, (old, new),
const char *old AND
const char *new)
{
  return (link (old, new, EA_OPEN_WRITE));
}
