/********************************************************************
*
* $Workfile:$
* $Revision: 1.1 $
* $Modtime:$
* $Author: svenwiegand $
*
* nderungen:
*	$History:$
*
*********************************************************************/

/********************************************************************
*
* Declarations for files generated by COM Interface Wrapper Wizard
* (CIWW)
*
* Copyright  2001 Sven Wiegand (sven.wiegand@web.de)
*
********************************************************************/

#ifndef __INTERFACEWRAPPER_H__
#define __INTERFACEWRAPPER_H__

#include "InterfaceWrapperTools.h"
#include <atlbase.h>
#include <comdef.h>

/** Type of functions to retrieve a module state. */
typedef AFX_MODULE_STATE* (__stdcall *GET_MODULE_STATE_FUNCTION)();

/**
Base class for all the classes used to implement an interface.

Supports basic IUnknown features like internal reference counting.

@author Sven Wiegand
*/
template<class T>
class CInterfaceImplementationWrapper
{
// construction/destruction
public:
	//@{
	/**
	Constructs a stand allone object.

	@param pModuleState
		Pointer to the module state, that should be activated, when a
		COM-method is invoked.
	@param pGetModuleStateFunction
		Pointer to a global function that returs a pointer to the module
		state, that should be activated, when a COM-method is invoked.
	@param bNoDelete
		TRUE if the object should not be deleted, if the reference
		count becomes zero on a call to release.
	*/
	CInterfaceImplementationWrapper(AFX_MODULE_STATE* pModuleState, BOOL bNoDelete = FALSE);
	CInterfaceImplementationWrapper(GET_MODULE_STATE_FUNCTION pGetModuleStateFunction, BOOL bNoDelete = FALSE);
	//@}

	//@{
	/**
	Constructs an object which delegates its IUnknown-calls
	(AddRef(), Release() and QueryInterface()) to another object.

	This will usually be used to construct an object as part of a
	C++ aggregation.

	@param pModuleState
		Pointer to the module state, that should be activated, when a
		COM-method is invoked.
	@param pGetModuleStateFunction
		Pointer to a global function that returs a pointer to the module
		state, that should be activated, when a COM-method is invoked.
	@param pOwner
		Interface to delegate the IUnknown-calls to.
	*/
	CInterfaceImplementationWrapper(AFX_MODULE_STATE* pModuleState, IUnknown *pOwner);
	CInterfaceImplementationWrapper(GET_MODULE_STATE_FUNCTION pGetModuleStateFunction, IUnknown *pOwner);
	//@}

	virtual ~CInterfaceImplementationWrapper();

// operators
public:
	operator T*();

// operations
public:
	/**
	Sets an object, this object will deligate its IUnknown-calls
	(AddRef(), Release() and QueryInterface()) to.

	This will usually be used to construct an object as part of a
	C++ aggregation. 
	
	This should only be called directly after the construction of the
	object.

	@param pOwner
		Interface to delegate the IUnknown-calls to or NULL, if the
		object should handle the IUnknown-calls itself.
	*/
	void SetOwner(IUnknown *pOwner);

// overridables
public:
	/** Returns the pointer to the wrapped COM interface.	*/
	virtual T* GetInterface() = 0;

	/** 
	Returns the pointer to the specified interface, if implemented
	by the object or NULL otherwise.

	This method is called by QueryInterface. So overriding this
	method for providing additional interfaces makes overriding
	QueryInterface() unnecessary.

	The base implementation returns GetInterface() if the specified
	interface ID matches the result of GetInterfaceId() and NULL
	otherwise.

	@param riid
		ID of the interface to retrieve a pointer to.
	*/
	virtual IUnknown* GetInterfaceById(REFIID riid);

	/**
	If a owner has been set at construction time, the owner's AddRef()
	will be called, otherwise NonDelegatingAddRef() will be called.
	*/
	virtual ULONG AddRef();

	/**
	If a owner has been set at construction time, the owner's Release()
	will be called, otherwise NonDelegatingRelease() will be called.
	*/
	virtual ULONG Release();

	/**
	If a owner has been set at construction time, the owner's 
	QueryInterface() will be called, otherwise 
	NonDelegatingQueryInterface() will be called.
	*/
	virtual HRESULT QueryInterface(REFIID riid, void **ppv);

	/**
	If FALSE has been specified for the bNoDelete parameter of the
	object's constructor, the internal reference counter will be 
	incremented and returned afterwards, else only 2 will be 
	returned.
	*/
	virtual ULONG NonDelegatingAddRef();

	/**
	If FALSE has been specified for the bNoDelete parameter of the
	object's constructor, the internal reference counter will be 
	decremented, checked if it is zero and if it is the object will
	be destroyed by calling delete and the decremented reference 
	counter will be returned afterwards, else only 1 will be returned.
	*/
	virtual ULONG NonDelegatingRelease();

	/**
	Implements IUnknown::QueryInterface() by calling 
	GetInterface(riid). If the returned pointer is not NULL, its
	AddRef() method will be called and the pointer will be provided
	by the ppv parameter.
	*/
	virtual HRESULT NonDelegatingQueryInterface(REFIID riid, void **ppv);

// implementation helpers
protected:
	/**
	Should return the state of the module, this object belongs to.

	This base implementation works as follows: It checks if a valid
	module state pointer has been specified with the constructor and
	if this is the case returns this pointer. Otherwise it checks if a
	valid function pointer for a function that returns a module state
	has been specified with the constructor and returns the result of
	that function. Otherwise the method will return NULL and the debug 
	version will do an ASSERT(FALSE).
	*/
	virtual AFX_MODULE_STATE* GetModuleState();

// attributes
private:
	/**
	TRUE if the object should not be destroyed, when the reference
	counter becomes zero. 
	*/
	BOOL m_bNoDelete;

	/**
	The objects reference counter.
	*/
	LONG m_lRef;

	/**
	Owner of the object, the IUnknown-calls should be deligated to or
	NULL, if no owner has been specified.
	*/
	IUnknown *m_pOwner;

	/** 
	Module state to activate, when a COM-method is invoked, or NULL,
	if none has been specified with the constructor.
	*/
	AFX_MODULE_STATE *m_pModuleState;

	/**
	Pointer to a function returning the module state to activate, when
	a COM-method is invoked, or NULL, if none has been specified with
	the constructor.
	*/
	GET_MODULE_STATE_FUNCTION m_pGetModuleStateFunction;
};


/**
Base class for all the classes used to implement an interface derived
from IDispatch.

Supports basic IDispatch features.

Only works for dual interfaces.

@author Sven Wiegand
*/
template<class T>
class CDispatchInterfaceImplementationWrapper : public CInterfaceImplementationWrapper<T>
{
// construction/destruction
public:
	CDispatchInterfaceImplementationWrapper(AFX_MODULE_STATE *pModuleState, REFGUID rguidTypeLibrary, USHORT usVerMajor, USHORT usVerMinor, BOOL bNoDelete = FALSE);
	CDispatchInterfaceImplementationWrapper(GET_MODULE_STATE_FUNCTION pGetModuleStateFunction, REFGUID rguidTypeLibrary, USHORT usVerMajor, USHORT usVerMinor, BOOL bNoDelete = FALSE);
	CDispatchInterfaceImplementationWrapper(AFX_MODULE_STATE *pModuleState, REFGUID rguidTypeLibrary, USHORT usVerMajor, USHORT usVerMinor, IUnknown *pOwner);
	CDispatchInterfaceImplementationWrapper(GET_MODULE_STATE_FUNCTION pGetModuleStateFunction, REFGUID rguidTypeLibrary, USHORT usVerMajor, USHORT usVerMinor, IUnknown *pOwner);
	virtual ~CDispatchInterfaceImplementationWrapper();

// overridables
public:
	virtual HRESULT GetTypeInfoCount(UINT *pctinfo);
	virtual HRESULT GetTypeInfo(UINT iTInfo, LCID lcid, ITypeInfo **ppTInfo);
	virtual HRESULT GetIDsOfNames(REFIID riid, LPOLESTR *rgszNames, UINT cNames, LCID lcid, DISPID *rgid);
	virtual HRESULT Invoke(DISPID id, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS *pDispParams, VARIANT *pVarResult, EXCEPINFO *pExcepInfo, UINT *puArgErr);

// overridings
public:
	IUnknown* GetInterfaceById(REFIID riid);

// implementation helpers
private:
	void InitTypeInfo(REFGUID rguidTypeLibrary, USHORT usVerMajor, USHORT usVerMinor);

// attributes
private:
	ITypeInfo *m_pTypeInfo;
};


/**
Base class to implement an aggregate of classes implementing 
interfaces.

Derive your class from CInterfaceAggregate. Implement
the virtual inerface implementation wrappers, to implement the
necessary interfaces. Add one attribute for each interface 
implementation that should be aggregated. In the constructor
of your aggregate pass the m_xUnknown-pointer as the pOwner
pointer to the aggregated attributes.

All calls to the IUnknown-methods of the attributes will be deligated
to the calls of the aggregate. Override GetInterface() of the 
aggregate, so that it calls GetInterface() for all the attributes.

Use the GETTHIS() macro from InterfaceWrapperTools.h to retrieve
the pointer of the aggregate from a attribute.

@author Sven Wiegand
*/
class CInterfaceAggregate : public CInterfaceImplementationWrapper<IUnknown>
{
// construction/destruction
public:
	CInterfaceAggregate(AFX_MODULE_STATE *pModuleState, BOOL bNoDelete = FALSE);
	CInterfaceAggregate(GET_MODULE_STATE_FUNCTION pGetModuleStateFunction, BOOL bNoDelete = FALSE);
	CInterfaceAggregate(AFX_MODULE_STATE *pModuleState, IUnknown *pOwner);
	CInterfaceAggregate(GET_MODULE_STATE_FUNCTION pGetModuleStateFunction, IUnknown *pOwner);

	virtual ~CInterfaceAggregate();

// overridings
protected:
	IUnknown* GetInterface();

// IUnknonw-Implementation
private:
	class XUnknown : public IUnknown
	{
		/** Calls QueryInterface of the aggregate */
		STDMETHOD(QueryInterface)(REFIID riid, void** ppv);

		/** Calls AddRef of the aggregate */
		STDMETHOD_(ULONG, AddRef)();

		/** Calls Release of the aggregate */
		STDMETHOD_(ULONG, Release)();
	} m_xUnknown;
	friend class XUnknown;
};


/**
Base class for all classes that are wrapping a com interface.

@author Sven Wiegand
*/
template<class T>
class CInterfaceCallingWrapper
{
// construction/destruction
public:
	CInterfaceCallingWrapper();

	/**
	Attaches the given interface to this object.

	@param bIncrementRefCount
		Specify TRUE, if the reference count of the given interface
		should be incremented and FALSE otherwise.
	*/
	CInterfaceCallingWrapper(T *p, BOOL bIncrementRefCount = FALSE);

	/**
	Attaches the interface of the given wrapper to this object and
	increments the reference count of the interface.
	*/
	CInterfaceCallingWrapper(const CInterfaceCallingWrapper<T> &iw);

	/**
	Attaches the given interface, if it is of the wrapped type.

	This constructor calls QueryInterface() on the given interface
	to determine if the interface is of the wrapped type. If it is,
	the interface returned by QueryInterface() will be attached to
	the object, otherwise the object's pointer will be set to NULL.

	<b>Important:</b> If bIncrementRefCount is FALSE, the constructor
	will call Release() on the interface returned by QueryInterface()
	to set the reference count of the given COM object to the value,
	it had before the constructor was called. If bIncrementRefCount
	is set to TRUE, the constructor will do nothing additional, because
	AddRef() has already been called by QueryInterface. That way, the
	constructor seems to behave the same way as the 
	CInterfaceCallingWrapper(T *p,...) version.

	@param pUnknown
		Pointer to the interface that should be attached to this object.
		(See remarks above.).
	@param bIncrementRefCount
		Specify TRUE, if the reference count of the given interface
		should be incremented and FALSE otherwise. (See remarks above.)
	@param bThrowException
		If this parameter is TRUE, an exception will be thrown if the
		call to QueryInterface() fails, otherwise the object's pointer
		will be set to NULL and you can test for success with the
		!operator.
	*/
	CInterfaceCallingWrapper(IUnknown *pUnknown, BOOL bIncrementRefCount = FALSE, BOOL bThrowException = FALSE);

	/**
	Decrements the interfaces reference count.
	*/
	virtual ~CInterfaceCallingWrapper();

// operators
public:
	/** Returns the wrapped interface pointer */
	operator T*();

	/** Returns the dereferenced value of the interface pointer */
	T& operator*();

	/** Use to access the interface pointer */
	T* operator->();

	/** Same as Attach(p, TRUE);	*/
	T* operator=(T *p);

	/** true if the wrapped interface pointer is NULL false otherwise */
	bool operator!() const;

	/** compares the given pointer with the interface pointer of this object */
	bool operator==(T *p) const;

// operations
public:
	/** 
	Attaches the specified pointer.

	Will fail if there is already an interface attached to this 
	wrapper. Call Detach() first.

	@param bIncrementRefCount
		Specify TRUE, if the reference count of the given interface
		should be incremented and FALSE otherwise.

	@return
		TRUE if the interface has been attached to the wrapper, FALSE
		if there is already an interface attached.
	*/
	BOOL Attach(T *p, BOOL bIncrementRefCount = FALSE);

	/**
	Returns the member pointer and detaches it from this object by 
	setting it to NULL.

	@param bIncrementRefCount
		Specify TRUE, if the reference count of the given interface
		should be decremented and FALSE otherwise.
	*/
	T* Detach(BOOL bDecrementRefCount = FALSE);

	/**
	Copies the internal pointer to a target pointer. The pointer's 
	reference count is incremented if successful. Returns NULL if the
	wrapped interface pointer is NULL.
	*/
	T* CopyTo();

	/**
	Creates an instance of an object in a type-safe manner.
	*/
	HRESULT CoCreateInstance(REFCLSID rclsid, LPUNKNOWN pUnkOuter = NULL, DWORD dwClsContext = CLSCTX_ALL);

	/**
	Creates an instance of an object in a type-safe manner.
	*/
	HRESULT CoCreateInstance(LPCTSTR lpszProgId, LPUNKNOWN pUnkOuter = NULL, DWORD dwClsContext = CLSCTX_ALL);

	/**
	Calls QueryInterface() on the internal pointer in a type-safe 
	manner.
	*/
	template<class Q> HRESULT QueryInterface(Q **p)
	{
		return m_p.QueryInterface(p);
	}

	/**
	Calls QueryInterface() on the internal pointer in a type-safe 
	manner.

	@param bThrowException
		If TRUE the method will throw a CComException if the call to 
		QueryInterface() fails, otherwise only a NULL pointer will
		be returned if the call fails.
	*/
	/*
	Compiler does not allow explicit template parameter specification
	in the current version.

	template<class Q> Q* QueryInterface(BOOL bThrowException = FALSE)
	{
		Q	*p = NULL;
		HRESULT	hr = m_p.QueryInterface(&p);
		if (hr != S_OK && bThrowException)
			AfxThrowComException(hr);

		return p;
	}
	*/

	/**
	Calls QueryInterface() on the internal pointer.

	@param riid
		The interface ID of the interface to return a pointer to.
	@param bThrowException
		If TRUE the method will throw a CComException if the call to 
		QueryInterface() fails, otherwise only a NULL pointer will
		be returned if the call fails.
	*/
	IUnknown* QueryInterface(REFIID riid, BOOL bThrowException = FALSE);

	/**
	Returns the wrapped interface pointer.
	*/
	T* P();

	/**
	Returns the wrapped interface pointer as const.
	*/
	T* GetP() const;

// attributes
private:
	CComPtr<T> m_p;
};


/**
Base class for COM coclass implementations.

The template parameter T is the default interface implemented by the
related COM class.

@author Sven Wiegand
*/
template<class T>
class CCoClassWrapper
{
// construction/destruction
public:
	CCoClassWrapper(REFCLSID ClsId);
	virtual ~CCoClassWrapper();

// operations
public:
	/**
	Calls CoCreateInstance to create an instance of the class.

	Can only be called once on an object.

	@param dwClassContext
		See documentation of CoCreateInstance().
	*/
	HRESULT Create(DWORD dwClassContext = CLSCTX_ALL);

	/**
	Decrements the reference count of the internal default interface
	and sets the internal pointer to NULL.
	*/
	void Detach();

	/**
	Returns the interface, declared as the default interface for the
	COM class. Does not increase the reference counter of the 
	interface.
	*/
	T* DefaultInterface();

// attributes
protected:
	CComPtr<T> m_p;
	const CLSID &m_ClsId;
};


/**
Thrown if a call to a COM-interface returned a non successfull
HRESULT value. The m_hr member contains the return value that
caused the error.

To throw such an exception you should always use the static
Throw() method or the global AfxThrowComException() function.
Both are creating an instance on the heap and throwing the pointer.

To destruct a catched pointer to a CComException object, call the
Delete() method.

@author Sven Wiegand
*/
class CComException : public CException
{
// construction/destruction
public:
	CComException(HRESULT hr, IUnknown *pInterface = NULL, const GUID *piid = NULL);

// static helpers
public:
	/**
	Constructs a CComException object on the heap and throws the 
	pointer.
	*/
	static void Throw(HRESULT hr, IUnknown *pInterface = NULL, const GUID *piid = NULL);

	/**
	Returns the HRESULT value that caused the exception.
	*/
	HRESULT GetResult() const;

	/**
	Returns the GUID of the interface that caused the error or 
	GUID_NULL if this information is not available.
	*/
	GUID GetInterfaceId() const;

	/**
	Returns a description of the error, if available.
	*/
	CString GetDescription() const;

	/**
	Returns the path of the help file that describes the error, if 
	available.
	*/
	CString GetHelpFile() const;

	/**
	Returns the language dependent programmatic ID (ProgID) for the
	class or application that raised the error.
	*/
	CString GetSource() const;

	/**
	Returns the Help context identifier for the error or 0 if not
	available.
	*/
	DWORD GetHelpContext() const;

// overridings
public:
	BOOL GetErrorMessage(LPTSTR strError, UINT nMaxError, PUINT pnHelpContext = NULL);
	int ReportError(UINT nType = MB_OK, UINT nMessageID = 0);

// attributes
private:
	/** Value returned by the COM call causing the exception. */
	HRESULT m_hr;

	/** GUID of the interface that caused the error or GUID_NULL */
	GUID m_guidInterface;

	/** Description of the error or an empty string */
	CString m_strDescription;

	/** Path of the help file that describes the error */
	CString m_strHelpFile;

	/** 
	Language dependent programmatic ID (ProgID) for the class or 
	application that raised the error.
	*/
	CString m_strSource;

	/** Help context identifier for the error or 0 if not available */
	DWORD m_dwHelpContext;
};


/** Calls CComException::Throw() */
void AfxThrowComException(HRESULT hr, IUnknown *pInterface = NULL, const GUID *piid = NULL);

/** Calls CComException::Throw() */
template<class T>
void AfxThrowComException(HRESULT hr, CInterfaceImplementationWrapper<T> *pWrapper)
{
	CComException::Throw(hr, pWrapper->GetInterface(), &__uuidof(T));
}


// include template definitions
#include "../Source/InterfaceWrapper.inl"


#endif //__INTERFACEWRAPPERS_H__