/*7:*/
//line 183 "./o2externs.w"

/*6:*/
//line 180 "./o2externs.w"

#include "o2_externs.h" 
/*:6*/
//line 184 "./o2externs.w"

/*8:*/
//line 189 "./o2externs.w"

RULES_HAVING_AR_type RULES_HAVING_AR;
COMMON_LA_SETS_type COMMON_LA_SETS;
T_fsm_phrase*O2_FSM_PHASE(0);
T_parallel_parser_phrase*O2_PP_PHASE(0);
T_enum_phrase*O2_T_ENUM_PHASE(0);
T_lr1_k_phrase*O2_LRK_PHASE(0);
T_rc_phrase*O2_RC_PHASE(0);
T_error_symbols_phrase*O2_ERROR_PHASE(0);
T_terminals_phrase*O2_T_PHASE(0);
T_rules_phrase*O2_RULES_PHASE(0);

yacco2::AST*CWEB_MARKER(0);
yacco2::AST*GRAMMAR_TREE(0);
RULE_ENO START_OF_RULES_ENUM(-1);
extern STBL_T_ITEMS_type STBL_T_ITEMS;
/*:8*//*10:*/
//line 209 "./o2externs.w"

void prescan_mpname_for_cweb(std::string&In,std::string&Out){
int len= In.length();
for(int x= 0;x<len;++x){
switch(In[x]){
case' ':{
Out+= '.';
break;
}
case'\\':{
if(x+1<len){
if(In[x+1]=='\\'){
Out+= In[x];
++x;
break;
}
Out+= In[x];
break;
}else{
Out+= In[x];
break;
}
}
default:{
Out+= In[x];
break;
}
}
}
}

/*:10*//*11:*/
//line 241 "./o2externs.w"

extern void Print_dump_state(state*State){
/*12:*/
//line 245 "./o2externs.w"

const char*literal_name;
yacco2::lrclog<<std::endl;
yacco2::lrclog<<"->State: ";
state*cur_state= State;
literal_name= cur_state->entry_symbol_literal();

yacco2::lrclog<<cur_state->state_no_<<" Entry: "<<
cur_state->vectored_into_by_elem_
<<" Symbol: "
<<literal_name;
if(cur_state->closure_state_birthing_it_!=0){
yacco2::lrclog<<" Birthing closure state: "
<<cur_state->closure_state_birthing_it_->state_no_;
}
yacco2::lrclog<<std::endl;
yacco2::lrclog<<"   Follow set:"<<std::endl;
S_FOLLOW_SETS_ITER_type sfi= cur_state->state_s_follow_set_map_.begin();
S_FOLLOW_SETS_ITER_type sfie= cur_state->state_s_follow_set_map_.end();
for(;sfi!=sfie;++sfi){
follow_element*fe= sfi->second;
rule_def* rd = (rule_def*)AST::content(*fe->rule_def_t_);
yacco2::lrclog<<"    Rule no: "<<fe->rule_no_
<<" Name: "<<rd->rule_name()->c_str()<<std::endl;

FOLLOW_SETS_ITER_type i= fe->follow_set_.begin();
FOLLOW_SETS_ITER_type ie= fe->follow_set_.end();
if(i!=ie){
yacco2::lrclog<<"    follow set:"<<endl;
yacco2::lrclog<<"      ";
}
int nos(1);
for(;i!=ie;++i){
T_in_stbl*tit= *i;
++nos;
if(nos> 15){
yacco2::lrclog<<endl;
yacco2::lrclog<<"\t\t";
nos= 1;
}
yacco2::lrclog<<tit->t_def()->t_name()->c_str()<<" ";
}

TRANSITIONS_ITER_type j= fe->transitions_.begin();
TRANSITIONS_ITER_type je= fe->transitions_.end();
if(j!=je){
yacco2::lrclog<<"    transitions"<<endl;
}
for(;j!=je;++j){
follow_element*tfe= *j;
rule_def* rd = (rule_def*)AST::content(*tfe->rule_def_t_);
yacco2::lrclog<<"      S"<<tfe->its_state_->state_no_
<<"x"<<rd->rule_name()->c_str()<<endl;
}
MERGES_ITER_type k= fe->merges_.begin();
MERGES_ITER_type ke= fe->merges_.end();
if(k!=ke){
yacco2::lrclog<<"    merges"<<endl;
}
for(;k!=ke;++k){
state*s= *k;
yacco2::lrclog<<"      S"<<s->state_no_<<" ";
}
yacco2::lrclog<<endl;
}
yacco2::lrclog<<"   Vectors:"<<std::endl;
S_VECTORS_ITER_type svi= cur_state->state_s_vector_.begin();
S_VECTORS_ITER_type svie= cur_state->state_s_vector_.end();
for(;svi!=svie;++svi){
yacco2::lrclog<<"    Symbol no: "<<svi->first;

int first_time(0);
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
S_VECTOR_ELEMS_ITER_type selie= svi->second.end();
for(;seli!=selie;++seli){
state_element*se= *seli;
if(first_time==0){
first_time= 1;
CAbs_lr1_sym*sym= AST::content(*se->sr_element_);
yacco2::lrclog<<" Symbol: ";
switch(sym->enumerated_id__){
case T_Enum::T_refered_rule_:{
/*16:*/
//line 489 "./o2externs.w"

refered_rule* rr = (refered_rule*)sym;
/*:16*/
//line 327 "./o2externs.w"

rule_def*rd= rr->its_rule_def();
yacco2::lrclog<<rd->rule_name()->c_str()<<endl;
break;
}
case T_Enum::T_refered_T_:{
/*17:*/
//line 492 "./o2externs.w"

refered_T* rt = (refered_T*)sym;

/*:17*/
//line 333 "./o2externs.w"

T_terminal_def*td= rt->its_t_def();
yacco2::lrclog<<td->t_name()->c_str()<<endl;
break;
}
default:{
yacco2::lrclog<<sym->id()<<endl;
break;
}

}

}
/*13:*/
//line 361 "./o2externs.w"

CAbs_lr1_sym*sym= AST::content(*se->sr_element_);
Voc_ENO id= sym->enumerated_id__;
/*14:*/
//line 367 "./o2externs.w"

switch(id){
case T_Enum::T_refered_rule_:{
/*16:*/
//line 489 "./o2externs.w"

refered_rule* rr = (refered_rule*)sym;
/*:16*/
//line 370 "./o2externs.w"

yacco2::lrclog<<"      RxSRxPos: "<<rr->grammar_s_enumerate()->c_str();
rule_def*rd= rr->its_rule_def();
yacco2::lrclog<<" "<<rd->rule_name()->c_str();
break;
}
case T_Enum::T_T_eosubrule_:{
/*18:*/
//line 496 "./o2externs.w"

T_eosubrule* eos = (T_eosubrule*)sym;
/*:18*/
//line 377 "./o2externs.w"

if(se->la_set_!=0){
LA_SET_ITER_type i= se->la_set_->begin();
LA_SET_ITER_type ie= se->la_set_->end();
int nos(1);
if(i!=ie){
yacco2::lrclog<<"      reduce set #: "<<se->common_la_set_idx_<<endl;
yacco2::lrclog<<"        ";
for(;i!=ie;++i){
T_in_stbl*tit= *i;
++nos;
if(nos> 15){
yacco2::lrclog<<endl;
yacco2::lrclog<<"      ";
nos= 1;
}
yacco2::lrclog<<tit->t_def()->t_name()->c_str()<<" ";
}
yacco2::lrclog<<endl;}else{
yacco2::lrclog<<"      reduce set #: Empty see following transition"<<endl;
}
}
yacco2::lrclog<<"      RxSRxPos: "<<eos->grammar_s_enumerate()->c_str();
rule_def*rd= eos->its_rule_def();
yacco2::lrclog<<" Eos of "<<rd->rule_name()->c_str();
break;
}
case T_Enum::T_T_null_call_thread_eosubrule_:{
/*19:*/
//line 499 "./o2externs.w"

T_null_call_thread_eosubrule* eos = (T_null_call_thread_eosubrule*)sym;
/*:19*/
//line 405 "./o2externs.w"

if(se->la_set_!=0){
LA_SET_ITER_type i= se->la_set_->begin();
LA_SET_ITER_type ie= se->la_set_->end();
int nos(1);
if(i!=ie){
yacco2::lrclog<<"      reduce set #: "<<se->common_la_set_idx_<<endl;
yacco2::lrclog<<"        ";
for(;i!=ie;++i){
T_in_stbl*tit= *i;
++nos;
if(nos> 15){
yacco2::lrclog<<endl;
yacco2::lrclog<<"      ";
nos= 1;
}
yacco2::lrclog<<tit->t_def()->t_name()->c_str()<<" ";
}
yacco2::lrclog<<endl;
}else{
yacco2::lrclog<<"      reduce set #: Empty see following transition"<<endl;
}
}
yacco2::lrclog<<"      RxSRxPos: "<<eos->grammar_s_enumerate()->c_str();
rule_def*rd= eos->its_rule_def();
yacco2::lrclog<<" Eos of "<<rd->rule_name()->c_str();
break;
}
case T_Enum::T_T_called_thread_eosubrule_:{
/*20:*/
//line 502 "./o2externs.w"

T_called_thread_eosubrule* eos = (T_called_thread_eosubrule*)sym;


/*:20*/
//line 434 "./o2externs.w"

if(se->la_set_!=0){
LA_SET_ITER_type i= se->la_set_->begin();
LA_SET_ITER_type ie= se->la_set_->end();
int nos(1);
if(i!=ie){
yacco2::lrclog<<"      reduce set #: "<<se->common_la_set_idx_<<endl;
yacco2::lrclog<<"        ";
for(;i!=ie;++i){
T_in_stbl*tit= *i;
++nos;
if(nos> 15){
yacco2::lrclog<<endl;
yacco2::lrclog<<"      ";
nos= 1;
}
yacco2::lrclog<<tit->t_def()->t_name()->c_str()<<" ";
}
yacco2::lrclog<<endl;
}else{
yacco2::lrclog<<"      reduce set #: Empty see following transition"<<endl;
}
}
yacco2::lrclog<<"      RxSRxPos: "<<eos->grammar_s_enumerate()->c_str();
rule_def*rd= eos->its_rule_def();
yacco2::lrclog<<" Eos of "<<rd->rule_name()->c_str();
break;
}
case T_Enum::T_refered_T_:{
/*17:*/
//line 492 "./o2externs.w"

refered_T* rt = (refered_T*)sym;

/*:17*/
//line 463 "./o2externs.w"

yacco2::lrclog<<"      RxSRxPos: "<<rt->grammar_s_enumerate()->c_str();
T_terminal_def*td= rt->its_t_def();
yacco2::lrclog<<" "<<td->t_name()->c_str();
break;
}
}
yacco2::lrclog<<" Closured S"<<se->closure_state_->state_no_;
yacco2::lrclog<<" CS-gening-it S"<<se->closured_state_gening_it_->state_no_;
if(se->closure_state_->state_no_!=se->closured_state_gening_it_->state_no_){
yacco2::lrclog<<" due to rt bnd ";
}
if(se->goto_state_!=0){
yacco2::lrclog<<" goto S"<<se->goto_state_->state_no_;
}
if(se->reduced_state_!=0){
yacco2::lrclog<<" reduced S"<<se->reduced_state_->state_no_;
yacco2::lrclog<<std::endl;
}else{
yacco2::lrclog<<" reduced S"<<"????";
yacco2::lrclog<<std::endl;
}
/*:14*/
//line 364 "./o2externs.w"


/*:13*/
//line 346 "./o2externs.w"

}
}
if(cur_state->state_s_conflict_state_list_.empty()!=true){
yacco2::lrclog<<"  ===>Conflict states:"<<std::endl;
S_CONFLICT_STATES_ITER_type csi= cur_state->state_s_conflict_state_list_.begin();
S_CONFLICT_STATES_ITER_type csie= cur_state->state_s_conflict_state_list_.end();
for(;csi!=csie;++csi){
state*cstate= *csi;
yacco2::lrclog<<"      State no: "<<cstate->state_no_<<endl;
}
}
yacco2::lrclog<<"End of state"<<std::endl;

/*:12*/
//line 243 "./o2externs.w"

}
/*:11*//*21:*/
//line 576 "./o2externs.w"

bool
process_fsm_phrase
(yacco2::Parser&Calling_parser
,NS_yacco2_terminals::T_fsm&Phrase_to_parse
,yacco2::CAbs_lr1_sym**Cont_tok
,yacco2::INT*Cont_pos)
{
using namespace NS_yacco2_terminals;
using namespace yacco2;
TOKEN_GAGGLE op1;
yacco2::INT start_pos= Calling_parser.current_token_pos__;
token_container_type*ip1= Calling_parser.token_supplier();
TOKEN_GAGGLE*er1= (TOKEN_GAGGLE*)Calling_parser.error_queue();

using namespace NS_fsm_phrase;
Cfsm_phrase fsm;
Parser p1(fsm,ip1,&op1,start_pos,er1);
p1.parse();

if(er1->empty()==YES){
*Cont_pos= p1.current_token_pos__;
*Cont_tok= p1.current_token();
TOKEN_GAGGLE_ITER i= op1.begin();
CAbs_lr1_sym*sym= *i;
T_fsm_phrase* t = (T_fsm_phrase*)sym;
Phrase_to_parse.fsm_phrase(t);
if(O2_FSM_PHASE!=0){
CAbs_lr1_sym*sym= new Err_already_processed_fsm_phase;
sym->set_rc(Phrase_to_parse);
p1.add_token_to_error_queue(*sym);
goto error_exit;
}
O2_FSM_PHASE= t;
AST*gt= t->phrase_tree();
BUILD_GRAMMAR_TREE(*gt);
return Success;
}
error_exit:
lrclog<<"error in fsm-phrase"<<std::endl;
return Failure;
}

/*:21*//*22:*/
//line 620 "./o2externs.w"

void output_cweb_macros_and_banner(
NS_mpost_output::Cmpost_output*Fsm
,std::ofstream&Ofile
,yacco2::KCHARP Banner
,const char*Date
,string*Grammar_name
,string*Name_space
,int No_t){
using namespace NS_mpost_output;
KCHARP macros= 
"\\input%s \"supp-pdf\"\n"
"\\input \"/usr/local/yacco2/diagrams+etc/o2mac.tex\"\n";
int x= sprintf(Fsm->big_buf_,macros," ");
Ofile.write(Fsm->big_buf_,x);
KCHARP banner= 
"\\DOCtitle{%s}{%s}%\n"
"{%s}{%i}\n";
char fname[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave(Grammar_name->c_str(),fname);
char ns_name[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave(Name_space->c_str(),ns_name);

x= sprintf(Fsm->big_buf_,banner
,Banner
,fname,ns_name,No_t);
Ofile.write(Fsm->big_buf_,x);
}

/*:22*//*23:*/
//line 690 "./o2externs.w"

bool
process_parallel_parser_phrase
(yacco2::Parser&Calling_parser
,NS_yacco2_terminals::T_parallel_parser&Phrase_to_parse
,yacco2::CAbs_lr1_sym**Cont_tok
,yacco2::INT*Cont_pos)
{
using namespace NS_yacco2_terminals;
using namespace yacco2;

using namespace NS_parallel_parser_phrase;
TOKEN_GAGGLE op1;
yacco2::INT start_pos= Calling_parser.current_token_pos__;
token_container_type*ip1= Calling_parser.token_supplier();
TOKEN_GAGGLE*er1= (TOKEN_GAGGLE*)Calling_parser.error_queue();
Cparallel_parser_phrase pparser;
Parser p1(pparser,ip1,&op1,start_pos,er1);
p1.parse();
if(er1->empty()==YES){
*Cont_pos= p1.current_token_pos__;
*Cont_tok= p1.current_token();
TOKEN_GAGGLE_ITER i= op1.begin();
CAbs_lr1_sym*sym= *i;
T_parallel_parser_phrase* t = (T_parallel_parser_phrase*)sym;
Phrase_to_parse.parallel_parser_phrase(t);
if(O2_PP_PHASE!=0){
CAbs_lr1_sym*sym= new Err_already_processed_pp_phase;
sym->set_rc(Phrase_to_parse);
p1.add_token_to_error_queue(*sym);
goto error_exit;
}
O2_PP_PHASE= t;
AST*gt= t->phrase_tree();
BUILD_GRAMMAR_TREE(*gt);
return Success;
}
error_exit:
lrclog<<"error in parallel-parser-phrase"<<std::endl;
return Failure;
}


/*:23*//*24:*/
//line 753 "./o2externs.w"

bool
process_T_enum_phrase
(yacco2::Parser&Calling_parser
,NS_yacco2_terminals::T_enumeration&Phrase_to_parse
,yacco2::CAbs_lr1_sym**Cont_tok
,yacco2::INT*Cont_pos)
{
using namespace NS_yacco2_terminals;
using namespace yacco2;

using namespace NS_T_enum_phrase;
TOKEN_GAGGLE op1;
yacco2::INT start_pos= Calling_parser.current_token_pos__;
token_container_type*ip1= Calling_parser.token_supplier();
TOKEN_GAGGLE*er1= (TOKEN_GAGGLE*)Calling_parser.error_queue();
CT_enum_phrase enum_ph;
Parser p1(enum_ph,ip1,&op1,start_pos,er1);
p1.parse();
if(er1->empty()==YES){
*Cont_pos= p1.current_token_pos__;
*Cont_tok= p1.current_token();
TOKEN_GAGGLE_ITER i= op1.begin();
CAbs_lr1_sym*sym= *i;
T_enum_phrase* t = (T_enum_phrase*)sym;
Phrase_to_parse.enum_phrase(t);
if(O2_T_ENUM_PHASE!=0){
CAbs_lr1_sym*sym= new Err_already_processed_T_enum_phase;
sym->set_rc(Phrase_to_parse);
p1.add_token_to_error_queue(*sym);
goto error_exit;
}
O2_T_ENUM_PHASE= t;
AST*gt= t->phrase_tree();
BUILD_GRAMMAR_TREE(*gt);
return Success;
}
error_exit:
lrclog<<"error in t-enum-phrase"<<std::endl;
return Failure;
}

/*:24*//*25:*/
//line 816 "./o2externs.w"

bool
process_error_symbols_phrase
(yacco2::Parser&Calling_parser
,NS_yacco2_terminals::T_error_symbols&Phrase_to_parse
,yacco2::CAbs_lr1_sym**Cont_tok
,yacco2::INT*Cont_pos)
{
using namespace NS_yacco2_terminals;
using namespace yacco2;

using namespace NS_err_symbols_ph;
TOKEN_GAGGLE op1;
yacco2::INT start_pos= Calling_parser.current_token_pos__;
token_container_type*ip1= Calling_parser.token_supplier();
TOKEN_GAGGLE*er1= (TOKEN_GAGGLE*)Calling_parser.error_queue();
Cerr_symbols_ph err_ph;
Parser p1(err_ph,ip1,&op1,start_pos,er1);
p1.parse();
if(er1->empty()==YES){
*Cont_pos= p1.current_token_pos__;
*Cont_tok= p1.current_token();
TOKEN_GAGGLE_ITER i= op1.begin();
CAbs_lr1_sym*sym= *i;
T_error_symbols_phrase* t = (T_error_symbols_phrase*)sym;
Phrase_to_parse.error_symbols_phrase(t);
if(O2_ERROR_PHASE!=0){
CAbs_lr1_sym*sym= new Err_already_processed_error_phase;
sym->set_rc(Phrase_to_parse);
p1.add_token_to_error_queue(*sym);
goto error_exit;
}
O2_ERROR_PHASE= t;
AST*gt= t->phrase_tree();
BUILD_GRAMMAR_TREE(*gt);
return Success;
}
error_exit:
lrclog<<"error in error-symbols-phrase"<<std::endl;
return Failure;
}


/*:25*//*26:*/
//line 878 "./o2externs.w"

bool
process_rc_phrase
(yacco2::Parser&Calling_parser
,NS_yacco2_terminals::T_raw_characters&Phrase_to_parse
,yacco2::CAbs_lr1_sym**Cont_tok
,yacco2::INT*Cont_pos)
{
using namespace NS_yacco2_terminals;
using namespace yacco2;

using namespace NS_rc_phrase;
TOKEN_GAGGLE op1;
yacco2::INT start_pos= Calling_parser.current_token_pos__;
token_container_type*ip1= Calling_parser.token_supplier();
TOKEN_GAGGLE*er1= (TOKEN_GAGGLE*)Calling_parser.error_queue();
Crc_phrase rc_ph;
Parser p1(rc_ph,ip1,&op1,start_pos,er1);
p1.parse();
if(er1->empty()==YES){
*Cont_pos= p1.current_token_pos__;
*Cont_tok= p1.current_token();
TOKEN_GAGGLE_ITER i= op1.begin();
CAbs_lr1_sym*sym= *i;
T_rc_phrase* t = (T_rc_phrase*)sym;
Phrase_to_parse.rc_phrase(t);
if(O2_RC_PHASE!=0){
CAbs_lr1_sym*sym= new Err_already_processed_rc_phase;
sym->set_rc(Phrase_to_parse);
p1.add_token_to_error_queue(*sym);
goto error_exit;
}
O2_RC_PHASE= t;
AST*gt= t->phrase_tree();
BUILD_GRAMMAR_TREE(*gt);
return Success;
}
error_exit:
lrclog<<"error in rc-phrase"<<std::endl;
return Failure;
}


/*:26*//*27:*/
//line 940 "./o2externs.w"

bool
process_lr1_k_phrase
(yacco2::Parser&Calling_parser
,NS_yacco2_terminals::T_lr1_constant_symbols&Phrase_to_parse
,yacco2::CAbs_lr1_sym**Cont_tok
,yacco2::INT*Cont_pos)
{
using namespace NS_yacco2_terminals;
using namespace yacco2;

using namespace NS_lr1_k_phrase;
TOKEN_GAGGLE op1;
yacco2::INT start_pos= Calling_parser.current_token_pos__;
token_container_type*ip1= Calling_parser.token_supplier();
TOKEN_GAGGLE*er1= (TOKEN_GAGGLE*)Calling_parser.error_queue();
Clr1_k_phrase lr_ph;
Parser p1(lr_ph,ip1,&op1,start_pos,er1);
p1.parse();
if(er1->empty()==YES){
*Cont_pos= p1.current_token_pos__;
*Cont_tok= p1.current_token();
TOKEN_GAGGLE_ITER i= op1.begin();
CAbs_lr1_sym*sym= *i;
T_lr1_k_phrase* t = (T_lr1_k_phrase*)sym;
Phrase_to_parse.lr1_k_phrase(t);
if(O2_LRK_PHASE!=0){
CAbs_lr1_sym*sym= new Err_already_processed_lrk_phase;
sym->set_rc(Phrase_to_parse);
p1.add_token_to_error_queue(*sym);
goto error_exit;
}
O2_LRK_PHASE= t;
AST*gt= t->phrase_tree();
BUILD_GRAMMAR_TREE(*gt);
return Success;
}
error_exit:
lrclog<<"error in lr1-k-phrase"<<std::endl;
return Failure;
}


/*:27*//*28:*/
//line 1004 "./o2externs.w"

bool
process_terminals_phrase
(yacco2::Parser&Calling_parser
,NS_yacco2_terminals::T_terminals&Phrase_to_parse
,yacco2::CAbs_lr1_sym**Cont_tok
,yacco2::INT*Cont_pos)
{
using namespace NS_yacco2_terminals;
using namespace yacco2;

using namespace NS_terminals_phrase;
TOKEN_GAGGLE op1;
yacco2::INT start_pos= Calling_parser.current_token_pos__;
token_container_type*ip1= Calling_parser.token_supplier();
TOKEN_GAGGLE*er1= (TOKEN_GAGGLE*)Calling_parser.error_queue();
Cterminals_phrase term_ph;
Parser p1(term_ph,ip1,&op1,start_pos,er1);
p1.parse();
if(er1->empty()==YES){
*Cont_pos= p1.current_token_pos__;
*Cont_tok= p1.current_token();
TOKEN_GAGGLE_ITER i= op1.begin();
CAbs_lr1_sym*sym= *i;
T_terminals_phrase* t = (T_terminals_phrase*)sym;
Phrase_to_parse.terminals_phrase(t);
if(O2_T_PHASE!=0){
CAbs_lr1_sym*sym= new Err_already_processed_T_phase;
sym->set_rc(Phrase_to_parse);
p1.add_token_to_error_queue(*sym);
goto error_exit;
}
O2_T_PHASE= t;
AST*gt= t->phrase_tree();
BUILD_GRAMMAR_TREE(*gt);
return Success;
}
error_exit:
lrclog<<"error in terminals-phrase"<<std::endl;
return Failure;
}


/*:28*//*32:*/
//line 1176 "./o2externs.w"

bool
process_rules_phrase
(yacco2::Parser&Calling_parser
,NS_yacco2_terminals::T_rules&Phrase_to_parse
,yacco2::CAbs_lr1_sym**Cont_tok
,yacco2::INT*Cont_pos)
{
/*30:*/
//line 1143 "./o2externs.w"

lrclog<<"Enumerate T alphabet"<<endl;
using namespace NS_enumerate_T_alphabet;
Cenumerate_T_alphabet enum_syms_fsm;
Parser enum_syms(enum_syms_fsm,0,0,0,Calling_parser.error_queue(),0,0);
enum_syms.parse();
if(Calling_parser.error_queue()->empty()!=true)return Failure;

/*:30*/
//line 1184 "./o2externs.w"

using namespace NS_yacco2_terminals;
using namespace yacco2;

using namespace NS_rules_phrase;
TOKEN_GAGGLE op1;
yacco2::INT start_pos= Calling_parser.current_token_pos__;
token_container_type*ip1= Calling_parser.token_supplier();
TOKEN_GAGGLE*er1= (TOKEN_GAGGLE*)Calling_parser.error_queue();
Crules_phrase rule_ph;
Parser p1(rule_ph,ip1,&op1,start_pos,er1);
p1.parse();
if(er1->empty()==YES){
*Cont_pos= p1.current_token_pos__;
*Cont_tok= p1.current_token();
TOKEN_GAGGLE_ITER i= op1.begin();
CAbs_lr1_sym*sym= *i;
T_rules_phrase* t = (T_rules_phrase*)sym;
Phrase_to_parse.rules_phrase(t);
if(O2_RULES_PHASE!=0){
CAbs_lr1_sym*sym= new Err_already_processed_rule_phase;
sym->set_rc(Phrase_to_parse);
p1.add_token_to_error_queue(*sym);
goto error_exit;
}
O2_RULES_PHASE= t;
AST*gt= t->phrase_tree();
BUILD_GRAMMAR_TREE(*gt);
/*31:*/
//line 1162 "./o2externs.w"

lrclog<<"Enumerate Rule alphabet"<<endl;
int Rules_enum= START_OF_RULES_ENUM;
RULE_DEFS_TBL_ITER_type ri= t->crt_order()->begin();
RULE_DEFS_TBL_ITER_type rie= t->crt_order()->end();
int rule_no(0);
for(;ri!=rie;++ri,++Rules_enum){
rule_def*rd= *ri;
++rule_no;
rd->enum_id(Rules_enum);
rd->rule_no(rule_no);
}

/*:31*/
//line 1212 "./o2externs.w"

return Success;
}
error_exit:
lrclog<<"error in rules-phrase"<<std::endl;
return Failure;
}

/*:32*//*34:*/
//line 1237 "./o2externs.w"

extern void
YACCO2_PARSE_CMD_LINE
(yacco2::CHAR&T_sw,yacco2::CHAR&ERR_sw
,yacco2::CHAR&PRT_sw
,std::string&Grammar_to_compile
,yacco2::TOKEN_GAGGLE&Error_queue)
{
using namespace NS_yacco2_err_symbols;
using namespace yacco2;
tok_can<std::ifstream> Cmd1_tokens(Yacco2_holding_file);
if(Cmd1_tokens.file_ok()==NO){
yacco2::Delete_tokens(Cmd1_tokens.container());
CAbs_lr1_sym*sym= new Err_bad_filename(Yacco2_holding_file);
sym->set_external_file_id(1);
sym->set_line_no(1);
sym->set_pos_in_line(1);
Error_queue.push_back(*sym);
return;
}

using namespace NS_o2_lcl_opts;
TOKEN_GAGGLE lcl_options_tokens;
Co2_lcl_opts opts_fsm;
Parser options(opts_fsm,&Cmd1_tokens,&lcl_options_tokens,0,&Error_queue,0,0);
options.parse();
yacco2::Delete_tokens(Cmd1_tokens.container());
if(Error_queue.empty()!=YES)return;
T_sw= opts_fsm.t_sw_;ERR_sw= opts_fsm.err_sw_;
PRT_sw= opts_fsm.prt_sw_;
Grammar_to_compile+= opts_fsm.file_to_compile_;
}

/*:34*//*35:*/
//line 1290 "./o2externs.w"

extern void
BUILD_GRAMMAR_TREE(yacco2::AST&Item)
{
using namespace NS_yacco2_T_enum;
using namespace NS_yacco2_terminals;
using namespace yacco2;
CAbs_lr1_sym*sym= AST::content(Item);
static AST*cur_node(0);
static AST*holding_kcweb(0);
static AST*end_holding_kcweb(0);
static bool rules_phrase_seen(false);
if(sym->enumerated_id__==T_Enum::T_T_cweb_marker_){
if(rules_phrase_seen==true){
AST::join_sts(*cur_node,Item);
cur_node= &Item;
return;
}
if(holding_kcweb==0){
holding_kcweb= &Item;
}else{
if(end_holding_kcweb==0){
end_holding_kcweb= &Item;
AST::join_sts(*holding_kcweb,*end_holding_kcweb);
}else{
AST::join_sts(*end_holding_kcweb,Item);
end_holding_kcweb= &Item;
}
}
return;
}
if(cur_node==0){
CAbs_lr1_sym*gp= new T_grammar_phrase();
gp->set_line_no_and_pos_in_line(*sym);
gp->set_external_file_id(sym->tok_co_ords__.external_file_id__);
GRAMMAR_TREE= new AST(*gp);
AST::crt_tree_of_1son(*GRAMMAR_TREE,Item);
cur_node= &Item;
}else{
AST::join_sts(*cur_node,Item);
cur_node= &Item;
}
if(sym->enumerated_id__==T_Enum::T_T_rules_phrase_){
rules_phrase_seen= true;
}
/*36:*/
//line 1343 "./o2externs.w"

if(holding_kcweb==0)return;
tok_can_ast_functor just_walk_functr;
ast_prefix_1forest element_walk(Item,&just_walk_functr);
tok_can<AST*> phrase_can(element_walk);
using namespace NS_cweb_put_k_into_ph;
Ccweb_put_k_into_ph cweb_k_fsm;
cweb_k_fsm.initialize(holding_kcweb,&rules_phrase_seen);
Parser cweb_k(cweb_k_fsm,&phrase_can,0);
cweb_k.parse();
holding_kcweb= 0;
end_holding_kcweb= 0;

/*:36*/
//line 1335 "./o2externs.w"

}

/*:35*//*37:*/
//line 1381 "./o2externs.w"

void load_kw_into_tbl(yacco2::CAbs_lr1_sym*Kw){
using namespace yacco2_stbl;
T_sym_tbl_report_card report_card;
const char*kwkey= Kw->id__;
if(*kwkey=='#')++kwkey;
kw_in_stbl*kw= new kw_in_stbl(Kw);
add_sym_to_stbl(report_card,*kwkey,*kw,table_entry::defed,table_entry::keyword);
kw->stbl_idx(report_card.pos_);
}

extern void LOAD_YACCO2_KEYWORDS_INTO_STBL()
{
using namespace yacco2_stbl;
load_kw_into_tbl(new T_raw_characters);
load_kw_into_tbl(new T_lr1_constant_symbols);
load_kw_into_tbl(new T_error_symbols);
load_kw_into_tbl(new T_eocode);
load_kw_into_tbl(new T_AD);
load_kw_into_tbl(new T_AB);
load_kw_into_tbl(new T_parallel_la_boundary);
load_kw_into_tbl(new T_arbitrator_code);
load_kw_into_tbl(new T_parallel_parser);
load_kw_into_tbl(new T_parallel_thread_function);
load_kw_into_tbl(new T_parallel_control_monitor);
load_kw_into_tbl(new T_fsm);
load_kw_into_tbl(new T_fsm_id);
load_kw_into_tbl(new T_fsm_filename);
load_kw_into_tbl(new T_fsm_namespace);
load_kw_into_tbl(new T_fsm_class);
load_kw_into_tbl(new T_fsm_version);
load_kw_into_tbl(new T_fsm_date);
load_kw_into_tbl(new T_fsm_debug);
load_kw_into_tbl(new T_fsm_comments);
load_kw_into_tbl(new T_terminals);
load_kw_into_tbl(new T_enumeration);
load_kw_into_tbl(new T_file_name);
load_kw_into_tbl(new T_name_space);
load_kw_into_tbl(new T_sym_class);
load_kw_into_tbl(new T_rules);
load_kw_into_tbl(new T_lhs);
load_kw_into_tbl(new T_user_declaration);
load_kw_into_tbl(new T_user_prefix_declaration);
load_kw_into_tbl(new T_user_suffix_declaration);
load_kw_into_tbl(new T_constructor);
load_kw_into_tbl(new T_destructor);
load_kw_into_tbl(new T_op);
load_kw_into_tbl(new T_failed);
load_kw_into_tbl(new T_user_implementation);
load_kw_into_tbl(new T_user_imp_tbl);
load_kw_into_tbl(new T_user_imp_sym);
load_kw_into_tbl(new T_constant_defs);
load_kw_into_tbl(new T_terminals_refs);
load_kw_into_tbl(new T_terminals_sufx);
load_kw_into_tbl(new T_lrk_sufx);
load_kw_into_tbl(new T_NULL);
}

/*:37*//*38:*/
//line 1445 "./o2externs.w"

extern void PRINT_RULES_TREE_STRUCTURE(AST*Node)
{
using namespace NS_yacco2_T_enum;
using namespace NS_yacco2_terminals;
if(Node==0)return;
CAbs_lr1_sym*sym= AST::content(*Node);
if(sym==0){
yacco2::lrclog<<" SYMBOL IN AST CONTENT NULL"
<<" Node*: "<<Node<<endl;
return;
}
yacco2::lrclog<<sym->id__<<' ';

switch(sym->enumerated_id__){
case T_Enum::T_refered_T_:{
refered_T* sym1 = (refered_T*)sym;
T_in_stbl*T= sym1->t_in_stbl();
yacco2::lrclog<<T->t_def()->t_name()->c_str();
break;
}
case T_Enum::T_refered_rule_:{
refered_rule* sym1 = (refered_rule*)sym;
rule_in_stbl*R= sym1->Rule_in_stbl();
yacco2::lrclog<<R->r_def()->rule_name()->c_str();
break;
}
case T_Enum::T_T_identifier_:{
T_identifier* sym1 = (T_identifier*)sym;
yacco2::lrclog<<sym1->identifier()->c_str();
break;
}
case T_Enum::T_rule_def_:{
rule_def* sym1 = (rule_def*)sym;
yacco2::lrclog<<sym1->rule_name()->c_str();
yacco2::lrclog<<" epsilon: ";
if(sym1->epsilon()==true){
yacco2::lrclog<<" Y ";
}else{
yacco2::lrclog<<" N ";
}
break;
}
case T_Enum::T_T_terminal_def_:{
T_terminal_def* sym1 = (T_terminal_def*)sym;
yacco2::lrclog<<sym1->t_name()->c_str();
break;
}
case T_Enum::T_T_subrule_def_:{
T_subrule_def* sym1 = (T_subrule_def*)sym;
yacco2::lrclog<<" epsilon: ";
if(sym1->epsilon()==true){
yacco2::lrclog<<" Y ";
}else{
yacco2::lrclog<<" N ";
}
break;
}
case T_Enum::T_T_eosubrule_:{
break;
}
case T_Enum::T_T_NULL_:{
break;
}
case T_Enum::T_T_2colon_:{
break;
}

default:{
yacco2::lrclog<<sym->id__;
}
}

yacco2::lrclog<<" file# "<<sym->tok_co_ords__.external_file_id__
<<':'<<sym->tok_co_ords__.rc_pos__<<':';
yacco2::lrclog<<" line# "<<sym->tok_co_ords__.line_no__
<<':'<<sym->tok_co_ords__.pos_in_line__<<':';
yacco2::lrclog<<" sym*: "<<sym<<' ';
yacco2::lrclog<<endl;
}

/*:38*//*39:*/
//line 1529 "./o2externs.w"

extern void WRT_CWEB_MARKER(std::ofstream*Wfile,yacco2::AST*Cweb_marker){
using namespace NS_yacco2_T_enum;
using namespace NS_yacco2_terminals;
using namespace yacco2;
INT_SET_type filter;
filter.insert(T_Enum::T_T_cweb_comment_);
tok_can_ast_functor just_walk_functr;
ast_prefix_1forest rule_walk(*Cweb_marker,&just_walk_functr,&filter,ACCEPT_FILTER);
tok_can<AST*> comments_can(rule_walk);
for(int x(0);comments_can[x]!=yacco2::PTR_LR1_eog__;++x){
T_cweb_comment*k= (T_cweb_comment*)comments_can[x];
(*Wfile)<<k->comment_data()->c_str()<<endl;
}
}

/*:39*//*40:*/
//line 1552 "./o2externs.w"

extern void PRINT_GRAMMAR_TREE(AST*Node)
{
using namespace NS_yacco2_T_enum;
using namespace NS_yacco2_terminals;
if(Node==0)return;
CAbs_lr1_sym*sym= AST::content(*Node);
if(sym==0){
yacco2::lrclog<<" SYMBOL IN AST CONTENT NULL"
<<" Node*: "<<Node
<<" lt*: "<<Node->lt_<<" rt*: "<<Node->rt_
<<std::endl;
return;
}
yacco2::lrclog<<sym->id__<<' ';

switch(sym->enumerated_id__){
case T_Enum::T_T_cweb_comment_:{
T_cweb_comment* sym1 = (T_cweb_comment*)sym;
yacco2::lrclog<<sym1->comment_data()->c_str();
break;
}
}

yacco2::lrclog<<" file# "<<sym->tok_co_ords__.external_file_id__
<<':'<<sym->tok_co_ords__.rc_pos__<<':';
yacco2::lrclog<<" line# "<<sym->tok_co_ords__.line_no__
<<':'<<sym->tok_co_ords__.pos_in_line__<<':';
yacco2::lrclog<<" sym*: "<<sym<<' ';
yacco2::lrclog<<" Node*: "<<Node
<<" lt*: "<<Node->lt_<<" rt*: "<<Node->rt_
<<std::endl;
}

/*:40*//*41:*/
//line 1632 "./o2externs.w"

extern
bool
PROCESS_INCLUDE_FILE
(yacco2::Parser&Calling_parser
,NS_yacco2_terminals::T_file_inclusion&File_include
,yacco2::token_container_type&T2)
{
using namespace NS_yacco2_terminals;
using namespace NS_yacco2_err_symbols;
using namespace yacco2;
std::string*ps_fn= File_include.file_name()->c_string();
lrclog<<"Pre-process file: "<<ps_fn->c_str()<<std::endl;
if(yacco2::STK_FILE_NOS__.size()>=Nested_file_cnt_limit){
CAbs_lr1_sym*s= new Err_nested_files_exceeded(Nested_file_cnt_limit,*ps_fn);
s->set_line_no_and_pos_in_line(File_include);
s->set_external_file_id(File_include.tok_co_ords__.external_file_id__);
Calling_parser.add_token_to_error_queue(*s);
Calling_parser.abort_parse__;
return Failure;
}

tok_can<std::ifstream> p1_tokens(ps_fn->c_str());
if(p1_tokens.file_ok()==NO){
yacco2::Delete_tokens(p1_tokens.container());
CAbs_lr1_sym*sym= new NS_yacco2_err_symbols::Err_bad_filename(*ps_fn);
sym->set_external_file_id(File_include.tok_co_ords__.external_file_id__);
sym->set_line_no_and_pos_in_line(File_include);
Calling_parser.add_token_to_error_queue(*sym);
Calling_parser.abort_parse__;
return Failure;
}
using namespace NS_pass3;
Cpass3 p3_fsm;
Parser pass3(p3_fsm,&p1_tokens,&T2,0,Calling_parser.error_queue(),Calling_parser.recycle_bin__);
pass3.parse();
yacco2::Delete_tokens(p1_tokens.container());

if(pass3.error_queue()->empty()!=YES){
Calling_parser.abort_parse__;
return Failure;
}

yacco2::STK_FILE_NOS__.pop_back();
return Success;
}

/*:41*//*42:*/
//line 1714 "./o2externs.w"

extern
bool
PROCESS_KEYWORD_FOR_SYNTAX_CODE
(yacco2::Parser&Parser
,yacco2::CAbs_lr1_sym*Keyword
,yacco2::CAbs_lr1_sym**Cont_tok
,yacco2::INT*Cont_pos)
{
using namespace NS_yacco2_T_enum;
using namespace NS_yacco2_terminals;
using namespace yacco2;
switch(Keyword->enumerated_id__){
case T_Enum::T_T_fsm_:{
T_fsm* fsm = (T_fsm*)Keyword;
return process_fsm_phrase(Parser,*fsm,Cont_tok,Cont_pos);
}
case T_Enum::T_T_parallel_parser_:{
T_parallel_parser* pparser = (T_parallel_parser*)Keyword;
return process_parallel_parser_phrase(Parser,*pparser,Cont_tok,Cont_pos);
}
case T_Enum::T_T_enumeration_:{
T_enumeration* enumer = (T_enumeration*)Keyword;
return process_T_enum_phrase(Parser,*enumer,Cont_tok,Cont_pos);
}
case T_Enum::T_T_error_symbols_:{
T_error_symbols* err = (T_error_symbols*)Keyword;
return process_error_symbols_phrase(Parser,*err,Cont_tok,Cont_pos);
}
case T_Enum::T_T_raw_characters_:{
T_raw_characters* rc = (T_raw_characters*)Keyword;
return process_rc_phrase(Parser,*rc,Cont_tok,Cont_pos);
}
case T_Enum::T_T_lr1_constant_symbols_:{
T_lr1_constant_symbols* lr = (T_lr1_constant_symbols*)Keyword;
return process_lr1_k_phrase(Parser,*lr,Cont_tok,Cont_pos);
}
case T_Enum::T_T_terminals_:{
T_terminals* term = (T_terminals*)Keyword;
return process_terminals_phrase(Parser,*term,Cont_tok,Cont_pos);
}
case T_Enum::T_T_rules_:{
T_rules* rule = (T_rules*)Keyword;
return process_rules_phrase(Parser,*rule,Cont_tok,Cont_pos);
}
default:{
CAbs_lr1_sym*sym= new Err_not_kw_defining_grammar_construct;
sym->set_rc(*Keyword);
Parser.add_token_to_error_queue(*sym);
return Failure;
}
}
return Success;
}

/*:42*//*44:*/
//line 1786 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_LOAD_XLATE_CHRS
(NS_mpost_output::Cmpost_output*Fsm)
{
Fsm->xlated_names_[T_Enum::T_raw_exclam_]= "exclamation mark";
Fsm->xlated_names_[T_Enum::T_raw_dbl_quote_]= "dbl quote";
Fsm->xlated_names_[T_Enum::T_raw_no_sign_]= "no sign";
Fsm->xlated_names_[T_Enum::T_raw_dollar_sign_]= "dollar sign";
Fsm->xlated_names_[T_Enum::T_raw_percent_]= "percent";
Fsm->xlated_names_[T_Enum::T_raw_ampersign_]= "ampersand";
Fsm->xlated_names_[T_Enum::T_raw_right_quote_]= "rt quote";
Fsm->xlated_names_[T_Enum::T_raw_open_bracket_]= "open bracket";
Fsm->xlated_names_[T_Enum::T_raw_close_bracket_]= "close bracket";
Fsm->xlated_names_[T_Enum::T_raw_asteric_]= "asterisk";
Fsm->xlated_names_[T_Enum::T_raw_plus_]= "plus";
Fsm->xlated_names_[T_Enum::T_raw_comma_]= "comma";
Fsm->xlated_names_[T_Enum::T_raw_minus_]= "minus";
Fsm->xlated_names_[T_Enum::T_raw_period_]= "period";
Fsm->xlated_names_[T_Enum::T_raw_slash_]= "slash";
Fsm->xlated_names_[T_Enum::T_raw_colon_]= "colon";
Fsm->xlated_names_[T_Enum::T_raw_semi_colon_]= "semi colon";
Fsm->xlated_names_[T_Enum::T_raw_less_than_]= "less than";
Fsm->xlated_names_[T_Enum::T_raw_eq_]= "eq";
Fsm->xlated_names_[T_Enum::T_raw_gt_than_]= "gt than";
Fsm->xlated_names_[T_Enum::T_raw_question_mark_]= "question mark";
Fsm->xlated_names_[T_Enum::T_raw_at_sign_]= "at sign";
Fsm->xlated_names_[T_Enum::T_raw_open_sq_bracket_]= "open sq bracket";
Fsm->xlated_names_[T_Enum::T_raw_back_slash_]= "back slash";
Fsm->xlated_names_[T_Enum::T_raw_close_sq_bracket_]= "close sq bracket";
Fsm->xlated_names_[T_Enum::T_raw_up_arrow_]= "up arrow";
Fsm->xlated_names_[T_Enum::T_raw_under_score_]= "under score";
Fsm->xlated_names_[T_Enum::T_raw_left_quote_]= "left quote";
Fsm->xlated_names_[T_Enum::T_raw_open_brace_]= "open brace";
Fsm->xlated_names_[T_Enum::T_raw_vertical_line_]= "vertical line";
Fsm->xlated_names_[T_Enum::T_raw_close_brace_]= "close brace";
Fsm->xlated_names_[T_Enum::T_raw_tilde_]= "tilde";
Fsm->xlated_names_[T_Enum::T_raw_del_]= "del";
Fsm->xlated_names_[T_Enum::T_LR1_invisible_shift_operator_]= "\\invisibleshift";
Fsm->xlated_names_[T_Enum::T_LR1_all_shift_operator_]= "\\allshift";
Fsm->xlated_names_[T_Enum::T_LR1_reduce_operator_]= "\\reduceoperator";
Fsm->xlated_names_[T_Enum::T_LR1_fset_transience_operator_]= "\\transienceoperator";
Fsm->xlated_names_[T_Enum::T_LR1_questionable_shift_operator_]= "\\questionableoperator";
}

/*:44*//*48:*/
//line 1889 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_EMIT_PREFIX_CODE
(NS_mpost_output::Cmpost_output*Fsm)
{
/*46:*/
//line 1839 "./o2externs.w"


KCHARP mp_prefix_file= "% file: ";
Fsm->omp_file_<<mp_prefix_file;
KCHARP mp_prefix_file_value= 
"%s - grammar railroad diagrams for mpost program\n";
int x= sprintf(Fsm->big_buf_,mp_prefix_file_value,Fsm->mp_filename_.c_str());
Fsm->omp_file_.write(Fsm->big_buf_,x);
Fsm->omp_file_<<endl;

KCHARP mp_prefix_date= "% date: ";
Fsm->omp_file_<<mp_prefix_date;
KCHARP mp_prefix_date_value= 
"%s\n"
"input \"/usr/local/yacco2/diagrams+etc/o2diag.mp\"\n"
"numeric no_of_rules,Box_solid,Box_dotted,Circle_solid,Circle_dotted;\n"
"Box_solid:=1;Box_dotted:=2;Circle_solid:=3;Circle_dotted:=4;\n"
"string rule_names[].literal;\n"
"string rule_names[].vname;\n"
"numeric rule_s_no_rhs[];\n"
"string rhs_elems[][][].literal;\n"
"string rhs_elems[][][].vname;\n"
"numeric rhs_elems[][][].Drw_how;\n"
"numeric rule_s_subrule_no_elems[][];\n";
x= sprintf(Fsm->big_buf_,mp_prefix_date_value,Fsm->gened_date_time_.c_str());
Fsm->omp_file_.write(Fsm->big_buf_,x);


/*:46*/
//line 1896 "./o2externs.w"

/*47:*/
//line 1868 "./o2externs.w"

KCHARP w_prefix_file= "% file: ";
Fsm->ow_file_<<w_prefix_file;
KCHARP w_prefix_filename_value= "%s - cweb grammar\n";
x= sprintf(Fsm->big_buf_,w_prefix_filename_value,Fsm->w_filename_.c_str());
Fsm->ow_file_.write(Fsm->big_buf_,x);

KCHARP w_prefix_date= "%Date: ";
Fsm->ow_file_<<w_prefix_date;
KCHARP w_prefix_date_value= "%s\n";
x= sprintf(Fsm->big_buf_,w_prefix_date_value,Fsm->gened_date_time_.c_str());
Fsm->ow_file_.write(Fsm->big_buf_,x);


KCHARP macros= 
"\\input%s \"supp-pdf\"\n"
"\\input \"/usr/local/yacco2/diagrams+etc/o2mac.tex\"\n";
x= sprintf(Fsm->big_buf_,macros," ");
Fsm->ow_file_.write(Fsm->big_buf_,x);

/*:47*/
//line 1897 "./o2externs.w"

}


/*:48*//*49:*/
//line 1910 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_gen_dimension_name
(Cmpost_output*Fsm,std::string&Mp_obj_name,int Dimension){
int R,Q;
R= Dimension%27;
Q= Dimension/27;
++Q;
Mp_obj_name+= Fsm->mp_dimension_[Q];
Mp_obj_name+= Fsm->mp_dimension_[R];
}

/*:49*//*50:*/
//line 1926 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_calc_mp_obj_name
(Cmpost_output*Fsm,std::string&Mp_obj_name,int Elem_no){
Fsm->MPOST_CWEB_gen_dimension_name(Fsm,Mp_obj_name,Fsm->rule_no_);
Fsm->MPOST_CWEB_gen_dimension_name(Fsm,Mp_obj_name,Fsm->subrule_no_);
Fsm->MPOST_CWEB_gen_dimension_name(Fsm,Mp_obj_name,Elem_no);
}

/*:50*//*51:*/
//line 1943 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_wrt_mp_rhs_elem
(Cmpost_output*Fsm,std::string&Elem_name,std::string&Drw_how){
std::string mp_xlate_name;
prescan_mpname_for_cweb(Elem_name,mp_xlate_name);
std::string mp_obj_name;
KCHARP mp_subrule_elems_literal= "rhs_elems[%i][%i][%i].literal := \"%s\";";
int x= sprintf(Fsm->big_buf_,mp_subrule_elems_literal
,Fsm->rule_no_,Fsm->subrule_no_,Fsm->elem_no_
,mp_xlate_name.c_str());
Fsm->omp_file_.write(Fsm->big_buf_,x);
Fsm->omp_file_<<endl;
KCHARP mp_subrule_elems_RorT= "rhs_elems[%i][%i][%i].Drw_how := %s;";
x= sprintf(Fsm->big_buf_,mp_subrule_elems_RorT,Fsm->rule_no_,Fsm->subrule_no_,Fsm->elem_no_
,Drw_how.c_str());
Fsm->omp_file_.write(Fsm->big_buf_,x);
Fsm->omp_file_<<endl;
KCHARP mp_subrule_elems_vname= "rhs_elems[%i][%i][%i].vname := \"%s\";";
Fsm->MPOST_CWEB_calc_mp_obj_name(Fsm,mp_obj_name,Fsm->elem_no_);
x= sprintf(Fsm->big_buf_,mp_subrule_elems_vname,Fsm->rule_no_,Fsm->subrule_no_,Fsm->elem_no_
,mp_obj_name.c_str());
Fsm->omp_file_.write(Fsm->big_buf_,x);
Fsm->omp_file_<<endl;
}

/*:51*//*55:*/
//line 2065 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_gen_sr_elem_xrefs
(Cmpost_output*Fsm,AST*Subrule_tree){
/*53:*/
//line 1984 "./o2externs.w"

using namespace yacco2;
using namespace NS_yacco2_T_enum;
using namespace NS_yacco2_terminals;
KCHARP xref= "@.%s@>\n";
INT_SET_type filter;
filter.insert(T_Enum::T_refered_T_);
filter.insert(T_Enum::T_refered_rule_);
filter.insert(T_Enum::T_T_eosubrule_);
filter.insert(T_Enum::T_T_called_thread_eosubrule_);
filter.insert(T_Enum::T_T_null_call_thread_eosubrule_);
filter.insert(T_Enum::T_LR1_parallel_operator_);
filter.insert(T_Enum::T_LR1_fset_transience_operator_);

tok_can_ast_functor just_walk_functr;
ast_prefix_1forest element_walk(*Subrule_tree,&just_walk_functr,&filter,ACCEPT_FILTER);
tok_can<AST*> elements_can(element_walk);


/*:53*/
//line 2071 "./o2externs.w"

int elem_cnt(0);
string th_name;
/*54:*/
//line 2004 "./o2externs.w"

for(int x(0);elements_can[x]!=yacco2::PTR_LR1_eog__;++x){
++elem_cnt;
CAbs_lr1_sym*sym= elements_can[x];
switch(sym->enumerated_id__){
case T_Enum::T_LR1_parallel_operator_:{
int x= sprintf(Fsm->big_buf_,xref,"\\paralleloperator");
Fsm->ow_file_.write(Fsm->big_buf_,x);
break;
}
case T_Enum::T_LR1_fset_transience_operator_:{
int x= sprintf(Fsm->big_buf_,xref,"\\transienceoperator");
Fsm->ow_file_.write(Fsm->big_buf_,x);
break;
}
case T_Enum::T_refered_T_:{
refered_T* rt = (refered_T*)sym;
Fsm->MPOST_CWEB_xref_refered_T(Fsm,rt);
break;
}
case T_Enum::T_refered_rule_:{
refered_rule* rr = (refered_rule*)sym;
Fsm->MPOST_CWEB_xref_refered_rule(Fsm,rr);
break;
}
case T_Enum::T_T_eosubrule_:{
if(elem_cnt==1){
int x= sprintf(Fsm->big_buf_,xref,"\\emptyrule");
Fsm->ow_file_.write(Fsm->big_buf_,x);
}
break;
}
case T_Enum::T_T_called_thread_eosubrule_:{
T_called_thread_eosubrule* id = (T_called_thread_eosubrule*)sym;
if(id->ns()!=0){
th_name+= id->ns()->identifier()->c_str();
th_name+= "::";
}
th_name+= id->called_thread_name()->identifier()->c_str();
string name_with_bkslash;
int len= th_name.length();
for(int x= 0;x<len;++x){
char c= th_name[x];
if(c=='_'){
name_with_bkslash+= '\\';
}
name_with_bkslash+= c;
}
int x= sprintf(Fsm->big_buf_,xref,name_with_bkslash.c_str());
Fsm->ow_file_.write(Fsm->big_buf_,x);
break;
}
case T_Enum::T_T_null_call_thread_eosubrule_:{
int x= sprintf(Fsm->big_buf_,xref,"NULL");
Fsm->ow_file_.write(Fsm->big_buf_,x);
break;
}
}
}

/*:54*/
//line 2074 "./o2externs.w"

}

/*:55*//*56:*/
//line 2078 "./o2externs.w"

extern int
MPOST_CWEB_xlated_symbol(AST*Sym_t,char*Xlated_sym){
CAbs_lr1_sym*Sym= AST::content(*Sym_t);
int Enum= Sym->enumerated_id();
Xlated_sym[0]= (char)0;
const char*xsym= "%s";
switch(Enum){
case T_Enum::T_LR1_parallel_operator_:{
sprintf(Xlated_sym,xsym,"\\paralleloperator");
return 1;
}
case T_Enum::T_LR1_fset_transience_operator_:{
sprintf(Xlated_sym,xsym,"\\transienceoperator");
return 1;
}
case T_Enum::T_refered_T_:{
refered_T* rt = (refered_T*)Sym;
XLATE_SYMBOLS_FOR_cweave(rt->its_t_def()->t_name()->c_str(),Xlated_sym);
return rt->element_pos();
}
case T_Enum::T_refered_rule_:{
refered_rule* rr = (refered_rule*)Sym;
XLATE_SYMBOLS_FOR_cweave(rr->its_rule_def()->rule_name()->c_str(),Xlated_sym);
return rr->element_pos();
}
case T_Enum::T_T_eosubrule_:{
T_eosubrule* eos = (T_eosubrule*)Sym;
AST*prev_t= Sym_t->pr_;
if(eos->element_pos()==1){
sprintf(Xlated_sym,xsym,"\\emptyrule");
return eos->element_pos();
}else{
sprintf(Xlated_sym,xsym,"");
}
CAbs_lr1_sym*sym= AST::content(*prev_t);
switch(sym->enumerated_id()){
case T_Enum::T_T_called_thread_eosubrule_:{
return eos->element_pos()-1;
}
case T_Enum::T_T_null_call_thread_eosubrule_:{
return eos->element_pos()-1;
}
default:{
return eos->element_pos();
}
}
}
case T_Enum::T_T_called_thread_eosubrule_:{
T_called_thread_eosubrule* id = (T_called_thread_eosubrule*)Sym;
string th_name;
if(id->ns()!=0){
th_name+= id->ns()->identifier()->c_str();
th_name+= "::";
}
th_name+= id->called_thread_name()->identifier()->c_str();
XLATE_SYMBOLS_FOR_cweave(th_name.c_str(),Xlated_sym);
return id->element_pos();
}
case T_Enum::T_T_null_call_thread_eosubrule_:{
T_null_call_thread_eosubrule* id = (T_null_call_thread_eosubrule*)Sym;
sprintf(Xlated_sym,xsym,"NULL");
return id->element_pos();
}
}
return 0;
}
/*:56*//*57:*/
//line 2155 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_crt_rhs_sym_str
(state_element*se,std::string*Xlated_str){
char a[BUFFER_SIZE];
char cur_sym[Max_cweb_item_size];
char nxtsym_1[Max_cweb_item_size];
char nxtsym_2[Max_cweb_item_size];
KCHARP thread_expr_string_template= 
"{%s} {%s} {%s}";
KCHARP underline_symbol= "{$\\underline{%s}$} \n";
KCHARP underline_symbol_wepsilon= "{$\\underline{%s^{\\emptyrule}}$} \n";
KCHARP not_underline_symbol= "{%s} \n";
state_element*nxt1_se= 0;
state_element*nxt2_se= 0;
state_element*nxt3_se= 0;
int pp= MPOST_CWEB_xlated_symbol(se->sr_element_,cur_sym);

if(
(se->its_enum_id_==T_Enum::T_LR1_parallel_operator_)
||
(se->its_enum_id_==T_Enum::T_LR1_fset_transience_operator_)
){
nxt1_se= se->next_state_element_;
AST*nxt2_se= se->sr_element_->rt_->rt_;
pp= MPOST_CWEB_xlated_symbol(nxt1_se->sr_element_,nxtsym_1);
pp= MPOST_CWEB_xlated_symbol(nxt2_se,nxtsym_2);
sprintf(a,thread_expr_string_template,cur_sym,nxtsym_1,nxtsym_2);
(*Xlated_str)+= a;
return;
}
sprintf(a,not_underline_symbol,cur_sym);
(*Xlated_str)+= a;
if(se->sr_def_element_->enumerated_id__!=T_Enum::T_rule_def_){
return;
}

nxt1_se= se->next_state_element_;
if(nxt1_se==0)return;
if(nxt1_se->its_enum_id_==T_Enum::T_T_eosubrule_)return;
pp= MPOST_CWEB_xlated_symbol(nxt1_se->sr_element_,nxtsym_1);
if(nxt1_se->sr_def_element_->enumerated_id__!=T_Enum::T_rule_def_){
sprintf(a,underline_symbol,nxtsym_1);
}else{
rule_def*rd= (rule_def*)nxt1_se->sr_def_element_;
if(rd->epsilon()==YES){
sprintf(a,underline_symbol_wepsilon,nxtsym_1);
nxt2_se= nxt1_se->next_state_element_;
}else{
sprintf(a,underline_symbol,nxtsym_1);
nxt2_se= 0;
}
}
(*Xlated_str)+= a;

if(nxt2_se!=0){
if(nxt2_se->its_enum_id_==T_Enum::T_T_eosubrule_)return;
pp= MPOST_CWEB_xlated_symbol(nxt2_se->sr_element_,nxtsym_2);
if(nxt2_se->sr_def_element_->enumerated_id__!=T_Enum::T_rule_def_){
sprintf(a,underline_symbol,nxtsym_2);
}else{
rule_def*rd= (rule_def*)nxt2_se->sr_def_element_;
if(rd->epsilon()==YES){
sprintf(a,underline_symbol_wepsilon,nxtsym_2);
nxt3_se= nxt1_se->next_state_element_;
if(nxt3_se->its_enum_id_==T_Enum::T_T_eosubrule_){
nxt3_se= 0;
}
}else{
sprintf(a,underline_symbol,nxtsym_2);
nxt3_se= 0;
}
}
(*Xlated_str)+= a;
}
if(nxt3_se!=0){
sprintf(a,not_underline_symbol,"...");
(*Xlated_str)+= a;
}
}

/*:57*//*58:*/
//line 2241 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_woutput_sr_sdcode
(Cmpost_output*Fsm,T_subrule_def*Subrule_def){
SDC_MAP_type*sr_dirs= Subrule_def->subrule_directives();
SDC_MAP_ITER_type i= sr_dirs->begin();
SDC_MAP_ITER_type ie= sr_dirs->end();
TOKEN_GAGGLE dirs_tokens;
for(;i!=ie;++i){
CAbs_lr1_sym*sym= i->second;
dirs_tokens.push_back(*sym);
}

using namespace NS_cweave_sdc;
Ccweave_sdc sdc_fsm;
sdc_fsm.initialize(&Fsm->ow_file_,Fsm->subrule_def_,Fsm->subrule_no_);
Parser sdc_emit(sdc_fsm,&dirs_tokens,0);
sdc_emit.parse();
}

/*:58*//*62:*/
//line 2296 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_wrt_fsm
(Cmpost_output*Fsm,T_fsm_phrase*Fsm_phrase){
KCHARP banner= 
"\\GRAMMARtitle{%s}\n{%s}{%s}%\n"
"{%s}{%s}%\n"
"{%s}\n";

KCHARP banner_of_thread= 
"\\THREADtitle{%s}%\n"
"{%s}{%s}%\n"
"{%s}{%s}{%s}{%i}%\n"
"{%s}\n";
char fname[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave(Fsm->grammar_filename_prefix_.c_str(),fname);
char ns_name[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave(Fsm_phrase->namespace_id()->identifier()->c_str(),ns_name);
char fsm_name[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave(Fsm_phrase->fsm_id()->c_string()->c_str(),fsm_name);
char k_cweb[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave(Fsm_phrase->comment()->c_string()->c_str(),k_cweb);

if(O2_PP_PHASE!=0){
T_parallel_parser_phrase*la_ph= O2_PP_PHASE;
T_parallel_la_boundary*la= la_ph->la_bndry();

char expr_prescan_cweb[Max_cweb_item_size];
int x= sprintf(Fsm->big_buf_
,banner_of_thread
,fname
,fsm_name
,ns_name
,Fsm_phrase->version()->c_string()->c_str()
,Fsm_phrase->debug()->c_string()->c_str()
,k_cweb
,la->la_first_set()->size()

,la->cweb_la_srce_expr()->c_str()
);
Fsm->ow_file_.write(Fsm->big_buf_,x);
Fsm->ow_file_<<endl;
}else{
int x= sprintf(Fsm->big_buf_
,banner
,fname
,fsm_name
,ns_name
,Fsm_phrase->version()->c_string()->c_str()
,Fsm_phrase->debug()->c_string()->c_str()
,k_cweb
);
Fsm->ow_file_.write(Fsm->big_buf_,x);
Fsm->ow_file_<<endl;
}

if(Fsm_phrase->cweb_marker()!=0){
WRT_CWEB_MARKER(&Fsm->ow_file_,Fsm_phrase->cweb_marker());
}

/*60:*/
//line 2267 "./o2externs.w"

char xa[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave
(Fsm_phrase->fsm_class_phrase()->identifier()->identifier()->c_str()
,xa);

KCHARP fsm_class= 
"@*2 Fsm %s class.\n";
int x= sprintf(Fsm->big_buf_
,fsm_class
,xa
);
Fsm->ow_file_.write(Fsm->big_buf_,x);
Fsm->ow_file_<<endl;

/*:60*/
//line 2358 "./o2externs.w"

/*61:*/
//line 2283 "./o2externs.w"

T_fsm_class_phrase*fcp= Fsm_phrase->fsm_class_phrase();
SDC_MAP_type*sr_dirs= fcp->directives_map();
SDC_MAP_ITER_type i= sr_dirs->begin();
SDC_MAP_ITER_type ie= sr_dirs->end();
TOKEN_GAGGLE dirs_tokens;
for(;i!=ie;++i){
CAbs_lr1_sym*sym= i->second;
dirs_tokens.push_back(*sym);
}


/*:61*/
//line 2359 "./o2externs.w"


using namespace NS_cweave_fsm_sdc;
Ccweave_fsm_sdc sdc_fsm;
sdc_fsm.initialize(&Fsm->ow_file_,Fsm_phrase);
Parser sdc_emit(sdc_fsm,&dirs_tokens,0);
sdc_emit.parse();
}


/*:62*//*70:*/
//line 2488 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_wrt_T
(Cmpost_output*Fsm,T_terminals_phrase*T_phrase){
/*64:*/
//line 2373 "./o2externs.w"

output_cweb_macros_and_banner(
Fsm,Fsm->ow_t_file_,"Terminal Vocabulary",Fsm->gened_date_time_.c_str()
,T_phrase->filename_id()->identifier()
,T_phrase->namespace_id()->identifier()
,T_phrase->alphabet()->size());

/*:64*/
//line 2494 "./o2externs.w"

if(T_phrase->cweb_marker()!=0){
WRT_CWEB_MARKER(&Fsm->ow_t_file_,T_phrase->cweb_marker());
}

/*67:*/
//line 2429 "./o2externs.w"

if(T_phrase->terminals_refs_code()!=0){
KCHARP tref= 
"@*2 {\\bf Terminals-refs} directive.\\fbreak\n";
Fsm->ow_t_file_<<tref;

T_syntax_code*stc= T_phrase->terminals_refs_code();
if(stc->cweb_marker()!=0){
WRT_CWEB_MARKER(&Fsm->ow_t_file_,stc->cweb_marker());
}
KCHARP tref_code= 
"@<terminals-refs directive@>=\n"
"%s"
"\n";

int x= sprintf(Fsm->big_buf_
,tref_code
,T_phrase->terminals_refs_code()->syntax_code()->c_str()
);
Fsm->ow_t_file_.write(Fsm->big_buf_,x);
Fsm->ow_t_file_<<endl;
}

/*:67*/
//line 2499 "./o2externs.w"

T_DEF_MAP_ITER_type a= T_phrase->alphabet()->begin();
T_DEF_MAP_ITER_type ae= T_phrase->alphabet()->end();
char term_name[Max_cweb_item_size];
for(;a!=ae;++a){
T_terminal_def*tdef= a->second;
/*66:*/
//line 2391 "./o2externs.w"

char ab[]= "Y";
if(tdef->autoabort()==true)ab[0]= 'Y';
else ab[0]= 'N';
char ad[]= "Y";
if(tdef->autodelete()==true)ad[0]= 'Y';
else ad[0]= 'N';

char name[Max_cweb_item_size];

XLATE_SYMBOLS_FOR_cweave(tdef->t_name()->c_str(),name);
char class_name[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave(tdef->classsym()->c_str(),class_name);

const char*enum_name_for_format= 
"T\\_%s\\_";
char a[SMALL_BUFFER_4K];
sprintf(a,enum_name_for_format,class_name);

KCHARP t_entry= "@*2 {\\bf %s}.\\fbreak\n"
"Enum: %s\n\\fbreak\n"
"\\line{Class: %s \\hfil AB: %s \\hfil AD: %s}\n";
int x= sprintf(Fsm->big_buf_
,t_entry
,name
,a
,class_name
,ab
,ad
);
Fsm->ow_t_file_.write(Fsm->big_buf_,x);
Fsm->ow_t_file_<<endl;
if(tdef->cweb_marker()!=0){
WRT_CWEB_MARKER(&Fsm->ow_t_file_,tdef->cweb_marker());
}
/*65:*/
//line 2381 "./o2externs.w"

KCHARP rule_it= 
"\\fbreak%s\n"
"\\hrule\n";
x= sprintf(Fsm->big_buf_,rule_it," ");
Fsm->ow_t_file_.write(Fsm->big_buf_,x);

/*:65*/
//line 2426 "./o2externs.w"


/*:66*/
//line 2505 "./o2externs.w"

/*69:*/
//line 2477 "./o2externs.w"

SDC_MAP_type*sr_dirs= tdef->directives_map();
SDC_MAP_ITER_type i= sr_dirs->begin();
SDC_MAP_ITER_type ie= sr_dirs->end();
TOKEN_GAGGLE dirs_tokens;
for(;i!=ie;++i){
CAbs_lr1_sym*sym= i->second;
dirs_tokens.push_back(*sym);
}

/*:69*/
//line 2506 "./o2externs.w"

using namespace NS_cweave_T_sdc;
Ccweave_T_sdc sdc_fsm;
XLATE_SYMBOLS_FOR_cweave(tdef->t_name()->c_str(),term_name);
sdc_fsm.initialize(&Fsm->ow_t_file_,term_name);
Parser sdc_emit(sdc_fsm,&dirs_tokens,0);
sdc_emit.parse();
}
/*68:*/
//line 2453 "./o2externs.w"

if(T_phrase->terminals_sufx_code()!=0){
KCHARP tsuf= 
"@*1 {\\bf Terminals-sufx} directive.\\fbreak\n";
Fsm->ow_t_file_<<tsuf;

T_syntax_code*stc= T_phrase->terminals_sufx_code();
if(stc->cweb_marker()!=0){
WRT_CWEB_MARKER(&Fsm->ow_t_file_,stc->cweb_marker());
}
KCHARP tsuf_code= 
"@<terminals-sufx directive@>=\n"
"%s"
"\n";

int x= sprintf(Fsm->big_buf_
,tsuf_code
,T_phrase->terminals_sufx_code()->syntax_code()->c_str()
);
Fsm->ow_t_file_.write(Fsm->big_buf_,x);
Fsm->ow_t_file_<<endl;
}

/*:68*/
//line 2514 "./o2externs.w"

Fsm->ow_t_file_<<"@** Index.\n";
}

/*:70*//*75:*/
//line 2582 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_wrt_Err
(Cmpost_output*Fsm,T_error_symbols_phrase*Err_phrase){
/*72:*/
//line 2522 "./o2externs.w"

output_cweb_macros_and_banner(
Fsm,Fsm->ow_err_file_,"Error Vocabulary",Fsm->gened_date_time_.c_str()
,Err_phrase->filename_id()->identifier()
,Err_phrase->namespace_id()->identifier()
,Err_phrase->alphabet()->size());

/*:72*/
//line 2588 "./o2externs.w"

if(Err_phrase->cweb_marker()!=0){
WRT_CWEB_MARKER(&Fsm->ow_err_file_,Err_phrase->cweb_marker());
}

T_DEF_MAP_ITER_type a= Err_phrase->alphabet()->begin();
T_DEF_MAP_ITER_type ae= Err_phrase->alphabet()->end();
char term_name[Max_cweb_item_size];
for(;a!=ae;++a){
T_terminal_def*tdef= a->second;
/*74:*/
//line 2546 "./o2externs.w"

char ab[]= "Y";
if(tdef->autoabort()==true)ab[0]= 'Y';
else ab[0]= 'N';
char ad[]= "Y";
if(tdef->autodelete()==true)ad[0]= 'Y';
else ad[0]= 'N';
char name[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave(tdef->t_name()->c_str(),name);
char class_name[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave(tdef->classsym()->c_str(),class_name);
const char*enum_name_for_format= 
"T\\_%s\\_";
char enum_name[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave(tdef->classsym()->c_str(),enum_name);
char a[SMALL_BUFFER_4K];
sprintf(a,enum_name_for_format,enum_name);
KCHARP t_entry= "@*2 {\\bf %s}.\\fbreak\n"
"Enum: %s\n\\fbreak\n"
"\\line{Class: %s \\hfil AB: %s \\hfil AD: %s}\n";
int x= sprintf(Fsm->big_buf_
,t_entry
,name
,a
,class_name
,ab
,ad
);
Fsm->ow_err_file_.write(Fsm->big_buf_,x);
Fsm->ow_err_file_<<endl;
if(tdef->cweb_marker()!=0){
WRT_CWEB_MARKER(&Fsm->ow_err_file_,tdef->cweb_marker());
}
/*73:*/
//line 2530 "./o2externs.w"

KCHARP rule_it= 
"\\fbreak%s\n"
"\\hrule\n";
x= sprintf(Fsm->big_buf_,rule_it," ");
Fsm->ow_err_file_.write(Fsm->big_buf_,x);

/*:73*/
//line 2579 "./o2externs.w"


/*:74*/
//line 2598 "./o2externs.w"

/*69:*/
//line 2477 "./o2externs.w"

SDC_MAP_type*sr_dirs= tdef->directives_map();
SDC_MAP_ITER_type i= sr_dirs->begin();
SDC_MAP_ITER_type ie= sr_dirs->end();
TOKEN_GAGGLE dirs_tokens;
for(;i!=ie;++i){
CAbs_lr1_sym*sym= i->second;
dirs_tokens.push_back(*sym);
}

/*:69*/
//line 2599 "./o2externs.w"

using namespace NS_cweave_T_sdc;
Ccweave_T_sdc sdc_fsm;
XLATE_SYMBOLS_FOR_cweave(tdef->t_name()->c_str(),term_name);
sdc_fsm.initialize(&Fsm->ow_err_file_,term_name);
Parser sdc_emit(sdc_fsm,&dirs_tokens,0);
sdc_emit.parse();
}
Fsm->ow_err_file_<<"@** Index.\n";
}


/*:75*//*81:*/
//line 2727 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_wrt_Lrk
(Cmpost_output*Fsm,T_lr1_k_phrase*Lrk_phrase){
/*77:*/
//line 2615 "./o2externs.w"

output_cweb_macros_and_banner(
Fsm,Fsm->ow_lrk_file_,"Lr K Vocabulary",Fsm->gened_date_time_.c_str()
,Lrk_phrase->filename_id()->identifier()
,Lrk_phrase->namespace_id()->identifier()
,Lrk_phrase->alphabet()->size()
);

/*:77*/
//line 2733 "./o2externs.w"

if(Lrk_phrase->cweb_marker()!=0){
WRT_CWEB_MARKER(&Fsm->ow_lrk_file_,Lrk_phrase->cweb_marker());
}
char term_name[Max_cweb_item_size];
char name[Max_cweb_item_size];

T_DEF_MAP_ITER_type a= Lrk_phrase->alphabet()->begin();
T_DEF_MAP_ITER_type ae= Lrk_phrase->alphabet()->end();
for(;a!=ae;++a){
T_terminal_def*tdef= a->second;
/*79:*/
//line 2638 "./o2externs.w"

char ab[]= "Y";
if(tdef->autoabort()==true)ab[0]= 'Y';
else ab[0]= 'N';
char ad[]= "Y";

if(tdef->autodelete()==true)ad[0]= 'Y';
else ad[0]= 'N';
switch(tdef->enumerated_id__){
case T_Enum::T_LR1_parallel_operator_:{
strcpy(name,"\\paralleloperator");
strcpy(term_name,"|parallel_operator|");
break;
}
case T_Enum::T_LR1_all_shift_operator_:{
strcpy(name,"\\allshift");
strcpy(term_name,"|all_shift|");
break;
}
case T_Enum::T_LR1_invisible_shift_operator_:{
strcpy(name,"\\invisibleshift");
strcpy(term_name,"|invisible_shift|");
break;
}
case T_Enum::T_LR1_fset_transience_operator_:{
strcpy(name,"\\transienceoperator");
strcpy(term_name,"|transience_operator|");
break;
}
case T_Enum::T_LR1_questionable_shift_operator_:{
strcpy(name,"\\questionableoperator");
strcpy(term_name,"|questionable_operator|");
break;
}
default:{
XLATE_SYMBOLS_FOR_cweave(tdef->t_name()->c_str(),name);
XLATE_SYMBOLS_FOR_cweave(tdef->t_name()->c_str(),term_name);
break;
}
}
const char*enum_class_name_format= "T\\_%s\\_";
char class_name[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave(tdef->classsym()->c_str(),class_name);
char a[SMALL_BUFFER_4K];
sprintf(a,enum_class_name_format,class_name);

KCHARP t_entry= "@*2 {\\bf %s}.\\fbreak\n"
"Enum: %s\n\\fbreak\n"
"\\line{Class: %s \\hfil AB: %s \\hfil AD: %s}\n";
int x= sprintf(Fsm->big_buf_
,t_entry
,name
,a
,class_name
,ab
,ad
);
Fsm->ow_lrk_file_.write(Fsm->big_buf_,x);
Fsm->ow_lrk_file_<<endl;
if(tdef->cweb_marker()!=0){
WRT_CWEB_MARKER(&Fsm->ow_lrk_file_,tdef->cweb_marker());
}
/*78:*/
//line 2624 "./o2externs.w"

KCHARP rule_it= 
"\\fbreak%s\n"
"\\hrule\n";
x= sprintf(Fsm->big_buf_,rule_it," ");
Fsm->ow_lrk_file_.write(Fsm->big_buf_,x);

/*:78*/
//line 2700 "./o2externs.w"


/*:79*/
//line 2744 "./o2externs.w"

/*69:*/
//line 2477 "./o2externs.w"

SDC_MAP_type*sr_dirs= tdef->directives_map();
SDC_MAP_ITER_type i= sr_dirs->begin();
SDC_MAP_ITER_type ie= sr_dirs->end();
TOKEN_GAGGLE dirs_tokens;
for(;i!=ie;++i){
CAbs_lr1_sym*sym= i->second;
dirs_tokens.push_back(*sym);
}

/*:69*/
//line 2745 "./o2externs.w"

using namespace NS_cweave_T_sdc;
Ccweave_T_sdc sdc_fsm;
sdc_fsm.initialize(&Fsm->ow_lrk_file_,term_name);
Parser sdc_emit(sdc_fsm,&dirs_tokens,0);
sdc_emit.parse();
}
/*80:*/
//line 2703 "./o2externs.w"

if(Lrk_phrase->lrk_sufx_code()!=0){
KCHARP tsuf= 
"@*1 {\\bf lrk-sufx} directive.\\fbreak\n";
Fsm->ow_lrk_file_<<tsuf;

T_syntax_code*stc= Lrk_phrase->lrk_sufx_code();
if(stc->cweb_marker()!=0){
WRT_CWEB_MARKER(&Fsm->ow_lrk_file_,stc->cweb_marker());
}
KCHARP tsuf_code= 
"@<lrk-sufx directive@>=\n"
"%s"
"\n";
int x= sprintf(Fsm->big_buf_
,tsuf_code
,Lrk_phrase->lrk_sufx_code()->syntax_code()->c_str()
);
Fsm->ow_lrk_file_.write(Fsm->big_buf_,x);
Fsm->ow_lrk_file_<<endl;
}


/*:80*/
//line 2752 "./o2externs.w"

Fsm->ow_lrk_file_<<"@** Index.\n";
}

/*:81*//*82:*/
//line 2759 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_wrt_rule_s_lhs_sdc
(Cmpost_output*Fsm,rule_def*Rule_def){
T_rule_lhs_phrase*rlp= Rule_def->rule_lhs();
if(rlp==0)return;
SDC_MAP_type*sr_dirs= rlp->lhs_directives_map();
SDC_MAP_ITER_type i= sr_dirs->begin();
SDC_MAP_ITER_type ie= sr_dirs->end();
TOKEN_GAGGLE dirs_tokens;
for(;i!=ie;++i){
CAbs_lr1_sym*sym= i->second;
dirs_tokens.push_back(*sym);
}
T_parallel_monitor_phrase*ppm= Rule_def->parallel_mntr();
if(ppm!=0){
sr_dirs= ppm->mntr_directives_map();
i= sr_dirs->begin();
ie= sr_dirs->end();
for(;i!=ie;++i){
CAbs_lr1_sym*sym= i->second;
dirs_tokens.push_back(*sym);
}
}
using namespace NS_cweave_lhs_sdc;
Ccweave_lhs_sdc lhs_sdc_fsm;
lhs_sdc_fsm.initialize(&Fsm->ow_file_,Rule_def->rule_name()->c_str());
Parser lhs_sdc_emit(lhs_sdc_fsm,&dirs_tokens,0);
lhs_sdc_emit.parse();
}

/*:82*//*83:*/
//line 2796 "./o2externs.w"

bool
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_should_subrule_be_printed
(Cmpost_output*Fsm,T_subrule_def*Subrule_def){
if(Subrule_def->cweb_marker()!=0)return true;
SDC_MAP_type*sr_dirs= Subrule_def->subrule_directives();
if(sr_dirs->empty()==true)return false;
return true;
}
/*:83*//*85:*/
//line 2857 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_xref_refered_T
(Cmpost_output*Fsm,refered_T*R_T){
T_in_stbl*t= R_T->t_in_stbl();
T_terminal_def*td= t->t_def();

KCHARP xref= "@.%s@>\n";

char name[Max_cweb_item_size];
XLATE_SYMBOLS_FOR_cweave(td->t_name()->c_str(),name);
/*84:*/
//line 2809 "./o2externs.w"

switch(td->classification()){
case T_terminal_def::err:{
int x= sprintf(Fsm->big_buf_,xref,name);
Fsm->ow_file_.write(Fsm->big_buf_,x);
break;
}
case T_terminal_def::rc:{
break;
INT_STR_MAP_ITER_type i= Fsm->xlated_names_.find(td->enumerated_id__);
if(i!=Fsm->xlated_names_.end()){
int x= sprintf(Fsm->big_buf_,xref,i->second.c_str());
Fsm->ow_file_.write(Fsm->big_buf_,x);
}else{
int x= sprintf(Fsm->big_buf_,xref,name);
Fsm->ow_file_.write(Fsm->big_buf_,x);
}
break;
}
case T_terminal_def::lrk:{
INT_STR_MAP_ITER_type i= Fsm->xlated_names_.find(td->enumerated_id__);
if(i!=Fsm->xlated_names_.end()){
int x= sprintf(Fsm->big_buf_,xref,i->second.c_str());
Fsm->ow_file_.write(Fsm->big_buf_,x);
}else{
int x= sprintf(Fsm->big_buf_,xref,name);
Fsm->ow_file_.write(Fsm->big_buf_,x);
}
break;
}
case T_terminal_def::t:{
INT_STR_MAP_ITER_type i= Fsm->xlated_names_.find(td->enumerated_id__);
if(i!=Fsm->xlated_names_.end()){
int x= sprintf(Fsm->big_buf_,xref,i->second.c_str());
Fsm->ow_file_.write(Fsm->big_buf_,x);
}else{
int x= sprintf(Fsm->big_buf_,xref,name);
Fsm->ow_file_.write(Fsm->big_buf_,x);
}
break;
}
}

/*:84*/
//line 2870 "./o2externs.w"

}

/*:85*//*86:*/
//line 2876 "./o2externs.w"

void
NS_mpost_output::
Cmpost_output::
MPOST_CWEB_xref_refered_rule
(Cmpost_output*Fsm,refered_rule*R_rule){
rule_in_stbl*r= R_rule->Rule_in_stbl();
rule_def*rd= r->r_def();
KCHARP xref= "@.%s@>\n";
string name_with_bkslash;
int len= rd->rule_name()->length();
for(int x= 0;x<len;++x){
char c= (*rd->rule_name())[x];
if(c=='_'){
name_with_bkslash+= '\\';
}
name_with_bkslash+= c;
}
int x= sprintf(Fsm->big_buf_,xref,name_with_bkslash.c_str());
Fsm->ow_file_.write(Fsm->big_buf_,x);
}

/*:86*//*93:*/
//line 3049 "./o2externs.w"

AST*elem_space[Max_no_subrules];
void GEN_CALLED_THREADS_FS_OF_RULE(rule_def*Start_rule){
using namespace NS_yacco2_T_enum;
using namespace std;
std::set<rule_def*> rules_in_elem_space;
std::set<rule_def*> ::iterator i;
INT_SET_type sr_filter;
sr_filter.insert(T_Enum::T_T_subrule_def_);
tok_can_ast_functor just_walk_functr;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
int cc(0);
int nc(-1);
AST*cur_elem_t(0);
CAbs_lr1_sym*cur_elem(0);
/*89:*/
//line 2973 "./o2externs.w"

{
AST*rtree= Start_rule->rule_s_tree();
ast_prefix_1forest subrule_walk(*rtree,&just_walk_functr,&sr_filter,ACCEPT_FILTER);
tok_can<AST*> subrules_can(subrule_walk);
yacco2::UINT xxx(0);
for(;subrules_can.operator[](xxx)!=yacco2::PTR_LR1_eog__;++xxx);
/*88:*/
//line 2960 "./o2externs.w"

vector<AST*> ::iterator ti= subrules_can.nodes_visited()->begin();
vector<AST*> ::iterator tie= subrules_can.nodes_visited()->end();
for(;ti!=tie;++ti){
AST*srdef_t= *ti;
T_subrule_def* sr_def = (T_subrule_def*)AST::content(*srdef_t);
AST*sr_t= sr_def->subrule_s_tree();
AST*et= AST::get_spec_child(*sr_t,1);
++nc;
elem_space[nc]= et;
}

/*:88*/
//line 2980 "./o2externs.w"

}

/*:89*/
//line 3064 "./o2externs.w"

while(cc<=nc){
cur_elem_t= elem_space[cc];
cur_elem= AST::content(*cur_elem_t);
/*91:*/
//line 3001 "./o2externs.w"

switch(cur_elem->enumerated_id__){
case T_Enum::T_T_eosubrule_:{
++cc;
continue;
}
case T_Enum::T_refered_T_:{
refered_T* rt = (refered_T*)cur_elem;
T_terminal_def*td= rt->its_t_def();
if(td->enum_id()!=LR1_PARALLEL_OPERATOR){
++cc;
continue;
}
/*92:*/
//line 3037 "./o2externs.w"

AST*first_el_t= cur_elem_t;
AST*third_el_t= AST::get_younger_sibling(*first_el_t,2);
CAbs_lr1_sym*sym= AST::content(*third_el_t);
if(sym->enumerated_id__==T_Enum::T_T_called_thread_eosubrule_){
T_called_thread_eosubrule*ct= (T_called_thread_eosubrule*)sym;
Start_rule->add_to_called_thread_first_set(ct);
}

/*:92*/
//line 3014 "./o2externs.w"

++cc;
continue;
}
case T_Enum::T_refered_rule_:{
refered_rule* rr = (refered_rule*)cur_elem;
rule_def*rdef= rr->its_rule_def();
/*90:*/
//line 2984 "./o2externs.w"

{
i= rules_in_elem_space.find(rdef);
if(i==rules_in_elem_space.end()){
rules_in_elem_space.insert(rdef);
AST*rtree= rdef->rule_s_tree();
ast_prefix_1forest subrule_walk(*rtree,&just_walk_functr,&sr_filter,ACCEPT_FILTER);
tok_can<AST*> subrules_can(subrule_walk);
yacco2::UINT xxx(0);
for(;subrules_can.operator[](xxx)!=yacco2::PTR_LR1_eog__;++xxx);
/*88:*/
//line 2960 "./o2externs.w"

vector<AST*> ::iterator ti= subrules_can.nodes_visited()->begin();
vector<AST*> ::iterator tie= subrules_can.nodes_visited()->end();
for(;ti!=tie;++ti){
AST*srdef_t= *ti;
T_subrule_def* sr_def = (T_subrule_def*)AST::content(*srdef_t);
AST*sr_t= sr_def->subrule_s_tree();
AST*et= AST::get_spec_child(*sr_t,1);
++nc;
elem_space[nc]= et;
}

/*:88*/
//line 2994 "./o2externs.w"

}
}

/*:90*/
//line 3021 "./o2externs.w"

if(rdef->epsilon()==YES){
AST*et= AST::brother(*cur_elem_t);
elem_space[cc]= et;
continue;
}else{
++cc;
continue;
}
}
}
/*:91*/
//line 3068 "./o2externs.w"

}
}

/*:93*//*98:*/
//line 3150 "./o2externs.w"

void GEN_FS_OF_RULE(rule_def*Rule_def){
using namespace NS_yacco2_T_enum;
using namespace std;
std::set<rule_def*> rules_in_elem_space;
std::set<rule_def*> ::iterator i;
INT_SET_type sr_filter;
sr_filter.insert(T_Enum::T_T_subrule_def_);
tok_can_ast_functor just_walk_functr;

T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
int cc(0);
int nc(-1);
AST*cur_elem_t(0);
CAbs_lr1_sym*cur_elem(0);
/*95:*/
//line 3080 "./o2externs.w"

{
AST*rtree= Rule_def->rule_s_tree();
ast_prefix_1forest subrule_walk(*rtree,&just_walk_functr,&sr_filter,ACCEPT_FILTER);
tok_can<AST*> subrules_can(subrule_walk);
yacco2::UINT xxx(0);
for(;subrules_can.operator[](xxx)!=yacco2::PTR_LR1_eog__;++xxx);
/*88:*/
//line 2960 "./o2externs.w"

vector<AST*> ::iterator ti= subrules_can.nodes_visited()->begin();
vector<AST*> ::iterator tie= subrules_can.nodes_visited()->end();
for(;ti!=tie;++ti){
AST*srdef_t= *ti;
T_subrule_def* sr_def = (T_subrule_def*)AST::content(*srdef_t);
AST*sr_t= sr_def->subrule_s_tree();
AST*et= AST::get_spec_child(*sr_t,1);
++nc;
elem_space[nc]= et;
}

/*:88*/
//line 3087 "./o2externs.w"

}

/*:95*/
//line 3165 "./o2externs.w"

/*97:*/
//line 3131 "./o2externs.w"

if(Rule_def->rule_no()!=1)goto not_start_rule;
if(O2_PP_PHASE==0)goto not_start_rule;
if(Rule_def->epsilon()==NO)goto not_start_rule;
{
T_parallel_la_boundary*la= O2_PP_PHASE->la_bndry();
set<T_in_stbl*> ::iterator lai= la->la_first_set()->begin();
set<T_in_stbl*> ::iterator laie= la->la_first_set()->end();
for(;lai!=laie;++lai){
T_in_stbl*tstbl= *lai;
Rule_def->add_to_first_set(*tstbl);
}
}
not_start_rule:;

/*:97*/
//line 3166 "./o2externs.w"

while(cc<=nc){
cur_elem_t= elem_space[cc];
cur_elem= AST::content(*cur_elem_t);
/*96:*/
//line 3091 "./o2externs.w"

switch(cur_elem->enumerated_id__){
case T_Enum::T_T_eosubrule_:{
++cc;
continue;
}
case T_Enum::T_refered_T_:{
refered_T* rt = (refered_T*)cur_elem;
T_in_stbl*tstbl= rt->t_in_stbl();
Rule_def->add_to_first_set(*tstbl);
Rule_def->add_rule_adding_T_in_first_set(tstbl,rt->grammar_s_enumerate());
++cc;
continue;
}
case T_Enum::T_refered_rule_:{
refered_rule* rr = (refered_rule*)cur_elem;
rule_def*rdef= rr->its_rule_def();
/*90:*/
//line 2984 "./o2externs.w"

{
i= rules_in_elem_space.find(rdef);
if(i==rules_in_elem_space.end()){
rules_in_elem_space.insert(rdef);
AST*rtree= rdef->rule_s_tree();
ast_prefix_1forest subrule_walk(*rtree,&just_walk_functr,&sr_filter,ACCEPT_FILTER);
tok_can<AST*> subrules_can(subrule_walk);
yacco2::UINT xxx(0);
for(;subrules_can.operator[](xxx)!=yacco2::PTR_LR1_eog__;++xxx);
/*88:*/
//line 2960 "./o2externs.w"

vector<AST*> ::iterator ti= subrules_can.nodes_visited()->begin();
vector<AST*> ::iterator tie= subrules_can.nodes_visited()->end();
for(;ti!=tie;++ti){
AST*srdef_t= *ti;
T_subrule_def* sr_def = (T_subrule_def*)AST::content(*srdef_t);
AST*sr_t= sr_def->subrule_s_tree();
AST*et= AST::get_spec_child(*sr_t,1);
++nc;
elem_space[nc]= et;
}

/*:88*/
//line 2994 "./o2externs.w"

}
}

/*:90*/
//line 3108 "./o2externs.w"

if(rdef->epsilon()==YES){
AST*et= AST::brother(*cur_elem_t);
elem_space[cc]= et;
continue;
}else{
++cc;
continue;
}
}
}

/*:96*/
//line 3170 "./o2externs.w"

}
}

/*:98*//*102:*/
//line 3212 "./o2externs.w"

bool
fs_sort_criteria(const NS_yacco2_terminals::T_in_stbl*E1,const NS_yacco2_terminals::T_in_stbl*E2){
T_in_stbl* e1 = (T_in_stbl*)E1;
T_in_stbl* e2 = (T_in_stbl*)E2;
T_terminal_def*e1_t_def= e1->t_def();
T_terminal_def*e2_t_def= e2->t_def();
string*e1s= e1_t_def->t_name();
string*e2s= e2_t_def->t_name();
if(*e1s<*e2s)return true;
return false;
}
void PRT_RULE_S_FIRST_SET(std::ofstream&Ofile,NS_yacco2_terminals::rule_def*Rule_def){
/*100:*/
//line 3183 "./o2externs.w"

T_IN_STBL_SET_type*fs= Rule_def->first_set();
Ofile<<"@*2 |"<<Rule_def->rule_name()->c_str()<<"|";
if(Rule_def->epsilon()==true){
Ofile<<"{$^\\emptyrule$}";
}
Ofile<<" \\# in set: "<<fs->size()<<".\\fbreak"<<std::endl;
T_IN_STBL_SORTED_SET_type ran_array;
ran_array.reserve(fs->size());
T_IN_STBL_SET_ITER_type ii= fs->begin();
T_IN_STBL_SET_ITER_type iie= fs->end();
for(;ii!=iie;++ii){
ran_array.push_back(*ii);
}
stable_sort(ran_array.begin(),ran_array.end(),fs_sort_criteria);

/*:100*/
//line 3225 "./o2externs.w"

/*101:*/
//line 3200 "./o2externs.w"

char xlate[Max_cweb_item_size];
T_IN_STBL_SORTED_SET_ITER_type i= ran_array.begin();
T_IN_STBL_SORTED_SET_ITER_type ie= ran_array.end();
for(;i!=ie;++i){
T_in_stbl*el= *i;
Ofile<<" ";
XLATE_SYMBOLS_FOR_cweave(el->t_def()->t_name()->c_str(),xlate);
Ofile<<xlate<<"\\ \\ "<<std::endl;
}

/*:101*/
//line 3226 "./o2externs.w"

}

/*:102*//*104:*/
//line 3239 "./o2externs.w"

LA_SET_type*make_copy_of_la_set(LA_SET_type*Set1){
LA_SET_type*copy_set= new LA_SET_type;
using namespace yacco2_stbl;
T_sym_tbl_report_card report_card;
find_sym_in_stbl(report_card,*LR1_EOLR_LITERAL);
T_in_stbl* td = (T_in_stbl*)report_card.tbl_entry_->symbol_;
LA_SET_ITER_type f= Set1->find(td);
if(f!=Set1->end()){
copy_set->insert(td);
return copy_set;
}
LA_SET_ITER_type i= Set1->begin();
LA_SET_ITER_type ie= Set1->end();
for(;i!=ie;++i){
copy_set->insert(*i);
}
return copy_set;
}

/*:104*//*105:*/
//line 3261 "./o2externs.w"

bool are_2_la_sets_equal(LA_SET_type*Common_set1,LA_SET_type*Set2){
LA_SET_type*la_set_to_compare_against= Set2;
using namespace yacco2_stbl;
T_sym_tbl_report_card report_card;
find_sym_in_stbl(report_card,*LR1_EOLR_LITERAL);
T_in_stbl* td = (T_in_stbl*)report_card.tbl_entry_->symbol_;
LA_SET_type*eolr_set(0);
LA_SET_ITER_type f= Set2->find(td);
if(f!=Set2->end()){
eolr_set= new LA_SET_type;
eolr_set->insert(td);
la_set_to_compare_against= eolr_set;
}

if(Common_set1->size()!=la_set_to_compare_against->size()){
if(eolr_set!=0)delete eolr_set;
return false;
}
LA_SET_ITER_type set1i= Common_set1->begin();
LA_SET_ITER_type set1ie= Common_set1->end();
LA_SET_ITER_type set2i= la_set_to_compare_against->begin();
LA_SET_ITER_type set2ie= la_set_to_compare_against->end();
for(;set1i!=set1ie;){
T_in_stbl*set1T= *set1i;
T_in_stbl*set2T= *set2i;
if(set1T!=set2T)
return false;
++set1i;
++set2i;
}
if(eolr_set!=0)delete eolr_set;
return true;
}

/*:105*//*106:*/
//line 3297 "./o2externs.w"

int find_common_la_set_idx(LA_SET_type*La_){
if(COMMON_LA_SETS.empty()==true){
LA_SET_type*copy_set= make_copy_of_la_set(La_);
COMMON_LA_SETS.push_back(copy_set);
return 0;
}
COMMON_LA_SETS_ITER_type i= COMMON_LA_SETS.begin();
COMMON_LA_SETS_ITER_type ie= COMMON_LA_SETS.end();
int idx(0);
for(;i!=ie;++i,++idx){
LA_SET_type*st1= *i;
bool result= are_2_la_sets_equal(st1,La_);
if(result==true){
return idx;
}
}
LA_SET_type*copy_set= make_copy_of_la_set(La_);
COMMON_LA_SETS.push_back(copy_set);
return idx;
}


/*:106*//*107:*/
//line 3326 "./o2externs.w"

void COMMONIZE_LA_SETS(){
STATES_ITER_type si= LR1_STATES.begin();
STATES_ITER_type sie= LR1_STATES.end();
for(;si!=sie;++si){
state*cur_state= *si;
S_VECTORS_ITER_type svi= cur_state->state_s_vector_.begin();
S_VECTORS_ITER_type svie= cur_state->state_s_vector_.end();
for(;svi!=svie;++svi){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
S_VECTOR_ELEMS_ITER_type selie= svi->second.end();
for(;seli!=selie;++seli){
state_element*se= *seli;
if(se->goto_state_!=0)continue;
bool set_ok= se->calc_la(*se);
if(set_ok==false){
return;
}
se->common_la_set_idx_= find_common_la_set_idx(se->la_set_);
}
}
}
}

/*:107*//*109:*/
//line 3372 "./o2externs.w"

int calc_cyclic_key
(NS_yacco2_terminals::rule_def*Rule_use,NS_yacco2_terminals::rule_def*Against_rule){
using namespace NS_yacco2_T_enum;
static int no_of_rules(0);
static int start_of_rules(0);
if(no_of_rules==0){
start_of_rules= O2_T_ENUM_PHASE->total_enumerate();
no_of_rules= O2_RULES_PHASE->rules_alphabet()->size();
}
int rule_use_enum_rel0= Rule_use->enum_id()-start_of_rules;
int part1_key_of_rule_use= rule_use_enum_rel0*no_of_rules;
int against_rule_enum_rel0= Against_rule->enum_id()-start_of_rules;
int part2_key_of_against_rule= against_rule_enum_rel0;
int key= part1_key_of_rule_use+part2_key_of_against_rule;
return key;
}

/*:109*//*110:*/
//line 3397 "./o2externs.w"

void determine_rhs_indirect_use_cnt
(NS_yacco2_terminals::rule_def*Use_for_rule,yacco2::AST*SRule_t
,NS_yacco2_terminals::rule_def*Against_rule){
using namespace NS_yacco2_T_enum;
SET_FILTER_type filter;
filter.insert(T_Enum::T_refered_rule_);

tok_can_ast_functor walk_functr;
ast_prefix_1forest walk(*SRule_t,&walk_functr,&filter,ACCEPT_FILTER);
TOK_CAN_TREE_type rules_use_can(walk);
int indirect_use_cnt(0);
int direct_use_cnt(0);
int x(0);
CAbs_lr1_sym*sym= rules_use_can[x];
for(;sym->enumerated_id()!=LR1_Eog;++x,sym= rules_use_can[x]){
refered_rule* rr = (refered_rule*)sym;
rule_def*its_rd= rr->its_rule_def();
if(its_rd==Use_for_rule){
continue;
}
int idc= MAX_USE_CNT_RxR(Use_for_rule,its_rd);
}
}

/*:110*//*111:*/
//line 3428 "./o2externs.w"

int determine_rhs_max_use_cnt
(NS_yacco2_terminals::rule_def*Use_for_rule,yacco2::AST*SRule_t
,NS_yacco2_terminals::rule_def*Against_rule){
using namespace NS_yacco2_T_enum;
SET_FILTER_type filter;
filter.insert(T_Enum::T_refered_rule_);

tok_can_ast_functor walk_functr;
ast_prefix_1forest walk(*SRule_t,&walk_functr,&filter,ACCEPT_FILTER);
TOK_CAN_TREE_type rules_use_can(walk);
int running_indirect_use_cnt(0);
int running_direct_use_cnt(0);
int x(0);
CAbs_lr1_sym*sym= rules_use_can[x];
rule_def*its_rd(0);
for(;sym->enumerated_id()!=LR1_Eog;++x,sym= rules_use_can[x]){
refered_rule* rr = (refered_rule*)sym;
its_rd= rr->its_rule_def();
if(its_rd==Against_rule)Against_rule->recursive(YES);
if(its_rd==Use_for_rule){
++running_direct_use_cnt;
continue;
}else{
use_cnt_type rule_use_key(Use_for_rule,its_rd);
int use_cnt_key= calc_cyclic_key(Use_for_rule,its_rd);
CYCLIC_USE_TBL_ITER_type i= CYCLIC_USE_TABLE.find(use_cnt_key);
use_cnt_type&uc= i->second;
int idc= uc.use_cnt_;
int potential_idc_cnt= idc+running_direct_use_cnt;
if(potential_idc_cnt> running_indirect_use_cnt){
running_indirect_use_cnt= potential_idc_cnt;
}
}
}
if(running_direct_use_cnt> running_indirect_use_cnt){
return running_direct_use_cnt;
}
return running_indirect_use_cnt;
}

/*:111*//*112:*/
//line 3471 "./o2externs.w"

int MAX_USE_CNT_RxR
(NS_yacco2_terminals::rule_def*Rule_use,NS_yacco2_terminals::rule_def*Against_rule){
use_cnt_type rule_use_key(Rule_use,Against_rule);
int use_cnt_key= calc_cyclic_key(Rule_use,Against_rule);
CYCLIC_USE_TBL_ITER_type i= CYCLIC_USE_TABLE.find(use_cnt_key);
if(i!=CYCLIC_USE_TABLE.end()){
return i->second.use_cnt_;
}
CYCLIC_USE_TABLE.insert(make_pair(use_cnt_key,rule_use_key));
using namespace NS_yacco2_T_enum;
if(Against_rule->rule_use_skeleton()==0){
i= CYCLIC_USE_TABLE.find(use_cnt_key);
use_cnt_type&uc= i->second;
uc.use_cnt_= 0;
return 0;
}
SET_FILTER_type filter;
filter.insert(T_Enum::T_T_subrule_def_);
tok_can_ast_functor walk_functr;
ast_prefix walk(*Against_rule->rule_use_skeleton(),&walk_functr
,&filter,ACCEPT_FILTER);
TOK_CAN_TREE_type rules_use_can(walk);
int use_cnt(0);
int x(0);
CAbs_lr1_sym*sym= rules_use_can[x];
for(;sym->enumerated_id()!=LR1_Eog;++x,sym= rules_use_can[x]){
AST*sr_t= rules_use_can.ast(x);
determine_rhs_indirect_use_cnt(Rule_use,sr_t,Against_rule);
int rhs_uc= determine_rhs_max_use_cnt(Rule_use,sr_t,Against_rule);
if(use_cnt<rhs_uc){
use_cnt= rhs_uc;
}
}
i= CYCLIC_USE_TABLE.find(use_cnt_key);
use_cnt_type&uc= i->second;
if((Against_rule->recursive()==YES)
&&(Rule_use!=Against_rule))use_cnt= 2*use_cnt;
uc.use_cnt_= use_cnt;
return use_cnt;
}


/*:112*//*115:*/
//line 3615 "./o2externs.w"

void intro_comment
(std::ofstream&Op_str,const char*File_name){
char big_buf_[BIG_BUFFER_32K];
KCHARP op_template= 
"/*\n"
" File: %s\n"
" Date and Time: %s\n"
"*/";

int x= sprintf(big_buf_
,op_template
,File_name
,DATE_AND_TIME()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:115*//*116:*/
//line 3643 "./o2externs.w"

void grammar_header_includes
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
T_lr1_k_phrase*lrk_ph= O2_LRK_PHASE;
T_rc_phrase*rc_ph= O2_RC_PHASE;
T_error_symbols_phrase*err_ph= O2_ERROR_PHASE;
T_terminals_phrase*t_ph= O2_T_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP include_list= 
"#include \"%s\"\n"
"#include \"%s.h\"\n"
"#include \"%s.h\"\n"
"#include \"%s.h\"\n"
"#include \"%s.h\"\n"
"#include \"%s.h\"";

int x= sprintf(big_buf_
,include_list
,O2_library_file
,enum_ph->filename_id()->identifier()->c_str()
,lrk_ph->filename_id()->identifier()->c_str()
,err_ph->filename_id()->identifier()->c_str()
,t_ph->filename_id()->identifier()->c_str()
,rc_ph->filename_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
/*:116*//*117:*/
//line 3676 "./o2externs.w"

void user_prefix_declaration_for_header
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP upd_code= "%s";

T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
SDC_MAP_type*dir_map= fsm_class->directives_map();
SDC_MAP_ITER_type i= dir_map->find(SDC_user_prefix_declaration);
if(i==dir_map->end())return;
T_user_prefix_declaration* upd = (T_user_prefix_declaration*)i->second;
int x= sprintf(big_buf_
,upd_code
,upd->syntax_code()->syntax_code()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}


/*:117*//*118:*/
//line 3701 "./o2externs.w"

void thread_entry_extern_for_header
(std::ofstream&Op_str){
T_parallel_parser_phrase*pp_ph= O2_PP_PHASE;
if(pp_ph==0){
Op_str<<"// monolithic grammar: no thread"<<endl;
return;
}
char big_buf_[BIG_BUFFER_32K];
KCHARP th_extern= "extern yacco2::Thread_entry I%s;\n";

int x= sprintf(big_buf_
,th_extern
,pp_ph->pp_funct()->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:118*//*119:*/
//line 3721 "./o2externs.w"

void using_ns_for_header
(std::ofstream&Op_str){
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
char big_buf_[BIG_BUFFER_32K];

KCHARP default_ns_use= 
"using namespace %s;// enumerate\n"
"using namespace yacco2;";

int x= sprintf(big_buf_
,default_ns_use
,enum_ph->namespace_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:119*//*120:*/
//line 3744 "./o2externs.w"

void fsm_enum_rules_subrules_for_header
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
char big_buf_[BIG_BUFFER_32K];

KCHARP enumeration_of_rules_sbrules= 
"  enum rules_and_subrules{\n"
"   start_of_rule_list = %s::T_Enum::sum_total_T";
int x= sprintf(big_buf_
,enumeration_of_rules_sbrules
,enum_ph->namespace_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;


T_rules_phrase*rules_ph= O2_RULES_PHASE;

RULE_DEFS_TBL_ITER_type i= rules_ph->crt_order()->begin();
RULE_DEFS_TBL_ITER_type ie= rules_ph->crt_order()->end();
int overall_subrules_nos(0);
int current_rule_no(-1);
int no_rules= rules_ph->rules_alphabet()->size();
KCHARP rule_enum= 
"   ,R_%s_ = %i//start_of_rule_list + %i";
for(;i!=ie;++i){
++current_rule_no;
rule_def*rd= *i;
x= sprintf(big_buf_
,rule_enum
,rd->rule_name()->c_str()
,rd->enum_id()
,current_rule_no++
);
Op_str.write(big_buf_,x);
Op_str<<endl;
T_subrules_phrase*sr_ph= rd->subrules();
SUBRULE_DEFS_ITER_type j= sr_ph->subrules()->begin();
SUBRULE_DEFS_ITER_type je= sr_ph->subrules()->end();
KCHARP subrule_enum= 
"    ,rhs%i_%s_ = %i";
for(;j!=je;++j){
T_subrule_def*srd= *j;
++overall_subrules_nos;
int x= sprintf(big_buf_
,subrule_enum
,srd->subrule_no_of_rule()
,rd->rule_name()->c_str()
,overall_subrules_nos
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}
KCHARP end_enumeration_of_rules_sbrules= 
"  };";
Op_str<<end_enumeration_of_rules_sbrules<<endl;
}

/*:120*//*121:*/
//line 3812 "./o2externs.w"

void fsm_map_subrules_to_rules_for_header
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
char big_buf_[BIG_BUFFER_32K];

KCHARP array_of_subrules_to_rules_mapping= 
"  fsm_rules_reuse_table_type fsm_rules_reuse_table;\n"
"  static int rhs_to_rules_mapping_[%i];";


T_rules_phrase*rules_ph= O2_RULES_PHASE;

RULE_DEFS_TBL_ITER_type i= rules_ph->crt_order()->begin();
RULE_DEFS_TBL_ITER_type ie= rules_ph->crt_order()->end();
int overall_subrules_nos(0);
for(;i!=ie;++i){
rule_def*rd= *i;
T_subrules_phrase*sr_ph= rd->subrules();
SUBRULE_DEFS_ITER_type j= sr_ph->subrules()->begin();
SUBRULE_DEFS_ITER_type je= sr_ph->subrules()->end();
for(;j!=je;++j){
++overall_subrules_nos;
}
}
++overall_subrules_nos;
int x= sprintf(big_buf_
,array_of_subrules_to_rules_mapping
,overall_subrules_nos
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:121*//*122:*/
//line 3849 "./o2externs.w"

void fsm_comments_about_la_sets_and_states
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP no_of_la_sets_and_states= 
"  //no of la sets = %i\n"
"  //no of states = %i";
int x= sprintf(big_buf_
,no_of_la_sets_and_states
,COMMON_LA_SETS.size()
,NO_LR1_STATES
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:122*//*123:*/
//line 3871 "./o2externs.w"

void fsm_class_declaration_for_header
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP class_fsm= 
"class %s: public yacco2::CAbs_fsm {\n"
" public:";
int x= sprintf(big_buf_
,class_fsm
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;

fsm_enum_rules_subrules_for_header(Op_str);
fsm_comments_about_la_sets_and_states(Op_str);

KCHARP ctor_fsm= 
"  %s();";

x= sprintf(big_buf_
,ctor_fsm
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;

KCHARP dtor_fsm= 
"  ~%s();";
x= sprintf(big_buf_
,dtor_fsm
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;

KCHARP op_failed= 
"  void op();\n"
"  bool failed();";
Op_str<<op_failed<<endl;


KCHARP reduce_rhs= 
"  void reduce_rhs_of_rule\n"
"      (yacco2::UINT Sub_rule_no,yacco2::Rule_s_reuse_entry** Recycled_rule);";
Op_str<<reduce_rhs<<endl;
fsm_map_subrules_to_rules_for_header(Op_str);
KCHARP user_declaration= 
"  %s";

SDC_MAP_type*dir_map= fsm_class->directives_map();
SDC_MAP_ITER_type i= dir_map->find(SDC_user_declaration);
if(i!=dir_map->end()){
T_user_declaration* ud = (T_user_declaration*)i->second;
int x= sprintf(big_buf_
,user_declaration
,ud->syntax_code()->syntax_code()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

KCHARP end_class_fsm= 
" };";
Op_str<<end_class_fsm<<endl;

}
/*:123*//*124:*/
//line 3942 "./o2externs.w"

void forward_refs_of_rules_declarations_for_header
(std::ofstream&Op_str){
T_rules_phrase*rules_ph= O2_RULES_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP forward_ref= 
"struct %s;";

RULE_DEFS_TBL_ITER_type i= rules_ph->crt_order()->begin();
RULE_DEFS_TBL_ITER_type ie= rules_ph->crt_order()->end();
for(;i!=ie;++i){
rule_def*rd= *i;
int x= sprintf(big_buf_
,forward_ref
,rd->rule_name()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}

/*:124*//*125:*/
//line 3964 "./o2externs.w"

void rules_class_defs_for_header
(std::ofstream&Op_str){
T_rules_phrase*rules_ph= O2_RULES_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP end_rule_def= 
"};\n";
/*126:*/
//line 3975 "./o2externs.w"

RULE_DEFS_TBL_ITER_type i= rules_ph->crt_order()->begin();
RULE_DEFS_TBL_ITER_type ie= rules_ph->crt_order()->end();
KCHARP start_rule_def= 
"struct %s:public yacco2::CAbs_lr1_sym {\n"
"  %s(yacco2::Parser* P);";
for(;i!=ie;++i){
rule_def*rd= *i;
/*127:*/
//line 4029 "./o2externs.w"

if(rd->parallel_mntr()!=0){
T_parallel_monitor_phrase*pp_phrase= rd->parallel_mntr();
if(rd->parallel_mntr()->mntr_directives_map()->empty()!=true){
SDC_MAP_type*dir_map= pp_phrase->mntr_directives_map();
SDC_MAP_ITER_type i= dir_map->find(SDC_arbitrator_code);
if(i!=dir_map->end()){
T_arbitrator_code* ac = (T_arbitrator_code*)i->second;
string::size_type idx= 
ac->syntax_code()->syntax_code()->find(CODE_PRESENCE_IN_ARBITRATOR_CODE);
if(idx!=string::npos){
KCHARP rule_s_arbitrator= 
"yacco2::THR _YACCO2_CALL_TYPE\n"
"AR_%s(yacco2::Parser* Caller_pp);// rule's arbitrator";

int x= sprintf(big_buf_
,rule_s_arbitrator
,rd->rule_name()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
RULES_HAVING_AR.insert(rd);
}
}
}
}


/*:127*/
//line 3983 "./o2externs.w"

int x= sprintf(big_buf_
,start_rule_def
,rd->rule_name()->c_str()
,rd->rule_name()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
T_rule_lhs_phrase*rlhs= rd->rule_lhs();
if(rlhs!=0){
SDC_MAP_type*dir_map= rlhs->lhs_directives_map();
SDC_MAP_ITER_type i= dir_map->find(SDC_destructor);
if(i!=dir_map->end()){
KCHARP rule_def_dtor= 
"  static void dtor_%s(yacco2::VOIDP This,yacco2::VOIDP P);";
int x= sprintf(big_buf_
,rule_def_dtor
,rd->rule_name()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
i= dir_map->find(SDC_op);
if(i!=dir_map->end()){
KCHARP rule_def_op= 
"  void op();";
Op_str<<rule_def_op<<endl;
}
i= dir_map->find(SDC_constructor);
if(i!=dir_map->end()){
KCHARP rule_def_ctor= 
"  void ctor();";
Op_str<<rule_def_ctor<<endl;
}
i= dir_map->find(SDC_user_declaration);
if(i!=dir_map->end()){
T_user_declaration* ud = (T_user_declaration*)i->second;
Op_str<<ud->syntax_code()->syntax_code()->c_str()<<endl;
}
}
/*128:*/
//line 4059 "./o2externs.w"

KCHARP sub_rule_def_public= 
"  public:";
Op_str<<sub_rule_def_public<<endl;
KCHARP sub_rule_def= 
"  void sr%i();";
T_subrules_phrase*sr_ph= rd->subrules();
SUBRULE_DEFS_ITER_type j= sr_ph->subrules()->begin();
SUBRULE_DEFS_ITER_type je= sr_ph->subrules()->end();
for(int xx= 1;j!=je;++j,++xx){
T_subrule_def*srd= *j;
SDC_MAP_type*sdrmap= srd->subrule_directives();
if(!sdrmap->empty()){
int x= sprintf(big_buf_
,sub_rule_def
,xx
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}
Op_str<<end_rule_def<<endl;

/*:128*/
//line 4023 "./o2externs.w"


}
/*:126*/
//line 3971 "./o2externs.w"

}

/*:125*//*129:*/
//line 4093 "./o2externs.w"

void possible_thread_procedure_declaration
(std::ofstream&Op_str){
if(O2_PP_PHASE==0)return;
T_parallel_parser_phrase*pp_ph= O2_PP_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP thd_proc= 
"yacco2::THR _YACCO2_CALL_TYPE\n"
"%s(yacco2::Parser* Caller);// called thread\n"
"yacco2::THR_result _YACCO2_CALL_TYPE\n"
"PROC_%s(yacco2::Parser* Caller);// called thread's twin the procedure";
int x= sprintf(big_buf_
,thd_proc
,pp_ph->pp_funct()->identifier()->identifier()->c_str()
,pp_ph->pp_funct()->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:129*//*130:*/
//line 4117 "./o2externs.w"

void rules_reuse_table_declaration
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
T_rules_phrase*rules_ph= O2_RULES_PHASE;
int no_rules= rules_ph->rules_alphabet()->size();
char big_buf_[BIG_BUFFER_32K];
KCHARP rules_recycled_table_type= 
"struct fsm_rules_reuse_table_type{\n"
" fsm_rules_reuse_table_type();\n"
" int no_rules_entries_;\n"
" Per_rule_s_reuse_table* per_rule_s_table_[%i];\n"
"};";
int x= sprintf(big_buf_
,rules_recycled_table_type
,no_rules
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:130*//*131:*/
//line 4140 "./o2externs.w"

void namespace_for_header
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP ns_of_grammar_start= 
"namespace %s {";
int x= sprintf(big_buf_
,ns_of_grammar_start
,fsm_ph->namespace_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
possible_thread_procedure_declaration(Op_str);
using_ns_for_header(Op_str);
rules_reuse_table_declaration(Op_str);
fsm_class_declaration_for_header(Op_str);
forward_refs_of_rules_declarations_for_header(Op_str);
rules_class_defs_for_header(Op_str);
KCHARP ns_of_grammar_end= 
"} // end of namespace\n";
Op_str<<ns_of_grammar_end<<endl;
}

/*:131*//*132:*/
//line 4165 "./o2externs.w"

void state_1_extern
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
char big_buf_[BIG_BUFFER_32K];
KCHARP state_extern= 
"extern yacco2::State S1_%s;";
int x= sprintf(big_buf_
,state_extern
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
/*:132*//*133:*/
//line 4181 "./o2externs.w"

void grammar_include_guard_for_header
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
char big_buf_[BIG_BUFFER_32K];
KCHARP signal_guard_start= 
"#ifndef __%s_h__\n"
"#define __%s_h__ 1";
int x= sprintf(big_buf_
,signal_guard_start
,fsm_ph->filename_id()->identifier()->c_str()
,fsm_ph->filename_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
grammar_header_includes(Op_str);
user_prefix_declaration_for_header(Op_str);
thread_entry_extern_for_header(Op_str);
state_1_extern(Op_str);
namespace_for_header(Op_str);
KCHARP signal_guard_end= 
"#endif";
Op_str<<signal_guard_end<<endl;
}
/*:133*//*134:*/
//line 4209 "./o2externs.w"

void user_suffix_declaration_for_header
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
char big_buf_[BIG_BUFFER_32K];

T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
SDC_MAP_type*dir_map= fsm_class->directives_map();
SDC_MAP_ITER_type i= dir_map->find(SDC_user_suffix_declaration);
if(i==dir_map->end())return;
T_user_suffix_declaration* upd = (T_user_suffix_declaration*)i->second;
KCHARP upd_code= "%s";
int x= sprintf(big_buf_
,upd_code
,upd->syntax_code()->syntax_code()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:134*//*135:*/
//line 4230 "./o2externs.w"

void OP_GRAMMAR_HEADER(TOKEN_GAGGLE&Error_queue){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
string fn(fsm_ph->filename_id()->identifier()->c_str());
fn+= Suffix_fsmheader;
std::ofstream Op_file;
Op_file.open(fn.c_str(),ios_base::out|ios::trunc);
if(!Op_file){
CAbs_lr1_sym*sym= new Err_bad_fsmheader_filename(fn.c_str());
sym->set_line_no_and_pos_in_line(*fsm_ph->filename_id());
sym->set_who_created("o2externs.w - OP_GRAMMAR_HEADER",__LINE__);
Error_queue.push_back(*sym);
return;
}

intro_comment(Op_file,fn.c_str());
grammar_include_guard_for_header(Op_file);
user_suffix_declaration_for_header(Op_file);
Op_file.close();
}

/*:135*//*137:*/
//line 4260 "./o2externs.w"

void fsm_cpp_includes
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP include_list= 
"#include \"%s.h\"";

int x= sprintf(big_buf_
,include_list
,fsm_ph->filename_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:137*//*138:*/
//line 4277 "./o2externs.w"

void using_ns_for_fsm_cpp
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
T_lr1_k_phrase*lrk_ph= O2_LRK_PHASE;
T_rc_phrase*rc_ph= O2_RC_PHASE;
T_error_symbols_phrase*err_ph= O2_ERROR_PHASE;
T_terminals_phrase*t_ph= O2_T_PHASE;

char big_buf_[BIG_BUFFER_32K];

KCHARP default_ns_use= 
"using namespace %s;// enumerate\n"
"using namespace %s;// error symbols\n"
"using namespace %s;// lrk \n"
"using namespace %s;// terminals\n"
"using namespace %s;// rc \n"
"using namespace %s;// yacco2 library\n"
"using namespace %s;// grammar's ns\n"
"// first set terminals";

int x= sprintf(big_buf_
,default_ns_use
,enum_ph->namespace_id()->identifier()->c_str()
,err_ph->namespace_id()->identifier()->c_str()
,lrk_ph->namespace_id()->identifier()->c_str()
,t_ph->namespace_id()->identifier()->c_str()
,rc_ph->namespace_id()->identifier()->c_str()
,"yacco2"
,fsm_ph->namespace_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
/*:138*//*139:*/
//line 4315 "./o2externs.w"

void rules_reuse_table_implementation
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_rules_phrase*rules_ph= O2_RULES_PHASE;
int no_rules= rules_ph->rules_alphabet()->size();
char big_buf_[BIG_BUFFER_32K];

KCHARP rules_recycled_table_type= 
"fsm_rules_reuse_table_type::fsm_rules_reuse_table_type(){\n"
" no_rules_entries_ = %i;";
int x= sprintf(big_buf_
,rules_recycled_table_type
,no_rules
);
Op_str.write(big_buf_,x);
Op_str<<endl;
KCHARP per_rule_s_table_ref_type= 
" per_rule_s_table_[%i] =  new Per_rule_s_reuse_table();";

for(int xx= 1;xx<=no_rules;++xx){
int x0= xx-1;
x= sprintf(big_buf_
,per_rule_s_table_ref_type
,x0
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
Op_str<<"}"<<endl;
}

/*:139*//*140:*/
//line 4349 "./o2externs.w"

void fsm_map_subrules_to_rules_table_imp
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
T_rules_phrase*rules_ph= O2_RULES_PHASE;
char big_buf_[BIG_BUFFER_32K];
RULE_DEFS_TBL_ITER_type i= rules_ph->crt_order()->begin();
RULE_DEFS_TBL_ITER_type ie= rules_ph->crt_order()->end();
int overall_subrules_nos(0);
for(;i!=ie;++i){
rule_def*rd= *i;
T_subrules_phrase*sr_ph= rd->subrules();
SUBRULE_DEFS_ITER_type j= sr_ph->subrules()->begin();
SUBRULE_DEFS_ITER_type je= sr_ph->subrules()->end();
for(;j!=je;++j){
++overall_subrules_nos;
}
}
++overall_subrules_nos;

KCHARP array_of_subrules_to_rules_mapping_start= 
"int %s::rhs_to_rules_mapping_[%i] = {\n"
" -1";
int x= sprintf(big_buf_
,array_of_subrules_to_rules_mapping_start
,fsm_class->identifier()->identifier()->c_str()
,overall_subrules_nos
);
Op_str.write(big_buf_,x);
Op_str<<endl;

KCHARP subrules_to_rule_mapping= 
" ,%i // subrule %i for rule %i";

KCHARP array_of_subrules_to_rules_mapping_end= 
"};%s";



i= rules_ph->crt_order()->begin();
ie= rules_ph->crt_order()->end();
overall_subrules_nos= 0;
for(;i!=ie;++i){
rule_def*rd= *i;
T_subrules_phrase*sr_ph= rd->subrules();
SUBRULE_DEFS_ITER_type j= sr_ph->subrules()->begin();
SUBRULE_DEFS_ITER_type je= sr_ph->subrules()->end();
for(;j!=je;++j){
++overall_subrules_nos;
int x= sprintf(big_buf_
,subrules_to_rule_mapping
,rd->rule_no()-1
,overall_subrules_nos
,rd->rule_no()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}
x= sprintf(big_buf_
,array_of_subrules_to_rules_mapping_end," "
);
Op_str.write(big_buf_,x);
Op_str<<endl;
enum_ph->total_no_subrules(overall_subrules_nos);
}

/*:140*//*141:*/
//line 4431 "./o2externs.w"

void fsm_class_implementation
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP ctor_fsm= 
"  %s::\n"
"  %s()\n"
"    :yacco2::CAbs_fsm\n"
"      (\"%s\"\n"
"      ,\"%s\"\n"
"      ,\"%s\"\n"
"      ,%s\n"
"      ,\"%s\"\n"
"      ,\"%s\"\n"
"      ,S1_%s){\n"
"    %s\n"
"  }";
SDC_MAP_type*dir_map= fsm_class->directives_map();
SDC_MAP_ITER_type i= dir_map->find(SDC_constructor);
const char*cc_str(0);
if(i!=dir_map->end()){
T_constructor* cc = (T_constructor*)i->second;
cc_str= cc->syntax_code()->syntax_code()->c_str();
}else{
cc_str= "";
}

int x= sprintf(big_buf_
,ctor_fsm
,fsm_class->identifier()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()
,fsm_ph->fsm_id()->c_string()->c_str()
,fsm_ph->version()->c_string()->c_str()
,fsm_ph->date()->c_string()->c_str()
,fsm_ph->debug()->c_string()->c_str()
,fsm_ph->comment()->c_string()->c_str()
,DATE_AND_TIME()
,fsm_class->identifier()->identifier()->c_str()
,cc_str
);
Op_str.write(big_buf_,x);
Op_str<<endl;

KCHARP dtor_rtn_start= 
" \n"
"%s::~%s(){\n"
"%s";
i= dir_map->find(SDC_destructor);
const char*dc_str(0);
if(i!=dir_map->end()){
T_destructor* dc = (T_destructor*)i->second;
dc_str= dc->syntax_code()->syntax_code()->c_str();
}else{
dc_str= "";
}
x= sprintf(big_buf_
,dtor_rtn_start
,fsm_class->identifier()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()
,dc_str
);
Op_str.write(big_buf_,x);
Op_str<<endl;


T_rules_phrase*rules_ph= O2_RULES_PHASE;
int no_rules= rules_ph->rules_alphabet()->size();
KCHARP delete_recycled_rules= 
"  for(int x = 0;x < %i;++x){\n"
"   ///delete fsm_rules_reuse_table.per_rule_s_table_[x];\n"
"  }";

x= sprintf(big_buf_
,delete_recycled_rules
,no_rules
);
Op_str.write(big_buf_,x);
Op_str<<endl;
KCHARP dtor_rtn_end= 
"}%s\n"
"";
x= sprintf(big_buf_
,dtor_rtn_end," "
);
Op_str.write(big_buf_,x);
Op_str<<endl;

KCHARP failed_rtn= 
"  bool %s::failed(){\n"
"    %s\n"
"  }";

i= dir_map->find(SDC_failed);
const char*fc_str(0);
if(i!=dir_map->end()){
T_failed* fc = (T_failed*)i->second;
fc_str= fc->syntax_code()->syntax_code()->c_str();
}else{
fc_str= "  return false;";
}
x= sprintf(big_buf_
,failed_rtn
,fsm_class->identifier()->identifier()->c_str()
,fc_str
);
Op_str.write(big_buf_,x);
Op_str<<endl;
KCHARP op_rtn= 
"  void %s::op(){%s\n}";
i= dir_map->find(SDC_op);
const char*oc_str(0);
if(i!=dir_map->end()){
T_op* oc = (T_op*)i->second;
oc_str= oc->syntax_code()->syntax_code()->c_str();
}else{
oc_str= "";
}
x= sprintf(big_buf_
,op_rtn
,fsm_class->identifier()->identifier()->c_str()
,oc_str
);
Op_str.write(big_buf_,x);
Op_str<<endl;
fsm_map_subrules_to_rules_table_imp(Op_str);
dir_map= fsm_class->directives_map();
i= dir_map->find(SDC_user_implementation);
if(i!=dir_map->end()){
T_user_implementation* ui = (T_user_implementation*)i->second;
Op_str<<ui->syntax_code()->syntax_code()->c_str()<<endl;
}
}

/*:141*//*142:*/
//line 4574 "./o2externs.w"

void rules_subrules_implementations
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
T_rules_phrase*rules_ph= O2_RULES_PHASE;
char big_buf_[BIG_BUFFER_32K];
/*143:*/
//line 4584 "./o2externs.w"

RULE_DEFS_TBL_ITER_type i= rules_ph->crt_order()->begin();
RULE_DEFS_TBL_ITER_type ie= rules_ph->crt_order()->end();
for(;i!=ie;++i){
rule_def*rd= *i;
/*144:*/
//line 4735 "./o2externs.w"

if(rd->parallel_mntr()!=0){
T_parallel_monitor_phrase* pp_phrase = rd->parallel_mntr();
/*145:*/
//line 4741 "./o2externs.w"

if(pp_phrase->mntr_directives_map()->empty()!=true){
SDC_MAP_type*pp_map= pp_phrase->mntr_directives_map();
SDC_MAP_ITER_type p= pp_map->find(SDC_arbitrator_code);
if(p!=pp_map->end()){
T_arbitrator_code* ac = (T_arbitrator_code*)p->second;
string::size_type idx= 
ac->syntax_code()->syntax_code()->find(CODE_PRESENCE_IN_ARBITRATOR_CODE);
if(idx!=string::npos){
KCHARP rule_s_arbitrator_imp= 
"yacco2::THR _YACCO2_CALL_TYPE\n"
"%s::AR_%s(yacco2::Parser* Caller_pp){\n"
" yacco2::KCHARP ar_name = \"AR_%s\";\n"
"#include \"war_begin_code.h\"\n"
" %s\n"
"#include \"war_end_code.h\"\n"
"}\n";
int x= sprintf(big_buf_
,rule_s_arbitrator_imp
,fsm_ph->namespace_id()->identifier()->c_str()
,rd->rule_name()->c_str()
,rd->rule_name()->c_str()
,ac->syntax_code()->syntax_code()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}
}

/*:145*/
//line 4738 "./o2externs.w"

}
/*:144*/
//line 4589 "./o2externs.w"

T_rule_lhs_phrase*rlhs= rd->rule_lhs();
const char*ctor_code(0);
const char*dtor_code(0);
string dtor_name("0");
const char*op_code(0);
const char*user_imp_code(0);
T_destructor*dtor(0);
if(rlhs!=0){
SDC_MAP_type*dir_map= rlhs->lhs_directives_map();
SDC_MAP_ITER_type i= dir_map->find(SDC_constructor);
if(i!=dir_map->end()){
T_constructor* ctor = (T_constructor*)i->second;
ctor_code= ctor->syntax_code()->syntax_code()->c_str();
}
i= dir_map->find(SDC_destructor);
if(i!=dir_map->end()){
dtor = (T_destructor*)i->second;
dtor_code= dtor->syntax_code()->syntax_code()->c_str();
KCHARP dtor_nm= 
"&dtor_%s";
sprintf(big_buf_
,dtor_nm
,rd->rule_name()->c_str()
);
dtor_name.clear();
dtor_name+= big_buf_;
}
i= dir_map->find(SDC_op);
if(i!=dir_map->end()){
T_op* op = (T_op*)i->second;
op_code= op->syntax_code()->syntax_code()->c_str();
}

i= dir_map->find(SDC_user_implementation);
if(i!=dir_map->end()){
T_user_implementation* uimp= (T_user_implementation*)i->second;
user_imp_code= uimp->syntax_code()->syntax_code()->c_str();
}
}

KCHARP rule_def_imp= 
"%s::%s(yacco2::Parser* P)\n"
" :CAbs_lr1_sym\n"
"  (\"%s\",%s,%s::R_%s_,P,%s,%s){\n"
"}\n";
string ad;
if(rd->autodelete()==true){
ad+= "true";
}else{
ad+= "false";
}
string ab;
if(rd->autoabort()==true){
ab+= "true";
}else{
ab+= "false";
}
int x= sprintf(big_buf_
,rule_def_imp
,rd->rule_name()->c_str()
,rd->rule_name()->c_str()
,rd->rule_name()->c_str()
,dtor_name.c_str()
,fsm_class->identifier()->identifier()->c_str()
,rd->rule_name()->c_str()
,ad.c_str()
,ab.c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;


if(dtor_code!=0){
std::string::size_type r= 
dtor->syntax_code()->syntax_code()->find("ABORT_STATUS");
KCHARP rule_def_dtor= 
"void %s::dtor_%s(yacco2::VOIDP This,yacco2::VOIDP P){\n"
" bool ABORT_STATUS = ((yacco2::Parser*)P)->top_stack_record()->aborted__;\n"
" %s* R = (%s*)(This);\n"
" %s\n"
"}";
KCHARP rule_def_dtor_noabort= 
"void %s::dtor_%s(yacco2::VOIDP This,yacco2::VOIDP P){\n"
" %s* R = (%s*)(This);\n"
" %s\n"
"}";
int x;
if(r!=std::string::npos){
x= sprintf(big_buf_
,rule_def_dtor
,rd->rule_name()->c_str()
,rd->rule_name()->c_str()
,rd->rule_name()->c_str()
,rd->rule_name()->c_str()
,dtor_code
);
}else{
x= sprintf(big_buf_
,rule_def_dtor_noabort
,rd->rule_name()->c_str()
,rd->rule_name()->c_str()
,rd->rule_name()->c_str()
,rd->rule_name()->c_str()
,dtor_code
);
}
Op_str.write(big_buf_,x);
Op_str<<endl;
}
if(op_code!=0){
KCHARP rule_def_op= 
"void %s::op(){\n"
"  sstrace_rulesss\n"
" %s\n"
"}";
int x= sprintf(big_buf_
,rule_def_op
,rd->rule_name()->c_str()
,op_code
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

if(ctor_code!=0){
KCHARP rule_def_ctor= 
"void %s::ctor(){\n"
" %s\n"
"}";
int x= sprintf(big_buf_
,rule_def_ctor
,rd->rule_name()->c_str()
,ctor_code
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

if(user_imp_code!=0){
Op_str<<user_imp_code<<endl;
}
/*146:*/
//line 4784 "./o2externs.w"

T_subrules_phrase*sr_ph= rd->subrules();
SUBRULE_DEFS_ITER_type j= sr_ph->subrules()->begin();
SUBRULE_DEFS_ITER_type je= sr_ph->subrules()->end();
int nosrs= sr_ph->no_subrules();
for(int xx= 1;j!=je;++j,++xx){
T_subrule_def*srd= *j;
AST*sr_t= AST::get_spec_child(*srd->subrule_s_tree(),1);
int no_parms= srd->no_of_elems()-1;
KCHARP sub_rule_def_imp= 
"void %s::sr%i(){";
SDC_MAP_type*dir_map= srd->subrule_directives();
if(dir_map->empty()!=true){
int x= sprintf(big_buf_
,sub_rule_def_imp
,rd->rule_name()->c_str()
,xx
);
Op_str.write(big_buf_,x);
Op_str<<endl;

SDC_MAP_ITER_type i= dir_map->find(SDC_op);
if(i!=dir_map->end()){
T_op* rhsc = (T_op*)i->second;
std::string::size_type idx;
idx= rhsc->syntax_code()->syntax_code()->find("sf->p");

if(idx==std::string::npos)goto write_out_op_code;
/*147:*/
//line 4852 "./o2externs.w"

for(int y= 1;y<=no_parms;++y){
bool eos_thd_or_proc(false);
CAbs_lr1_sym*sym= AST::content(*sr_t);
const char*parm_name(0);
switch(sym->enumerated_id__){
case T_Enum::T_refered_rule_:{
refered_rule* rr = (refered_rule*)sym;
parm_name= rr->its_rule_def()->rule_name()->c_str();
break;
}
case T_Enum::T_refered_T_:{
refered_T* rt = (refered_T*)sym;
T_terminal_def*td= rt->its_t_def();
if(td->enum_id()==LR1_ALL_SHIFT_OPERATOR){
parm_name= "CAbs_lr1_sym";
break;
}
if(td->enum_id()==LR1_QUESTIONABLE_SHIFT_OPERATOR){
parm_name= "CAbs_lr1_sym";
break;
}
if(td->enum_id()==LR1_INVISIBLE_SHIFT_OPERATOR){
parm_name= "CAbs_lr1_sym";
break;
}
parm_name= td->classsym()->c_str();
break;
}
case T_Enum::T_T_identifier_:{
parm_name= "T_identifier";
break;
}
case T_Enum::T_T_NULL_:{
parm_name= "T_NULL";
break;
}
case T_Enum::T_T_2colon_:{
parm_name= "T_2colon";
break;
}
case T_Enum::T_T_called_thread_eosubrule_:{
eos_thd_or_proc= true;
--no_parms;
--y;
break;
}
case T_Enum::T_T_null_call_thread_eosubrule_:{
eos_thd_or_proc= true;
--no_parms;
--y;
break;
}
}


if(y==1){
KCHARP sub_rule_stk_parms_begin= 
"  struct SF{";
Op_str<<sub_rule_stk_parms_begin<<endl;
}
KCHARP sub_rule_stk_parm= 
"   %s* p%i__;\n"
"   State* s%i__;\n"
"   bool abort%i__;\n"
"   Rule_s_reuse_entry* rule_s_reuse_entry%i__;";
if(eos_thd_or_proc==false){
int x= sprintf(big_buf_
,sub_rule_stk_parm
,parm_name
,y
,y
,y
,y
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
sr_t= AST::brother(*sr_t);
}
if(no_parms> 0){
KCHARP sub_rule_stk_parms_end= 
"  };";
Op_str<<sub_rule_stk_parms_end<<endl;
KCHARP stk_frame_equate= 
"  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(%i);";

int x= sprintf(big_buf_
,stk_frame_equate
,no_parms
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:147*/
//line 4812 "./o2externs.w"

write_out_op_code:;
KCHARP sub_rule_def_op_code= 
"  %s";
int x= sprintf(big_buf_
,sub_rule_def_op_code
,rhsc->syntax_code()->syntax_code()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
KCHARP sub_rule_def_end= 
"}\n";
Op_str<<sub_rule_def_end<<endl;
}
}
/*:146*/
//line 4731 "./o2externs.w"

}

/*:143*/
//line 4581 "./o2externs.w"

}
/*:142*//*148:*/
//line 4948 "./o2externs.w"

void OP_GRAMMAR_CPP(TOKEN_GAGGLE&Error_queue){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
string fn(fsm_ph->filename_id()->identifier()->c_str());
fn+= Suffix_fsmimp;
std::ofstream Op_file;
Op_file.open(fn.c_str(),ios_base::out|ios::trunc);
if(!Op_file){
CAbs_lr1_sym*sym= new Err_bad_fsmcpp_filename(fn.c_str());
sym->set_line_no_and_pos_in_line(*fsm_ph->filename_id());
sym->set_who_created("o2externs.w - OP_GRAMMAR_CPP",__LINE__);
Error_queue.push_back(*sym);
return;
}

intro_comment(Op_file,fn.c_str());
fsm_cpp_includes(Op_file);
using_ns_for_fsm_cpp(Op_file);
rules_reuse_table_implementation(Op_file);
fsm_class_implementation(Op_file);
rules_subrules_implementations(Op_file);
Op_file.close();
}

/*:148*//*150:*/
//line 4992 "./o2externs.w"

void user_imp_sym
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
SDC_MAP_type*dir_map= fsm_class->directives_map();
SDC_MAP_ITER_type i= dir_map->find(SDC_user_imp_sym);
if(i!=dir_map->end()){
T_user_imp_sym* ui = (T_user_imp_sym*)i->second;
Op_str<<ui->syntax_code()->syntax_code()->c_str();
Op_str<<endl;
}
}
/*:150*//*151:*/
//line 5009 "./o2externs.w"

void thread_implementation
(std::ofstream&Op_str){
T_parallel_parser_phrase*pp_ph= O2_PP_PHASE;
if(pp_ph==0){
Op_str<<"// monolithic grammar --- no thread"<<endl;
return;
}
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
T_rules_phrase*rules_ph= O2_RULES_PHASE;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP thread_definition= 
"yacco2::THR _YACCO2_CALL_TYPE\n"
"%s::%s(yacco2::Parser* Caller_pp){\n"
"  yacco2::Thread_entry& pp_thread_entry = I%s;\n"
"  %s::%s %s_;// parallel-parser's parse table\n"
"#define ssPARSE_TABLE %s_\n"
"#include \"wpp_core.h\"\n"
"}";

int x= sprintf(big_buf_
,thread_definition
,fsm_ph->namespace_id()->identifier()->c_str()
,pp_ph->pp_funct()->identifier()->identifier()->c_str()
,pp_ph->pp_funct()->identifier()->identifier()->c_str()
,fsm_ph->namespace_id()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;

KCHARP proc_thread_definition= 
"THR_result _YACCO2_CALL_TYPE\n"
"%s::PROC_%s(yacco2::Parser* Caller_pp){\n"
"  char called_proc_name[] = \"PROC_%s\";\n"
"  static bool one_time(false);\n"
"  static %s::%s* %s_%s_(0);// parallel-parser's fsm table\n"
"  static Parser* %s_%s_parser(0);\n"
"  Parser* proc_parser(0);\n"
"  if(one_time == false){\n"
"    one_time = true;\n"
"    %s_%s_ = new %s::%s();// parallel-parser's fsm table\n"
"    %s_%s_parser = new Parser(*%s_%s_,Caller_pp);\n"
"  }\n"
" proc_parser = %s_%s_parser;\n"
"#include \"wproc_pp_core.h\"\n"
"}";

x= sprintf(big_buf_
,proc_thread_definition
,fsm_ph->namespace_id()->identifier()->c_str()
,pp_ph->pp_funct()->identifier()->identifier()->c_str()
,pp_ph->pp_funct()->identifier()->identifier()->c_str()
,fsm_ph->namespace_id()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()
,fsm_ph->namespace_id()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()

,fsm_ph->namespace_id()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()

,fsm_ph->namespace_id()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()
,fsm_ph->namespace_id()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()

,fsm_ph->namespace_id()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()
,fsm_ph->namespace_id()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()

,fsm_ph->namespace_id()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:151*//*152:*/
//line 5092 "./o2externs.w"

void fsm_reduce_rhs_of_rule_implementation
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
T_rules_phrase*rules_ph= O2_RULES_PHASE;
char big_buf_[BIG_BUFFER_32K];

KCHARP reduce_rhs_of_rule_hdr= 
"void \n"
"%s::reduce_rhs_of_rule\n"
"    (yacco2::UINT Sub_rule_no,yacco2::Rule_s_reuse_entry** Recycled_rule){\n"
"   int reducing_rule = rhs_to_rules_mapping_[Sub_rule_no];\n"
"   Per_rule_s_reuse_table* rule_reuse_tbl_ptr = \n"
"        fsm_rules_reuse_table.per_rule_s_table_[reducing_rule];\n"
"   Rule_s_reuse_entry* re(0);\n"
"   find_a_recycled_rule(rule_reuse_tbl_ptr,&re);\n"
"   (*Recycled_rule) = re;\n"
"   fnd_re: switch (Sub_rule_no){";
int x= sprintf(big_buf_
,reduce_rhs_of_rule_hdr
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
/*153:*/
//line 5121 "./o2externs.w"

RULE_DEFS_TBL_ITER_type i= rules_ph->crt_order()->begin();
RULE_DEFS_TBL_ITER_type ie= rules_ph->crt_order()->end();
for(;i!=ie;++i){
rule_def*rd= *i;
/*154:*/
//line 5175 "./o2externs.w"

const char*rule_s_ctor= "// no rule's constructor directive";
T_rule_lhs_phrase*rlhs= rd->rule_lhs();
if(rlhs!=0){
SDC_MAP_type*rdlhs_map= rlhs->lhs_directives_map();
if(rdlhs_map!=0){
SDC_MAP_ITER_type kkk= rdlhs_map->find(SDC_constructor);
if(kkk!=rdlhs_map->end()){
T_constructor* cc = (T_constructor*)kkk->second;
rule_s_ctor= "sym->ctor();\n";
}
}
}

T_subrules_phrase*sr_ph= rd->subrules();
SUBRULE_DEFS_ITER_type j= sr_ph->subrules()->begin();
SUBRULE_DEFS_ITER_type je= sr_ph->subrules()->end();
KCHARP case_stmt_parta= 
"    case rhs%i_%s_:{\n"
"       %s* sym;\n"
"     if(re->rule_ == 0){\n"
"       sym = new %s(parser__);\n"
"       re->rule_ = sym;\n"
"     }else{\n"
"       sym = (%s*)re->rule_;\n"
"     }\n"
"    %s\n"
"     (*Recycled_rule)->rule_ = sym;\n"
"     sym->rule_info__.rhs_no_of_parms__ = %i;\n"
"    \n";
KCHARP case_stmt_partb= "     sym->sr%i();";
KCHARP case_stmt_partc= "     return;}";
for(;j!=je;++j){
T_subrule_def*srd= *j;

int no_parms= srd->no_of_elems()-1;

AST*sr_t= srd->subrule_s_tree();
set<int> eos_filter;
eos_filter.insert(T_Enum::T_T_called_thread_eosubrule_);
eos_filter.insert(T_Enum::T_T_null_call_thread_eosubrule_);
tok_can_ast_functor walk_the_plank_mate;
ast_prefix_1forest eos_walk
(*sr_t,&walk_the_plank_mate,&eos_filter,ACCEPT_FILTER);
tok_can<AST*> eos_can(eos_walk);
for(int xxx= 0;eos_can.operator[](xxx)!=yacco2::PTR_LR1_eog__;++xxx);
if(eos_can.empty()==false)--no_parms;

int x= sprintf(big_buf_
,case_stmt_parta
,srd->subrule_no_of_rule()
,rd->rule_name()->c_str()
,rd->rule_name()->c_str()
,rd->rule_name()->c_str()
,rd->rule_name()->c_str()
,rule_s_ctor
,no_parms);
Op_str.write(big_buf_,x);
Op_str<<endl;

SDC_MAP_type*sdrmap= srd->subrule_directives();

if(!sdrmap->empty()){
int x= sprintf(big_buf_,case_stmt_partb,srd->subrule_no_of_rule());
Op_str.write(big_buf_,x);
Op_str<<endl;
}


if(rd->rule_lhs()!=0){
SDC_MAP_type*xxrdmap= rd->rule_lhs()->lhs_directives_map();
if(xxrdmap!=0){
SDC_MAP_ITER_type kkk= xxrdmap->find(SDC_op);
if(kkk!=xxrdmap->end()){
Op_str<<"     sym->op();"<<endl;
}
}
}
Op_str<<case_stmt_partc<<endl;
}



/*:154*/
//line 5126 "./o2externs.w"

}
KCHARP default_case_and_end_sw= 
"    default: return;\n"
"   }";
Op_str<<default_case_and_end_sw<<endl;

KCHARP end_rtn= 
"}";
Op_str<<end_rtn<<endl;

/*:153*/
//line 5117 "./o2externs.w"

}

/*:152*//*155:*/
//line 5259 "./o2externs.w"

void OP_GRAMMAR_SYM(TOKEN_GAGGLE&Error_queue){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
string fn(fsm_ph->filename_id()->identifier()->c_str());
fn+= Suffix_fsmsym;
std::ofstream Op_file;
Op_file.open(fn.c_str(),ios_base::out|ios::trunc);
if(!Op_file){
CAbs_lr1_sym*sym= new Err_bad_fsmsym_filename(fn.c_str());
sym->set_line_no_and_pos_in_line(*fsm_ph->filename_id());
sym->set_who_created("o2externs.w - OP_GRAMMAR_CPP",__LINE__);
Error_queue.push_back(*sym);
return;
}

intro_comment(Op_file,fn.c_str());
user_imp_sym(Op_file);
fsm_cpp_includes(Op_file);
using_ns_for_fsm_cpp(Op_file);
thread_implementation(Op_file);

fsm_reduce_rhs_of_rule_implementation(Op_file);
Op_file.close();
}

/*:155*//*157:*/
//line 5308 "./o2externs.w"

void user_imp_tbl
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
SDC_MAP_type*dir_map= fsm_class->directives_map();
SDC_MAP_ITER_type i= dir_map->find(SDC_user_imp_tbl);
if(i!=dir_map->end()){
T_user_imp_tbl* ui = (T_user_imp_tbl*)i->second;
Op_str<<ui->syntax_code()->syntax_code()->c_str();
Op_str<<endl;
}
}

/*:157*//*158:*/
//line 5323 "./o2externs.w"

void output_la_sets
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
char big_buf_[BIG_BUFFER_32K];

COMMON_LA_SETS_ITER_type i= COMMON_LA_SETS.begin();
COMMON_LA_SETS_ITER_type ie= COMMON_LA_SETS.end();
for(int idx= 0;i!=ie;++i,++idx){
LA_SET_type*la_set= *i;
/*159:*/
//line 5340 "./o2externs.w"

KCHARP la_set_entry_literal= 
"// %s";
LA_SET_ITER_type j= la_set->begin();
LA_SET_ITER_type je= la_set->end();
for(;j!=je;++j){
T_in_stbl*tsym= *j;
int x= sprintf(big_buf_
,la_set_entry_literal
,tsym->t_def()->classsym()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
/*:159*/
//line 5334 "./o2externs.w"

/*160:*/
//line 5364 "./o2externs.w"

KCHARP la_set_hdr= 
"yacco2::UCHAR LA%i_%s[] ={";
int x= sprintf(big_buf_
,la_set_hdr
,idx+1
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
/*161:*/
//line 5378 "./o2externs.w"

BIT_MAP_type paired_set;
LA_SET_ITER_type k= la_set->begin();
LA_SET_ITER_type ke= la_set->end();
int en_no(-1);
for(;k!=ke;++k){
T_in_stbl*T= *k;
en_no= T->t_def()->enum_id();

int Q= en_no/NO_BITS_PER_SET_PARTITION;
int R= en_no%NO_BITS_PER_SET_PARTITION;
int One(1);
int E_v= One<<R;
BIT_MAP_ITER_type e= paired_set.find(Q);
if(e==paired_set.end()){
paired_set[Q]= E_v;
}else{
int se= e->second;
int v= se+E_v;
e->second= v;
}
}

/*:161*/
//line 5374 "./o2externs.w"

/*162:*/
//line 5402 "./o2externs.w"

KCHARP no_la_set_entries= 
"%i";
x= sprintf(big_buf_
,no_la_set_entries
,paired_set.size()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
BIT_MAP_ITER_type kl= paired_set.begin();
BIT_MAP_ITER_type kle= paired_set.end();
for(;kl!=kle;++kl){
int part_no= kl->first;
int e_v= kl->second;
KCHARP la_set_entry= 
",%i,%i";
x= sprintf(big_buf_
,la_set_entry
,part_no
,e_v
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
KCHARP la_set_hdr_end= 
"};";
Op_str<<la_set_hdr_end<<endl;


/*:162*/
//line 5375 "./o2externs.w"


/*:160*/
//line 5335 "./o2externs.w"

}
}
/*:158*//*163:*/
//line 5432 "./o2externs.w"

void externs_and_thread_tbl_defs
(std::ofstream&Op_str){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();

char big_buf_[BIG_BUFFER_32K];
STATES_ITER_type i= LR1_STATES.begin();
STATES_ITER_type ie= LR1_STATES.end();
int state_cnt(0);
for(;i!=ie;++i){
state*s= *i;
++state_cnt;
KCHARP state_extern= 
"extern yacco2::State S%i_%s;";
int x= sprintf(big_buf_
,state_extern
,state_cnt
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
/*164:*/
//line 5460 "./o2externs.w"

using namespace NS_yacco2_T_enum;
if(s->vectored_into_by_elem_sym_==0)continue;
switch(s->vectored_into_by_elem_){
case LR1_PARALLEL_OPERATOR:{
/*165:*/
//line 5477 "./o2externs.w"

string ar_name;
rule_def*ar_s_rule_s_name(0);
int no_of_threads(0);
S_VECTORS_ITER_type j= s->state_s_vector_.begin();
S_VECTORS_ITER_type je= s->state_s_vector_.end();
for(;j!=je;++j){
S_VECTOR_ELEMS_type&elem_list= j->second;
S_VECTOR_ELEMS_ITER_type k= elem_list.begin();
S_VECTOR_ELEMS_ITER_type ke= elem_list.end();
for(;k!=ke;++k){
state_element*se= *k;

if(se->next_state_element_==0)continue;
CAbs_lr1_sym*sym= AST::content(*AST::brother(*se->sr_element_));
if(sym->enumerated_id__!=T_Enum::T_T_called_thread_eosubrule_)continue;
rule_def*rd= se->subrule_def_->its_rule_def();
RULES_HAVING_AR_ITER_type ai= RULES_HAVING_AR.find(rd);
if(ai!=RULES_HAVING_AR.end()){
ar_s_rule_s_name= rd;
}
++no_of_threads;
}
}
if(ar_s_rule_s_name!=0){
ar_name+= "AR_";
ar_name+= ar_s_rule_s_name->rule_name()->c_str();
}

/*:165*/
//line 5465 "./o2externs.w"

/*166:*/
//line 5513 "./o2externs.w"

if(no_of_threads> 0){
KCHARP state_s_thread_tbl_def= 
"struct S%ittd_%s{\n"
" yacco2::USINT no_entries_;\n"
" yacco2::Type_pp_fnct_ptr ar_fnct_ptr_;\n"
" yacco2::ULINT (*thd_id_bit_map_ptr__)[];\n"
" yacco2::Thread_entry* thread_entries_[%i];\n"
"};";
int x= sprintf(big_buf_
,state_s_thread_tbl_def
,state_cnt
,fsm_class->identifier()->identifier()->c_str()
,no_of_threads
);
Op_str.write(big_buf_,x);
Op_str<<endl;
/*168:*/
//line 5613 "./o2externs.w"

if(ar_name.empty()==true)
ar_name+= "0";


/*:168*/
//line 5530 "./o2externs.w"

KCHARP state_s_thread_tbl_imp= 
"S%ittd_%s S%itt_%s = {\n"
"  %i // no of threads\n"
" ,%s //AR_rulename or 0\n"
" ,0// ptr to thread id bit map";
x= sprintf(big_buf_
,state_s_thread_tbl_imp
,state_cnt
,fsm_class->identifier()->identifier()->c_str()
,state_cnt
,fsm_class->identifier()->identifier()->c_str()
,no_of_threads
,ar_name.c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
j= s->state_s_vector_.begin();
je= s->state_s_vector_.end();
for(;j!=je;++j){
S_VECTOR_ELEMS_type&elem_list= j->second;
S_VECTOR_ELEMS_ITER_type k= elem_list.begin();
S_VECTOR_ELEMS_ITER_type ke= elem_list.end();
for(;k!=ke;++k){
state_element*se= *k;
if(se->next_state_element_==0)continue;
CAbs_lr1_sym*sym= AST::content(*AST::brother(*se->sr_element_));
if(sym->enumerated_id__==T_Enum::T_T_called_thread_eosubrule_){
T_called_thread_eosubrule* called_th = (T_called_thread_eosubrule*)sym;
KCHARP state_s_thread_tbl_entry= 
" ,(yacco2::Thread_entry*)&I%s";
int x= sprintf(big_buf_
,state_s_thread_tbl_entry
,called_th->called_thread_name()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}
}
KCHARP state_s_thread_tbl_end= 
"};";
Op_str<<state_s_thread_tbl_end<<endl;
}
/*:166*/
//line 5466 "./o2externs.w"

break;
}
default:continue;
}

/*:164*/
//line 5454 "./o2externs.w"

}
}
/*:163*//*169:*/
//line 5620 "./o2externs.w"

const char*determine_shift_element_name(CAbs_lr1_sym*Sym){
switch(Sym->enumerated_id__){
case T_Enum::T_T_terminal_def_:{
T_terminal_def* td = (T_terminal_def*)Sym;
return td->classsym()->c_str();
}
case T_Enum::T_rule_def_:{
rule_def* rd = (rule_def*)Sym;
return rd->rule_name()->c_str();
}
}
return"element not found";
}

/*:169*//*170:*/
//line 5642 "./o2externs.w"

void output_1st_state_s_shift_table(std::ofstream&Op_str,state&State){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
T_rules_phrase*rules_ph= O2_RULES_PHASE;
rule_def*s_rule= (*rules_ph->crt_order())[0];
int s_rule_enum_no= s_rule->enum_id();
char big_buf_[BIG_BUFFER_32K];
S_VECTORS_ITER_type svi;
S_VECTORS_ITER_type svie;
/*176:*/
//line 5810 "./o2externs.w"

int no_of_shift_items(0);
svi= State.state_s_vector_.begin();
svie= State.state_s_vector_.end();
for(;svi!=svie;++svi){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int cur_se_enum_no= svi->first;
/*178:*/
//line 5882 "./o2externs.w"

if(cur_se_enum_no>=0){
}else{
switch(cur_se_enum_no){
case-T_Enum::T_T_eosubrule_:{
if(se->next_state_element_==0)continue;
if(se->previous_state_element_==0)continue;
break;
}
default:{
break;
}
}
}

/*:178*/
//line 5818 "./o2externs.w"

++no_of_shift_items;
}

/*:176*/
//line 5652 "./o2externs.w"

++no_of_shift_items;
bool first_or_2nd_prt(false);
bool accept_prted(false);
/*173:*/
//line 5745 "./o2externs.w"

KCHARP def_of_state_s_shift_entries= 
"struct S%istd_%s{\n"
"  yacco2::USINT no_entries_;\n"
"  yacco2::Shift_entry shift_entries_[%i];\n"
"};";
int x= sprintf(big_buf_
,def_of_state_s_shift_entries
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,no_of_shift_items
);
Op_str.write(big_buf_,x);
Op_str<<endl;
KCHARP imp_of_state_s_shift_entries_begin= 
"S%istd_%s S%ist_%s = {\n"
" %i\n"
" ,\n"
"  {// start of table";
x= sprintf(big_buf_
,imp_of_state_s_shift_entries_begin
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,no_of_shift_items
);
Op_str.write(big_buf_,x);
Op_str<<endl;

/*:173*/
//line 5656 "./o2externs.w"

svi= State.state_s_vector_.begin();
svie= State.state_s_vector_.end();
for(;svi!=svie;++svi){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int cur_se_enum_no= svi->first;
/*178:*/
//line 5882 "./o2externs.w"

if(cur_se_enum_no>=0){
}else{
switch(cur_se_enum_no){
case-T_Enum::T_T_eosubrule_:{
if(se->next_state_element_==0)continue;
if(se->previous_state_element_==0)continue;
break;
}
default:{
break;
}
}
}

/*:178*/
//line 5663 "./o2externs.w"

int goto_state_no= se->goto_state_->state_no_;
const char*shift_elem_literal= determine_shift_element_name(se->sr_def_element_);
if(cur_se_enum_no<s_rule_enum_no){
/*171:*/
//line 5684 "./o2externs.w"

if(first_or_2nd_prt==false){
first_or_2nd_prt= true;
KCHARP imp_of_state_s_shift_1st_entry= 
"   {%i,(State*)&S%i_%s} // shift sym: %s";
int x= sprintf(big_buf_
,imp_of_state_s_shift_1st_entry
,cur_se_enum_no
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
,shift_elem_literal
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
else{
KCHARP imp_of_state_s_shift_2nd_entry= 
"   ,{%i,(State*)&S%i_%s} // shift sym: %s";
int x= sprintf(big_buf_
,imp_of_state_s_shift_2nd_entry
,cur_se_enum_no
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
,shift_elem_literal
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:171*/
//line 5667 "./o2externs.w"

}else{
if(accept_prted==false){
accept_prted= true;
/*172:*/
//line 5715 "./o2externs.w"

if(first_or_2nd_prt==false){
first_or_2nd_prt= true;
KCHARP imp_of_state_s_shift_1st_entry= 
"   {%i,(State*)&S%i_%s} // accept sym: %s";
int x= sprintf(big_buf_
,imp_of_state_s_shift_1st_entry
,s_rule_enum_no
,1
,fsm_class->identifier()->identifier()->c_str()
,s_rule->rule_name()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
else{
KCHARP imp_of_state_s_shift_1st_entry= 
"   ,{%i,(State*)&S%i_%s} // accept sym: %s";
int x= sprintf(big_buf_
,imp_of_state_s_shift_1st_entry
,s_rule_enum_no
,1
,fsm_class->identifier()->identifier()->c_str()
,s_rule->rule_name()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:172*/
//line 5671 "./o2externs.w"

}
/*171:*/
//line 5684 "./o2externs.w"

if(first_or_2nd_prt==false){
first_or_2nd_prt= true;
KCHARP imp_of_state_s_shift_1st_entry= 
"   {%i,(State*)&S%i_%s} // shift sym: %s";
int x= sprintf(big_buf_
,imp_of_state_s_shift_1st_entry
,cur_se_enum_no
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
,shift_elem_literal
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
else{
KCHARP imp_of_state_s_shift_2nd_entry= 
"   ,{%i,(State*)&S%i_%s} // shift sym: %s";
int x= sprintf(big_buf_
,imp_of_state_s_shift_2nd_entry
,cur_se_enum_no
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
,shift_elem_literal
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:171*/
//line 5673 "./o2externs.w"

}
}
if(accept_prted==false){
accept_prted= true;
/*172:*/
//line 5715 "./o2externs.w"

if(first_or_2nd_prt==false){
first_or_2nd_prt= true;
KCHARP imp_of_state_s_shift_1st_entry= 
"   {%i,(State*)&S%i_%s} // accept sym: %s";
int x= sprintf(big_buf_
,imp_of_state_s_shift_1st_entry
,s_rule_enum_no
,1
,fsm_class->identifier()->identifier()->c_str()
,s_rule->rule_name()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
else{
KCHARP imp_of_state_s_shift_1st_entry= 
"   ,{%i,(State*)&S%i_%s} // accept sym: %s";
int x= sprintf(big_buf_
,imp_of_state_s_shift_1st_entry
,s_rule_enum_no
,1
,fsm_class->identifier()->identifier()->c_str()
,s_rule->rule_name()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:172*/
//line 5678 "./o2externs.w"

}
/*174:*/
//line 5776 "./o2externs.w"

KCHARP imp_of_shift_entries_end= 
"  }// end of shift table\n"
"};";
Op_str<<imp_of_shift_entries_end<<endl;

/*:174*/
//line 5680 "./o2externs.w"

}

/*:170*//*175:*/
//line 5783 "./o2externs.w"

void output_all_others_state_s_shift_table(std::ofstream&Op_str,state&State){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
char big_buf_[BIG_BUFFER_32K];
bool first_or_2nd_prt(false);
S_VECTORS_ITER_type svi;
S_VECTORS_ITER_type svie;
/*176:*/
//line 5810 "./o2externs.w"

int no_of_shift_items(0);
svi= State.state_s_vector_.begin();
svie= State.state_s_vector_.end();
for(;svi!=svie;++svi){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int cur_se_enum_no= svi->first;
/*178:*/
//line 5882 "./o2externs.w"

if(cur_se_enum_no>=0){
}else{
switch(cur_se_enum_no){
case-T_Enum::T_T_eosubrule_:{
if(se->next_state_element_==0)continue;
if(se->previous_state_element_==0)continue;
break;
}
default:{
break;
}
}
}

/*:178*/
//line 5818 "./o2externs.w"

++no_of_shift_items;
}

/*:176*/
//line 5791 "./o2externs.w"

if(no_of_shift_items){
/*173:*/
//line 5745 "./o2externs.w"

KCHARP def_of_state_s_shift_entries= 
"struct S%istd_%s{\n"
"  yacco2::USINT no_entries_;\n"
"  yacco2::Shift_entry shift_entries_[%i];\n"
"};";
int x= sprintf(big_buf_
,def_of_state_s_shift_entries
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,no_of_shift_items
);
Op_str.write(big_buf_,x);
Op_str<<endl;
KCHARP imp_of_state_s_shift_entries_begin= 
"S%istd_%s S%ist_%s = {\n"
" %i\n"
" ,\n"
"  {// start of table";
x= sprintf(big_buf_
,imp_of_state_s_shift_entries_begin
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,no_of_shift_items
);
Op_str.write(big_buf_,x);
Op_str<<endl;

/*:173*/
//line 5793 "./o2externs.w"

S_VECTORS_ITER_type svi= State.state_s_vector_.begin();
S_VECTORS_ITER_type svie= State.state_s_vector_.end();
for(;svi!=svie;++svi){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int cur_se_enum_no= svi->first;
/*178:*/
//line 5882 "./o2externs.w"

if(cur_se_enum_no>=0){
}else{
switch(cur_se_enum_no){
case-T_Enum::T_T_eosubrule_:{
if(se->next_state_element_==0)continue;
if(se->previous_state_element_==0)continue;
break;
}
default:{
break;
}
}
}

/*:178*/
//line 5800 "./o2externs.w"

int goto_state_no= se->goto_state_->state_no_;
const char*shift_elem_literal= determine_shift_element_name(se->sr_def_element_);
/*171:*/
//line 5684 "./o2externs.w"

if(first_or_2nd_prt==false){
first_or_2nd_prt= true;
KCHARP imp_of_state_s_shift_1st_entry= 
"   {%i,(State*)&S%i_%s} // shift sym: %s";
int x= sprintf(big_buf_
,imp_of_state_s_shift_1st_entry
,cur_se_enum_no
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
,shift_elem_literal
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
else{
KCHARP imp_of_state_s_shift_2nd_entry= 
"   ,{%i,(State*)&S%i_%s} // shift sym: %s";
int x= sprintf(big_buf_
,imp_of_state_s_shift_2nd_entry
,cur_se_enum_no
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
,shift_elem_literal
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:171*/
//line 5803 "./o2externs.w"

}
/*174:*/
//line 5776 "./o2externs.w"

KCHARP imp_of_shift_entries_end= 
"  }// end of shift table\n"
"};";
Op_str<<imp_of_shift_entries_end<<endl;

/*:174*/
//line 5805 "./o2externs.w"

}
}

/*:175*//*179:*/
//line 5898 "./o2externs.w"

void output_meta_shifts_separately(std::ofstream&Op_str,state&State){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
char big_buf_[BIG_BUFFER_32K];
S_VECTORS_ITER_type svi= State.state_s_vector_.find(LR1_PARALLEL_OPERATOR);
S_VECTORS_ITER_type svie= State.state_s_vector_.end();
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP parallel_entry= 
"yacco2::Shift_entry S%ipse_%s = {%i,(State*)&S%i_%s};";
int x= sprintf(big_buf_
,parallel_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,LR1_PARALLEL_OPERATOR
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
svi= State.state_s_vector_.find(LR1_INVISIBLE_SHIFT_OPERATOR);
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP invisible_shift_entry= 
"yacco2::Shift_entry S%iise_%s = {%i,(State*)&S%i_%s};";
int x= sprintf(big_buf_
,invisible_shift_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,LR1_INVISIBLE_SHIFT_OPERATOR
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
svi= State.state_s_vector_.find(LR1_ALL_SHIFT_OPERATOR);
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP all_shift_entry= 
"yacco2::Shift_entry S%iase_%s = {%i,(State*)&S%i_%s};";
int x= sprintf(big_buf_
,all_shift_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,LR1_ALL_SHIFT_OPERATOR
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
svi= State.state_s_vector_.find(LR1_FSET_TRANSIENCE_OPERATOR);
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP procedure_call_entry= 
"yacco2::Shift_entry S%ipcse_%s = {%i,(State*)&S%i_%s};";
int x= sprintf(big_buf_
,procedure_call_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,LR1_FSET_TRANSIENCE_OPERATOR
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
svi= State.state_s_vector_.find(LR1_QUESTIONABLE_SHIFT_OPERATOR);
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP questionable_shift_entry= 
"yacco2::Shift_entry S%iqse_%s = {%i,(State*)&S%i_%s};";
int x= sprintf(big_buf_
,questionable_shift_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,LR1_QUESTIONABLE_SHIFT_OPERATOR
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

}

/*:179*//*180:*/
//line 5998 "./o2externs.w"

void output_state_s_reduced_table(std::ofstream&Op_str,state&State){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
char big_buf_[BIG_BUFFER_32K];
/*181:*/
//line 6017 "./o2externs.w"

int no_of_reduces(0);
S_VECTORS_ITER_type j= State.state_s_vector_.begin();
S_VECTORS_ITER_type je= State.state_s_vector_.end();
for(;j!=je;++j){
int cur_se_enum_no= j->first;
S_VECTOR_ELEMS_ITER_type seli= j->second.begin();
state_element*se= *seli;
if(cur_se_enum_no>=0)break;
switch(cur_se_enum_no){
case-T_Enum::T_T_eosubrule_:{
if(se->next_state_element_==0){
no_of_reduces+= j->second.size();
continue;
}
}
}
}

/*:181*/
//line 6003 "./o2externs.w"

/*182:*/
//line 6037 "./o2externs.w"

if(no_of_reduces> 0){
KCHARP reduce_def= 
"struct S%irtd_%s{\n"
" yacco2::USINT no_entries_;\n"
" yacco2::Reduce_entry reduce_entries_[%i];\n"
"};";
int x= sprintf(big_buf_
,reduce_def
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,no_of_reduces
);
Op_str.write(big_buf_,x);
Op_str<<endl;
KCHARP reduce_imp_begin= 
"S%irtd_%s S%irt_%s = {\n"
" %i\n"
" ,\n"
" {// start of table";
x= sprintf(big_buf_
,reduce_imp_begin
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,no_of_reduces
);
Op_str.write(big_buf_,x);
Op_str<<endl;
/*183:*/
//line 6074 "./o2externs.w"

j= State.state_s_vector_.begin();
je= State.state_s_vector_.end();
int reduce_no(-1);
for(;j!=je;++j){
int cur_se_enum_no= j->first;
if(cur_se_enum_no>=0)break;
S_VECTOR_ELEMS_type&elem_list= j->second;
S_VECTOR_ELEMS_ITER_type k= elem_list.begin();
S_VECTOR_ELEMS_ITER_type ke= elem_list.end();
for(;k!=ke;++k){
++reduce_no;
state_element*se= *k;
if(reduce_no==0){
KCHARP reduce_imp_1st_entry= 
"  {(Set_tbl*)&LA%i_%s,%s::rhs%i_%s_}";
int x= sprintf(big_buf_
,reduce_imp_1st_entry
,se->common_la_set_idx_+1
,fsm_class->identifier()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()
,se->subrule_def_->subrule_no_of_rule()
,se->subrule_def_->its_rule_def()->rule_name()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}else{
KCHARP reduce_imp_2nd_entry= 
"  ,{(Set_tbl*)&LA%i_%s,%s::rhs%i_%s_}";
int x= sprintf(big_buf_
,reduce_imp_2nd_entry
,se->common_la_set_idx_+1
,fsm_class->identifier()->identifier()->c_str()
,fsm_class->identifier()->identifier()->c_str()
,se->subrule_def_->subrule_no_of_rule()
,se->subrule_def_->its_rule_def()->rule_name()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}
}

/*:183*/
//line 6067 "./o2externs.w"

KCHARP reduce_imp_end= 
" }// end of reduce table\n"
"};";
Op_str<<reduce_imp_end<<endl;
}
/*:182*/
//line 6004 "./o2externs.w"

}

/*:180*//*184:*/
//line 6118 "./o2externs.w"

void output_state_s_called_threads_table(std::ofstream&Op_str,state&State){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
char big_buf_[BIG_BUFFER_32K];
KCHARP call_thread_table_imp= 
"yacco2::Shift_entry S%ipse_%s = \n"
"{%i,(State*)&S%i_%s};\n";
}

/*:184*//*185:*/
//line 6129 "./o2externs.w"

void output_state_s_called_procedure_table(std::ofstream&Op_str,state&State){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
char big_buf_[BIG_BUFFER_32K];
KCHARP call_thread_table_imp= 
"yacco2::Shift_entry S%ipcse_%s = \n"
"{%i,(State*)&S%i_%s};\n";
}
/*:185*//*186:*/
//line 6139 "./o2externs.w"

void output_questionable_shift(std::ofstream&Op_str,state&State){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
char big_buf_[BIG_BUFFER_32K];
S_VECTORS_ITER_type svi= State.state_s_vector_.find(LR1_PARALLEL_OPERATOR);
S_VECTORS_ITER_type svie= State.state_s_vector_.end();
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP parallel_entry= 
"yacco2::Shift_entry S%ipse_%s = {%i,(State*)&S%i_%s};";
int x= sprintf(big_buf_
,parallel_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,LR1_PARALLEL_OPERATOR
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
svi= State.state_s_vector_.find(LR1_INVISIBLE_SHIFT_OPERATOR);
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP invisible_shift_entry= 
"yacco2::Shift_entry S%iise_%s = {%i,(State*)&S%i_%s};";
int x= sprintf(big_buf_
,invisible_shift_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,LR1_INVISIBLE_SHIFT_OPERATOR
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
svi= State.state_s_vector_.find(LR1_ALL_SHIFT_OPERATOR);
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP all_shift_entry= 
"yacco2::Shift_entry S%iase_%s = {%i,(State*)&S%i_%s};";
int x= sprintf(big_buf_
,all_shift_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,LR1_ALL_SHIFT_OPERATOR
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
svi= State.state_s_vector_.find(LR1_FSET_TRANSIENCE_OPERATOR);
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP procedure_call_entry= 
"yacco2::Shift_entry S%ipcse_%s = {%i,(State*)&S%i_%s};";
int x= sprintf(big_buf_
,procedure_call_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,LR1_FSET_TRANSIENCE_OPERATOR
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
svi= State.state_s_vector_.find(LR1_QUESTIONABLE_SHIFT_OPERATOR);
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP questionable_shift_entry= 
"yacco2::Shift_entry S%iise_%s = {%i,(State*)&S%i_%s};";
int x= sprintf(big_buf_
,questionable_shift_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,LR1_QUESTIONABLE_SHIFT_OPERATOR
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}

/*:186*//*187:*/
//line 6242 "./o2externs.w"

void output_lr_state(std::ofstream&Op_str,state&State){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
T_fsm_class_phrase*fsm_class= fsm_ph->fsm_class_phrase();
char big_buf_[BIG_BUFFER_32K];
KCHARP state_entry= 
"yacco2::State S%i_%s = //State's vectored into symbol: \"%s\" \n"
"{%i";
int x= sprintf(big_buf_
,state_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
,State.entry_symbol_literal()
,State.state_no_
);
Op_str.write(big_buf_,x);
Op_str<<endl;

/*188:*/
//line 6274 "./o2externs.w"

S_VECTORS_ITER_type svi= State.state_s_vector_.find(LR1_PARALLEL_OPERATOR);
S_VECTORS_ITER_type svie= State.state_s_vector_.end();
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP parallel_entry= 
",(Shift_entry*)&S%ipse_%s";
int x= sprintf(big_buf_
,parallel_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
}else{
Op_str<<",0";
}

/*:188*/
//line 6260 "./o2externs.w"

/*189:*/
//line 6294 "./o2externs.w"

svi= State.state_s_vector_.find(LR1_ALL_SHIFT_OPERATOR);
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP all_shift_entry= 
",(Shift_entry*)&S%iase_%s";
int x= sprintf(big_buf_
,all_shift_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}else{
Op_str<<",0";
}

/*:189*/
//line 6261 "./o2externs.w"

/*190:*/
//line 6314 "./o2externs.w"

svi= State.state_s_vector_.find(LR1_INVISIBLE_SHIFT_OPERATOR);
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP invisible_shift_entry= 
",(Shift_entry*)&S%iise_%s";
int x= sprintf(big_buf_
,invisible_shift_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}else{
Op_str<<",0";
}

/*:190*/
//line 6262 "./o2externs.w"

/*191:*/
//line 6334 "./o2externs.w"

svi= State.state_s_vector_.find(LR1_FSET_TRANSIENCE_OPERATOR);
svie= State.state_s_vector_.end();
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP procedure_call_entry= 
",(Shift_entry*)&S%ipcse_%s";
int x= sprintf(big_buf_
,procedure_call_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
}else{
Op_str<<",0";
}

/*:191*/
//line 6263 "./o2externs.w"

/*193:*/
//line 6375 "./o2externs.w"

/*176:*/
//line 5810 "./o2externs.w"

int no_of_shift_items(0);
svi= State.state_s_vector_.begin();
svie= State.state_s_vector_.end();
for(;svi!=svie;++svi){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int cur_se_enum_no= svi->first;
/*178:*/
//line 5882 "./o2externs.w"

if(cur_se_enum_no>=0){
}else{
switch(cur_se_enum_no){
case-T_Enum::T_T_eosubrule_:{
if(se->next_state_element_==0)continue;
if(se->previous_state_element_==0)continue;
break;
}
default:{
break;
}
}
}

/*:178*/
//line 5818 "./o2externs.w"

++no_of_shift_items;
}

/*:176*/
//line 6376 "./o2externs.w"

if(no_of_shift_items> 0){
KCHARP shift_entry= 
",(Shift_tbl*)&S%ist_%s";
int x= sprintf(big_buf_
,shift_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
}else{
Op_str<<",0";
}


/*:193*/
//line 6264 "./o2externs.w"

/*194:*/
//line 6392 "./o2externs.w"

/*181:*/
//line 6017 "./o2externs.w"

int no_of_reduces(0);
S_VECTORS_ITER_type j= State.state_s_vector_.begin();
S_VECTORS_ITER_type je= State.state_s_vector_.end();
for(;j!=je;++j){
int cur_se_enum_no= j->first;
S_VECTOR_ELEMS_ITER_type seli= j->second.begin();
state_element*se= *seli;
if(cur_se_enum_no>=0)break;
switch(cur_se_enum_no){
case-T_Enum::T_T_eosubrule_:{
if(se->next_state_element_==0){
no_of_reduces+= j->second.size();
continue;
}
}
}
}

/*:181*/
//line 6393 "./o2externs.w"

if(no_of_reduces> 0){
KCHARP reduce_entry= 
",(Reduce_tbl*)&S%irt_%s";
int x= sprintf(big_buf_
,reduce_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);

}else{
Op_str<<",0";
}
/*:194*/
//line 6265 "./o2externs.w"

/*195:*/
//line 6410 "./o2externs.w"

svi= State.state_s_vector_.find(LR1_PARALLEL_OPERATOR);
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
if(se->next_state_element_->goto_state_==0){
Op_str<<",0";
}else{
int goto_state_no= se->goto_state_->state_no_;
KCHARP thread_calls_entry= 
",(State_s_thread_tbl*)&S%itt_%s";
int x= sprintf(big_buf_
,thread_calls_entry
,goto_state_no
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);

}
}else{
Op_str<<",0";
}

/*:195*/
//line 6266 "./o2externs.w"

/*196:*/
//line 6436 "./o2externs.w"

svi= State.state_s_vector_.find(LR1_FSET_TRANSIENCE_OPERATOR);
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
if(se->next_state_element_->goto_state_==0){
Op_str<<",0";
}else{
/*167:*/
//line 5582 "./o2externs.w"

S_VECTORS_ITER_type j= se->goto_state_->state_s_vector_.begin();
S_VECTORS_ITER_type je= se->goto_state_->state_s_vector_.end();
for(;j!=je;++j){
S_VECTOR_ELEMS_type&elem_list= j->second;
S_VECTOR_ELEMS_ITER_type k= elem_list.begin();
S_VECTOR_ELEMS_ITER_type ke= elem_list.end();
for(;k!=ke;++k){
state_element*se= *k;
if(se->next_state_element_==0)continue;
AST*bypassed_thd_eos_t= AST::brother(*se->sr_element_);
CAbs_lr1_sym*sym= AST::content(*bypassed_thd_eos_t);
if(sym->enumerated_id__==T_Enum::T_T_called_thread_eosubrule_){
T_called_thread_eosubrule* called_th = (T_called_thread_eosubrule*)sym;
KCHARP state_s_thread_tbl_entry= 
",(yacco2::Type_pc_fnct_ptr)&%s::%s";
int x= sprintf(big_buf_
,state_s_thread_tbl_entry
,called_th->ns()->identifier()->c_str()
,called_th->called_thread_name()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
}
}
}

/*:167*/
//line 6444 "./o2externs.w"

}
}else{
Op_str<<",0";
}

/*:196*/
//line 6267 "./o2externs.w"

/*192:*/
//line 6354 "./o2externs.w"

svi= State.state_s_vector_.find(LR1_QUESTIONABLE_SHIFT_OPERATOR);
if(svi!=svie){
S_VECTOR_ELEMS_ITER_type seli= svi->second.begin();
state_element*se= *seli;
int goto_state_no= se->goto_state_->state_no_;
KCHARP questionable_shift_entry= 
",(Shift_entry*)&S%iqse_%s";
int x= sprintf(big_buf_
,questionable_shift_entry
,State.state_no_
,fsm_class->identifier()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}else{
Op_str<<",0";
}


/*:192*/
//line 6268 "./o2externs.w"

Op_str<<"};"<<endl;
}


/*:187*//*197:*/
//line 6457 "./o2externs.w"

void emit_each_lr_state_s_tables(std::ofstream&Op_str){
STATES_ITER_type si= LR1_STATES.begin();
STATES_ITER_type sie= LR1_STATES.end();
for(;si!=sie;++si){
state*cur_state= *si;
if(cur_state->state_no_==1){
output_1st_state_s_shift_table(Op_str,*cur_state);
}else{
output_all_others_state_s_shift_table(Op_str,*cur_state);
}
output_meta_shifts_separately(Op_str,*cur_state);
output_state_s_reduced_table(Op_str,*cur_state);
output_state_s_called_threads_table(Op_str,*cur_state);
output_state_s_called_procedure_table(Op_str,*cur_state);
output_lr_state(Op_str,*cur_state);
}
}
/*:197*//*198:*/
//line 6476 "./o2externs.w"

void OP_GRAMMAR_TBL(TOKEN_GAGGLE&Error_queue){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
string fn(fsm_ph->filename_id()->identifier()->c_str());
fn+= Suffix_fsmtbl;
std::ofstream Op_file;
Op_file.open(fn.c_str(),ios_base::out|ios::trunc);
if(!Op_file){
CAbs_lr1_sym*sym= new Err_bad_fsmtbl_filename(fn.c_str());
sym->set_line_no_and_pos_in_line(*fsm_ph->filename_id());
sym->set_who_created("o2externs.w - OP_GRAMMAR_CPP",__LINE__);
Error_queue.push_back(*sym);
return;
}

intro_comment(Op_file,fn.c_str());
user_imp_tbl(Op_file);
fsm_cpp_includes(Op_file);
using_ns_for_fsm_cpp(Op_file);
output_la_sets(Op_file);
externs_and_thread_tbl_defs(Op_file);
emit_each_lr_state_s_tables(Op_file);
Op_file.close();
}

/*:198*//*200:*/
//line 6522 "./o2externs.w"

void enumerate_lrk
(std::ofstream&Op_str){
T_lr1_k_phrase*ph= O2_LRK_PHASE;
std::vector<T_terminal_def*> *dictionary= ph->crt_order();

char big_buf_[BIG_BUFFER_32K];
KCHARP enumerate_item= 
"   ,T_%s_ = %i";
std::vector<T_terminal_def*> ::iterator i= dictionary->begin();
std::vector<T_terminal_def*> ::iterator ie= dictionary->end();
for(;i!=ie;++i){
T_terminal_def*td= *i;
int x= sprintf(big_buf_
,enumerate_item
,td->classsym()->c_str()
,td->enum_id()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}

/*:200*//*201:*/
//line 6549 "./o2externs.w"

void enumerate_rc
(std::ofstream&Op_str){
T_rc_phrase*ph= O2_RC_PHASE;
std::vector<T_terminal_def*> *dictionary= ph->crt_order();
char big_buf_[BIG_BUFFER_32K];
KCHARP enumerate_item= 
"   ,T_%s_ = %i";
std::vector<T_terminal_def*> ::iterator i= dictionary->begin();
std::vector<T_terminal_def*> ::iterator ie= dictionary->end();
for(;i!=ie;++i){
T_terminal_def*td= *i;
int x= sprintf(big_buf_
,enumerate_item
,td->classsym()->c_str()
,td->enum_id()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}

/*:201*//*202:*/
//line 6575 "./o2externs.w"

void enumerate_errors
(std::ofstream&Op_str){
T_error_symbols_phrase*ph= O2_ERROR_PHASE;
std::vector<T_terminal_def*> *dictionary= ph->crt_order();
char big_buf_[BIG_BUFFER_32K];
KCHARP enumerate_item= 
"   ,T_%s_ = %i";
std::vector<T_terminal_def*> ::iterator i= dictionary->begin();
std::vector<T_terminal_def*> ::iterator ie= dictionary->end();
for(;i!=ie;++i){
T_terminal_def*td= *i;

int x= sprintf(big_buf_
,enumerate_item
,td->classsym()->c_str()
,td->enum_id()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}
/*:202*//*203:*/
//line 6601 "./o2externs.w"

void enumerate_T
(std::ofstream&Op_str){
T_terminals_phrase*ph= O2_T_PHASE;
std::vector<T_terminal_def*> *dictionary= ph->crt_order();
char big_buf_[BIG_BUFFER_32K];
KCHARP enumerate_item= 
"   ,T_%s_ = %i";
std::vector<T_terminal_def*> ::iterator i= dictionary->begin();
std::vector<T_terminal_def*> ::iterator ie= dictionary->end();
for(;i!=ie;++i){
T_terminal_def*td= *i;
int x= sprintf(big_buf_
,enumerate_item
,td->classsym()->c_str()
,td->enum_id()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}

/*:203*//*204:*/
//line 6624 "./o2externs.w"

void enumeration_summary_for_struct
(std::ofstream&Op_str){
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP summary= 
"   sum_total_T = %i\n"
"   ,no_of_terminals = %i\n"
"   ,no_of_raw_chars = %i\n"
"   ,no_of_lr1_constants = %i\n"
"   ,no_of_error_terminals = %i\n"
"   ,start_LRK=%i,end_LRK=%i\n"
"   ,start_RC=%i,end_RC=%i\n"
"   ,start_T=%i,end_T=%i\n"
"   ,start_ERR=%i,end_ERR=%i\n"
"   ,start_R=%i";
int x= sprintf(big_buf_
,summary
,enum_ph->total_enumerate()
,enum_ph->total_T_enumerate()
,enum_ph->total_rc_enumerate()
,enum_ph->total_lrk_enumerate()
,enum_ph->total_err_enumerate()
,enum_ph->start_lrk_enumerate(),enum_ph->stop_lrk_enumerate()
,enum_ph->start_rc_enumerate(),enum_ph->stop_rc_enumerate()
,enum_ph->start_T_enumerate(),enum_ph->stop_T_enumerate()
,enum_ph->start_err_enumerate(),enum_ph->stop_err_enumerate()
,enum_ph->total_enumerate()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:204*//*205:*/
//line 6658 "./o2externs.w"

void enumeration_define_list
(std::ofstream&Op_str){
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP enum_list_start= 
"  enum enumerated_terminals%s{";
int x= sprintf(big_buf_
,enum_list_start," "
);
Op_str.write(big_buf_,x);
Op_str<<endl;

enumeration_summary_for_struct(Op_str);
enumerate_lrk(Op_str);
enumerate_rc(Op_str);
enumerate_T(Op_str);
enumerate_errors(Op_str);

KCHARP enum_list_end= 
"  }; // close defining enum list";
Op_str<<enum_list_end<<endl;
}

/*:205*//*206:*/
//line 6683 "./o2externs.w"

void enumeration_define_structure
(std::ofstream&Op_str){
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP struct_start= 
" struct T_Enum%s{";
int x= sprintf(big_buf_
,struct_start," "
);
Op_str.write(big_buf_,x);
Op_str<<endl;

enumeration_define_list(Op_str);
KCHARP struct_end= 
" }; // close defining T_enum";
Op_str<<struct_end<<endl;
}
/*:206*//*207:*/
//line 6702 "./o2externs.w"

void enumeration_namespace_for_header
(std::ofstream&Op_str){
using namespace NS_yacco2_terminals;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP ns_of_enum_start= 
"namespace %s {";
int x= sprintf(big_buf_
,ns_of_enum_start
,enum_ph->namespace_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;

enumeration_define_structure(Op_str);
KCHARP ns_of_enum_end= 
"} // end of namespace";
Op_str<<ns_of_enum_end<<endl;
}

/*:207*//*208:*/
//line 6724 "./o2externs.w"

void enumeration_include_guard_for_header
(std::ofstream&Op_str){
using namespace NS_yacco2_terminals;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP signal_guard_start= 
"#ifndef __%s_h__\n"
"#define __%s_h__ 1";
int x= sprintf(big_buf_
,signal_guard_start
,enum_ph->filename_id()->identifier()->c_str()
,enum_ph->filename_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
enumeration_namespace_for_header(Op_str);
KCHARP signal_guard_end= 
"#endif";
Op_str<<signal_guard_end<<endl;
}
/*:208*//*209:*/
//line 6746 "./o2externs.w"

void gen_Tes_literals_per_spec_voc
(std::ofstream&Op_str
,std::vector<T_terminal_def*> ::iterator I
,std::vector<T_terminal_def*> ::iterator IE){
char big_buf_[BIG_BUFFER_32K];

KCHARP literal= 
"%s";
for(;I!=IE;++I){
T_terminal_def*td= *I;
int x= sprintf(big_buf_
,literal
,td->classsym()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}
/*:209*//*210:*/
//line 6766 "./o2externs.w"

void gen_Tes_literals
(std::ofstream&Op_str){
T_terminals_phrase*pht= O2_T_PHASE;
T_rc_phrase*phrc= O2_RC_PHASE;
T_error_symbols_phrase*phe= O2_ERROR_PHASE;
T_lr1_k_phrase*phlr= O2_LRK_PHASE;

char big_buf_[BIG_BUFFER_32K];
KCHARP t_alphabet= 
"T-alphabet%s";
int x= sprintf(big_buf_,t_alphabet," ");
Op_str.write(big_buf_,x);
Op_str<<endl;
gen_Tes_literals_per_spec_voc(Op_str,phlr->crt_order()->begin(),phlr->crt_order()->end());
gen_Tes_literals_per_spec_voc(Op_str,phrc->crt_order()->begin(),phrc->crt_order()->end());
gen_Tes_literals_per_spec_voc(Op_str,pht->crt_order()->begin(),pht->crt_order()->end());
gen_Tes_literals_per_spec_voc(Op_str,phe->crt_order()->begin(),phe->crt_order()->end());
KCHARP end_t_alphabet= 
"end-T-alphabet%s";
x= sprintf(big_buf_,end_t_alphabet," ");
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:210*//*211:*/
//line 6819 "./o2externs.w"

void OP_ENUMERATION_HEADER(TOKEN_GAGGLE&Error_queue){
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
string fn(enum_ph->filename_id()->identifier()->c_str());
fn+= Suffix_enumeration_hdr;
std::ofstream Op_file;
Op_file.open(fn.c_str(),ios_base::out|ios::trunc);
if(!Op_file){
CAbs_lr1_sym*sym= new Err_bad_enum_filename(fn.c_str());
sym->set_line_no_and_pos_in_line(*enum_ph->filename_id());
sym->set_who_created("o2externs.w - OP_ENUMERATION_HEADER_CPP",__LINE__);
Error_queue.push_back(*sym);
return;
}

intro_comment(Op_file,fn.c_str());
enumeration_include_guard_for_header(Op_file);
Op_file.close();
}

/*:211*//*212:*/
//line 6847 "./o2externs.w"

void OP_T_Alphabet(TOKEN_GAGGLE&Error_queue){
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
string fn_literal(enum_ph->filename_id()->identifier()->c_str());
fn_literal+= Suffix_t_alphabet;
std::ofstream Op_file;
Op_file.open(fn_literal.c_str(),ios_base::out|ios::trunc);
if(!Op_file){
CAbs_lr1_sym*sym= new Err_bad_enum_filename(fn_literal.c_str());
sym->set_line_no_and_pos_in_line(*enum_ph->filename_id());
sym->set_who_created("o2externs.w - OP_ENUMERATION_HEADER_CPP",__LINE__);
Error_queue.push_back(*sym);
return;
}
intro_comment(Op_file,fn_literal.c_str());
gen_Tes_literals(Op_file);
Op_file.close();
}

/*:212*//*214:*/
//line 6880 "./o2externs.w"

void errors_loop_thru_and_gen_defs_for_header
(std::ofstream&Op_str){
T_error_symbols_phrase*errors_ph= O2_ERROR_PHASE;

std::vector<T_terminal_def*> *dictionary= errors_ph->crt_order();
char big_buf_[BIG_BUFFER_32K];
KCHARP def_item= 
"  struct %s:public yacco2::CAbs_lr1_sym{\n"
"%s";

std::vector<T_terminal_def*> ::iterator i= dictionary->begin();
std::vector<T_terminal_def*> ::iterator ie= dictionary->end();
for(;i!=ie;++i){
T_terminal_def*td= *i;
SDC_MAP_type*sdc_map= td->directives_map();
SDC_MAP_ITER_type j= sdc_map->find(SDC_user_declaration);
if(j==sdc_map->end()){
KCHARP shell_of_def_item= 
"  struct %s:public yacco2::CAbs_lr1_sym{\n"
"    %s();\n"
"  };";
int x= sprintf(big_buf_
,shell_of_def_item
,td->classsym()->c_str()
,td->classsym()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}else{
T_user_declaration*gw_sdc= (T_user_declaration*)j->second;
int x= sprintf(big_buf_
,def_item
,td->classsym()->c_str()
,gw_sdc->syntax_code()->syntax_code()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;

j= sdc_map->find(SDC_op);
if(j!=sdc_map->end()){
Op_str<<"  op();"<<endl;
}
j= sdc_map->find(SDC_destructor);
if(j!=sdc_map->end()){
KCHARP dtor= 
"  static void dtor_%s(yacco2::VOIDP This,yacco2::VOIDP P);\n";
int x= sprintf(big_buf_
,dtor
,td->classsym()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
Op_str<<"  };"<<endl;
}
}
}

/*:214*//*215:*/
//line 6940 "./o2externs.w"

void errors_use_enum_namespace_for_header
(std::ofstream&Op_str){
T_error_symbols_phrase*errors_ph= O2_ERROR_PHASE;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;

char big_buf_[BIG_BUFFER_32K];
KCHARP using_T_namespace= 
"  using namespace %s;";
int x= sprintf(big_buf_
,using_T_namespace
,enum_ph->namespace_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:215*//*216:*/
//line 6958 "./o2externs.w"

void errors_namespace_for_header
(std::ofstream&Op_str){
T_error_symbols_phrase*errors_ph= O2_ERROR_PHASE;

char big_buf_[BIG_BUFFER_32K];
KCHARP namespace_start= 
"namespace %s{";
int x= sprintf(big_buf_
,namespace_start
,errors_ph->namespace_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
errors_use_enum_namespace_for_header(Op_str);
errors_loop_thru_and_gen_defs_for_header(Op_str);

KCHARP namespace_end= 
"}//namespace";
Op_str<<namespace_end<<endl;
}

/*:216*//*217:*/
//line 6981 "./o2externs.w"

void errors_include_guard_for_header
(std::ofstream&Op_str){
T_error_symbols_phrase*errors_ph= O2_ERROR_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP signal_guard_start= 
"#ifndef __%s_h__\n"
"#define __%s_h__ 1";
int x= sprintf(big_buf_
,signal_guard_start
,errors_ph->filename_id()->identifier()->c_str()
,errors_ph->filename_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
errors_namespace_for_header(Op_str);
KCHARP signal_guard_end= 
"#endif";
Op_str<<signal_guard_end<<endl;
}

/*:217*//*218:*/
//line 7003 "./o2externs.w"

void errors_include_files_for_header
(std::ofstream&Op_str){
T_error_symbols_phrase*errors_ph= O2_ERROR_PHASE;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
T_lr1_k_phrase*lr_ph= O2_LRK_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP include_files= 
"#include \"%s\"\n"
"#include \"%s%s\"\n"
"#include \"%s%s\"";
int x= sprintf(big_buf_
,include_files
,O2_library_file
,enum_ph->filename_id()->identifier()->c_str()
,Suffix_enumeration_hdr
,lr_ph->filename_id()->identifier()->c_str()
,Suffix_LRK_hdr
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:218*//*219:*/
//line 7028 "./o2externs.w"

void OP_ERRORS_HEADER(TOKEN_GAGGLE&Error_queue){
T_error_symbols_phrase*errors_ph= O2_ERROR_PHASE;
string fn(errors_ph->filename_id()->identifier()->c_str());
fn+= Suffix_Errors_hdr;
std::ofstream Op_file;
Op_file.open(fn.c_str(),ios_base::out|ios::trunc);
if(!Op_file){
CAbs_lr1_sym*sym= new Err_bad_errors_hdrfilename(fn.c_str());
sym->set_line_no_and_pos_in_line(*errors_ph->filename_id());
sym->set_who_created("o2externs.w - OP_ERRORS_HEADER_CPP",__LINE__);
Error_queue.push_back(*sym);
return;
}

intro_comment(Op_file,fn.c_str());
errors_include_files_for_header(Op_file);
errors_include_guard_for_header(Op_file);
Op_file.close();
}

/*:219*//*221:*/
//line 7059 "./o2externs.w"

void errors_imp_dtor
(std::ofstream&Op_str,T_terminal_def*Td,SDC_MAP_ITER_type&J){
char big_buf_[BIG_BUFFER_32K];
T_destructor*dtor_t= (T_destructor*)J->second;
KCHARP dtor_code= 
"void %s::dtor_%s(yacco2::VOIDP This,yacco2::VOIDP P){\n"
" bool ABORT_STATUS = ((yacco2::Parser*)P)->top_stack_record()->aborted__;\n"
" %s* R = (%s*)(This);\n"
" %s\n"
"}";
KCHARP dtor_code_noabort= 
"void %s::dtor_%s(yacco2::VOIDP This,yacco2::VOIDP P){\n"
" %s* R = (%s*)(This);\n"
" %s\n"
"}";
std::string::size_type r= 
dtor_t->syntax_code()->syntax_code()->find("ABORT_STATUS");
int x(0);
if(r!=std::string::npos){
x= sprintf(big_buf_
,dtor_code
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,dtor_t->syntax_code()->syntax_code()->c_str()
);
}else{
x= sprintf(big_buf_
,dtor_code_noabort
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,dtor_t->syntax_code()->syntax_code()->c_str()
);
}
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:221*//*222:*/
//line 7102 "./o2externs.w"

void errors_imp_implementation
(std::ofstream&Op_str,T_terminal_def*Td,SDC_MAP_ITER_type&J){
char big_buf_[BIG_BUFFER_32K];
T_user_implementation*imp_t= (T_user_implementation*)J->second;
Op_str<<imp_t->syntax_code()->syntax_code()->c_str();
SDC_MAP_type*sdc_map= Td->directives_map();
SDC_MAP_ITER_type j= sdc_map->find(SDC_destructor);
if(j!=sdc_map->end()){
errors_imp_dtor(Op_str,Td,j);
}
}

/*:222*//*223:*/
//line 7116 "./o2externs.w"

void errors_imp_shellimplementation
(std::ofstream&Op_str,T_terminal_def*Td,std::string&Autodelete,std::string&Autoabort){
char big_buf_[BIG_BUFFER_32K];
KCHARP shell_of_def_item= 
"%s::\n"
"%s()\n"
" T_CTOR(\"%s\",T_Enum::T_%s_,%s,%s,%s){}";
int x= sprintf(big_buf_
,shell_of_def_item
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,Td->t_name()->c_str()
,Td->classsym()->c_str()
,"0"
,Autodelete.c_str()
,Autoabort.c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:223*//*224:*/
//line 7139 "./o2externs.w"

void errors_loop_thru_and_gen_defs_for_imp
(std::ofstream&Op_str){
T_error_symbols_phrase*errors_ph= O2_ERROR_PHASE;
std::vector<T_terminal_def*> *dictionary= errors_ph->crt_order();
char big_buf_[BIG_BUFFER_32K];
string auto_delete;
string auto_abort;
string dtor_adr;

std::vector<T_terminal_def*> ::iterator i= dictionary->begin();
std::vector<T_terminal_def*> ::iterator ie= dictionary->end();
for(;i!=ie;++i){
T_terminal_def*td= *i;
SDC_MAP_type*sdc_map= td->directives_map();
SDC_MAP_ITER_type j= sdc_map->find(SDC_user_implementation);
if(td->autodelete()==false){
auto_delete= "false";
}else{
auto_delete= "true";
}
if(td->autoabort()==false){
auto_abort= "false";
}else{
auto_abort= "true";
}

if(j==sdc_map->end()){
errors_imp_shellimplementation(Op_str,td,auto_delete,auto_abort);
}else{
errors_imp_implementation(Op_str,td,j);
}
}
}

/*:224*//*225:*/
//line 7175 "./o2externs.w"

void errors_use_enum_namespace_for_imp
(std::ofstream&Op_str){
T_error_symbols_phrase*errors_ph= O2_ERROR_PHASE;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;

char big_buf_[BIG_BUFFER_32K];
KCHARP using_namespace= 
"  using namespace %s;\n"
"  using namespace %s;";
int x= sprintf(big_buf_
,using_namespace
,errors_ph->namespace_id()->identifier()->c_str()
,enum_ph->namespace_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:225*//*226:*/
//line 7195 "./o2externs.w"

void errors_include_files_for_imp
(std::ofstream&Op_str){
T_error_symbols_phrase*errors_ph= O2_ERROR_PHASE;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
T_lr1_k_phrase*lr_ph= O2_LRK_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP include_files= 
"#include \"%s%s\"";
int x= sprintf(big_buf_
,include_files
,errors_ph->filename_id()->identifier()->c_str()
,Suffix_Errors_hdr
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:226*//*227:*/
//line 7215 "./o2externs.w"

void OP_ERRORS_CPP(TOKEN_GAGGLE&Error_queue){
T_error_symbols_phrase*errors_ph= O2_ERROR_PHASE;
string fn(errors_ph->filename_id()->identifier()->c_str());
fn+= Suffix_Errors_imp;
std::ofstream Op_file;
Op_file.open(fn.c_str(),ios_base::out|ios::trunc);
if(!Op_file){
CAbs_lr1_sym*sym= new Err_bad_errors_impfilename(fn.c_str());
sym->set_line_no_and_pos_in_line(*errors_ph->filename_id());
sym->set_who_created("o2externs.w - OP_ERRORS_HEADER_CPP",__LINE__);
Error_queue.push_back(*sym);
return;
}

intro_comment(Op_file,fn.c_str());
errors_include_files_for_imp(Op_file);
errors_use_enum_namespace_for_imp(Op_file);
errors_loop_thru_and_gen_defs_for_imp(Op_file);
Op_file.close();
}
/*:227*//*229:*/
//line 7250 "./o2externs.w"

void user_t_loop_thru_and_gen_defs_for_header
(std::ofstream&Op_str){
T_terminals_phrase*t_ph= O2_T_PHASE;

std::vector<T_terminal_def*> *dictionary= t_ph->crt_order();
char big_buf_[BIG_BUFFER_32K];
KCHARP def_item= 
"  struct %s:public yacco2::CAbs_lr1_sym{\n"
"%s";

std::vector<T_terminal_def*> ::iterator i= dictionary->begin();
std::vector<T_terminal_def*> ::iterator ie= dictionary->end();
for(;i!=ie;++i){
T_terminal_def*td= *i;
SDC_MAP_type*sdc_map= td->directives_map();
SDC_MAP_ITER_type j= sdc_map->find(SDC_user_declaration);
if(j==sdc_map->end()){
KCHARP shell_of_def_item= 
"  struct %s:public yacco2::CAbs_lr1_sym{\n"
"    %s();\n"
"  };";
int x= sprintf(big_buf_
,shell_of_def_item
,td->classsym()->c_str()
,td->classsym()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}else{
T_user_declaration*gw_sdc= (T_user_declaration*)j->second;
int x= sprintf(big_buf_
,def_item
,td->classsym()->c_str()
,gw_sdc->syntax_code()->syntax_code()->c_str()
);
Op_str.write(big_buf_,x);


j= sdc_map->find(SDC_op);
if(j!=sdc_map->end()){
Op_str<<"  op();"<<endl;
}
j= sdc_map->find(SDC_destructor);
if(j!=sdc_map->end()){
KCHARP dtor= 
"  static void dtor_%s(yacco2::VOIDP This,yacco2::VOIDP P);";
int x= sprintf(big_buf_
,dtor
,td->classsym()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
Op_str<<"  };"<<endl;
}
}
}

/*:229*//*230:*/
//line 7310 "./o2externs.w"

void user_t_use_enum_namespace_for_header
(std::ofstream&Op_str){
T_terminals_phrase*t_ph= O2_T_PHASE;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;

char big_buf_[BIG_BUFFER_32K];
KCHARP using_T_namespace= 
"  using namespace %s;";
int x= sprintf(big_buf_
,using_T_namespace
,enum_ph->namespace_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:230*//*231:*/
//line 7328 "./o2externs.w"

void user_t_terminals_refs_for_header
(std::ofstream&Op_str){
T_terminals_phrase*t_ph= O2_T_PHASE;
char big_buf_[BIG_BUFFER_32K];
if(t_ph->terminals_refs_code()!=0){
KCHARP t_ref_code= 
"  %s";
int x= sprintf(big_buf_
,t_ref_code
,t_ph->terminals_refs_code()->syntax_code()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}

/*:231*//*232:*/
//line 7346 "./o2externs.w"

void user_t_terminals_sufx_for_header
(std::ofstream&Op_str){
T_terminals_phrase*t_ph= O2_T_PHASE;
char big_buf_[BIG_BUFFER_32K];
if(t_ph->terminals_sufx_code()!=0){
KCHARP t_sufx_code= 
"  %s";
int x= sprintf(big_buf_
,t_sufx_code
,t_ph->terminals_sufx_code()->syntax_code()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}
}

/*:232*//*233:*/
//line 7364 "./o2externs.w"

void user_t_namespace_for_header
(std::ofstream&Op_str){
T_terminals_phrase*t_ph= O2_T_PHASE;

char big_buf_[BIG_BUFFER_32K];
KCHARP namespace_start= 
"namespace %s{";
int x= sprintf(big_buf_
,namespace_start
,t_ph->namespace_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
user_t_use_enum_namespace_for_header(Op_str);
user_t_terminals_refs_for_header(Op_str);
user_t_loop_thru_and_gen_defs_for_header(Op_str);
user_t_terminals_sufx_for_header(Op_str);

KCHARP namespace_end= 
"}//namespace";
Op_str<<namespace_end<<endl;
}

/*:233*//*234:*/
//line 7389 "./o2externs.w"

void user_t_include_guard_for_header
(std::ofstream&Op_str){
T_terminals_phrase*t_ph= O2_T_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP signal_guard_start= 
"#ifndef __%s_h__\n"
"#define __%s_h__ 1";
int x= sprintf(big_buf_
,signal_guard_start
,t_ph->filename_id()->identifier()->c_str()
,t_ph->filename_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
user_t_namespace_for_header(Op_str);
KCHARP signal_guard_end= 
"#endif";
Op_str<<signal_guard_end<<endl;
}

/*:234*//*235:*/
//line 7411 "./o2externs.w"

void user_t_include_files_for_header
(std::ofstream&Op_str){
T_terminals_phrase*t_ph= O2_T_PHASE;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
T_lr1_k_phrase*lr_ph= O2_LRK_PHASE;
T_error_symbols_phrase*errors_ph= O2_ERROR_PHASE;

char big_buf_[BIG_BUFFER_32K];
KCHARP include_files= 
"#include \"%s\"\n"
"#include \"%s%s\"\n"
"#include \"%s%s\"\n"
"#include \"%s%s\"";
int x= sprintf(big_buf_
,include_files
,O2_library_file
,enum_ph->filename_id()->identifier()->c_str()
,Suffix_enumeration_hdr
,lr_ph->filename_id()->identifier()->c_str()
,Suffix_LRK_hdr
,errors_ph->filename_id()->identifier()->c_str()
,Suffix_Errors_hdr
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:235*//*236:*/
//line 7441 "./o2externs.w"

void OP_USER_T_HEADER(TOKEN_GAGGLE&Error_queue){
T_terminals_phrase*t_ph= O2_T_PHASE;
string fn(t_ph->filename_id()->identifier()->c_str());
fn+= Suffix_T_hdr;
std::ofstream Op_file;
Op_file.open(fn.c_str(),ios_base::out|ios::trunc);
if(!Op_file){
CAbs_lr1_sym*sym= new Err_bad_errors_hdrfilename(fn.c_str());
sym->set_line_no_and_pos_in_line(*t_ph->filename_id());
sym->set_who_created("o2externs.w - OP_USER_T_HEADER_CPP",__LINE__);
Error_queue.push_back(*sym);
return;
}

intro_comment(Op_file,fn.c_str());
user_t_include_files_for_header(Op_file);
user_t_include_guard_for_header(Op_file);
Op_file.close();
}

/*:236*//*238:*/
//line 7474 "./o2externs.w"

void user_t_imp_dtor
(std::ofstream&Op_str,T_terminal_def*Td,SDC_MAP_ITER_type&J){
char big_buf_[BIG_BUFFER_32K];
T_destructor*dtor_t= (T_destructor*)J->second;
KCHARP dtor_code= 
"void %s::dtor_%s(yacco2::VOIDP This,yacco2::VOIDP P){\n"
" bool ABORT_STATUS = ((yacco2::Parser*)P)->top_stack_record()->aborted__;\n"
" %s* R = (%s*)(This);\n"
" %s\n"
"}";
KCHARP dtor_code_noabort= 
"void %s::dtor_%s(yacco2::VOIDP This,yacco2::VOIDP P){\n"
" %s* R = (%s*)(This);\n"
" %s\n"
"}";
std::string::size_type r= 
dtor_t->syntax_code()->syntax_code()->find("ABORT_STATUS");
int x(0);
if(r!=std::string::npos){
x= sprintf(big_buf_
,dtor_code
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,dtor_t->syntax_code()->syntax_code()->c_str()
);
}else{
x= sprintf(big_buf_
,dtor_code_noabort
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,dtor_t->syntax_code()->syntax_code()->c_str()
);
}
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:238*//*239:*/
//line 7517 "./o2externs.w"

void user_t_imp_implementation
(std::ofstream&Op_str,T_terminal_def*Td,SDC_MAP_ITER_type&J){
char big_buf_[BIG_BUFFER_32K];
T_user_implementation*imp_t= (T_user_implementation*)J->second;
Op_str<<imp_t->syntax_code()->syntax_code()->c_str();
SDC_MAP_type*sdc_map= Td->directives_map();
SDC_MAP_ITER_type j= sdc_map->find(SDC_destructor);
if(j!=sdc_map->end()){
errors_imp_dtor(Op_str,Td,j);
}
}

/*:239*//*240:*/
//line 7531 "./o2externs.w"

void user_t_imp_shellimplementation
(std::ofstream&Op_str,T_terminal_def*Td,std::string&Autodelete,std::string&Autoabort){
char big_buf_[BIG_BUFFER_32K];
KCHARP shell_of_def_item= 
"%s::\n"
"%s()\n"
" T_CTOR(\"%s\",T_Enum::T_%s_,%s,%s,%s){}";
int x= sprintf(big_buf_
,shell_of_def_item
,Td->classsym()->c_str()
,Td->classsym()->c_str()
,Td->t_name()->c_str()
,Td->classsym()->c_str()
,"0"
,Autodelete.c_str()
,Autoabort.c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:240*//*241:*/
//line 7554 "./o2externs.w"

void user_t_loop_thru_and_gen_defs_for_imp
(std::ofstream&Op_str){
T_terminals_phrase*t_ph= O2_T_PHASE;

std::vector<T_terminal_def*> *dictionary= t_ph->crt_order();
char big_buf_[BIG_BUFFER_32K];
string auto_delete;
string auto_abort;
string dtor_adr;

std::vector<T_terminal_def*> ::iterator i= dictionary->begin();
std::vector<T_terminal_def*> ::iterator ie= dictionary->end();
for(;i!=ie;++i){
T_terminal_def*td= *i;
SDC_MAP_type*sdc_map= td->directives_map();
SDC_MAP_ITER_type j= sdc_map->find(SDC_user_implementation);
if(td->autodelete()==false){
auto_delete= "false";
}else{
auto_delete= "true";
}
if(td->autoabort()==false){
auto_abort= "false";
}else{
auto_abort= "true";
}

if(j==sdc_map->end()){
user_t_imp_shellimplementation(Op_str,td,auto_delete,auto_abort);
}else{
user_t_imp_implementation(Op_str,td,j);
}
}
}

/*:241*//*242:*/
//line 7591 "./o2externs.w"

void user_t_use_enum_namespace_for_imp
(std::ofstream&Op_str){
T_terminals_phrase*t_ph= O2_T_PHASE;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;

char big_buf_[BIG_BUFFER_32K];
KCHARP using_namespace= 
"  using namespace %s;\n"
"  using namespace %s;";
int x= sprintf(big_buf_
,using_namespace
,t_ph->namespace_id()->identifier()->c_str()
,enum_ph->namespace_id()->identifier()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:242*//*243:*/
//line 7611 "./o2externs.w"

void user_t_include_files_for_imp
(std::ofstream&Op_str){
T_terminals_phrase*t_ph= O2_T_PHASE;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
T_lr1_k_phrase*lr_ph= O2_LRK_PHASE;
char big_buf_[BIG_BUFFER_32K];
KCHARP include_files= 
"#include \"%s%s\"";
int x= sprintf(big_buf_
,include_files
,t_ph->filename_id()->identifier()->c_str()
,Suffix_T_hdr
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:243*//*244:*/
//line 7631 "./o2externs.w"

void OP_USER_T_CPP(TOKEN_GAGGLE&Error_queue){
T_terminals_phrase*t_ph= O2_T_PHASE;
string fn(t_ph->filename_id()->identifier()->c_str());
fn+= Suffix_Errors_imp;
std::ofstream Op_file;
Op_file.open(fn.c_str(),ios_base::out|ios::trunc);
if(!Op_file){
CAbs_lr1_sym*sym= new Err_bad_errors_impfilename(fn.c_str());
sym->set_line_no_and_pos_in_line(*t_ph->filename_id());
sym->set_who_created("o2externs.w - OP_USER_T_CPP",__LINE__);
Error_queue.push_back(*sym);
return;
}

intro_comment(Op_file,fn.c_str());
user_t_include_files_for_imp(Op_file);
user_t_use_enum_namespace_for_imp(Op_file);
user_t_loop_thru_and_gen_defs_for_imp(Op_file);
Op_file.close();
}

/*:244*//*246:*/
//line 7664 "./o2externs.w"

void fsc_prelude_imp
(std::ofstream&Op_str,std::string&Fn){
KCHARP pp_thd_nm(0);
string transitive("n");
string mono;
char big_buf_[BIG_BUFFER_32K];
T_fsm_phrase*fcp= O2_FSM_PHASE;
T_parallel_parser_phrase*ppp= O2_PP_PHASE;
T_enum_phrase*enum_ph= O2_T_ENUM_PHASE;
T_rules_phrase*rules_ph= O2_RULES_PHASE;

RULE_DEFS_TBL_ITER_type i= rules_ph->crt_order()->begin();
RULE_DEFS_TBL_ITER_type ie= rules_ph->crt_order()->end();
rule_def*rd= *i;
FIRST_SET_type*fs= rd->first_set();
FIRST_SET_ITER_type j= fs->begin();
FIRST_SET_ITER_type je= fs->end();
for(;j!=je;++j){
T_in_stbl*tintbl= *j;
T_terminal_def*tdef= tintbl->t_def();
if(tdef->enum_id()==LR1_PARALLEL_OPERATOR){
transitive[0]= 'y';
break;
}
}

KCHARP fsc_prelude= 
"transitive   %s\n"
"grammar-name \"%s\"\n"
"name-space   \"%s\"\n"
"thread-name  \"%s\"\n"
"monolithic   %s\n"
"file-name    \"%s\"\n"
"no-of-T      %i";
if(ppp==0){
pp_thd_nm= fcp->fsm_class_phrase()->identifier()->identifier()->c_str();
mono+= 'y';
}else{
pp_thd_nm= ppp->pp_funct()->identifier()->identifier()->c_str();
mono+= 'n';
}
int x= sprintf(big_buf_
,fsc_prelude
,transitive.c_str()
,fcp->filename_id()->identifier()->c_str()
,fcp->namespace_id()->identifier()->c_str()
,pp_thd_nm
,mono.c_str()
,Fn.c_str()
,enum_ph->total_enumerate()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:246*//*248:*/
//line 7793 "./o2externs.w"

void list_of_native_Tes_in_fs_imp
(std::ofstream&Op_str){
char big_buf_[BIG_BUFFER_32K];
int no_Tes_in_list(0);
string Tes_in_list;


STATES_ITER_type si= LR1_STATES.begin();
state*cur_state= *si;
int no_of_Tes_in_fs(0);
std::set<CAbs_lr1_sym*> fs_set;

T_rules_phrase*rules_ph= O2_RULES_PHASE;
RULE_DEFS_TBL_ITER_type i= rules_ph->crt_order()->begin();
RULE_DEFS_TBL_ITER_type ie= rules_ph->crt_order()->end();
rule_def*rd= *i;
FIRST_SET_type*fs= rd->first_set();
FIRST_SET_ITER_type j= fs->begin();
FIRST_SET_ITER_type je= fs->end();
for(;j!=je;++j){
T_in_stbl*tintbl= *j;
T_terminal_def*tdef= tintbl->t_def();
if(tdef->enum_id()==LR1_PARALLEL_OPERATOR){
continue;
}
++no_Tes_in_list;
}

done:;
KCHARP fs_list_of_Tes= 
"list-of-native-first-set-terminals %i";
KCHARP fs_T_in_list= 
"   %s";
KCHARP end_fs_list_of_Tes= 
"end-list-of-native-first-set-terminals%s";
int x= sprintf(big_buf_
,fs_list_of_Tes
,no_Tes_in_list
);
Op_str.write(big_buf_,x);
Op_str<<endl;

j= fs->begin();
for(;j!=je;++j){
T_in_stbl*tintbl= *j;
T_terminal_def*tdef= tintbl->t_def();
if(tdef->enum_id()==LR1_PARALLEL_OPERATOR){
continue;
}
if(tdef->enum_id()==LR1_INVISIBLE_SHIFT_OPERATOR){
x= sprintf(big_buf_
,fs_T_in_list
,LR1_FSET_TRANSIENCE_OPERATOR_LITERAL
);
}else{
x= sprintf(big_buf_
,fs_T_in_list
,tdef->classsym()->c_str()
);
}
Op_str.write(big_buf_,x);
Op_str<<endl;
}
x= sprintf(big_buf_,end_fs_list_of_Tes," ");
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:248*//*249:*/
//line 7863 "./o2externs.w"

void transitive_list_of_threads_in_fs_imp
(std::ofstream&Op_str){
char big_buf_[BIG_BUFFER_32K];
T_rules_phrase*rules_ph= O2_RULES_PHASE;
AST*rules_tree= rules_ph->phrase_tree();
AST*start_rule_def_t= AST::get_1st_son(*rules_tree);
rule_def*rd= (rule_def*)AST::content(*start_rule_def_t);


int no_threads_in_list= rd->called_thread_first_set()->size();

KCHARP transitive_thread_list= 
"list-of-transitive-threads %i";
KCHARP transitive_thread_in_list= 
"  %s::%s";
KCHARP end_transitive_thread_list= 
"end-list-of-transitive-threads%s";

int x= sprintf(big_buf_,transitive_thread_list,no_threads_in_list);
Op_str.write(big_buf_,x);
Op_str<<endl;

std::set<T_called_thread_eosubrule*> ::iterator e= rd->called_thread_first_set()->begin();
std::set<T_called_thread_eosubrule*> ::iterator ee= rd->called_thread_first_set()->end();
for(;e!=ee;++e){
T_called_thread_eosubrule*called_thd= *e;
x= sprintf(big_buf_
,transitive_thread_in_list
,called_thd->ns()->identifier()->c_str()
,called_thd->called_thread_name()->identifier()->c_str());
Op_str.write(big_buf_,x);
Op_str<<endl;
}

x= sprintf
(big_buf_
,end_transitive_thread_list," "
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:249*//*250:*/
//line 7907 "./o2externs.w"

void used_list_of_threads_imp
(std::ofstream&Op_str){
char big_buf_[BIG_BUFFER_32K];
std::set<string> used_threads;
STATES_ITER_type i= LR1_STATES.begin();
STATES_ITER_type ie= LR1_STATES.end();
for(;i!=ie;++i){
state*start_state= *i;
S_VECTOR_ELEMS_type*state_elems_wparallelism(0);
S_VECTORS_type&vect= start_state->state_s_vector_;
S_VECTORS_ITER_type vi= vect.find(LR1_PARALLEL_OPERATOR);
if(vi==vect.end())continue;
state_elems_wparallelism= &vi->second;
S_VECTOR_ELEMS_ITER_type k= state_elems_wparallelism->begin();
S_VECTOR_ELEMS_ITER_type ke= state_elems_wparallelism->end();
for(;k!=ke;++k){
state_element*thread_1st_elem= *k;
AST*rtned_T_t= thread_1st_elem->next_state_element_->sr_element_;
AST*bypassed_thd_eos_t= AST::brother(*rtned_T_t);
if(bypassed_thd_eos_t==0)continue;
CAbs_lr1_sym*sym= AST::content(*bypassed_thd_eos_t);
if(sym->enumerated_id__!=T_Enum::T_T_called_thread_eosubrule_){
continue;
}
T_called_thread_eosubrule*called_thd= (T_called_thread_eosubrule*)sym;

string fqtnm;
fqtnm+= called_thd->ns()->identifier()->c_str();
fqtnm+= "::";
fqtnm+= called_thd->called_thread_name()->identifier()->c_str();
if(used_threads.find(fqtnm)==used_threads.end())used_threads.insert(fqtnm);
}
}
KCHARP used_thread_list= 
"list-of-used-threads %i";
KCHARP used_thread_in_list= 
"  %s";
KCHARP end_used_thread_list= 
"end-list-of-used-threads%s";

int x= sprintf(big_buf_,used_thread_list,used_threads.size());
Op_str.write(big_buf_,x);
Op_str<<endl;

std::set<string> ::iterator si= used_threads.begin();
std::set<string> ::iterator sie= used_threads.end();
for(;si!=sie;++si){
x= sprintf(big_buf_
,used_thread_in_list
,si->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

x= sprintf
(big_buf_
,end_used_thread_list," "
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:250*//*251:*/
//line 7972 "./o2externs.w"

void grammar_s_comments_for_linker_doc_imp
(std::ofstream&Op_str){
char big_buf_[BIG_BUFFER_32K];
T_fsm_phrase*fcp= O2_FSM_PHASE;

KCHARP fsm_comments= 
"fsm-comments\n"
"\"%s\"";
int x= sprintf
(big_buf_
,fsm_comments
,fcp->comment()->c_string()->c_str()
);
Op_str.write(big_buf_,x);
Op_str<<endl;
}

/*:251*//*252:*/
//line 7992 "./o2externs.w"

void OP_FSC_FILE(TOKEN_GAGGLE&Error_queue){
T_fsm_phrase*fsm_ph= O2_FSM_PHASE;
string fn(fsm_ph->filename_id()->identifier()->c_str());
fn+= Suffix_fsc;
std::ofstream Op_file;
Op_file.open(fn.c_str(),ios_base::out|ios::trunc);
if(!Op_file){
CAbs_lr1_sym*sym= new Err_bad_fsmtbl_filename(fn.c_str());
sym->set_line_no_and_pos_in_line(*fsm_ph->filename_id());
sym->set_who_created("o2externs.w - OP_FSC_FILE",__LINE__);
Error_queue.push_back(*sym);
return;
}
intro_comment(Op_file,fn.c_str());
fsc_prelude_imp(Op_file,fn);
list_of_native_Tes_in_fs_imp(Op_file);
transitive_list_of_threads_in_fs_imp(Op_file);
used_list_of_threads_imp(Op_file);
grammar_s_comments_for_linker_doc_imp(Op_file);
Op_file.close();
}

/*:252*/
//line 185 "./o2externs.w"



/*:7*/
